/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.core.launcher;

import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.debug.core.i18n.Messages;
import org.eclipse.birt.report.debug.internal.core.launcher.IReportLaunchConstants;
import org.eclipse.birt.report.debug.internal.core.launcher.LauncherEngineConfig;
import org.eclipse.birt.report.debug.internal.core.vm.ReportVMServer;
import org.eclipse.birt.report.debug.internal.core.vm.VMContextData;
import org.eclipse.birt.report.debug.internal.core.vm.VMException;
import org.eclipse.birt.report.debug.internal.core.vm.VMListener;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.metadata.ValidationValueException;
import org.mozilla.javascript.Context;

public class ReportLauncher
implements VMListener,
IReportLaunchConstants {
    private static final Logger logger = Logger.getLogger(ReportLauncher.class.getName());
    private static final String RPTDOC_SUFFIX = "rptdocument";
    private IReportEngine engine;
    private EngineConfig engineConfig;
    private Map paramValues = new HashMap();
    private String reportDesignFile = ReportLauncher.getFileName();
    private boolean debugScript = (ReportLauncher.getDebugType() & 2) == 2;
    private String targetFormat = ReportLauncher.getTargetFormat();
    private ReportVMServer server;
    private IRunTask runTask;
    private IRenderTask renderTask;
    private IRunAndRenderTask runAndRenderTask;
    IGetParameterDefinitionTask task;
    List allParameters;

    public static void main(String[] args) {
        new ReportLauncher().run();
    }

    private static int getListenPort() {
        String str = System.getProperty("report.listen.port");
        if (str == null) {
            throw new Error(Messages.getString("ReportLauncher.PortValueAbsent"));
        }
        return Integer.parseInt(str);
    }

    private static String getFileName() {
        return System.getProperty("report.file.name");
    }

    private static String getEngineHome() {
        return System.getProperty("engine.home");
    }

    private static String getResourceFolder() {
        return System.getProperty("use.resource.folder");
    }

    private static String getOutputFolder() {
        return System.getProperty("temp.folder");
    }

    private static String getTargetFormat() {
        return System.getProperty("engine.target.format");
    }

    private static int getTaskType() {
        String str = System.getProperty("engine.task.type");
        if (str == null) {
            return 4;
        }
        return Integer.parseInt(str);
    }

    private static int getDebugType() {
        String str = System.getProperty("engine.debug.type");
        if (str == null) {
            return 2;
        }
        return Integer.parseInt(str);
    }

    private static String getUserClassPath() {
        return System.getProperty("report.user.class.path");
    }

    private void initParameters() {
        if (this.allParameters == null) {
            this.allParameters = new ArrayList();
            try {
                IReportRunnable runnable = this.engine.openReportDesign(this.reportDesignFile);
                List list = runnable.getDesignHandle().getRoot().getParametersAndParameterGroups();
                this.initAllParameters(this.allParameters, list);
            }
            catch (EngineException engineException) {}
        }
        Properties propertys = System.getProperties();
        for (String string : propertys.keySet()) {
            if (string.startsWith("param:")) {
                this.addParameter(this.paramValues, string, propertys.getProperty(string));
                continue;
            }
            if (!string.startsWith("mulparam:0")) continue;
            this.addMulitipleParameter(this.paramValues, string, propertys.getProperty(string));
        }
    }

    private void addParameter(Map map, String key, String value) {
        String temp = key.substring("param:".length());
        map.put(temp, this.getParameterObject(temp, value));
    }

    private java.util.Date doValidateDateTimeByPattern(String value, String dataType) throws ValidationValueException {
        try {
            long time = Long.parseLong(value);
            return new java.util.Date(time);
        }
        catch (Exception exception) {
            Object obj = null;
            try {
                obj = ReportLauncher.convert(value, dataType);
            }
            catch (BirtException birtException) {}
            if (obj instanceof java.util.Date) {
                return (java.util.Date)obj;
            }
            throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", "dateTime");
        }
    }

    private Date doValidateSqlDateTimeByPattern(String value, String dataType) throws ValidationValueException {
        try {
            long time = Long.parseLong(value);
            return new Date(time);
        }
        catch (Exception exception) {
            Object obj = null;
            try {
                obj = ReportLauncher.convert(value, dataType);
            }
            catch (BirtException birtException) {}
            if (obj instanceof Date) {
                return (Date)obj;
            }
            throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", "dateTime");
        }
    }

    private static Time doValidateTimeDateTimeByPattern(String value, String dataType) throws ValidationValueException {
        try {
            long time = Long.parseLong(value);
            return new Time(time);
        }
        catch (Exception exception) {
            Object obj = null;
            try {
                obj = ReportLauncher.convert(value, dataType);
            }
            catch (BirtException birtException) {}
            if (obj instanceof Time) {
                return (Time)obj;
            }
            throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", "dateTime");
        }
    }

    private Object getParameterObject(String key, String value) {
        ParameterHandle temp = this.findParameter(key);
        if (temp instanceof ScalarParameterHandle) {
            ScalarParameterHandle handle = (ScalarParameterHandle)temp;
            String dataType = handle.getDataType();
            try {
                if ("date".equalsIgnoreCase(dataType)) {
                    return this.doValidateSqlDateTimeByPattern(value, dataType);
                }
                if ("time".equalsIgnoreCase(dataType)) {
                    return ReportLauncher.doValidateTimeDateTimeByPattern(value, dataType);
                }
                if ("dateTime".equalsIgnoreCase(dataType)) {
                    return this.doValidateDateTimeByPattern(value, dataType);
                }
            }
            catch (ValidationValueException validationValueException) {
                return value;
            }
            try {
                return ReportLauncher.convert(value, dataType);
            }
            catch (BirtException birtException) {
                return value;
            }
        }
        return value;
    }

    public static Object convert(Object value, String dataType) throws BirtException {
        if ("boolean".equals(dataType)) {
            return DataTypeUtil.toBoolean((Object)value);
        }
        if ("dateTime".equals(dataType)) {
            return DataTypeUtil.toDate((Object)value);
        }
        if ("date".equals(dataType)) {
            return DataTypeUtil.toSqlDate((Object)value);
        }
        if ("time".equals(dataType)) {
            return DataTypeUtil.toSqlTime((Object)value);
        }
        if ("decimal".equals(dataType)) {
            return DataTypeUtil.toBigDecimal((Object)value);
        }
        if ("float".equals(dataType)) {
            return DataTypeUtil.toDouble((Object)value);
        }
        if ("string".equals(dataType)) {
            return DataTypeUtil.toString((Object)value);
        }
        if ("integer".equals(dataType)) {
            return DataTypeUtil.toInteger((Object)value);
        }
        return value;
    }

    private ParameterHandle findParameter(String key) {
        int i = 0;
        while (i < this.allParameters.size()) {
            ParameterHandle handle;
            Object obj = this.allParameters.get(i);
            if (obj instanceof ParameterHandle && (handle = (ParameterHandle)obj).getName().equals(key)) {
                return handle;
            }
            ++i;
        }
        return null;
    }

    private List initAllParameters(List allParameters, List list) {
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof ParameterHandle) {
                allParameters.add(obj);
            } else if (obj instanceof ParameterGroupHandle) {
                this.initAllParameters(allParameters, ((ParameterGroupHandle)obj).getParameters().getContents());
            }
            ++i;
        }
        return allParameters;
    }

    private void addMulitipleParameter(Map map, String key, String value) {
        ArrayList<Object> list = new ArrayList<Object>();
        String temp = key.substring("mulparam:".length() + 1);
        list.add(this.getParameterObject(temp, value));
        int i = 1;
        Properties propertys = System.getProperties();
        Set<Object> set = propertys.keySet();
        while (set.contains("mulparam:" + i + temp)) {
            list.add(this.getParameterObject(temp, (String)propertys.get("mulparam:" + i + temp)));
            ++i;
        }
        Object[] objs = new Object[list.size()];
        list.toArray(objs);
        map.put(temp, objs);
    }

    private void run() {
        this.init();
        this.renderReport();
        this.dispose();
        System.exit(1);
    }

    private void init() {
        if (this.debugScript) {
            this.server = new ReportVMServer();
            this.server.addVMListener(this);
            Context cx = Context.enter();
            try {
                this.server.start(ReportLauncher.getListenPort(), cx);
            }
            catch (VMException vMException) {
                throw new Error(Messages.getString("ReportLauncher.FailToStartDebugServer"));
            }
        }
        this.engineConfig = new LauncherEngineConfig();
        this.engineConfig.setEngineHome(ReportLauncher.getEngineHome());
        if (ReportLauncher.getResourceFolder() != null) {
            this.engineConfig.setResourcePath(ReportLauncher.getResourceFolder());
        }
        try {
            Platform.startup((PlatformConfig)this.engineConfig);
        }
        catch (BirtException birtException) {
            throw new Error(Messages.getString("ReportLauncher.FailToStartReportPlatform"));
        }
        IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        this.configEngine();
        this.engine = factory.createReportEngine(this.engineConfig);
        this.engine.changeLogLevel(Level.WARNING);
        this.initParameters();
    }

    private void configEngine() {
        String userClassPath = ReportLauncher.getUserClassPath();
        logger.info(String.valueOf(Messages.getString("ReportLauncher.UserClassPathReceived")) + userClassPath);
        System.clearProperty("user.projectclasspath");
        if (userClassPath != null) {
            this.engineConfig.getAppContext().put("user.projectclasspath", userClassPath);
            System.setProperty("user.projectclasspath", userClassPath);
        }
    }

    private void renderReport() {
        String outputFolder = ReportLauncher.getOutputFolder();
        int taskType = ReportLauncher.getTaskType();
        boolean isRunAndRenderTask = (taskType & 4) != 0;
        boolean isRunTask = (taskType & 1) != 0;
        boolean isRenderTask = (taskType & 2) != 0;
        try {
            if (isRunAndRenderTask) {
                this.createReport(this.reportDesignFile, outputFolder, this.paramValues);
            } else {
                String reportDocumentFile = this.reportDesignFile;
                if (isRunTask) {
                    reportDocumentFile = this.createReportDocument(this.reportDesignFile, outputFolder, this.paramValues);
                }
                if (isRenderTask) {
                    this.createReportOutput(reportDocumentFile, outputFolder);
                }
            }
        }
        catch (EngineException e) {
            logger.log(Level.SEVERE, Messages.getString("ReportLauncher.EngineException"), e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, Messages.getString("ReportLauncher.IOException"), e);
        }
    }

    private void createReport(String reportDesignFile, String outputFolder, Map parameters) throws IOException, EngineException {
        String outputFile = ReportLauncher.getOutputFileName(outputFolder, new File(reportDesignFile).getName(), this.targetFormat);
        IReportRunnable report = this.engine.openReportDesign(reportDesignFile);
        this.runAndRenderTask = this.engine.createRunAndRenderTask(report);
        HTMLRenderOption renderOption = new HTMLRenderOption();
        renderOption.setOutputFileName(outputFile);
        renderOption.setOutputFormat(this.targetFormat);
        try {
            if (parameters != null) {
                this.runAndRenderTask.setParameterValues(parameters);
            }
            this.runAndRenderTask.setAppContext(Collections.EMPTY_MAP);
            this.runAndRenderTask.setRenderOption((IRenderOption)renderOption);
            this.runAndRenderTask.run();
        }
        finally {
            this.runAndRenderTask.close();
            report = null;
            this.runAndRenderTask = null;
        }
    }

    private String createReportDocument(String reportDesignFile, String outputFolder, Map parameters) throws IOException, EngineException {
        String reportDocumentFile = ReportLauncher.getOutputFileName(outputFolder, new File(reportDesignFile).getName(), RPTDOC_SUFFIX);
        FileArchiveWriter archive = new FileArchiveWriter(reportDocumentFile);
        IReportRunnable report = this.engine.openReportDesign(reportDesignFile);
        this.runTask = this.engine.createRunTask(report);
        try {
            if (parameters != null) {
                this.runTask.setParameterValues(parameters);
            }
            this.runTask.setAppContext(Collections.EMPTY_MAP);
            this.runTask.run((IDocArchiveWriter)archive);
        }
        finally {
            this.runTask.close();
            report = null;
            this.runTask = null;
        }
        return reportDocumentFile;
    }

    private void createReportOutput(String reportDocumentFile, String outputFolder) throws EngineException, IOException {
        IReportDocument document = this.engine.openReportDocument(reportDocumentFile);
        this.renderTask = this.engine.createRenderTask(document);
        String outputFile = ReportLauncher.getOutputFileName(outputFolder, new File(this.reportDesignFile).getName(), this.targetFormat);
        HTMLRenderOption renderOption = new HTMLRenderOption();
        renderOption.setOutputFileName(outputFile);
        renderOption.setOutputFormat(this.targetFormat);
        try {
            this.renderTask.setRenderOption((IRenderOption)renderOption);
            this.renderTask.render();
        }
        finally {
            this.renderTask.close();
            this.renderTask = null;
            document.close();
            document = null;
        }
    }

    public static String getOutputFileName(String outputFolder, String fileName, String suffix) {
        return String.valueOf(outputFolder) + File.separator + fileName + "." + suffix;
    }

    public void handleEvent(int eventCode, VMContextData context) {
        if (eventCode == 10) {
            this.dispose();
        }
    }

    private void dispose() {
        try {
            if (this.runTask != null) {
                this.runTask.cancel();
                this.runTask.close();
                this.runTask = null;
            }
        }
        catch (Throwable throwable) {}
        try {
            if (this.renderTask != null) {
                this.renderTask.cancel();
                this.renderTask.close();
                this.renderTask = null;
            }
        }
        catch (Throwable throwable) {}
        try {
            if (this.runAndRenderTask != null) {
                this.runAndRenderTask.cancel();
                this.runAndRenderTask.close();
                this.runAndRenderTask = null;
            }
        }
        catch (Throwable throwable) {}
        if (this.server != null) {
            this.server.shutdown(Context.enter());
        }
        Platform.shutdown();
    }
}

