/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.ValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public abstract class ComplexValueHandle
extends ValueHandle {
    protected ElementPropertyDefn propDefn = null;
    protected StructureContext memberContext = null;

    public ComplexValueHandle(DesignElementHandle element, ElementPropertyDefn thePropDefn) {
        super(element);
        assert (thePropDefn != null);
        this.propDefn = thePropDefn;
    }

    public ComplexValueHandle(DesignElementHandle element, StructureContext theMemberContext) {
        super(element);
        assert (theMemberContext != null);
        this.propDefn = theMemberContext.getElementProp();
        assert (this.propDefn != null);
        this.memberContext = theMemberContext;
    }

    public ComplexValueHandle(DesignElementHandle element, MemberRef theMemberRef) {
        super(element);
        assert (theMemberRef != null);
        this.memberContext = theMemberRef.getContext();
        assert (this.memberContext != null);
        this.propDefn = this.memberContext.getElementProp();
        assert (this.propDefn != null);
    }

    public void setValue(Object value) throws SemanticException {
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        if (this.memberContext == null) {
            cmd.setProperty(this.propDefn, value);
        } else {
            cmd.setMember(this.memberContext, value);
        }
    }

    public Object getValue() {
        Object value = this.getRawValue();
        return ModelUtil.wrapPropertyValue(this.getModule(), (PropertyDefn)this.getDefn(), value);
    }

    protected final Object getRawValue() {
        Module tmpModule = this.getModule();
        Object value = null;
        value = this.memberContext == null ? this.getElement().getProperty(tmpModule, this.propDefn) : this.memberContext.getValue(tmpModule);
        return value;
    }

    public void setStringValue(String value) throws SemanticException {
        this.setValue(value);
    }

    public String getStringValue() {
        PropertyDefn prop = this.memberContext == null ? this.propDefn : this.memberContext.getPropDefn();
        return prop.getStringValue(this.getModule(), this.getValue());
    }

    public String getDisplayValue() {
        PropertyDefn prop = this.memberContext == null ? this.propDefn : this.memberContext.getPropDefn();
        return prop.getDisplayValue(this.getModule(), this.getValue());
    }

    public IElementPropertyDefn getPropertyDefn() {
        return this.propDefn;
    }

    public StructureContext getContext() {
        return this.memberContext;
    }

    protected IPropertyDefn getDefn() {
        if (this.memberContext != null) {
            return this.memberContext.getPropDefn();
        }
        return this.propDefn;
    }

    public boolean isSet() {
        if (this.memberContext == null) {
            FactoryPropertyHandle handle = new FactoryPropertyHandle(this.elementHandle, this.propDefn);
            return handle.isSet();
        }
        Object value = this.memberContext.getValue(this.getModule());
        return value != null;
    }
}

