/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IAbsoluteFontSizeValueProvider;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.command.LibraryChangeEvent;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.birt.report.model.api.core.IResourceChangeListener;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ModelResourceHandle;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.DefaultAbsoluteFontSizeValueProvider;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.parser.DesignReader;
import org.eclipse.birt.report.model.parser.GenericModuleReader;
import org.eclipse.birt.report.model.parser.LibraryReader;
import org.eclipse.birt.report.model.util.LibraryUtil;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ResourceLocatorImpl;
import org.eclipse.birt.report.model.util.URIUtilImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignSession {
    private static List<DesignElement> defaultTOCStyleList = null;
    public static final String TOC_DEFAULT_VALUE = "templates/TOCDefaultValue.xml";
    protected String resourceFolder = null;
    protected IResourceLocator resourceLocator = new ResourceLocatorImpl();
    protected static String resourcePath = null;
    protected IAbsoluteFontSizeValueProvider fontSizeProvider = DefaultAbsoluteFontSizeValueProvider.getInstance();
    protected List<ReportDesign> designs = new ArrayList<ReportDesign>();
    protected List<Library> libraries = new ArrayList<Library>();
    protected ULocale locale;
    protected ModelResourceHandle resources;
    private String units = "in";
    private int colorFormat = 3;
    private HashMap<String, Object> defaultValues = new HashMap();
    private List<IResourceChangeListener> resourceChangeListeners = null;
    private static Boolean isTOCStyleInitialized = Boolean.FALSE;

    public DesignSession(ULocale theLocale) {
        this.locale = theLocale;
        if (this.locale == null) {
            this.locale = ULocale.getDefault();
        }
        this.activate();
    }

    public void activate() {
        ThreadResources.setLocale(this.locale);
    }

    public void suspend() {
        ThreadResources.setLocale(null);
    }

    public ReportDesign openDesign(String fileName) throws DesignFileException {
        return this.openDesign(fileName, (ModuleOption)null);
    }

    public ReportDesign openDesign(String fileName, ModuleOption options) throws DesignFileException {
        if (fileName == null) {
            throw new IllegalArgumentException("The file name must not be null");
        }
        this.initializeOptions(options);
        ReportDesign design = DesignReader.getInstance().read(this, fileName, options);
        this.designs.add(design);
        return design;
    }

    private void initializeOptions(ModuleOption options) {
        if (options == null) {
            return;
        }
        if (this.resourceLocator == null) {
            this.resourceLocator = options.getResourceLocator();
        }
        if (this.locale == null) {
            this.locale = options.getLocale();
        }
        if (this.resourceFolder == null) {
            this.resourceFolder = options.getResourceFolder();
        }
    }

    public ReportDesign openDesign(String fileName, InputStream is) throws DesignFileException {
        return this.openDesign(fileName, is, null);
    }

    public ReportDesign openDesign(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        this.initializeOptions(options);
        ReportDesign design = DesignReader.getInstance().read(this, fileName, is, options);
        this.designs.add(design);
        return design;
    }

    public ReportDesign openDesign(URL systemId, InputStream is) throws DesignFileException {
        return this.openDesign(systemId, is, null);
    }

    public ReportDesign openDesign(URL systemId, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        ReportDesign design = DesignReader.getInstance().read(this, systemId, is, options);
        this.designs.add(design);
        return design;
    }

    public Module openModule(String fileName, InputStream is) throws DesignFileException {
        return this.openModule(fileName, is, null);
    }

    public Module openModule(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        this.initializeOptions(options);
        Module module = GenericModuleReader.getInstance().read(this, fileName, is, options);
        assert (module instanceof Library || module instanceof ReportDesign);
        if (module instanceof ReportDesign) {
            this.designs.add((ReportDesign)module);
        } else {
            this.libraries.add((Library)module);
        }
        return module;
    }

    public Module openModule(String fileName) throws DesignFileException {
        return this.openModule(fileName, (ModuleOption)null);
    }

    public Module openModule(String fileName, ModuleOption options) throws DesignFileException {
        if (fileName == null) {
            throw new IllegalArgumentException("The file name must not be null");
        }
        this.initializeOptions(options);
        Module module = GenericModuleReader.getInstance().read(this, fileName, options);
        assert (module instanceof Library || module instanceof ReportDesign);
        if (module instanceof ReportDesign) {
            this.designs.add((ReportDesign)module);
        } else {
            this.libraries.add((Library)module);
        }
        return module;
    }

    public Library openLibrary(String fileName) throws DesignFileException {
        return this.openLibrary(fileName, (ModuleOption)null);
    }

    public Library openLibrary(String fileName, ModuleOption options) throws DesignFileException {
        if (fileName == null) {
            throw new IllegalArgumentException("The file name must not be null");
        }
        this.initializeOptions(options);
        Library library = LibraryReader.getInstance().read(this, fileName, options);
        this.libraries.add(library);
        return library;
    }

    public Library openLibrary(String fileName, InputStream is) throws DesignFileException {
        return this.openLibrary(fileName, is, null);
    }

    public Library openLibrary(String fileName, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        this.initializeOptions(options);
        Library design = LibraryReader.getInstance().read(this, fileName, is, options);
        this.libraries.add(design);
        return design;
    }

    public Library openLibrary(URL systemId, InputStream is) throws DesignFileException {
        return this.openLibrary(systemId, is, null);
    }

    public Library openLibrary(URL systemId, InputStream is, ModuleOption options) throws DesignFileException {
        if (is == null) {
            throw new IllegalArgumentException("The input stream must not be null");
        }
        this.initializeOptions(options);
        Library library = LibraryReader.getInstance().read(this, systemId, is, options);
        this.libraries.add(library);
        return library;
    }

    public ReportDesign createDesign(String fileName, ModuleOption options) {
        URL systemId;
        ReportDesign design = new ReportDesign(this);
        design.setID(design.getNextID());
        design.addElementID(design);
        design.setFileName(fileName);
        if (!StringUtil.isBlank(fileName) && (systemId = URIUtilImpl.getDirectory(fileName)) != null) {
            design.setSystemId(systemId);
        }
        if (!this.isBlankCreation(options)) {
            this.addExtensionDefaultStyles(design);
        }
        design.setValid(true);
        this.designs.add(design);
        return design;
    }

    private boolean isBlankCreation(ModuleOption options) {
        if (options == null) {
            return false;
        }
        Boolean isSimpleCreation = (Boolean)options.getProperty("blankCreation");
        return isSimpleCreation != null && isSimpleCreation != false;
    }

    public Library createLibraryFromTemplate(String templateName) throws DesignFileException {
        Library library = this.openLibrary(templateName);
        library.setFileName(null);
        this.handleDefaultTheme(library);
        return library;
    }

    public ReportDesign createDesignFromTemplate(String templateName) throws DesignFileException {
        ReportDesign design = this.openDesign(templateName);
        design.setFileName(null);
        this.addExtensionDefaultStyles(design);
        return design;
    }

    private List<Style> findToAddExtensionDefaultStyle(ReportDesign design) {
        ArrayList<Style> retList = new ArrayList<Style>();
        List<Style> defaultStyles = MetaDataDictionary.getInstance().getExtensionFactoryStyles();
        int i = 0;
        while (i < defaultStyles.size()) {
            Style style = defaultStyles.get(i);
            assert (style.getName() != null);
            if (design.findStyle(style.getName()) == null) {
                retList.add(style);
            }
            ++i;
        }
        return retList;
    }

    private void addExtensionDefaultStyles(ReportDesign design) {
        List<Style> tmpStyles = this.findToAddExtensionDefaultStyle(design);
        int i = 0;
        while (i < tmpStyles.size()) {
            block4: {
                Style style = tmpStyles.get(i);
                Style tmpStyle = null;
                try {
                    tmpStyle = (Style)style.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    assert (false);
                    break block4;
                }
                design.add(tmpStyle, 0);
                tmpStyle.setID(design.getNextID());
                design.addElementID(tmpStyle);
                design.getNameHelper().getNameSpace(0).insert(tmpStyle);
            }
            ++i;
        }
    }

    public Library createLibrary() {
        Library library = new Library(this);
        library.setID(library.getNextID());
        library.addElementID(library);
        this.handleDefaultTheme(library);
        library.setValid(true);
        this.libraries.add(library);
        return library;
    }

    private void handleDefaultTheme(Library library) {
        String themeName = library.getThemeName();
        if (themeName == null) {
            String defaultThemeName = ModelMessages.getMessage("Theme.defaultThemeName");
            Theme theme = library.findNativeTheme(defaultThemeName);
            if (theme != null) {
                return;
            }
            theme = new Theme(defaultThemeName);
            library.setProperty("theme", (Object)new ElementRefValue(null, theme));
            LibraryUtil.insertCompatibleThemeToLibrary(library, theme);
            theme.setID(library.getNextID());
            library.addElementID(theme);
        }
    }

    public Iterator<ReportDesign> getDesignIterator() {
        return this.designs.iterator();
    }

    public Iterator<Library> getLibraryIterator() {
        return this.libraries.iterator();
    }

    public Iterator<Module> getModuleIterator() {
        ArrayList<Module> roots = new ArrayList<Module>();
        roots.addAll(this.designs);
        roots.addAll(this.libraries);
        return roots.iterator();
    }

    public void drop(Module module) {
        if (module instanceof ReportDesign) {
            assert (this.designs.contains(module));
            this.designs.remove(module);
        } else if (module instanceof Library) {
            assert (this.libraries.contains(module));
            this.libraries.remove(module);
        }
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String newUnits) throws PropertyValueException {
        if (!("cm".equalsIgnoreCase(newUnits) || "in".equalsIgnoreCase(newUnits) || "mm".equalsIgnoreCase(newUnits) || "pc".equalsIgnoreCase(newUnits) || "pt".equalsIgnoreCase(newUnits))) {
            throw new PropertyValueException((Object)newUnits, "Error.PropertyValueException.INVALID_VALUE", 5);
        }
        this.units = newUnits;
    }

    public void setColorFormat(int format) throws PropertyValueException {
        if (format != 3 && format != 4 && format != 1 && format != 0 && format != 2) {
            throw new PropertyValueException(new Integer(format), "Error.PropertyValueException.INVALID_VALUE", 5);
        }
        this.colorFormat = format;
    }

    public int getColorFormat() {
        return this.colorFormat;
    }

    public void setDefaultValue(String propName, Object value) throws PropertyValueException {
        assert (!StringUtil.isBlank(propName));
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementPropertyDefn propDefn = dd.getStyle().getProperty(propName);
        assert (propDefn != null);
        if (value == null) {
            this.defaultValues.remove(propName);
        } else {
            Object actualValue = ((ElementPropertyDefn)propDefn).validateValue(null, value);
            this.defaultValues.put(propName, actualValue);
        }
    }

    public Object getDefaultValue(String propName) {
        assert (!StringUtil.isBlank(propName));
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementPropertyDefn propDefn = dd.getStyle().getProperty(propName);
        assert (propDefn != null);
        return this.defaultValues.get(propName);
    }

    public void setResourceLocator(IResourceLocator algorithm) {
        assert (algorithm != null);
        this.resourceLocator = algorithm;
    }

    public IResourceLocator getResourceLocator() {
        assert (this.resourceLocator != null);
        return this.resourceLocator;
    }

    public IAbsoluteFontSizeValueProvider getPredefinedFontSizeProvider() {
        return this.fontSizeProvider;
    }

    public void setPredefinedFontSizeProvider(IAbsoluteFontSizeValueProvider fontSizeProvider) {
        this.fontSizeProvider = fontSizeProvider;
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public void fireLibChange(LibraryChangeEvent ev) {
        URL url = ModelUtil.getURLPresentation(ev.getChangedResourcePath());
        if (url == null) {
            return;
        }
        String path = url.toExternalForm();
        Iterator<Module> iter = this.getModuleIterator();
        while (iter.hasNext()) {
            Module module = iter.next();
            if (!module.getLocation().equalsIgnoreCase(path) && module.getLibraryByLocation(path, Integer.MAX_VALUE) == null) continue;
            LibraryChangeEvent event = new LibraryChangeEvent(ev.getChangedResourcePath());
            event.setTarget(module);
            event.setDeliveryPath(ev.getDeliveryPath());
            module.broadcastResourceChangeEvent(event);
        }
        this.broadcastResourceChangeEvent(ev);
    }

    public void addResourceChangeListener(IResourceChangeListener listener) {
        if (this.resourceChangeListeners == null) {
            this.resourceChangeListeners = new ArrayList<IResourceChangeListener>();
        }
        if (!this.resourceChangeListeners.contains(listener)) {
            this.resourceChangeListeners.add(listener);
        }
    }

    public boolean removeResourceChangeListener(IResourceChangeListener listener) {
        if (this.resourceChangeListeners == null) {
            return false;
        }
        return this.resourceChangeListeners.remove(listener);
    }

    public void broadcastResourceChangeEvent(ResourceChangeEvent event) {
        if (this.resourceChangeListeners == null || this.resourceChangeListeners.isEmpty()) {
            return;
        }
        ArrayList<IResourceChangeListener> temp = new ArrayList<IResourceChangeListener>(this.resourceChangeListeners);
        for (IResourceChangeListener listener : temp) {
            listener.resourceChanged(null, event);
        }
    }

    public void setResourceFolder(String resourceFolder) {
        this.resourceFolder = resourceFolder;
    }

    public String getResourceFolder() {
        if (this.resourceFolder == null) {
            return resourcePath;
        }
        return this.resourceFolder;
    }

    public static String getResourcePath() {
        return resourcePath;
    }

    public static void setResourcePath(String resourcePath) {
        DesignSession.resourcePath = resourcePath;
    }

    private void initDefaultTOCStyle() {
        defaultTOCStyleList = new ArrayList<DesignElement>();
        URL url = new ResourceLocatorImpl().findResource(null, TOC_DEFAULT_VALUE, 0);
        if (url == null) {
            return;
        }
        ReportDesign tocDesign = null;
        try {
            DesignSession session = new DesignSession(this.locale);
            tocDesign = session.openDesign(url, url.openStream());
            tocDesign.setReadOnly();
        }
        catch (DesignFileException designFileException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        ContainerSlot styles = tocDesign.getSlot(0);
        int i = 0;
        while (i < styles.getCount()) {
            defaultTOCStyleList.add(styles.getContent(i));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DesignElement> getDefaultTOCStyleValue() {
        if (isTOCStyleInitialized.booleanValue()) {
            return Collections.unmodifiableList(defaultTOCStyleList);
        }
        Boolean bl = isTOCStyleInitialized;
        synchronized (bl) {
            if (!isTOCStyleInitialized.booleanValue()) {
                this.initDefaultTOCStyle();
                isTOCStyleInitialized = Boolean.TRUE;
            }
        }
        return Collections.unmodifiableList(defaultTOCStyleList);
    }

    public Module getOpenedModule(String location) {
        if (location == null) {
            return null;
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.addAll(this.designs);
        modules.addAll(this.libraries);
        int i = 0;
        while (i < modules.size()) {
            Module tmpModule = (Module)modules.get(i);
            if (location.equalsIgnoreCase(tmpModule.getLocation())) {
                return tmpModule;
            }
            ++i;
        }
        return null;
    }
}

