/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.scripts.IScriptableObjectClassInfo;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.LocalizableInfo;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
extends LocalizableInfo
implements IMethodInfo {
    private String returnType;
    private boolean isStatic = false;
    private boolean isConstructor = false;
    private List<IArgumentInfoList> arguments;
    private String javaDoc;
    private String context;
    private IElementDefn elementDefn;

    public MethodInfo(boolean isConstructor) {
        this.isConstructor = isConstructor;
    }

    public void addArgumentList(IArgumentInfoList argumentList) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<IArgumentInfoList>();
        }
        this.arguments.add(argumentList);
    }

    @Override
    public Iterator<IArgumentInfoList> argumentListIterator() {
        if (this.arguments == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.arguments.iterator();
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    @Override
    public String getToolTipKey() {
        return this.toolTipKey;
    }

    @Override
    public void setToolTipKey(String toolTipKey) {
        this.toolTipKey = toolTipKey;
    }

    @Override
    public String getToolTip() {
        assert (this.toolTipKey != null);
        return ModelMessages.getMessage(this.toolTipKey);
    }

    @Override
    public boolean isConstructor() {
        return this.isConstructor;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    @Override
    public String getJavaDoc() {
        return this.javaDoc;
    }

    public void setJavaDoc(String javaDoc) {
        this.javaDoc = javaDoc;
    }

    void setContext(String context) {
        this.context = context;
    }

    String getContext() {
        return this.context;
    }

    void setElementDefn(IElementDefn elementDefn) {
        assert (elementDefn instanceof PeerExtensionElementDefn);
        this.elementDefn = elementDefn;
    }

    @Override
    public IClassInfo getClassReturnType() {
        if (this.elementDefn == null) {
            return null;
        }
        IScriptableObjectClassInfo factory = ((PeerExtensionElementDefn)this.elementDefn).getScriptableFactory();
        if (factory == null) {
            return null;
        }
        return factory.getScriptableClass(this.returnType);
    }
}

