/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.OdaDesignerState;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.GraphicMasterPage;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.VariableElement;
import org.eclipse.birt.report.model.elements.interfaces.IOdaExtendableElementModel;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.metadata.ODAExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.AbstractPropertyState;
import org.eclipse.birt.report.model.parser.Base64PropertyState;
import org.eclipse.birt.report.model.parser.CompatibleColumnDataTypeState;
import org.eclipse.birt.report.model.parser.CompatibleDateTimeLevelTypeState;
import org.eclipse.birt.report.model.parser.CompatibleFormatPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleIgnorePropertyState;
import org.eclipse.birt.report.model.parser.CompatibleIncludeResourceState;
import org.eclipse.birt.report.model.parser.CompatibleIntervalState;
import org.eclipse.birt.report.model.parser.CompatibleMiscExpressionState;
import org.eclipse.birt.report.model.parser.CompatibleMustMatchState;
import org.eclipse.birt.report.model.parser.CompatibleNewHandlerOnEachEventState;
import org.eclipse.birt.report.model.parser.CompatibleODAPrivatePropertyState;
import org.eclipse.birt.report.model.parser.CompatibleOnRowPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleOperatorState;
import org.eclipse.birt.report.model.parser.CompatiblePageBreakPropState;
import org.eclipse.birt.report.model.parser.CompatibleParamAllowMumbleState;
import org.eclipse.birt.report.model.parser.CompatiblePropToExprState;
import org.eclipse.birt.report.model.parser.CompatiblePropertyState;
import org.eclipse.birt.report.model.parser.CompatibleRenamedPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleTOCPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleVariableNamePropertyState;
import org.eclipse.birt.report.model.parser.CompatibleVerticalAlignState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ElementPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class PropertyState
extends AbstractPropertyState {
    private static final int GROUP_START_PROP = "groupStart".toLowerCase().hashCode();
    private static final int CHEET_SHEET = "cheetSheet".toLowerCase().hashCode();
    private static final int FILTER_OPERATOR_MEMBER = "operator".toLowerCase().hashCode();
    private static final int MAPRULE_OPERATOR_MEMBER = "operator".toLowerCase().hashCode();
    private static final int DATE_TIME_FORMAT_STRUCT = "DateTimeFormatValue".toLowerCase().hashCode();
    private static final int NUMBER_FORMAT_STRUCT = "NumberFormatValue".toLowerCase().hashCode();
    private static final int STRING_FORMAT_STRUCT = "StringFormatValue".toLowerCase().hashCode();
    private static final int PARAM_FORMAT_STRUCT = "ParameterFormatValue".toLowerCase().hashCode();
    private static final int HEADER_HEIGHT = "headerHeight".toLowerCase().hashCode();
    private static final int FOOTER_HEIGHT = "footerHeight".toLowerCase().hashCode();
    private static final int THUMBNAIL_PROP = "thumbnail".toLowerCase().hashCode();
    private static final int DATA_MEMBER = "data".toLowerCase().hashCode();
    private static final int CONTENT_AS_BLOB_MEMBER = "stateContentAsBlob".toLowerCase().hashCode();
    private static final int ON_CREATE_METHOD = "onCreate".toLowerCase().hashCode();
    private static final int CACHED_ROW_COUNT_PROP = "cachedRowCount".toLowerCase().hashCode();
    private static final int CHOICE_VERTICAL_ALIGN = "verticalAlign".toLowerCase().hashCode();
    private static final int DEFAULT_VALUE_PROP = "defaultValue".toLowerCase().hashCode();
    private static final int DATA_TYPE_MEMBER = "dataType".toLowerCase().hashCode();
    private static final int QUERY_TEXT_MEMBER = "queryText".toLowerCase().hashCode();
    protected PropertyDefn propDefn = null;
    protected String exprType = null;

    PropertyState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    PropertyState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
        super(theHandler, element);
        this.propDefn = propDefn;
        this.struct = struct;
    }

    protected void setName(String name) {
        super.setName(name);
        this.propDefn = this.struct != null ? (PropertyDefn)this.struct.getDefn().getMember(name) : this.element.getPropertyDefn(name);
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        super.parseAttrs(attrs);
        this.exprType = attrs.getValue("type");
        if (this.handler.markLineNumber && "theme".equalsIgnoreCase(this.name)) {
            this.handler.module.addLineNo(this.element.getPropertyDefn(this.name), new Integer(this.handler.getCurrentLineNo()));
        }
    }

    public void end() throws SAXException {
        String value = this.text.toString();
        Object toSet = value;
        if (this.propDefn == null) {
            this.propDefn = this.element.getPropertyDefn(this.name);
        }
        if (this.propDefn != null && this.propDefn.allowExpression() && this.exprType != null) {
            toSet = new Expression(value, this.exprType);
        }
        this.doEnd(toSet);
    }

    protected void doEnd(Object value) {
        if (this.struct != null) {
            this.setMember(this.struct, this.propDefn.getName(), this.name, value);
            return;
        }
        IPropertyDefn jmpDefn = null;
        jmpDefn = this.struct != null ? this.struct.getDefn().getMember(this.name) : this.element.getPropertyDefn(this.name);
        if ("style".equalsIgnoreCase(this.name)) {
            if (!this.element.getDefn().hasStyle()) {
                DesignParserException e = new DesignParserException(new String[]{this.name}, "Error.DesignParserException.UNDEFINED_PROPERTY");
                RecoverableError.dealUndefinedProperty(this.handler, e);
                return;
            }
            if (this.handler.versionNumber < 3021900) {
                Map nameMap = null;
                if (this.handler.module instanceof ReportDesign) {
                    nameMap = (Map)this.handler.tempValue.get(this.handler.module);
                } else {
                    Theme theme = this.handler.module.getTheme();
                    if (theme != null) {
                        nameMap = (Map)this.handler.tempValue.get(theme);
                    }
                }
                if (nameMap != null && nameMap.get(value) != null) {
                    ((StyledElement)this.element).setStyleName((String)nameMap.get(value));
                } else {
                    ((StyledElement)this.element).setStyleName((String)value);
                }
                if (value != null) {
                    if (this.handler.styledElements == null) {
                        this.handler.styledElements = new ArrayList<DesignElement>();
                    }
                    this.handler.styledElements.add(this.element);
                }
            } else {
                ((StyledElement)this.element).setStyleName((String)value);
            }
        } else if (this.element instanceof OdaDataSet && QUERY_TEXT_MEMBER == this.nameValue && this.handler.versionNumber < 3021900) {
            value = this.deEscape((String)value);
            this.setProperty(this.name, value);
        } else if (this.handler.versionNumber >= 3021600 && this.isXMLorScriptType(jmpDefn) && !ModelUtil.isExtensionPropertyOwnModel(jmpDefn)) {
            value = this.deEscape((String)value);
            this.setProperty(this.name, value);
        } else {
            this.setProperty(this.name, value);
        }
    }

    protected AbstractParseState generalJumpTo() {
        IPropertyDefn jmpDefn = null;
        jmpDefn = this.struct != null ? this.struct.getDefn().getMember(this.name) : this.element.getPropertyDefn(this.name);
        if (jmpDefn != null && ((PropertyDefn)jmpDefn).isElementType()) {
            ElementPropertyState state = new ElementPropertyState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (this.element instanceof ReportDesign && THUMBNAIL_PROP == this.nameValue) {
            Base64PropertyState state = new Base64PropertyState(this.handler, this.element, "8859_1");
            state.setName(this.name);
            return state;
        }
        if (this.struct instanceof EmbeddedImage && DATA_MEMBER == this.nameValue) {
            Base64PropertyState state = new Base64PropertyState(this.handler, this.element, this.propDefn, this.struct, "8859_1");
            state.setName(this.name);
            return state;
        }
        if (this.struct instanceof OdaDesignerState && CONTENT_AS_BLOB_MEMBER == this.nameValue) {
            Base64PropertyState state = new Base64PropertyState(this.handler, this.element, this.propDefn, this.struct, "8859_1");
            state.setName(this.name);
            return state;
        }
        if (ON_CREATE_METHOD == this.nameValue && (this.element instanceof Cell || this.element instanceof TableRow)) {
            CompatibleMiscExpressionState state = new CompatibleMiscExpressionState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        return super.generalJumpTo();
    }

    protected AbstractParseState versionConditionalJumpTo() {
        PropertyState state;
        if (this.handler.versionNumber <= 3020700) {
            CompatiblePropertyState state2;
            IPropertyDefn jmpDefn = null;
            jmpDefn = this.struct != null ? this.struct.getDefn().getMember(this.name) : this.element.getPropertyDefn(this.name);
            if (this.element instanceof ListGroup && GROUP_START_PROP == this.nameValue) {
                CompatibleRenamedPropertyState state3 = new CompatibleRenamedPropertyState(this.handler, this.element, "groupStart");
                state3.setName("intervalBase");
                return state3;
            }
            if (this.element instanceof ReportDesign && CHEET_SHEET == this.nameValue) {
                CompatibleRenamedPropertyState state4 = new CompatibleRenamedPropertyState(this.handler, this.element, "cheetSheet");
                state4.setName("cheatSheet");
                return state4;
            }
            int jmpDefnValue = -1;
            int jmpStructDefnValue = -1;
            if (jmpDefn != null) {
                jmpDefnValue = jmpDefn.getName().toLowerCase().hashCode();
                IStructureDefn structDefn = jmpDefn.getStructDefn();
                if (structDefn != null) {
                    jmpStructDefnValue = structDefn.getName().toLowerCase().hashCode();
                }
            }
            if (FILTER_OPERATOR_MEMBER == jmpDefnValue && this.struct instanceof FilterCondition || MAPRULE_OPERATOR_MEMBER == jmpDefnValue && (this.struct instanceof MapRule || this.struct instanceof HighlightRule)) {
                state2 = new CompatibleOperatorState(this.handler, this.element, this.propDefn, this.struct);
                state2.setName(this.name);
                return state2;
            }
            if (DATE_TIME_FORMAT_STRUCT == jmpStructDefnValue || NUMBER_FORMAT_STRUCT == jmpStructDefnValue || STRING_FORMAT_STRUCT == jmpStructDefnValue || PARAM_FORMAT_STRUCT == jmpStructDefnValue) {
                state2 = new CompatibleFormatPropertyState(this.handler, this.element, this.propDefn, this.struct);
                state2.setName(this.name);
                ((CompatibleFormatPropertyState)state2).createStructure();
                return state2;
            }
            if (this.element instanceof GraphicMasterPage && (HEADER_HEIGHT == this.nameValue || FOOTER_HEIGHT == this.nameValue)) {
                return new CompatibleIgnorePropertyState(this.handler, this.element);
            }
            if (this.element instanceof ListingElement || this.element instanceof GroupElement) {
                if ("pageBreakInterval".equalsIgnoreCase(this.name) && this.element instanceof GroupElement) {
                    return new CompatibleIgnorePropertyState(this.handler, this.element);
                }
                if (this.name.equalsIgnoreCase("onStart") || this.name.equalsIgnoreCase("onFinish")) {
                    return new CompatibleIgnorePropertyState(this.handler, this.element);
                }
                if ("onRow".equalsIgnoreCase(this.name) && !(this.element instanceof TableItem)) {
                    return new CompatibleIgnorePropertyState(this.handler, this.element);
                }
                if ("onRow".equalsIgnoreCase(this.name)) {
                    return new CompatibleOnRowPropertyState(this.handler, this.element);
                }
            }
        }
        if (this.handler.versionNumber < 3021600 && this.element instanceof Module && ("includeResource".equalsIgnoreCase(this.name) || "msgBaseName".equalsIgnoreCase(this.name))) {
            state = new CompatibleIncludeResourceState(this.handler, this.element);
            state.setName("includeResource");
            return state;
        }
        if (this.handler.versionNumber < 3021400 && this.element instanceof Level && "dateTimeLevelType".equalsIgnoreCase(this.name)) {
            state = new CompatibleDateTimeLevelTypeState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (this.handler.versionNumber < 3021400 && this.element instanceof Level && "interval".equalsIgnoreCase(this.name)) {
            state = new CompatibleIntervalState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (this.handler.versionNumber < 3021200 && this.element instanceof DataSet && CACHED_ROW_COUNT_PROP == this.nameValue) {
            state = new CompatibleRenamedPropertyState(this.handler, this.element, "cachedRowCount");
            state.setName("dataSetRowLimit");
            return state;
        }
        if (this.handler.versionNumber < 3021100 && this.propDefn == null && this.element instanceof ScalarParameter && ("allowNull".equalsIgnoreCase(this.name) || "allowBlank".equalsIgnoreCase(this.name))) {
            state = new CompatibleParamAllowMumbleState(this.handler, this.element, this.name);
            state.setName("isRequired");
            return state;
        }
        if (this.handler.versionNumber <= 3021000 && this.propDefn == null && this.element instanceof IOdaExtendableElementModel) {
            List<String> privatePropDefns;
            ODAExtensionElementDefn elementDefn = null;
            if (this.element instanceof OdaDataSet) {
                elementDefn = (ODAExtensionElementDefn)((OdaDataSet)this.element).getExtDefn();
            } else if (this.element instanceof OdaDataSource) {
                elementDefn = (ODAExtensionElementDefn)((OdaDataSource)this.element).getExtDefn();
            }
            if (elementDefn != null && (privatePropDefns = elementDefn.getODAPrivateDriverPropertyNames()).contains(this.name)) {
                CompatibleODAPrivatePropertyState state5 = new CompatibleODAPrivatePropertyState(this.handler, this.element);
                state5.setName(this.name);
                return state5;
            }
        }
        if (this.handler.versionNumber < 3021000) {
            if (this.element instanceof ReportItem && "toc".equalsIgnoreCase(this.name)) {
                state = new CompatibleTOCPropertyState(this.handler, this.element);
                state.setName("toc");
                return state;
            }
            if (this.element instanceof GroupElement && "toc".equalsIgnoreCase(this.name)) {
                state = new CompatibleTOCPropertyState(this.handler, this.element);
                state.setName("toc");
                return state;
            }
        }
        if (this.handler.versionNumber < 3020200 && CHOICE_VERTICAL_ALIGN == this.nameValue) {
            state = new CompatibleVerticalAlignState(this.handler, this.element);
            state.setName("verticalAlign");
            return state;
        }
        if (this.handler.versionNumber <= 3020000 && this.struct instanceof DataSetParameter && "isNullable".equals(this.name)) {
            state = new CompatibleRenamedPropertyState(this.handler, this.element, this.propDefn, this.struct, "isNullable");
            state.setName("allowNull");
            return state;
        }
        if (ON_CREATE_METHOD == this.nameValue && this.handler.versionNumber < 3020000) {
            state = new CompatibleMiscExpressionState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (this.struct instanceof ComputedColumn && "aggregrateOn".toLowerCase().hashCode() == this.nameValue && (this.element instanceof ScalarParameter || this.element instanceof ReportItem) && this.handler.versionNumber <= 3020200) {
            state = new CompatibleRenamedPropertyState(this.handler, this.element, this.propDefn, this.struct, "aggregrateOn");
            state.setName("aggregateOn");
            return state;
        }
        if (this.handler.versionNumber < 3020600 && (this.struct instanceof DataSetParameter || this.struct instanceof OdaDataSetParameter) && DATA_TYPE_MEMBER == this.nameValue) {
            state = new CompatibleColumnDataTypeState(this.handler, this.element, this.propDefn, this.struct);
            state.setName("dataType");
            return state;
        }
        if (this.handler.versionNumber < 3020900 && this.element instanceof ScalarParameter && "mustMatch".equalsIgnoreCase(this.name)) {
            state = new CompatibleMustMatchState(this.handler, this.element);
            state.setName("mustMatch");
            return state;
        }
        if (this.handler.versionNumber < 3010000 && ("pageBreakBefore".equalsIgnoreCase(this.name) || "pageBreakAfter".equalsIgnoreCase(this.name))) {
            state = new CompatiblePageBreakPropState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (this.handler.versionNumber < 3021800 && "eventHandlerClass".equalsIgnoreCase(this.name)) {
            state = new CompatibleNewHandlerOnEachEventState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (this.handler.versionNumber < 3021900 && this.element instanceof ScalarParameter && "defaultValue".equalsIgnoreCase(this.name)) {
            state = new CompatiblePropToExprState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (this.handler.versionNumber < 3022000 && this.element instanceof VariableElement && "variableName".equalsIgnoreCase(this.name)) {
            state = new CompatibleVariableNamePropertyState(this.handler, this.element);
            state.setName("name");
            return state;
        }
        return super.versionConditionalJumpTo();
    }

    private boolean isXMLorScriptType(IPropertyDefn jmpDefn) {
        return jmpDefn != null && (jmpDefn.getTypeCode() == 18 || jmpDefn.getTypeCode() == 12);
    }
}

