/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.simpleapi.IFilterCondition;
import org.eclipse.birt.report.model.api.simpleapi.IMultiRowItem;
import org.eclipse.birt.report.model.api.simpleapi.ISortCondition;
import org.eclipse.birt.report.model.simpleapi.FilterConditionImpl;
import org.eclipse.birt.report.model.simpleapi.ReportItem;
import org.eclipse.birt.report.model.simpleapi.SortConditionImpl;

public class MultiRowItem
extends ReportItem
implements IMultiRowItem {
    private final String filterPropName;
    private final String sortPropName;

    public MultiRowItem(ReportItemHandle item) {
        super(item);
        if (item instanceof ListingHandle) {
            this.filterPropName = "filter";
            this.sortPropName = "sort";
        } else if (item instanceof ExtendedItemHandle) {
            this.filterPropName = "filter";
            this.sortPropName = null;
        } else {
            this.filterPropName = null;
            this.sortPropName = null;
        }
    }

    public IFilterCondition[] getFilterConditions() {
        if (this.filterPropName == null) {
            return null;
        }
        PropertyHandle propHandle = this.handle.getPropertyHandle(this.filterPropName);
        Iterator iterator = propHandle.iterator();
        ArrayList<FilterConditionImpl> rList = new ArrayList<FilterConditionImpl>();
        int count = 0;
        while (iterator.hasNext()) {
            FilterConditionHandle conditionHandle = (FilterConditionHandle)iterator.next();
            FilterConditionImpl f = new FilterConditionImpl(conditionHandle);
            rList.add(f);
            ++count;
        }
        return rList.toArray(new IFilterCondition[count]);
    }

    public ISortCondition[] getSortConditions() {
        if (this.sortPropName == null) {
            return null;
        }
        PropertyHandle propHandle = this.handle.getPropertyHandle(this.sortPropName);
        Iterator iterator = propHandle.iterator();
        ArrayList<SortConditionImpl> rList = new ArrayList<SortConditionImpl>();
        int count = 0;
        while (iterator.hasNext()) {
            SortKeyHandle sortHandle = (SortKeyHandle)iterator.next();
            SortConditionImpl s = new SortConditionImpl(sortHandle);
            rList.add(s);
            ++count;
        }
        return rList.toArray(new ISortCondition[count]);
    }

    public void addFilterCondition(IFilterCondition condition) throws SemanticException {
        if (this.filterPropName == null || condition == null) {
            return;
        }
        PropertyHandle propHandle = this.handle.getPropertyHandle(this.filterPropName);
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            propHandle.addItem(condition.getStructure());
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void addSortCondition(ISortCondition condition) throws SemanticException {
        if (this.sortPropName == null || condition == null) {
            return;
        }
        PropertyHandle propHandle = this.handle.getPropertyHandle(this.sortPropName);
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            propHandle.addItem(condition.getStructure());
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void removeFilterCondition(IFilterCondition condition) throws SemanticException {
        if (this.filterPropName == null) {
            return;
        }
        PropertyHandle propHandle = this.handle.getPropertyHandle(this.filterPropName);
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            propHandle.removeItem(condition.getStructure());
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void removeFilterConditions() throws SemanticException {
        if (this.filterPropName == null) {
            return;
        }
        PropertyHandle propHandle = this.handle.getPropertyHandle(this.filterPropName);
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            propHandle.clearValue();
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void removeSortCondition(ISortCondition condition) throws SemanticException {
        if (this.sortPropName == null) {
            return;
        }
        PropertyHandle propHandle = this.handle.getPropertyHandle(this.sortPropName);
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            propHandle.removeItem(condition.getStructure());
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void removeSortConditions() throws SemanticException {
        if (this.sortPropName == null) {
            return;
        }
        PropertyHandle propHandle = this.handle.getPropertyHandle(this.sortPropName);
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            propHandle.clearValue();
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }
}

