/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.math.BigDecimal;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.extension.IEncryptionHelper;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class EncryptionUtil {
    public static Object decrypt(DesignElement element, ElementPropertyDefn propDefn, Object value) {
        String encryption = element.getEncryptionID(propDefn);
        if (encryption == null) {
            return value;
        }
        String str = null;
        if (value instanceof String) {
            str = (String)value;
        } else if (value instanceof Expression) {
            str = ((Expression)value).getStringExpression();
        }
        return EncryptionUtil.decrypt(propDefn, encryption, (Object)str);
    }

    public static Object decrypt(PropertyDefn propDefn, String encryptionID, Object value) {
        if (!(value instanceof String) && !(value instanceof Expression) || !propDefn.isEncryptable() && !EncryptionUtil.isPropertyBindingValueMember(propDefn)) {
            return value;
        }
        String str = null;
        str = value instanceof String ? (String)value : ((Expression)value).getStringExpression();
        IEncryptionHelper helper = MetaDataDictionary.getInstance().getEncryptionHelper(encryptionID);
        return helper == null ? value : helper.decrypt(str);
    }

    private static boolean isPropertyBindingValueMember(PropertyDefn propDefn) {
        return propDefn != null && propDefn.equals(MetaDataDictionary.getInstance().getStructure("PropertyBinding").getMember("value"));
    }

    public static Object encrypt(PropertyDefn propDefn, String encryptionID, Object value) {
        if (!(value instanceof String) && !(value instanceof Expression) || !propDefn.isEncryptable() && !EncryptionUtil.isPropertyBindingValueMember(propDefn)) {
            return value;
        }
        String str = null;
        str = value instanceof String ? (String)value : ((Expression)value).getStringExpression();
        IEncryptionHelper helper = MetaDataDictionary.getInstance().getEncryptionHelper(encryptionID);
        return helper == null ? value : helper.encrypt(str);
    }

    public static boolean canEncrypt(PropertyDefn propDefn) {
        if (propDefn == null) {
            return false;
        }
        return propDefn.isEncryptable() || EncryptionUtil.isPropertyBindingValueMember(propDefn);
    }

    private static String getEncryptionForBindingValue(Module module, Structure structure, PropertyDefn memberDefn, Object value) {
        if (structure instanceof PropertyBinding && module != null && value != null && "value".equals(memberDefn.getName())) {
            ElementPropertyDefn boundPropDefn;
            String propName;
            PropertyBinding propBinding = (PropertyBinding)structure;
            String encryptionID = propBinding.getEncryption();
            if (encryptionID != null) {
                return encryptionID;
            }
            BigDecimal idDecimal = propBinding.getID();
            long id = idDecimal == null ? -1L : idDecimal.longValue();
            DesignElement targetElement = module.getElementByID(id);
            if (targetElement != null && !StringUtil.isBlank(propName = propBinding.getName()) && (boundPropDefn = targetElement.getPropertyDefn(propBinding.getName())) != null && boundPropDefn.isEncryptable()) {
                encryptionID = targetElement.getEncryptionID(boundPropDefn);
            }
            return encryptionID;
        }
        if (structure instanceof PropertyBinding) {
            PropertyBinding propBinding = (PropertyBinding)structure;
            return propBinding.getEncryption();
        }
        return null;
    }

    public static void setEncryptionBindingValue(Module module, Structure structure, PropertyDefn memberDefn, Object value) {
        MetaDataDictionary dd;
        if (!(structure instanceof PropertyBinding)) {
            return;
        }
        if (!EncryptionUtil.needEncryption(value)) {
            structure.setProperty(memberDefn, value);
            return;
        }
        PropertyBinding propBinding = (PropertyBinding)structure;
        String encryptionID = EncryptionUtil.getEncryptionForBindingValue(module, structure, memberDefn, value);
        if (encryptionID != null && (dd = MetaDataDictionary.getInstance()).getEncryptionHelper(encryptionID) != null) {
            propBinding.setEncryption(encryptionID);
            Object encryptedValue = EncryptionUtil.encrypt(memberDefn, encryptionID, value);
            if (value instanceof String) {
                propBinding.setProperty(memberDefn, encryptedValue);
            } else {
                Expression exprValue = (Expression)value;
                Expression encryptedExprValue = new Expression(encryptedValue, exprValue.getUserDefinedType());
                propBinding.setProperty(memberDefn, (Object)encryptedExprValue);
            }
            return;
        }
        structure.setProperty(memberDefn, value);
    }

    private static boolean needEncryption(Object value) {
        Expression exprValue;
        return value instanceof Expression && "constant".equalsIgnoreCase((exprValue = (Expression)value).getType());
    }
}

