/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.ISession;
import org.eclipse.pde.api.tools.internal.provisional.ISessionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ApiUIPlugin
extends AbstractUIPlugin {
    private static Map fCompositeImages = new HashMap();
    private static ApiUIPlugin fgDefault = null;
    private static final String ICONS_PATH = "$nl$/icons/full/";
    private static final String DLCL = "$nl$/icons/full/dlcl16/";
    private static final String ELCL = "$nl$/icons/full/elcl16/";
    public static final int INTERNAL_ERROR = 120;
    private static final String OBJECT = "$nl$/icons/full/obj16/";
    private static final String OVR = "$nl$/icons/full/ovr16/";
    public static final String PLUGIN_ID = "org.eclipse.pde.api.tools.ui";
    private static final String WIZBAN = "$nl$/icons/full/wizban/";
    private BundleContext fBundleContext = null;
    private ISessionListener sessionListener = new ISessionListener(){

        public void sessionAdded(ISession addedSession) {
            ApiUIPlugin.this.getWorkbench().getDisplay().asyncExec(new Runnable(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    1.access$0(this.this$1).showAPIToolingView();
                }
            });
        }

        public void sessionRemoved(ISession removedSession) {
        }

        public void sessionActivated(ISession session) {
        }

        static /* synthetic */ ApiUIPlugin access$0(1 var0) {
            return var0.ApiUIPlugin.this;
        }
    };

    private static final void declareRegistryImage(ImageRegistry reg, String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        URL url = null;
        if (bundle != null) {
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        reg.put(key, desc);
    }

    public static ApiUIPlugin getDefault() {
        if (fgDefault == null) {
            fgDefault = new ApiUIPlugin();
        }
        return fgDefault;
    }

    public static Image getImage(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = (Image)fCompositeImages.get(descriptor)) != null) {
            return result;
        }
        result = descriptor.createImage();
        if (result != null) {
            fCompositeImages.put(descriptor, result);
        }
        return result;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return ApiUIPlugin.getDefault().getImageRegistry().getDescriptor(key);
    }

    public static String getPluginIdentifier() {
        return PLUGIN_ID;
    }

    public static Image getSharedImage(String key) {
        return ApiUIPlugin.getDefault().getImageRegistry().get(key);
    }

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public static void log(IStatus status) {
        if (ApiUIPlugin.getDefault() == null) {
            Throwable exception = status.getException();
            if (exception != null) {
                exception.printStackTrace();
            }
        } else {
            ApiUIPlugin.getDefault().getLog().log(status);
        }
    }

    public static void log(Throwable t) {
        ApiUIPlugin.log(ApiUIPlugin.newErrorStatus("Error logged from API Tools UI: ", t));
    }

    public static void logErrorMessage(String message) {
        ApiUIPlugin.log(ApiUIPlugin.newErrorStatus("Internal message logged from API Tools UI: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, ApiUIPlugin.getPluginIdentifier(), 120, message, exception);
    }

    public ApiUIPlugin() {
        fgDefault = this;
    }

    public Object acquireService(String serviceName) {
        ServiceReference reference = this.fBundleContext.getServiceReference(serviceName);
        if (reference == null) {
            return null;
        }
        return this.fBundleContext.getService(reference);
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        ApiUIPlugin.declareRegistryImage(reg, "IMG_OBJ_API_COMPONENT", "$nl$/icons/full/obj16/api_tools.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_OBJ_API_SYSTEM_LIBRARY", "$nl$/icons/full/obj16/library_obj.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_OBJ_API_SEARCH", "$nl$/icons/full/obj16/extract_references.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_OBJ_BUNDLE", "$nl$/icons/full/obj16/plugin_obj.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_OBJ_FRAGMENT", "$nl$/icons/full/obj16/frgmt_obj.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_OBJ_ECLIPSE_PROFILE", "$nl$/icons/full/obj16/eclipse_profile.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_OBJ_BUNDLE_VERSION", "$nl$/icons/full/obj16/bundleversion.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_OVR_ERROR", "$nl$/icons/full/ovr16/error_ovr.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_OVR_WARNING", "$nl$/icons/full/ovr16/warning_ovr.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_OVR_SUCCESS", "$nl$/icons/full/ovr16/success_ovr.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_WIZBAN_PROFILE", "$nl$/icons/full/wizban/profile_wiz.png");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_WIZBAN_COMPARE_TO_BASELINE", "$nl$/icons/full/wizban/compare_wiz.png");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_ELCL_FILTER", "$nl$/icons/full/elcl16/filter_ps.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_ELCL_REMOVE", "$nl$/icons/full/elcl16/remove_exc.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_ELCL_OPEN_PAGE", "$nl$/icons/full/elcl16/open_page.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_ELCL_COMPARE_APIS", "$nl$/icons/full/elcl16/compare_apis.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_ELCL_COMPARE_APIS_DISABLED", "$nl$/icons/full/dlcl16/compare_apis.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_ELCL_EXPORT", "$nl$/icons/full/elcl16/export.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_ELCL_NEXT_NAV", "$nl$/icons/full/elcl16/next_nav.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_ELCL_PREV_NAV", "$nl$/icons/full/elcl16/prev_nav.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_ELCL_EXPANDALL", "$nl$/icons/full/elcl16/expandall.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_DLCL_EXPORT", "$nl$/icons/full/dlcl16/export.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_DLCL_NEXT_NAV", "$nl$/icons/full/dlcl16/next_nav.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_DLCL_PREV_NAV", "$nl$/icons/full/dlcl16/prev_nav.gif");
        ApiUIPlugin.declareRegistryImage(reg, "IMG_DLCL_EXPANDALL", "$nl$/icons/full/dlcl16/expandall.gif");
    }

    void showAPIToolingView() {
        this.showView("org.eclipse.pde.api.tools.ui.views.apitooling.views.apitoolingview");
    }

    public void showPropertiesView() {
        this.showView("org.eclipse.ui.views.PropertySheet");
    }

    private void showView(String id) {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            try {
                IViewPart view = page.showView(id);
                page.bringToTop((IWorkbenchPart)view);
            }
            catch (PartInitException e) {
                ApiUIPlugin.log(e);
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        this.fBundleContext = context;
        ApiPlugin.getDefault().getSessionManager().addSessionListener(this.sessionListener);
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        Iterator iter = fCompositeImages.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        fCompositeImages.clear();
        this.fBundleContext = null;
        ApiPlugin.getDefault().getSessionManager().removeSessionListener(this.sessionListener);
        super.stop(context);
    }
}

