/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.dbprofile.ui.internal.sqb;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.impl.Connection;
import org.eclipse.birt.report.data.oda.jdbc.dbprofile.impl.Driver;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.ExactNumericDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.NumericalDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionVariable;
import org.eclipse.datatools.modelbase.sql.query.helper.DataTypeHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class SQLQueryUtility {
    private static final String EMPTY_STRING = "";
    private static final String PROP_PRIVATE_PARAMETERMETADATA = "parameterMetaData";
    private static final String CONST_PARAMS_DELIMITER = ";";
    private static final String CONST_PARAM_NAME_DELIMITER = ",";

    static void updateDataSetDesign(DataSetDesign dataSetDesign, QueryStatement queryStmt, IConnectionProfile connProfile, String dataSetName) {
        block11: {
            if (dataSetName != null) {
                dataSetDesign.setName(dataSetName);
            }
            dataSetDesign.setQueryText(EMPTY_STRING);
            boolean wasProfileConnected = connProfile.getConnectionState() == 1;
            IConnection customConn = null;
            try {
                try {
                    Driver customDriver = new Driver();
                    customConn = customDriver.getConnection(null);
                    assert (customConn instanceof Connection);
                    ((Connection)customConn).open(connProfile);
                    SQLQueryUtility.updateQueryMetaData(dataSetDesign, customConn, queryStmt);
                }
                catch (OdaException e) {
                    e.printStackTrace();
                    String queryText = dataSetDesign.getQueryText();
                    if (queryText == null || queryText.length() == 0) {
                        SQLQueryUtility.updateQueryText(dataSetDesign, queryStmt);
                    }
                    dataSetDesign.setResultSets(null);
                    dataSetDesign.setParameters(null);
                    if (!wasProfileConnected) {
                        SQLQueryUtility.closeConnection(customConn);
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (!wasProfileConnected) {
                    SQLQueryUtility.closeConnection(customConn);
                }
                throw throwable;
            }
            if (!wasProfileConnected) {
                SQLQueryUtility.closeConnection(customConn);
            }
        }
    }

    public static void setSystemHelp(Control control, String contextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, contextId);
    }

    private static void updateQueryText(DataSetDesign dataSetDesign, QueryStatement queryStmt) {
        dataSetDesign.setQueryText(SQLQueryUtility.getPreparableSQL(queryStmt));
    }

    private static void updateQueryMetaData(DataSetDesign dataSetDesign, IConnection conn, QueryStatement queryStmt) throws OdaException {
        SQLQueryUtility.updateQueryText(dataSetDesign, queryStmt);
        String queryText = dataSetDesign.getQueryText();
        IQuery query = conn.newQuery(null);
        query.prepare(queryText);
        try {
            IResultSetMetaData md = query.getMetaData();
            SQLQueryUtility.updateResultSetDesign(md, dataSetDesign);
        }
        catch (OdaException e) {
            dataSetDesign.setResultSets(null);
            e.printStackTrace();
        }
        SQLQueryUtility.updateParameterDesign(dataSetDesign, queryStmt);
    }

    static String getPreparableSQL(QueryStatement queryStmt) {
        if (queryStmt == null) {
            return null;
        }
        QueryStatement queryStmtCopy = SQLQueryUtility.copyQueryStatement(queryStmt);
        SQLQueryUtility.convertNamedVariablesToMarkers(queryStmtCopy);
        String queryText = StatementHelper.getSQLWithoutComments((SQLQueryObject)queryStmtCopy);
        return queryText;
    }

    private static QueryStatement copyQueryStatement(QueryStatement queryStmt) {
        QueryStatement queryStmtCopy = (QueryStatement)EcoreUtil.copy((EObject)queryStmt);
        queryStmtCopy.setSourceInfo(queryStmt.getSourceInfo());
        return queryStmtCopy;
    }

    private static void convertNamedVariablesToMarkers(QueryStatement queryStmt) {
        List paramVars = StatementHelper.getAllVariablesInQueryStatement((QueryStatement)queryStmt, (boolean)false, null);
        if (paramVars.isEmpty()) {
            return;
        }
        for (ValueExpressionVariable var : paramVars) {
            if (var.getName() == null) continue;
            var.setName(null);
        }
    }

    static boolean isEquivalentSQL(String sql1, String sql2) {
        if (sql1 == null || sql2 == null) {
            return sql1 == sql2;
        }
        return StatementHelper.compareSQL((String)sql1, (String)sql2) == 0;
    }

    private static void updateResultSetDesign(IResultSetMetaData md, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private static void updateParameterDesign(DataSetDesign dataSetDesign, QueryStatement queryStmt) {
        if (dataSetDesign == null || queryStmt == null) {
            return;
        }
        List paramVars = StatementHelper.getAllVariablesInQueryStatement((QueryStatement)queryStmt, (boolean)false);
        if (paramVars.isEmpty()) {
            dataSetDesign.setParameters(null);
            if (dataSetDesign.getPrivateProperties() != null) {
                dataSetDesign.getPrivateProperties().setProperty(PROP_PRIVATE_PARAMETERMETADATA, EMPTY_STRING);
            }
            return;
        }
        DataSetParameters dataSetParams = DesignFactory.eINSTANCE.createDataSetParameters();
        dataSetDesign.setParameters(dataSetParams);
        Iterator paramVarsIter = paramVars.iterator();
        int index = 0;
        StringBuffer paramMdPropBuf = new StringBuffer();
        while (paramVarsIter.hasNext()) {
            ValueExpressionVariable var = (ValueExpressionVariable)paramVarsIter.next();
            ParameterDefinition paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
            paramDefn.setInOutMode(ParameterMode.IN_LITERAL);
            DataElementAttributes paramAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
            paramDefn.setAttributes(paramAttrs);
            paramAttrs.setPosition(++index);
            paramAttrs.setName(var.getName());
            SQLQueryUtility.convertToDataElementAttributes(var, paramAttrs);
            SQLQueryUtility.adjustParameterDefinition(paramDefn);
            dataSetParams.getParameterDefinitions().add((Object)paramDefn);
            if (paramAttrs.getName() == null || paramAttrs.getName().trim().length() <= 0) continue;
            if (paramMdPropBuf.length() > 0) {
                paramMdPropBuf.append(CONST_PARAMS_DELIMITER);
            }
            paramMdPropBuf.append(String.valueOf(paramAttrs.getPosition()) + CONST_PARAM_NAME_DELIMITER + paramAttrs.getName());
        }
        if (dataSetDesign.getPrivateProperties() == null) {
            try {
                Properties props = new Properties();
                props.setProperty(PROP_PRIVATE_PARAMETERMETADATA, EMPTY_STRING);
                dataSetDesign.setPrivateProperties(DesignSessionUtil.createDataSetNonPublicProperties((String)dataSetDesign.getOdaExtensionDataSourceId(), (String)dataSetDesign.getOdaExtensionDataSetId(), (Properties)props));
            }
            catch (OdaException odaException) {
                return;
            }
        }
        dataSetDesign.getPrivateProperties().setProperty(PROP_PRIVATE_PARAMETERMETADATA, paramMdPropBuf.toString());
    }

    private static void convertToDataElementAttributes(ValueExpressionVariable var, DataElementAttributes elementAttrs) {
        DataType varDataType = var.getDataType();
        elementAttrs.setNativeDataTypeCode(SQLQueryUtility.getJDBCTypeCode(varDataType));
        if (varDataType != null) {
            if (varDataType instanceof NumericalDataType) {
                int precision = ((NumericalDataType)varDataType).getPrecision();
                if (precision > 0) {
                    elementAttrs.setPrecision(precision);
                }
            } else if (varDataType instanceof CharacterStringDataType) {
                elementAttrs.setPrecision(((CharacterStringDataType)varDataType).getLength());
            }
            if (varDataType instanceof ExactNumericDataType) {
                elementAttrs.setScale(((ExactNumericDataType)varDataType).getScale());
            }
        }
        if (var.getLabel() != null) {
            elementAttrs.setUiDisplayName(var.getLabel());
        }
        if (var.getDescription() != null) {
            elementAttrs.setUiDescription(var.getDescription());
        }
    }

    private static int getJDBCTypeCode(DataType varDataType) {
        if (varDataType == null) {
            return 0;
        }
        int nativeTypeCode = DataTypeHelper.getJDBCTypeForNamedType((String)varDataType.getName());
        if (nativeTypeCode != 0) {
            return nativeTypeCode;
        }
        if (varDataType instanceof PredefinedDataType && ((PredefinedDataType)varDataType).getPrimitiveType().getValue() == 17) {
            return 16;
        }
        return 0;
    }

    private static void adjustParameterDefinition(ParameterDefinition paramDefn) {
        assert (paramDefn != null);
        DataElementAttributes paramAttributes = paramDefn.getAttributes();
        if (paramAttributes == null) {
            return;
        }
        if (paramAttributes.getNativeDataTypeCode() == 0) {
            paramAttributes.setNativeDataTypeCode(1);
        }
        if (paramAttributes.allowsNull()) {
            paramAttributes.setNullability(ElementNullability.NOT_NULLABLE_LITERAL);
        }
    }

    private static void closeConnection(IConnection conn) {
        try {
            if (conn != null && conn.isOpen()) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }
}

