/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.util.DatasetClassPathHelper;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScriptLibHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataSetProvider {
    private static final String BIRT_SCRIPTLIB = "/birt/scriptlib";
    private static final String BIRT_CLASSES = "/birt/WEB-INF/classes/";
    private static final String VIEWER_NAMESPACE = "org.eclipse.birt.report.viewer";
    private static DataSetProvider instance = null;
    private transient Hashtable htColumns = new Hashtable(10);
    private static Hashtable htDataSourceExtensions = new Hashtable(10);
    private transient Hashtable sessionTable = new Hashtable(10);
    private static final char RENAME_SEPARATOR = '_';
    private static String UNNAME_PREFIX = "UNNAMED";

    private static DataSetProvider newInstance() {
        return new DataSetProvider();
    }

    public static DataSetProvider getCurrentInstance() {
        if (instance == null) {
            instance = DataSetProvider.newInstance();
        }
        return instance;
    }

    public DataSetViewData[] getColumns(String dataSetName, boolean refresh) {
        ModuleHandle handle = Utility.getReportModuleHandle();
        DataSetHandle dataSet = handle.findDataSet(dataSetName);
        if (dataSet == null) {
            return new DataSetViewData[0];
        }
        return this.getColumns(dataSet, refresh);
    }

    public DataSetViewData[] getColumns(DataSetHandle dataSet, boolean refresh) {
        return this.getColumns(dataSet, refresh, true, false);
    }

    public DataSetViewData[] getColumns(DataSetHandle dataSet, boolean refresh, boolean useColumnHints, boolean suppressErrorMessage) {
        if (dataSet == null) {
            return new DataSetViewData[0];
        }
        DataSetViewData[] columns = null;
        try {
            DataSessionContext context = new DataSessionContext(3, dataSet.getModuleHandle());
            DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
            columns = (DataSetViewData[])this.htColumns.get(dataSet);
            if (columns == null || refresh) {
                columns = this.populateAllOutputColumns(dataSet, session);
                this.htColumns.put(dataSet, columns);
            }
            session.shutdown();
        }
        catch (BirtException e) {
            if (!suppressErrorMessage) {
                ExceptionHandler.handle(e);
            }
            columns = null;
        }
        if (columns == null) {
            columns = new DataSetViewData[]{};
            this.htColumns.put(dataSet, columns);
        }
        return columns;
    }

    public DataSetViewData[] populateAllOutputColumns(DataSetHandle dataSetHandle, DataRequestSession session) throws BirtException {
        IResultMetaData metaData = session.getDataSetMetaData(dataSetHandle, false);
        if (metaData == null) {
            return new DataSetViewData[0];
        }
        DataSetViewData[] items = new DataSetViewData[metaData.getColumnCount()];
        int i = 0;
        while (i < metaData.getColumnCount()) {
            items[i] = new DataSetViewData();
            items[i].setName(metaData.getColumnName(i + 1));
            items[i].setDataTypeName(DataAdapterUtil.adapterToModelDataType((int)metaData.getColumnType(i + 1)));
            items[i].setAlias(metaData.getColumnAlias(i + 1));
            items[i].setComputedColumn(metaData.isComputedColumn(i + 1));
            items[i].setPosition(i + 1);
            items[i].setDataType(metaData.getColumnType(i + 1));
            ++i;
        }
        this.updateModel(dataSetHandle, items);
        return items;
    }

    public DataSetViewData[] populateAllCachedMetaData(DataSetHandle dataSetHandle, DataRequestSession session) throws BirtException {
        IResultMetaData metaData = session.getDataSetMetaData(dataSetHandle, true);
        DataSetViewData[] items = new DataSetViewData[metaData.getColumnCount()];
        int i = 0;
        while (i < metaData.getColumnCount()) {
            items[i] = new DataSetViewData();
            items[i].setName(metaData.getColumnName(i + 1));
            items[i].setDataTypeName(DataAdapterUtil.adapterToModelDataType((int)metaData.getColumnType(i + 1)));
            items[i].setAlias(metaData.getColumnAlias(i + 1));
            items[i].setComputedColumn(metaData.isComputedColumn(i + 1));
            items[i].setPosition(i + 1);
            items[i].setDataType(metaData.getColumnType(i + 1));
            ++i;
        }
        return items;
    }

    public void updateColumnsOfDataSetHandle(DataSetHandle dataSet, DataSetViewData[] dsItemModel) {
        if (dataSet == null || dsItemModel == null || dsItemModel.length == 0) {
            return;
        }
        this.htColumns.put(dataSet, dsItemModel);
    }

    public void setModelOfDataSetHandle(DataSetHandle dataSet, DataSetViewData[] dsItemModel) {
        if (dataSet == null || dsItemModel == null) {
            return;
        }
        this.updateModel(dataSet, dsItemModel);
        this.cleanUnusedResultSetColumn(dataSet, dsItemModel);
        this.cleanUnusedComputedColumn(dataSet, dsItemModel);
        this.htColumns.put(dataSet, dsItemModel);
    }

    private void cleanUnusedResultSetColumn(DataSetHandle dataSetHandle, DataSetViewData[] dsItemModel) {
        PropertyHandle handle = dataSetHandle.getPropertyHandle("resultSet");
        if (handle != null && handle.getListValue() != null) {
            ArrayList list = handle.getListValue();
            int count = list.size();
            int n = count - 1;
            while (n >= 0) {
                ResultSetColumn rsColumn = (ResultSetColumn)list.get(n);
                String columnName = rsColumn.getColumnName();
                boolean found = false;
                int m = 0;
                while (m < dsItemModel.length) {
                    if (columnName.equals(dsItemModel[m].getName())) {
                        found = true;
                        break;
                    }
                    ++m;
                }
                if (!found) {
                    try {
                        handle.removeItem((Object)rsColumn);
                    }
                    catch (PropertyValueException propertyValueException) {}
                }
                --n;
            }
        }
    }

    private void cleanUnusedComputedColumn(DataSetHandle dataSetHandle, DataSetViewData[] dsItemModel) {
        PropertyHandle handle = dataSetHandle.getPropertyHandle("computedColumns");
        if (handle != null && handle.getListValue() != null) {
            ArrayList list = handle.getListValue();
            int count = list.size();
            int n = count - 1;
            while (n >= 0) {
                ComputedColumn rsColumn = (ComputedColumn)list.get(n);
                String columnName = rsColumn.getName();
                boolean found = false;
                int m = 0;
                while (m < dsItemModel.length) {
                    if (columnName.equals(dsItemModel[m].getName())) {
                        found = true;
                        break;
                    }
                    ++m;
                }
                if (!found) {
                    try {
                        handle.removeItem((Object)rsColumn);
                    }
                    catch (PropertyValueException propertyValueException) {}
                }
                --n;
            }
        }
    }

    public IQueryResults execute(DataSetHandle dataSet, DataRequestSession session) throws BirtException {
        return this.execute(dataSet, true, true, -1, session);
    }

    public IQueryResults execute(DataSetHandle dataSet, boolean useColumnHints, boolean useFilters, int rowsToReturn, DataRequestSession session) throws BirtException {
        this.populateAllOutputColumns(dataSet, session);
        BaseDataSetDesign dataSetDesign = session.getModelAdaptor().adaptDataSet(dataSet);
        if (!useColumnHints) {
            dataSetDesign.getResultSetHints().clear();
        }
        if (!useFilters) {
            dataSetDesign.getFilters().clear();
        }
        QueryDefinition queryDefn = this.getQueryDefinition((IBaseDataSetDesign)dataSetDesign, rowsToReturn);
        IQueryResults resultSet = this.executeQuery(session, (IQueryDefinition)queryDefn);
        this.saveResultToDataItems(dataSet, resultSet);
        return resultSet;
    }

    public IQueryResults execute(DataSetHandle dataSet, QueryDefinition queryDefn, boolean useColumnHints, boolean useFilters, DataRequestSession session) throws BirtException {
        return this.execute(dataSet, (IQueryDefinition)queryDefn, useColumnHints, useFilters, false, session);
    }

    public IQueryResults execute(DataSetHandle dataSet, IQueryDefinition queryDefn, boolean useColumnHints, boolean useFilters, boolean clearCache, DataRequestSession session) throws BirtException {
        BaseDataSetDesign dataSetDesign = session.getModelAdaptor().adaptDataSet(dataSet);
        if (clearCache) {
            BaseDataSourceDesign dataSourceDesign = session.getModelAdaptor().adaptDataSource(dataSet.getDataSource());
            session.clearCache((IBaseDataSourceDesign)dataSourceDesign, (IBaseDataSetDesign)dataSetDesign);
        }
        if (!useColumnHints) {
            dataSetDesign.getResultSetHints().clear();
        }
        if (!useFilters) {
            dataSetDesign.getFilters().clear();
        }
        IQueryResults resultSet = this.executeQuery(session, queryDefn);
        this.saveResultToDataItems(dataSet, resultSet);
        return resultSet;
    }

    private void saveResultToDataItems(DataSetHandle dataSet, IQueryResults resultSet) throws BirtException {
        IResultMetaData metaData = resultSet.getResultMetaData();
        int columnCount = 0;
        if (metaData != null) {
            columnCount = metaData.getColumnCount();
        }
        DataSetViewData[] columns = new DataSetViewData[columnCount];
        HashSet<String> orgColumnNameSet = new HashSet<String>();
        HashSet<String> uniqueColumnNameSet = new HashSet<String>();
        int n = 0;
        while (n < columns.length) {
            orgColumnNameSet.add(metaData.getColumnName(n + 1));
            ++n;
        }
        n = 0;
        while (n < columns.length) {
            columns[n] = new DataSetViewData();
            columns[n].setParent(dataSet);
            columns[n].setDataType(metaData.getColumnType(n + 1));
            columns[n].setDataTypeName(metaData.getColumnTypeName(n + 1));
            columns[n].setPosition(n + 1);
            columns[n].setAlias(metaData.getColumnAlias(n + 1));
            columns[n].setComputedColumn(metaData.isComputedColumn(n + 1));
            String columnName = metaData.getColumnName(n + 1);
            String uniqueColumnName = this.getUniqueName(orgColumnNameSet, uniqueColumnNameSet, columnName, n);
            columns[n].setDataSetColumnName(uniqueColumnName);
            uniqueColumnNameSet.add(uniqueColumnName);
            if (!uniqueColumnName.equals(columnName)) {
                this.updateModelColumn(dataSet, columns[n]);
            }
            ++n;
        }
        this.updateModel(dataSet, columns);
        this.htColumns.put(dataSet, columns);
    }

    /*
     * Unable to fully structure code
     */
    private void updateModelColumn(DataSetHandle ds, DataSetViewData column) {
        resultSetColumns = ds.getPropertyHandle("resultSet");
        if (resultSetColumns == null) {
            return;
        }
        iterator = resultSetColumns.iterator();
        if (iterator != null) ** GOTO lbl17
        return;
lbl-1000:
        // 1 sources

        {
            rsColumnHandle = (ResultSetColumnHandle)iterator.next();
            if (!DataSetProvider.$assertionsDisabled && rsColumnHandle.getPosition() == null) {
                throw new AssertionError();
            }
            if (rsColumnHandle.getPosition().intValue() != column.getPosition()) continue;
            if (rsColumnHandle.getColumnName() == null || rsColumnHandle.getColumnName().equals(column.getDataSetColumnName())) break;
            try {
                rsColumnHandle.setColumnName(column.getDataSetColumnName());
            }
            catch (SemanticException v0) {}
            break;
lbl17:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl18:
        // 4 sources

    }

    private IQueryResults executeQuery(DataRequestSession session, IQueryDefinition queryDefn) throws BirtException {
        IQueryResults resultSet = session.executeQuery(queryDefn, null, null, null);
        return resultSet;
    }

    public final QueryDefinition getQueryDefinition(IBaseDataSetDesign dataSetDesign, int rowsToReturn) {
        if (dataSetDesign != null) {
            QueryDefinition defn = new QueryDefinition(null);
            defn.setDataSetName(dataSetDesign.getName());
            if (rowsToReturn > 0) {
                defn.setMaxRows(rowsToReturn);
            }
            List parameters = dataSetDesign.getParameters();
            for (ParameterDefinition paramDefn : parameters) {
                if (!paramDefn.isInputMode() || paramDefn.getDefaultInputValue() == null) continue;
                InputParameterBinding binding = new InputParameterBinding(paramDefn.getName(), (IBaseExpression)new ScriptExpression(paramDefn.getDefaultInputValue()));
                defn.addInputParamBinding(binding);
            }
            return defn;
        }
        return null;
    }

    public final QueryDefinition getQueryDefinition(IBaseDataSetDesign dataSetDesign, ParamBindingHandle[] bindingParams) {
        return this.getQueryDefinition(dataSetDesign, bindingParams, -1);
    }

    private QueryDefinition getQueryDefinition(IBaseDataSetDesign dataSetDesign, ParamBindingHandle[] bindingParams, int rowsToReturn) {
        if (bindingParams == null || bindingParams.length == 0) {
            return this.getQueryDefinition(dataSetDesign, rowsToReturn);
        }
        if (dataSetDesign != null) {
            QueryDefinition defn = new QueryDefinition(null);
            defn.setDataSetName(dataSetDesign.getName());
            if (rowsToReturn > 0) {
                defn.setMaxRows(rowsToReturn);
            }
            int i = 0;
            while (i < bindingParams.length) {
                ParamBindingHandle param = bindingParams[i];
                InputParameterBinding binding = new InputParameterBinding(param.getParamName(), (IBaseExpression)new ScriptExpression(param.getExpression()));
                defn.addInputParamBinding(binding);
                ++i;
            }
            return defn;
        }
        return null;
    }

    private String getUniqueName(HashSet orgColumnNameSet, HashSet newColumnNameSet, String columnName, int index) {
        String newColumnName;
        if (columnName == null || columnName.trim().length() == 0 || newColumnNameSet.contains(columnName)) {
            newColumnName = columnName == null || columnName.trim().length() == 0 ? String.valueOf(UNNAME_PREFIX) + '_' + String.valueOf(index + 1) : String.valueOf(columnName) + '_' + String.valueOf(index + 1);
            int i = 1;
            while (orgColumnNameSet.contains(newColumnName) || newColumnNameSet.contains(newColumnName)) {
                newColumnName = String.valueOf(newColumnName) + String.valueOf('_') + i;
                ++i;
            }
        } else {
            newColumnName = columnName;
        }
        return newColumnName;
    }

    public void updateModel(DataSetHandle ds, DataSetViewData[] columns) {
        PropertyHandle handle = ds.getPropertyHandle("columnHints");
        PropertyHandle resultSetColumnHandle = ds.getPropertyHandle("resultSetHints");
        Iterator iter = handle.iterator();
        if (iter != null) {
            block0: while (iter.hasNext()) {
                ColumnHintHandle hint = (ColumnHintHandle)iter.next();
                int n = 0;
                while (n < columns.length) {
                    String columnName = columns[n].getName();
                    if (resultSetColumnHandle != null && (columnName == null || columnName.trim().length() == 0)) {
                        Iterator resultIter = resultSetColumnHandle.iterator();
                        if (resultIter != null) {
                            while (resultIter.hasNext()) {
                                ResultSetColumnHandle column = (ResultSetColumnHandle)resultIter.next();
                                if (column.getPosition() != n + 1) continue;
                                columnName = column.getColumnName();
                                break;
                            }
                        }
                        if (columnName == null) {
                            columnName = "";
                        }
                        columns[n].setName(columnName);
                    }
                    if (columns[n].getName().equals(hint.getColumnName())) {
                        columns[n].setDisplayName(hint.getDisplayName());
                        columns[n].setDisplayNameKey(hint.getDisplayNameKey());
                        columns[n].setAlias(hint.getAlias());
                        columns[n].setHelpText(hint.getHelpText());
                        continue block0;
                    }
                    ++n;
                }
            }
        }
    }

    public IBaseDataSetDesign createDataSetDesign(DataSetHandle dataSet) throws BirtException {
        DataSessionContext context = new DataSessionContext(3, dataSet.getModuleHandle());
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
        return session.getModelAdaptor().adaptDataSet(dataSet);
    }

    public IBaseDataSourceDesign createDataSourceDesign(DataSourceHandle dataSource) throws BirtException {
        DataSessionContext context = new DataSessionContext(3, dataSource.getModuleHandle());
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
        return session.getModelAdaptor().adaptDataSource(dataSource);
    }

    public DataSetViewData[] getCachedDataSetItemModel(DataSetHandle ds) {
        DataSetViewData[] result = (DataSetViewData[])this.htColumns.get(ds);
        if (result == null) {
            try {
                DataSessionContext context = new DataSessionContext(3, ds.getModuleHandle());
                DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
                result = this.populateAllOutputColumns(ds, session);
                session.shutdown();
                return result;
            }
            catch (BirtException birtException) {
                result = new DataSetViewData[]{};
            }
        }
        return result;
    }

    public static IConfigurationElement findDataSetElement(String dataSetType, String dataSourceType) {
        IConfigurationElement dataSourceElem = DataSetProvider.findDataSourceElement(dataSourceType);
        if (dataSourceElem != null) {
            IExtension ext = dataSourceElem.getDeclaringExtension();
            IConfigurationElement[] elements = ext.getConfigurationElements();
            int n = 0;
            while (n < elements.length) {
                if (elements[n].getAttribute("id").equals(dataSetType)) {
                    return elements[n];
                }
                ++n;
            }
        }
        return null;
    }

    public static IConfigurationElement findDataSourceElement(String dataSourceType) {
        assert (dataSourceType != null);
        IConfigurationElement element = (IConfigurationElement)htDataSourceExtensions.get(dataSourceType);
        if (element == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.birt.report.designer.ui.odadatasource");
            int n = 0;
            while (n < elements.length) {
                if (elements[n].getAttribute("id").equals(dataSourceType)) {
                    element = elements[n];
                    htDataSourceExtensions.put(dataSourceType, element);
                    break;
                }
                ++n;
            }
            elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.datatools.connectivity.oda.design.ui.dataSource");
            n = 0;
            while (n < elements.length) {
                if (elements[n].getAttribute("id").equals(dataSourceType)) {
                    element = elements[n];
                    htDataSourceExtensions.put(dataSourceType, element);
                    break;
                }
                ++n;
            }
        }
        return element;
    }

    public final IBaseDataSetDesign getDataSetDesign(DataSetHandle dataSet, boolean useColumnHints, boolean useFilters) throws BirtException {
        if (dataSet != null) {
            DataRequestSession session = this.getDataRequestSession(dataSet);
            return this.getDataSetDesign(dataSet, useColumnHints, useFilters, session);
        }
        return null;
    }

    private IBaseDataSetDesign getDataSetDesign(DataRequestSession session, DataSetHandle dataSet, boolean useColumnHints, boolean useFilters) throws BirtException {
        if (dataSet != null) {
            return this.getDataSetDesign(dataSet, useColumnHints, useFilters, session);
        }
        return null;
    }

    private IBaseDataSetDesign getDataSetDesign(DataSetHandle dataSet, boolean useColumnHints, boolean useFilters, DataRequestSession session) throws BirtException {
        BaseDataSetDesign dataSetDesign = session.getModelAdaptor().adaptDataSet(dataSet);
        if (!useColumnHints) {
            dataSetDesign.getResultSetHints().clear();
        }
        if (!useFilters) {
            dataSetDesign.getFilters().clear();
        }
        if (!(dataSet instanceof JointDataSetHandle)) {
            BaseDataSourceDesign dataSourceDesign = session.getModelAdaptor().adaptDataSource(dataSet.getDataSource());
            session.defineDataSource((IBaseDataSourceDesign)dataSourceDesign);
        }
        if (dataSet instanceof JointDataSetHandle) {
            this.defineSourceDataSets(session, dataSet, (IBaseDataSetDesign)dataSetDesign);
        }
        session.defineDataSet((IBaseDataSetDesign)dataSetDesign);
        return dataSetDesign;
    }

    private void defineSourceDataSets(DataRequestSession session, DataSetHandle dataSet, IBaseDataSetDesign dataSetDesign) throws BirtException {
        List dataSets = dataSet.getModuleHandle().getAllDataSets();
        int i = 0;
        while (i < dataSets.size()) {
            DataSetHandle dsHandle = (DataSetHandle)dataSets.get(i);
            if (dsHandle.getName() != null && (dsHandle.getName().equals(((IJointDataSetDesign)dataSetDesign).getLeftDataSetDesignName()) || dsHandle.getName().equals(((IJointDataSetDesign)dataSetDesign).getRightDataSetDesignName()))) {
                this.getDataSetDesign(session, dsHandle, true, true);
            }
            ++i;
        }
    }

    public DataRequestSession getDataRequestSession(DataSetHandle dataSet) throws BirtException {
        if (this.sessionTable.get(dataSet.getName()) != null) {
            return (DataRequestSession)this.sessionTable.get(dataSet.getName());
        }
        DataSessionContext context = new DataSessionContext(3, dataSet.getModuleHandle());
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
        this.sessionTable.put(dataSet.getName(), session);
        return session;
    }

    public Collection getParametersFromDataSet(DataSetHandle dataSet) throws BirtException {
        return this.prepareQuery(dataSet).getParameterMetaData();
    }

    public IPreparedQuery prepareQuery(DataSetHandle dataSet) throws BirtException {
        DataRequestSession session = this.getDataRequestSession(dataSet);
        IBaseDataSetDesign dataSetDesign = this.getDataSetDesign(dataSet, true, true);
        QueryDefinition queryDefn = this.getQueryDefinition(dataSetDesign, -1);
        return session.prepare((IQueryDefinition)queryDefn, null);
    }

    public IPreparedQuery prepareQuery(DataSetHandle dataSet, IQueryDefinition query) throws BirtException {
        DataRequestSession session = this.getDataRequestSession(dataSet);
        this.getDataSetDesign(dataSet, true, true);
        return session.prepare(query, null);
    }

    public IPreparedQuery prepareQuery(DataSetHandle dataSet, IQueryDefinition query, boolean useColumnHints, boolean useFilters) throws BirtException {
        DataRequestSession session = this.getDataRequestSession(dataSet);
        this.getDataSetDesign(dataSet, useColumnHints, useFilters);
        return session.prepare(query, null);
    }

    public final IPreparedQuery prepareQuery(DataSetHandle dataSet, ParamBindingHandle[] bindingParams, boolean useColumnHints, boolean useFilters) throws BirtException {
        DataRequestSession session = this.getDataRequestSession(dataSet);
        IBaseDataSetDesign dataSetDesign = this.getDataSetDesign(dataSet, useColumnHints, useFilters);
        return session.prepare((IQueryDefinition)this.getQueryDefinition(dataSetDesign, bindingParams), null);
    }

    public static ClassLoader getCustomScriptClassLoader(ClassLoader parent, ModuleHandle handle) {
        List<URL> urls = DataSetProvider.getClassPathURLs();
        DataSetProvider.loadResourceFolderScriptLibs(handle, urls);
        if (urls.size() == 0) {
            return parent;
        }
        return new URLClassLoader(urls.toArray(new URL[0]), parent);
    }

    private static void loadResourceFolderScriptLibs(ModuleHandle handle, List<URL> urls) {
        Iterator it = handle.scriptLibsIterator();
        while (it.hasNext()) {
            ScriptLibHandle libHandle = (ScriptLibHandle)it.next();
            URL url = handle.findResource(libHandle.getName(), 2);
            if (url == null) continue;
            urls.add(url);
        }
    }

    private static List<URL> getClassPathURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.addAll(DataSetProvider.getDefaultViewerScriptLibURLs());
        urls.addAll(DataSetProvider.getWorkspaceProjectURLs());
        return urls;
    }

    private static List<URL> getDefaultViewerScriptLibURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            Bundle bundle = Platform.getBundle((String)VIEWER_NAMESPACE);
            Enumeration bundleFile = bundle.getEntryPaths(BIRT_SCRIPTLIB);
            while (bundleFile.hasMoreElements()) {
                String o = bundleFile.nextElement().toString();
                if (!o.endsWith(".jar")) continue;
                urls.add(bundle.getResource(o));
            }
            URL classes = bundle.getEntry(BIRT_CLASSES);
            if (classes != null) {
                urls.add(classes);
            }
        }
        catch (Exception exception) {}
        return urls;
    }

    private static List<URL> getWorkspaceProjectURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String classPath = DatasetClassPathHelper.getWorkspaceClassPath();
        if (classPath == null || classPath.length() == 0) {
            return urls;
        }
        String[] classPathArray = classPath.split(File.pathSeparator, -1);
        int count = classPathArray.length;
        int i = 0;
        while (i < count) {
            File file = new File(classPathArray[i]);
            try {
                urls.add(file.toURL());
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        return urls;
    }
}

