/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SessionHandle;

public class DataUtil {
    private static AggregationManager manager;

    public static AggregationManager getAggregationManager() throws BirtException {
        if (manager == null) {
            DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            manager = session.getAggregationManager();
            session.shutdown();
        }
        return manager;
    }

    public static Set getReferencedBindings(ComputedColumnHandle target, List allHandleList) {
        return DataUtil.getReferencedBindings(target, allHandleList, new HashSet());
    }

    private static Set getReferencedBindings(ComputedColumnHandle target, List allHandleList, Set prohibitedSet) {
        HashSet<Object> result = new HashSet<Object>();
        if (target == null || allHandleList == null || allHandleList.size() == 0) {
            return result;
        }
        prohibitedSet.add(target.getName());
        String expr = target.getExpression();
        try {
            List referredBindings = ExpressionUtil.extractColumnExpressions((String)expr);
            int i = 0;
            while (i < referredBindings.size()) {
                IColumnBinding binding = (IColumnBinding)referredBindings.get(i);
                int j = 0;
                while (j < allHandleList.size()) {
                    ComputedColumnHandle handle = (ComputedColumnHandle)allHandleList.get(j);
                    if (handle.getName().equals(binding.getResultSetColumnName()) && !prohibitedSet.contains(binding.getResultSetColumnName())) {
                        result.add(handle);
                    }
                    ++j;
                }
                ++i;
            }
            HashSet temp = new HashSet();
            Iterator it = result.iterator();
            while (it.hasNext()) {
                HashSet newProhibitedSet = new HashSet();
                newProhibitedSet.addAll(prohibitedSet);
                temp.addAll(DataUtil.getReferencedBindings((ComputedColumnHandle)it.next(), allHandleList, newProhibitedSet));
            }
            result.addAll(temp);
        }
        catch (BirtException birtException) {}
        return result;
    }

    public static List getValidGroupKeyBindings(List availableHandles) {
        ArrayList<ComputedColumnHandle> result = new ArrayList<ComputedColumnHandle>();
        if (availableHandles == null) {
            return result;
        }
        try {
            int i = 0;
            while (i < availableHandles.size()) {
                ComputedColumnHandle handle = (ComputedColumnHandle)availableHandles.get(i);
                ArrayList<String> originalNames = new ArrayList<String>();
                originalNames.add(handle.getName());
                if (DataUtil.acceptBinding(handle, availableHandles, originalNames)) {
                    result.add(handle);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return result;
        }
        return result;
    }

    public static String getParamValue(DataSetHandle dataSetHandle, OdaDataSetParameterHandle paramDefn) throws DesignFileException {
        ModuleHandle moduleHandle = dataSetHandle.getModuleHandle();
        String designFileName = moduleHandle.getFileName();
        String reportConfigName = String.valueOf(designFileName.substring(0, designFileName.length() - "rptdesign".length())) + "rptconfig";
        File file = new File(reportConfigName);
        if (file.exists()) {
            String paraName = paramDefn.getParamName();
            ScalarParameterHandle parameterHandle = (ScalarParameterHandle)moduleHandle.findParameter(paraName);
            paraName = String.valueOf(paraName) + "_" + parameterHandle.getID();
            SessionHandle sessionHandle = new DesignEngine(null).newSessionHandle(ULocale.US);
            ReportDesignHandle rdHandle = null;
            rdHandle = sessionHandle.openDesign(reportConfigName);
            if (rdHandle != null) {
                Iterator configVars = rdHandle.configVariablesIterator();
                while (configVars != null && configVars.hasNext()) {
                    ConfigVariableHandle configVar = (ConfigVariableHandle)configVars.next();
                    if (configVar == null) continue;
                    String varName = DataUtil.prepareConfigVarName(configVar.getName());
                    String varValue = configVar.getValue();
                    if (varName == null || varValue == null) continue;
                    if (varName.equals(paraName)) {
                        String value = varValue;
                        if (DataUtil.isToBeConverted(parameterHandle.getDataType())) {
                            value = "\"" + JavascriptEvalUtil.transformToJsConstants((String)value) + "\"";
                        }
                        return value;
                    }
                    if (!DataUtil.isNullValue(varName, varValue, paraName)) continue;
                    return null;
                }
            }
        }
        return ExpressionUtil.createJSParameterExpression((String)paramDefn.getParamName());
    }

    private static boolean isToBeConverted(String type) {
        return type.equals("string") || type.equals("dateTime") || type.equals("time") || type.equals("date");
    }

    private static String prepareConfigVarName(String name) {
        int index = name.lastIndexOf("_");
        return name.substring(0, index);
    }

    private static boolean isNullValue(String varName, String varValue, String newParaName) {
        return varName.toLowerCase().startsWith("__isnull") && varValue.equals(newParaName);
    }

    private static boolean acceptBinding(ComputedColumnHandle binding, List bindings, List originalNames) {
        try {
            String expr;
            if (binding.getAggregateFunction() == null && !ExpressionUtil.hasAggregation((String)(expr = binding.getExpression()))) {
                List referredBindings = ExpressionUtil.extractColumnExpressions((String)expr);
                ArrayList<String> names = new ArrayList<String>();
                names.add(binding.getName());
                names.addAll(originalNames);
                if (DataUtil.acceptindirectReferredBindings(originalNames, bindings, referredBindings)) {
                    return true;
                }
            }
        }
        catch (BirtException birtException) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean acceptindirectReferredBindings(List originalBindingName, List availableHandles, List referredBindings) {
        try {
            ArrayList<ComputedColumnHandle> candidateBindings = new ArrayList<ComputedColumnHandle>();
            int i = 0;
            while (i < referredBindings.size()) {
                IColumnBinding cb = (IColumnBinding)referredBindings.get(i);
                int j = 0;
                while (j < availableHandles.size()) {
                    ComputedColumnHandle binding = (ComputedColumnHandle)availableHandles.get(j);
                    if (!originalBindingName.contains(binding.getName()) && binding.getName().equals(cb.getResultSetColumnName())) {
                        candidateBindings.add(binding);
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < candidateBindings.size()) {
                ComputedColumnHandle handle = (ComputedColumnHandle)candidateBindings.get(i);
                if (!DataUtil.acceptBinding(handle, availableHandles, originalBindingName)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getAggregationExpression(ComputedColumnHandle bindingColumn) {
        if (bindingColumn.getExpression() != null) {
            return bindingColumn.getExpression();
        }
        String functionName = bindingColumn.getAggregateFunction();
        try {
            IAggrFunction function = DataUtil.getAggregationManager().getAggregation(functionName);
            IParameterDefn[] iParameterDefnArray = function.getParameterDefn();
            int n = iParameterDefnArray.length;
            int n2 = 0;
            while (n2 < n) {
                IParameterDefn param = iParameterDefnArray[n2];
                if (param.isDataField()) {
                    Iterator iterator = bindingColumn.argumentsIterator();
                    while (iterator.hasNext()) {
                        AggregationArgumentHandle arg = (AggregationArgumentHandle)iterator.next();
                        if (!DataAdapterUtil.adaptArgumentName((String)arg.getName()).equals(param.getName())) continue;
                        return arg.getValue();
                    }
                }
                ++n2;
            }
        }
        catch (BirtException birtException) {}
        return null;
    }
}

