/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.AbstractFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.StylePreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class EditableComboFieldEditor
extends AbstractFieldEditor {
    protected Combo fCombo;
    protected String[][] fEntryNamesAndValues;
    private ModifyListener modifyListener;

    public EditableComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        this.init(name, labelText);
        Assert.isTrue((boolean)this.checkArray(entryNamesAndValues));
        this.fEntryNamesAndValues = entryNamesAndValues;
        this.createControl(parent);
    }

    private boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        int i = 0;
        while (i < table.length) {
            String[] array = table[i];
            if (array == null || array.length != 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = 1;
            --numColumns;
        }
        ((GridData)this.fCombo.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()), true);
    }

    protected void doLoadDefault() {
        this.fCombo.removeModifyListener(this.modifyListener);
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()), false);
        if (this.getPreferenceStore() instanceof StylePreferenceStore) {
            StylePreferenceStore store = (StylePreferenceStore)this.getPreferenceStore();
            if (store.hasLocalValue(this.getPreferenceName())) {
                this.markDirty(true);
            } else {
                this.markDirty(false);
            }
        } else {
            this.markDirty(true);
        }
        this.fCombo.addModifyListener(this.modifyListener);
    }

    protected void updateComboForValue(String value, boolean setOldValue) {
        if (setOldValue) {
            this.setOldValue(value);
        } else {
            this.setDefaultValue(value);
        }
        int i = 0;
        while (i < this.fEntryNamesAndValues.length) {
            if (this.fEntryNamesAndValues[i][1] != null && this.fEntryNamesAndValues[i][1].equals(value) || this.fEntryNamesAndValues[i][1] == null && value == null) {
                this.fCombo.setText(this.fEntryNamesAndValues[i][0]);
                return;
            }
            ++i;
        }
        if (value == null) {
            this.fCombo.setText("");
        } else {
            this.fCombo.setText(value);
        }
        if (setOldValue) {
            this.setOldValue(this.getStringValue());
        } else {
            this.setDefaultValue(this.getStringValue());
        }
    }

    public Combo getComboBoxControl(Composite parent) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(parent, 0);
            int i = 0;
            while (i < this.fEntryNamesAndValues.length) {
                this.fCombo.add(this.fEntryNamesAndValues[i][0], i);
                ++i;
            }
            this.fCombo.setFont(parent.getFont());
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    EditableComboFieldEditor.this.valueChanged("field_editor_value");
                }
            });
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EditableComboFieldEditor.this.valueChanged("field_editor_value");
                }
            };
            this.fCombo.addModifyListener(this.modifyListener);
        }
        return this.fCombo;
    }

    protected String getValueForName(String name) {
        int i = 0;
        while (i < this.fEntryNamesAndValues.length) {
            String[] entry = this.fEntryNamesAndValues[i];
            if (name.equals(entry[0])) {
                return entry[1];
            }
            ++i;
        }
        return name;
    }

    protected String getStringValue() {
        if (this.fCombo != null) {
            return this.getValueForName(this.fCombo.getText());
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }
}

