/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatAdapter;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.FormatDateTimePattern;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;

public class FormatDateTimeAdapter
extends FormatAdapter {
    private static final String[] DATETIME_FORMAT_TYPES = new String[]{"General Date", "Long Date", "Medium Date", "Short Date", "Long Time", "Medium Time", "Short Time"};
    private static final String[] DATE_FORMAT_TYPES = new String[]{"General Date", "Long Date", "Medium Date", "Short Date"};
    private static final String[] TIME_FORMAT_TYPES = new String[]{"Long Time", "Medium Time", "Short Time"};
    private static String UNFORMATTED_DISPLAYNAME;
    private static String CUSTOM;
    private static String UNFORMATTED_NAME;
    private int type;
    private Date defaultDate = new Date();
    private String[][] choiceArray = null;
    private String[] formatTypes = null;

    public FormatDateTimeAdapter(int type) {
        this.type = type;
        this.init();
    }

    private void init() {
        switch (this.type) {
            case 3: {
                UNFORMATTED_DISPLAYNAME = "Unformatted";
                CUSTOM = "Custom";
                UNFORMATTED_NAME = "DateTimeUnformatted";
                break;
            }
            case 4: {
                UNFORMATTED_DISPLAYNAME = "Unformatted";
                CUSTOM = "Custom";
                UNFORMATTED_NAME = "DateUnformatted";
                break;
            }
            case 5: {
                UNFORMATTED_DISPLAYNAME = "Unformatted";
                CUSTOM = "Custom";
                UNFORMATTED_NAME = "TimeUnformatted";
            }
        }
    }

    public String[] getSimpleDateTimeFormatTypes() {
        if (this.type == 3) {
            return DATETIME_FORMAT_TYPES;
        }
        if (this.type == 4) {
            return DATE_FORMAT_TYPES;
        }
        if (this.type == 5) {
            return TIME_FORMAT_TYPES;
        }
        return new String[0];
    }

    public String[][] getFormatTypeChoiceSet() {
        String[][] choiceArray;
        String property;
        String structName;
        if (this.type == 3) {
            structName = "DateTimeFormatValue";
            property = "category";
        } else if (this.type == 4) {
            structName = "DateFormatValue";
            property = "category";
        } else {
            structName = "TimeFormatValue";
            property = "category";
        }
        IChoiceSet set = ChoiceSetFactory.getStructChoiceSet(structName, property);
        IChoice[] choices = set.getChoices();
        if (choices.length > 0) {
            choiceArray = new String[choices.length][2];
            int i = 0;
            int j = 0;
            while (i < choices.length) {
                choiceArray[j][0] = choices[i].getDisplayName();
                choiceArray[j][1] = choices[i].getName();
                ++j;
                ++i;
            }
        } else {
            choiceArray = new String[0][0];
        }
        return choiceArray;
    }

    public String[][] initChoiceArray() {
        if (this.choiceArray == null) {
            IChoiceSet set = ChoiceSetFactory.getStructChoiceSet("DateTimeFormatValue", "category");
            IChoice[] choices = set.getChoices();
            if (choices.length > 0) {
                this.choiceArray = new String[choices.length][2];
                int i = 0;
                int j = 0;
                while (i < choices.length) {
                    this.choiceArray[j][0] = choices[i].getDisplayName();
                    this.choiceArray[j][1] = choices[i].getName();
                    ++j;
                    ++i;
                }
            } else {
                this.choiceArray = new String[0][0];
            }
        }
        return this.choiceArray;
    }

    public String getCategory4UIDisplayName(String displayName) {
        if (this.initChoiceArray() != null) {
            int i = 0;
            while (i < this.choiceArray.length) {
                if (this.formatTypes[i].equals(displayName)) {
                    return this.choiceArray[i][1];
                }
                ++i;
            }
        }
        return displayName;
    }

    public String[] getFormatTypes(ULocale locale) {
        if (this.initChoiceArray() != null) {
            this.formatTypes = new String[this.choiceArray.length];
            int i = 0;
            while (i < this.choiceArray.length) {
                String fmtStr = "";
                String category = this.choiceArray[i][1];
                if (category.equals(CUSTOM) || category.equals(UNFORMATTED_DISPLAYNAME)) {
                    fmtStr = this.choiceArray[i][0];
                } else {
                    String pattern = FormatDateTimePattern.getPatternForCategory((String)category);
                    fmtStr = new DateFormatter(pattern, locale).format(this.defaultDate);
                }
                this.formatTypes[i] = fmtStr;
                ++i;
            }
        } else {
            this.formatTypes = new String[0];
        }
        return this.formatTypes;
    }

    public int getIndexOfCategory(String category) {
        if (this.initChoiceArray() != null) {
            int i = 0;
            while (i < this.choiceArray.length) {
                if (this.choiceArray[i][1].equals(category)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public String getUnformattedCategoryDisplayName() {
        return UNFORMATTED_DISPLAYNAME;
    }

    public String getCustomCategoryName() {
        return CUSTOM;
    }

    public String getUnformattedCategoryName() {
        return UNFORMATTED_NAME;
    }
}

