/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatDateTimeAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.designer.util.FormatDateTimePattern;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FormatDateTimePage
extends Composite
implements IFormatPage {
    private static final String LABEL_FORMAT_DATE_TIME_PAGE = Messages.getString((String)"FormatDateTimePage.label.format.page");
    private static final String LABEL_FORMAT_DATE_TIME_LOCALE = Messages.getString((String)"FormatDateTimePage.label.format.locale");
    private static final String LABEL_GENERAL_PREVIEW_GROUP = Messages.getString((String)"FormatDateTimePage.label.general.preview.group");
    private static final String LABEL_CUSTOM_SETTINGS = Messages.getString((String)"FormatDateTimePage.label.custom.settings");
    private static final String LABEL_CUSTOM_SETTINGS_LABEL = Messages.getString((String)"FormatDateTimePage.label.custom.settings.label");
    private static final String LABEL_PREVIEW_DATETIME = Messages.getString((String)"FormatDateTimePage.label.preview.dateTime");
    private static final String LABEL_FORMAT_CODE = Messages.getString((String)"FormatDateTimePage.label.format.code");
    private static final String LABEL_PREVIEW_GROUP = Messages.getString((String)"FormatDateTimePage.label.preview.group");
    private static final String LABEL_PREVIEW_LABEL = Messages.getString((String)"FormatDateTimePage.label.preview.label");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_NAME = Messages.getString((String)"FormatDateTimePage.label.table.column.format.name");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT = Messages.getString((String)"FormatDateTimePage.label.table.column.format.result");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE = Messages.getString((String)"FormatDateTimePage.label.table.column.format.code");
    private static final String ENTER_DATE_TIME_GUIDE_FORMAT = Messages.getString((String)"FormatDateTimePage.label.guide.format");
    private static final String ENTER_DATE_TIME_GUIDE_TEXT = Messages.getString((String)"FormatDateTimePage.label.guide.text");
    private static final String PREVIEW_TEXT_INVALID_DATETIME_TO_PREVIEW = Messages.getString((String)"FormatDateTimePage.preview.invalid.dateTime");
    private static final String PREVIEW_TEXT_INVALID_FORMAT_CODE = Messages.getString((String)"FormatDateTimePage.preview.invalid.formatCode");
    private String pattern = null;
    private String category = null;
    private String locale = null;
    private String oldCategory = null;
    private String oldPattern = null;
    private String oldLocale = null;
    private HashMap categoryPageMaps;
    private static final int FORMAT_CODE_INDEX = 2;
    private static final int DEFAULT_CATEGORY_CONTAINER_WIDTH = 220;
    private int pageAlignment;
    private Combo typeChoicer;
    private Combo localeChoicer;
    private Composite infoComp;
    private Composite formatCodeComp;
    private Composite generalPage;
    private Composite customPage;
    private Composite generalFormatCodePage;
    private Composite customFormatCodePage;
    private Label generalPreviewLabel;
    private Label cusPreviewLabel;
    private Label guideLabel;
    private Text previewTextBox;
    private Text formatCode;
    private Table table;
    private boolean hasLoaded = false;
    private String previewText = null;
    private boolean isDirty = false;
    private boolean showLocale = true;
    private List listeners = new ArrayList();
    private Date defaultDate = new Date();
    private String defaultDateTime = new DateFormatter(ENTER_DATE_TIME_GUIDE_FORMAT, ULocale.getDefault()).format(this.defaultDate);
    private FormatDateTimeAdapter formatAdapter;

    public FormatDateTimePage(Composite parent, int type, int style) {
        this(parent, type, style, 0, true);
    }

    public FormatDateTimePage(Composite parent, int type, int style, int pageAlignment, boolean showLocale) {
        super(parent, style);
        this.pageAlignment = pageAlignment;
        this.showLocale = showLocale;
        this.formatAdapter = new FormatDateTimeAdapter(type);
        this.createContents(pageAlignment);
    }

    protected void createContents(int pageAlignment2) {
        if (this.pageAlignment == 1) {
            this.createContentsHorizontally();
        } else {
            this.createContentsVirtically();
        }
    }

    protected void createContentsVirtically() {
        this.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        Composite topContainer = new Composite((Composite)this, 0);
        topContainer.setLayoutData((Object)new GridData(768));
        topContainer.setLayout((Layout)new GridLayout(2, false));
        new Label(topContainer, 0).setText(LABEL_FORMAT_DATE_TIME_PAGE);
        this.typeChoicer = new Combo(topContainer, 8);
        this.typeChoicer.setLayoutData((Object)new GridData(768));
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatDateTimePage.this.reLayoutSubPages();
                FormatDateTimePage.this.updateTextByLocale();
                FormatDateTimePage.this.updatePreview();
                FormatDateTimePage.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.formatAdapter.getFormatTypes(null));
        this.typeChoicer.select(0);
        Label label = new Label(topContainer, 0);
        label.setText(LABEL_FORMAT_DATE_TIME_LOCALE);
        this.localeChoicer = new Combo(topContainer, 8);
        this.localeChoicer.setLayoutData((Object)new GridData(768));
        this.localeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatDateTimePage.this.updateTextByLocale();
                FormatDateTimePage.this.updatePreview();
                FormatDateTimePage.this.notifyFormatChange();
            }
        });
        this.localeChoicer.setItems(this.formatAdapter.getLocaleDisplayNames());
        if (this.localeChoicer.getItemCount() > 0) {
            this.localeChoicer.select(0);
        }
        WidgetUtil.setExcludeGridData((Control)label, !this.showLocale);
        WidgetUtil.setExcludeGridData((Control)this.localeChoicer, !this.showLocale);
        this.infoComp = new Composite((Composite)this, 0);
        this.infoComp.setLayoutData((Object)new GridData(768));
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.setInput(null, null);
        this.setPreviewText(this.defaultDateTime);
    }

    protected void createContentsHorizontally() {
        this.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        Composite container = new Composite((Composite)this, 0);
        GridData data = new GridData();
        data.widthHint = 220;
        container.setLayoutData((Object)data);
        container.setLayout((Layout)new GridLayout(1, false));
        new Label(container, 0).setText(LABEL_FORMAT_DATE_TIME_PAGE);
        this.typeChoicer = new Combo(container, 8);
        this.typeChoicer.setLayoutData((Object)new GridData(768));
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatDateTimePage.this.reLayoutSubPages();
                FormatDateTimePage.this.updateTextByLocale();
                FormatDateTimePage.this.updatePreview();
                FormatDateTimePage.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.formatAdapter.getFormatTypes(null));
        Label label = new Label(container, 0);
        label.setText(LABEL_FORMAT_DATE_TIME_LOCALE);
        this.localeChoicer = new Combo(container, 8);
        this.localeChoicer.setLayoutData((Object)new GridData(768));
        this.localeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatDateTimePage.this.updateTextByLocale();
                FormatDateTimePage.this.updatePreview();
                FormatDateTimePage.this.notifyFormatChange();
            }
        });
        this.localeChoicer.setItems(this.formatAdapter.getLocaleDisplayNames());
        if (this.localeChoicer.getItemCount() > 0) {
            this.localeChoicer.select(0);
        }
        WidgetUtil.setExcludeGridData((Control)label, !this.showLocale);
        WidgetUtil.setExcludeGridData((Control)this.localeChoicer, !this.showLocale);
        this.infoComp = new Composite((Composite)this, 0);
        data = new GridData(1808);
        data.verticalSpan = 2;
        this.infoComp.setLayoutData((Object)data);
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.formatCodeComp = new Composite((Composite)this, 0);
        data = new GridData(1040);
        data.widthHint = 220;
        this.formatCodeComp.setLayoutData((Object)data);
        this.formatCodeComp.setLayout((Layout)new StackLayout());
        this.createFormatCodePages(this.formatCodeComp);
        this.setInput(null, null);
        this.setPreviewText(this.defaultDateTime);
    }

    private void createCategoryPages(Composite parent) {
        this.categoryPageMaps = new HashMap();
        this.categoryPageMaps.put("General", this.getGeneralPage(parent));
        this.categoryPageMaps.put("Custom", this.getCustomPage(parent));
    }

    private Object getPagebyCategory(String category) {
        if (category.equals(this.formatAdapter.getCustomCategoryName())) {
            return this.categoryPageMaps.get("Custom");
        }
        return this.categoryPageMaps.get("General");
    }

    private void createFormatCodePages(Composite parent) {
        this.getHorizonGeneralFormatCodePage(parent);
        this.getHorizonCustomFormatCodePage(parent);
    }

    private void fireFormatChanged(String newCategory, String newPattern, String newLocale) {
        if (this.listeners.isEmpty()) {
            return;
        }
        FormatChangeEvent event = new FormatChangeEvent(this, "dateTimeFormat", newCategory, newPattern, newLocale);
        for (Object listener : this.listeners) {
            if (!(listener instanceof IFormatChangeListener)) continue;
            ((IFormatChangeListener)listener).formatChange(event);
        }
    }

    private void notifyFormatChange() {
        if (this.hasLoaded) {
            this.fireFormatChanged(this.getCategory(), this.getPattern(), this.locale);
        }
    }

    public void addFormatChangeListener(IFormatChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void setInput(String formatString) {
        if (formatString == null) {
            this.setInput(null, null);
            return;
        }
        String fmtStr = formatString;
        int pos = fmtStr.indexOf(":");
        if (StringUtil.isBlank((String)fmtStr)) {
            this.setInput(null, null);
            return;
        }
        if (pos == -1) {
            this.setInput(fmtStr, fmtStr);
            return;
        }
        String category = fmtStr.substring(0, pos);
        String patternStr = fmtStr.substring(pos + 1);
        this.setInput(category, patternStr);
    }

    public void setInput(String categoryStr, String patternStr, ULocale locale) {
        this.hasLoaded = false;
        String localeStr = this.formatAdapter.getLocaleDisplayName(locale);
        this.initiatePageLayout(categoryStr, patternStr, localeStr);
        this.reLayoutSubPages();
        this.updateTextByLocale();
        this.updatePreview();
        this.oldCategory = categoryStr;
        this.oldPattern = patternStr;
        this.oldLocale = localeStr;
        this.hasLoaded = true;
    }

    public void setInput(String categoryStr, String patternStr) {
        this.setInput(categoryStr, patternStr, null);
    }

    public void setPreviewText(String text) {
        this.setDefaultPreviewText(text);
        this.updatePreview();
    }

    public String getPattern() {
        return this.pattern;
    }

    public ULocale getLocale() {
        return this.formatAdapter.getLocaleByDisplayName(this.locale);
    }

    public String getCategory() {
        return this.category;
    }

    public String getFormatString() {
        if (this.category == null && this.pattern == null) {
            return this.formatAdapter.getUnformattedCategoryDisplayName();
        }
        if (this.category == null) {
            this.category = "";
        }
        if (this.pattern == null) {
            this.pattern = "";
        }
        if (this.category.equals(this.pattern)) {
            return this.category;
        }
        return String.valueOf(this.category) + ":" + this.pattern;
    }

    public boolean isFormatModified() {
        String c = this.getCategory();
        String p = this.getPattern();
        String l = this.locale;
        if (this.oldCategory == null ? c != null : !this.oldCategory.equals(c)) {
            return true;
        }
        if (this.oldPattern == null ? p != null : !this.oldPattern.equals(p)) {
            return true;
        }
        return this.oldLocale == null ? l != null : !this.oldLocale.equals(l);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setControlsEnabeld(enabled);
    }

    private void setDefaultPreviewText(String text) {
        this.previewText = text == null || StringUtil.isBlank((String)text) ? null : text;
    }

    private String getPreviewText() {
        return this.previewText;
    }

    private void setPattern(String pattern) {
        this.pattern = pattern;
    }

    private void setCategory(String category) {
        this.category = category;
    }

    private void setLocale(String locale) {
        this.locale = locale;
    }

    private void markDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    private String validatedFmtStr(String fmtStr) {
        String text = fmtStr;
        if (text == null) {
            text = PREVIEW_TEXT_INVALID_FORMAT_CODE;
        }
        return text;
    }

    private void updatePreview() {
        this.markDirty(this.hasLoaded);
        String category = this.formatAdapter.getCategory4UIDisplayName(this.typeChoicer.getText());
        this.setCategory(category);
        ULocale locale = this.formatAdapter.getLocaleByDisplayName(this.locale);
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        boolean invalidPreviewText = false;
        Date sampleDateTime = this.defaultDate;
        if (this.getPreviewText() != null && !this.getPreviewText().equals(this.defaultDateTime)) {
            try {
                sampleDateTime = new DateFormatter(ENTER_DATE_TIME_GUIDE_FORMAT, locale).parse(this.getPreviewText());
            }
            catch (Exception exception) {
                invalidPreviewText = true;
            }
        }
        if (this.formatAdapter.getCustomCategoryName().equals(category)) {
            String fmtStr;
            String pattern = this.formatCode.getText();
            if (invalidPreviewText) {
                fmtStr = PREVIEW_TEXT_INVALID_DATETIME_TO_PREVIEW;
            } else {
                try {
                    fmtStr = new DateFormatter(pattern, locale).format(sampleDateTime);
                }
                catch (Exception exception) {
                    fmtStr = PREVIEW_TEXT_INVALID_DATETIME_TO_PREVIEW;
                }
            }
            this.cusPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            this.setPattern(pattern);
        } else {
            String pattern = null;
            if (!this.formatAdapter.getUnformattedCategoryDisplayName().equals(category)) {
                pattern = FormatDateTimePattern.getPatternForCategory((String)category);
                this.setPattern(pattern);
            } else {
                pattern = this.formatAdapter.getUnformattedCategoryName();
                this.setPattern(null);
            }
            String fmtStr = new DateFormatter(pattern, locale).format(sampleDateTime);
            this.generalPreviewLabel.setText(this.validatedFmtStr(fmtStr));
        }
    }

    private void initiatePageLayout(String categoryStr, String patternStr, String localeStr) {
        if (this.locale != null) {
            this.localeChoicer.setText(localeStr);
        } else {
            this.localeChoicer.select(0);
        }
        if (categoryStr == null) {
            this.typeChoicer.select(0);
        } else {
            if (categoryStr.equals(this.formatAdapter.getCustomCategoryName())) {
                this.formatCode.setText(patternStr == null ? "" : patternStr);
            }
            this.typeChoicer.select(this.formatAdapter.getIndexOfCategory(categoryStr));
        }
    }

    private void reLayoutSubPages() {
        Control control;
        String category = this.formatAdapter.getCategory4UIDisplayName(this.typeChoicer.getText());
        ((StackLayout)this.infoComp.getLayout()).topControl = control = (Control)this.getPagebyCategory(category);
        this.infoComp.layout();
        if (this.formatCodeComp != null) {
            ((StackLayout)this.formatCodeComp.getLayout()).topControl = category.equals("Custom") ? this.getHorizonCustomFormatCodePage(this.formatCodeComp) : this.getHorizonGeneralFormatCodePage(this.formatCodeComp);
            this.formatCodeComp.layout();
        }
    }

    private Composite getGeneralPage(Composite parent) {
        if (this.generalPage == null) {
            this.generalPage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            this.generalPage.setLayout((Layout)layout);
            this.generalPreviewLabel = this.createGeneralPreviewPart(this.generalPage);
        }
        return this.generalPage;
    }

    private Composite getCustomPage(Composite parent) {
        if (this.customPage == null) {
            this.customPage = new Composite(parent, 0);
            this.customPage.setLayout((Layout)this.createGridLayout4Page());
            this.createCustomSettingsPart(this.customPage);
            if (this.pageAlignment == 0) {
                Composite container = new Composite(this.customPage, 0);
                container.setLayoutData((Object)new GridData(768));
                container.setLayout((Layout)new GridLayout(2, false));
                new Label(container, 0).setText(LABEL_FORMAT_CODE);
                this.formatCode = new Text(container, 2052);
                this.formatCode.setLayoutData((Object)new GridData(768));
                this.formatCode.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (FormatDateTimePage.this.hasLoaded) {
                            FormatDateTimePage.this.updatePreview();
                        }
                    }
                });
                this.formatCode.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        FormatDateTimePage.this.notifyFormatChange();
                    }

                    public void focusGained(FocusEvent e) {
                    }
                });
            }
            this.createCustomPreviewPart(this.customPage);
        }
        return this.customPage;
    }

    private Composite getHorizonGeneralFormatCodePage(Composite parent) {
        if (this.generalFormatCodePage == null) {
            this.generalFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.generalFormatCodePage.setLayout((Layout)layout);
            Label l = new Label(this.generalFormatCodePage, 258);
            l.setLayoutData((Object)new GridData(768));
        }
        return this.generalFormatCodePage;
    }

    private Composite getHorizonCustomFormatCodePage(Composite parent) {
        if (this.customFormatCodePage == null) {
            this.customFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.customFormatCodePage.setLayout((Layout)layout);
            Label l = new Label(this.customFormatCodePage, 258);
            l.setLayoutData((Object)new GridData(768));
            Composite container = new Composite(this.customFormatCodePage, 0);
            container.setLayoutData((Object)new GridData(768));
            container.setLayout((Layout)new GridLayout(2, false));
            new Label(container, 0).setText(LABEL_FORMAT_CODE);
            this.formatCode = new Text(container, 2052);
            this.formatCode.setLayoutData((Object)new GridData(768));
            this.formatCode.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (FormatDateTimePage.this.hasLoaded) {
                        FormatDateTimePage.this.updatePreview();
                    }
                }
            });
            this.formatCode.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    FormatDateTimePage.this.notifyFormatChange();
                }

                public void focusGained(FocusEvent e) {
                }
            });
        }
        return this.customFormatCodePage;
    }

    private Label createGeneralPreviewPart(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(LABEL_GENERAL_PREVIEW_GROUP);
        GridData data = this.pageAlignment == 1 ? new GridData(1808) : new GridData(768);
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout(1, false));
        Label previewLabel = new Label((Composite)group, 0x1000300);
        previewLabel.setLayoutData((Object)new GridData(1808));
        return previewLabel;
    }

    private void createCustomSettingsPart(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(LABEL_CUSTOM_SETTINGS);
        group.setLayoutData((Object)this.createGridData4Part());
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(LABEL_CUSTOM_SETTINGS_LABEL);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.createTable((Composite)group);
    }

    private void createCustomPreviewPart(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(LABEL_PREVIEW_GROUP);
        if (this.pageAlignment == 1) {
            group.setLayoutData((Object)new GridData(1808));
            group.setLayout((Layout)new GridLayout(1, false));
        } else {
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)new GridLayout(2, false));
        }
        new Label((Composite)group, 0).setText(LABEL_PREVIEW_DATETIME);
        this.previewTextBox = new Text((Composite)group, 2052);
        this.previewTextBox.setText(this.defaultDateTime);
        GridData data = new GridData(768);
        if (this.pageAlignment == 1) {
            data.horizontalIndent = 10;
        }
        this.previewTextBox.setLayoutData((Object)data);
        this.previewTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormatDateTimePage.this.setDefaultPreviewText(FormatDateTimePage.this.previewTextBox.getText());
                if (FormatDateTimePage.this.hasLoaded) {
                    FormatDateTimePage.this.updatePreview();
                }
                if (StringUtil.isBlank((String)FormatDateTimePage.this.previewTextBox.getText())) {
                    FormatDateTimePage.this.guideLabel.setText("");
                } else {
                    FormatDateTimePage.this.guideLabel.setText(ENTER_DATE_TIME_GUIDE_TEXT);
                }
            }
        });
        if (this.pageAlignment == 0) {
            new Label((Composite)group, 0);
        }
        this.guideLabel = new Label((Composite)group, 0);
        this.guideLabel.setText("");
        Font font = JFaceResources.getDialogFont();
        FontData fData = font.getFontData()[0];
        fData.setHeight(fData.getHeight() - 1);
        this.guideLabel.setFont(FontManager.getFont((FontData)fData));
        data = new GridData(768);
        data.horizontalIndent = 10;
        this.guideLabel.setLayoutData((Object)data);
        Label label = new Label((Composite)group, 0);
        label.setText(LABEL_PREVIEW_LABEL);
        label.setLayoutData((Object)new GridData());
        this.cusPreviewLabel = new Label((Composite)group, 0x11000100);
        this.cusPreviewLabel.setText("");
        data = new GridData(1808);
        data.horizontalSpan = 1;
        this.cusPreviewLabel.setLayoutData((Object)data);
    }

    private void createTable(Composite parent) {
        this.table = new Table(parent, 101120);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        if (this.pageAlignment == 1) {
            data.widthHint = 240;
        }
        this.table.setLayoutData((Object)data);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatDateTimePage.this.formatCode.setText(((TableItem)e.item).getText(2));
                FormatDateTimePage.this.updatePreview();
                FormatDateTimePage.this.notifyFormatChange();
            }
        });
        TableColumn tableColumValue = new TableColumn(this.table, 0);
        tableColumValue.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_NAME);
        tableColumValue.setWidth(90);
        tableColumValue.setResizable(true);
        TableColumn tableColumnDisplay = new TableColumn(this.table, 0);
        tableColumnDisplay.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT);
        tableColumnDisplay.setWidth(120);
        tableColumnDisplay.setResizable(true);
        TableColumn tableColumnFormatCode = new TableColumn(this.table, 0);
        tableColumnFormatCode.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE);
        tableColumnFormatCode.setWidth(120);
        tableColumnFormatCode.setResizable(true);
        String[][] items = this.getTableItems(null);
        int i = 0;
        while (i < items.length) {
            new TableItem(this.table, 0).setText(items[i]);
            ++i;
        }
    }

    private void updateTextByLocale() {
        ULocale oldLocale = this.formatAdapter.getLocaleByDisplayName(this.locale);
        Date sampleDateTime = this.defaultDate;
        try {
            if (this.getPreviewText() != null) {
                sampleDateTime = new DateFormatter(ENTER_DATE_TIME_GUIDE_FORMAT, oldLocale).parse(this.getPreviewText());
            }
        }
        catch (ParseException parseException) {}
        this.setLocale(this.localeChoicer.getText());
        ULocale locale = this.formatAdapter.getLocaleByDisplayName(this.locale);
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        int index = this.typeChoicer.getSelectionIndex();
        this.typeChoicer.setItems(this.formatAdapter.getFormatTypes(locale));
        if (index >= 0 && index < this.typeChoicer.getItemCount()) {
            this.typeChoicer.select(index);
        }
        String[][] items = this.getTableItems(locale);
        int i = 0;
        while (i < items.length) {
            this.table.getItem(i).setText(items[i]);
            ++i;
        }
        if (this.table.getSelectionCount() == 1) {
            this.formatCode.setText(this.table.getSelection()[0].getText(2));
        }
        String sampleDateTimeString = new DateFormatter(ENTER_DATE_TIME_GUIDE_FORMAT, locale).format(sampleDateTime);
        this.previewTextBox.setText(sampleDateTimeString);
        this.setPreviewText(sampleDateTimeString);
    }

    private GridLayout createGridLayout4Page() {
        GridLayout layout;
        if (this.pageAlignment == 1) {
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
        } else {
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
        }
        return layout;
    }

    private GridData createGridData4Part() {
        GridData data = this.pageAlignment == 1 ? new GridData(1040) : new GridData(768);
        return data;
    }

    private void setControlsEnabeld(boolean b) {
        this.typeChoicer.setEnabled(b);
        this.localeChoicer.setEnabled(b);
        this.formatCode.setEnabled(b);
        this.previewTextBox.setEnabled(b);
        this.table.setEnabled(b);
    }

    private String getDisplayName4Category(String category) {
        return ChoiceSetFactory.getStructDisplayName("DateTimeFormatValue", "category", category);
    }

    public String[][] getTableItems(ULocale locale) {
        ArrayList<Object> itemList = new ArrayList<Object>();
        String[][] items = new String[][]{{this.getDisplayName4Category("General Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"General Date"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"General Date"), locale).getFormatCode()}, {this.getDisplayName4Category("Long Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Date"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Date"), locale).getFormatCode()}, {this.getDisplayName4Category("Medium Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Date"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Date"), locale).getFormatCode()}, {this.getDisplayName4Category("Short Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Date"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Date"), locale).getFormatCode()}, {this.getDisplayName4Category("Long Time"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Time"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Time"), locale).getFormatCode()}, {this.getDisplayName4Category("Medium Time"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Time"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Time"), locale).getFormatCode()}, {this.getDisplayName4Category("Short Time"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Time"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Time"), locale).getFormatCode()}};
        itemList.addAll(Arrays.asList(items));
        String[] customPatterns = FormatDateTimePattern.getCustormPatternCategorys();
        int i = 0;
        while (i < customPatterns.length) {
            itemList.add(new String[]{FormatDateTimePattern.getDisplayName4CustomCategory((String)customPatterns[i]), new DateFormatter(FormatDateTimePattern.getCustormFormatPattern((String)customPatterns[i]), locale).format(this.defaultDate), FormatDateTimePattern.getCustormFormatPattern((String)customPatterns[i])});
            ++i;
        }
        return (String[][])itemList.toArray((T[])new String[0][3]);
    }
}

