/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FormatCurrencyNumPattern;
import org.eclipse.birt.report.designer.util.FormatCustomNumPattern;
import org.eclipse.birt.report.designer.util.FormatFixedNumPattern;
import org.eclipse.birt.report.designer.util.FormatNumberPattern;
import org.eclipse.birt.report.designer.util.FormatPercentNumPattern;
import org.eclipse.birt.report.designer.util.FormatScientificNumPattern;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FormatNumberPage
extends Composite
implements IFormatPage {
    private static final String PREVIEW_TEXT_INVALID_NUMBER_TO_PREVIEW = Messages.getString((String)"FormatNumberPage.preview.invalidNumber");
    private static final String PREVIEW_TEXT_INVALID_FORMAT_CODE = Messages.getString((String)"FormatNumberPage.preview.invalidFormatCode");
    private static final String LABEL_FORMAT_NUMBER_PAGE = Messages.getString((String)"FormatNumberPage.label.format.number.page");
    private static final String LABEL_FORMAT_NUMBER_LOCALE = Messages.getString((String)"FormatNumberPage.label.format.number.locale");
    private static final String LABEL_CURRENCY_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.currency.settings");
    private static final String LABEL_CURRENCY_SYMBOL = Messages.getString((String)"FormatNumberPage.label.symbol");
    private static final String LABEL_FIXED_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.fixed.settings");
    private static final String LABEL_PERCENT_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.percent.settings");
    private static final String LABEL_USE_1000S_SEPARATOR = Messages.getString((String)"FormatNumberPage.label.use1000sSeparator");
    private static final String LABEL_USE_SYMBOL_SPACE = Messages.getString((String)"FormatNumberPage.label.useSymbolSpace");
    private static final String LABEL_SYMBOL_POSITION = Messages.getString((String)"FormatNumberPage.label.symbol.position");
    private static final String LABEL_NEGATIVE_NUMBERS = Messages.getString((String)"FormatNumberPage.label.negative.numbers");
    private static final String LABEL_SCIENTIFIC_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.scientific.settings");
    private static final String LABEL_DECIMAL_PLACES = Messages.getString((String)"FormatNumberPage.label.decimal.places");
    private static final String LABEL_CUSTOM_SETTINGS_GROUP = Messages.getString((String)"FormatNumberPage.label.custom.settings");
    private static final String LABEL_CUSTOM_SETTINGS_LABEL = Messages.getString((String)"FormatNumberPage.label.custom.settings.lable");
    private static final String LABEL_FORMAT_CODE = Messages.getString((String)"FormatNumberPage.label.format.code");
    private static final String LABEL_CUSTOM_PREVIEW_GROUP = Messages.getString((String)"FormatNumberPage.label.custom.preview.group");
    private static final String LABEL_PREVIEW_NUMBER = Messages.getString((String)"FormatNumberPage.label.preview.number");
    private static final String LABEL_COSTOM_PREVIEW_LABEL = Messages.getString((String)"FormatNumberPage.label.custom.preview.label");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE = Messages.getString((String)"FormatNumberPage.label.table.column.format.code");
    private static final String LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT = Messages.getString((String)"FormatNumberPage.label.table.column.format.result");
    private static final String LABEL_GENERAL_PREVIEW_GROUP = Messages.getString((String)"FormatNumberPage.label.general.preview.group");
    private String pattern = null;
    private String category = null;
    private String locale = null;
    private String oldCategory = null;
    private String oldPattern = null;
    private String oldLocale = null;
    private HashMap categoryPageMaps;
    private HashMap categoryPatternMaps;
    private static String[][] choiceArray = null;
    private static String[] formatTypes = null;
    private static final int FORMAT_TYPE_INDEX = 0;
    private static final int DEFAULT_CATEGORY_CONTAINER_WIDTH = 220;
    private static final double DEFAULT_PREVIEW_NUMBER = 1234.56;
    private static final String DEFAULT_PREVIEW_TEXT = NumberFormat.getNumberInstance((Locale)Locale.getDefault()).format(1234.56);
    private static final String DEFAULT_LOCALE_TEXT = NumberFormat.getNumberInstance((Locale)Locale.getDefault()).format(1234.56);
    private static String[] symbols = new String[0];
    private static final String DEFAULT_PATTERN = "#,##0.00";
    private Combo typeChoicer;
    private Combo localeChoicer;
    private Composite infoComp;
    private Composite formatCodeComp;
    private Composite generalPage;
    private Composite currencyPage;
    private Composite fixedPage;
    private Composite percentPage;
    private Composite scientificPage;
    private Composite customPage;
    private Composite generalFormatCodePage;
    private Composite customFormatCodePage;
    private Text previewTextBox;
    private Text formatCodeBox;
    private CLabel gPreviewLabel;
    private CLabel cPreviewLabel;
    private CLabel fPreviewLabel;
    private CLabel pPreviewLabel;
    private CLabel sPreviewLabel;
    private CLabel cusPreviewLabel;
    private Combo cPlacesChoice;
    private Combo cSymbolChoice;
    private Combo cSymPosChoice;
    private Combo fPlacesChoice;
    private Combo pSymPosChoice;
    private Combo pPlacesChoice;
    private Combo sPlacesChoice;
    private Button cUseSep;
    private Button pUseSep;
    private Button fUseSep;
    private Button cUseSpace;
    private org.eclipse.swt.widgets.List cNegNumChoice;
    private org.eclipse.swt.widgets.List fNegNumChoice;
    private org.eclipse.swt.widgets.List pNegNumChoice;
    private Table table;
    private boolean hasLoaded = false;
    private boolean isDirty = false;
    private String previewText = null;
    private boolean showLocale = true;
    private List listeners = new ArrayList();
    private int pageAlignment;
    private SelectionListener mySelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            FormatNumberPage.this.updatePreview();
            FormatNumberPage.this.notifyFormatChange();
        }
    };
    private ModifyListener myModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (FormatNumberPage.this.hasLoaded) {
                FormatNumberPage.this.updatePreview();
            }
        }
    };
    private FocusListener myFocusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
            FormatNumberPage.this.notifyFormatChange();
        }

        public void focusGained(FocusEvent e) {
        }
    };
    private FormatAdapter formatAdapter;
    private TableItem[] tableItems = new TableItem[4];

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Messages.getString((String)"FormatNumberPage.currency.symbol.none"));
        list.add("\u00a5");
        list.add("$");
        list.add("\u20ac");
        list.add("\u00a3");
        list.add("\u20a9");
        list.add("DKK");
        String localSymbol = Currency.getInstance((Locale)Locale.getDefault()).getSymbol();
        if (localSymbol != null && !list.contains(localSymbol)) {
            list.add(1, localSymbol);
        }
        symbols = list.toArray(new String[0]);
    }

    public FormatNumberPage(Composite parent, int style) {
        this(parent, style, 0, true);
    }

    public FormatNumberPage(Composite parent, int style, int pageAlignment, boolean showLocale) {
        super(parent, style);
        this.pageAlignment = pageAlignment;
        this.showLocale = showLocale;
        this.formatAdapter = new FormatAdapter();
        this.createContents(pageAlignment);
    }

    protected void createContents(int pageAlignment) {
        this.initChoiceArray();
        this.getFormatTypes();
        if (pageAlignment == 1) {
            this.createContentsHorizontally();
        } else {
            this.createContentsVirtically();
        }
    }

    protected void createContentsVirtically() {
        this.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        Composite topContainer = new Composite((Composite)this, 0);
        topContainer.setLayoutData((Object)new GridData(768));
        topContainer.setLayout((Layout)new GridLayout(2, false));
        new Label(topContainer, 0).setText(LABEL_FORMAT_NUMBER_PAGE);
        this.typeChoicer = new Combo(topContainer, 8);
        this.typeChoicer.setLayoutData((Object)new GridData(768));
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatNumberPage.this.reLayoutSubPages();
                FormatNumberPage.this.updateTextByLocale();
                FormatNumberPage.this.updatePreview();
                FormatNumberPage.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.getFormatTypes());
        Label label = new Label(topContainer, 0);
        label.setText(LABEL_FORMAT_NUMBER_LOCALE);
        this.localeChoicer = new Combo(topContainer, 8);
        this.localeChoicer.setLayoutData((Object)new GridData(768));
        this.localeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatNumberPage.this.updateTextByLocale();
                FormatNumberPage.this.updatePreview();
                FormatNumberPage.this.notifyFormatChange();
            }
        });
        this.localeChoicer.setItems(this.formatAdapter.getLocaleDisplayNames());
        if (this.localeChoicer.getItemCount() > 0) {
            this.localeChoicer.select(0);
        }
        WidgetUtil.setExcludeGridData((Control)label, !this.showLocale);
        WidgetUtil.setExcludeGridData((Control)this.localeChoicer, !this.showLocale);
        this.infoComp = new Composite((Composite)this, 0);
        this.infoComp.setLayoutData((Object)new GridData(768));
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.createCategoryPatterns();
        this.setInput(null, null);
        this.setPreviewText(DEFAULT_PREVIEW_TEXT);
    }

    protected void createContentsHorizontally() {
        this.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        Composite container = new Composite((Composite)this, 0);
        GridData data = new GridData();
        data.widthHint = 220;
        container.setLayoutData((Object)data);
        container.setLayout((Layout)new GridLayout(1, false));
        new Label(container, 0).setText(LABEL_FORMAT_NUMBER_PAGE);
        this.typeChoicer = new Combo(container, 8);
        this.typeChoicer.setLayoutData((Object)new GridData(768));
        this.typeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatNumberPage.this.reLayoutSubPages();
                FormatNumberPage.this.updateTextByLocale();
                FormatNumberPage.this.updatePreview();
                FormatNumberPage.this.notifyFormatChange();
            }
        });
        this.typeChoicer.setItems(this.getFormatTypes());
        Label label = new Label(container, 0);
        label.setText(LABEL_FORMAT_NUMBER_LOCALE);
        this.localeChoicer = new Combo(container, 8);
        this.localeChoicer.setLayoutData((Object)new GridData(768));
        this.localeChoicer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatNumberPage.this.updateTextByLocale();
                FormatNumberPage.this.updatePreview();
                FormatNumberPage.this.notifyFormatChange();
            }
        });
        this.localeChoicer.setItems(this.formatAdapter.getLocaleDisplayNames());
        if (this.localeChoicer.getItemCount() > 0) {
            this.localeChoicer.select(0);
        }
        WidgetUtil.setExcludeGridData((Control)label, !this.showLocale);
        WidgetUtil.setExcludeGridData((Control)this.localeChoicer, !this.showLocale);
        this.infoComp = new Composite((Composite)this, 0);
        data = new GridData(1808);
        data.verticalSpan = 2;
        this.infoComp.setLayoutData((Object)data);
        this.infoComp.setLayout((Layout)new StackLayout());
        this.createCategoryPages(this.infoComp);
        this.formatCodeComp = new Composite((Composite)this, 0);
        data = new GridData(1040);
        data.widthHint = 220;
        this.formatCodeComp.setLayoutData((Object)data);
        this.formatCodeComp.setLayout((Layout)new StackLayout());
        this.createFormatCodePages(this.formatCodeComp);
        this.createCategoryPatterns();
        this.setInput(null, null);
        this.setPreviewText(DEFAULT_PREVIEW_TEXT);
    }

    private void updateTextByLocale() {
        GridData gd;
        String places;
        FormatCurrencyNumPattern pattern;
        this.setLocale(this.localeChoicer.getText());
        ULocale locale = this.getLocaleByDisplayName(this.locale);
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        String category = this.getCategory4DisplayName(this.typeChoicer.getText());
        String priviewText = "";
        if (category.equals("Currency")) {
            priviewText = new NumberFormatter(DEFAULT_PATTERN, locale).format(1234.56);
            pattern = (FormatCurrencyNumPattern)this.categoryPatternMaps.get(category);
            places = this.cPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
            pattern.setUseSep(this.cUseSep.getSelection());
            pattern.setUseSpace(this.cUseSpace.getSelection());
            pattern.setSymbol(this.cSymbolChoice.getText());
            pattern.setSymPos(this.cSymPosChoice.getText());
            pattern.setUseBracket(this.cNegNumChoice.getSelectionIndex() == 1);
        } else if (category.equals("Fixed")) {
            priviewText = new NumberFormatter(DEFAULT_PATTERN, locale).format(1234.56);
            pattern = (FormatFixedNumPattern)this.categoryPatternMaps.get(category);
            places = this.fPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
            pattern.setUseSep(this.fUseSep.getSelection());
            pattern.setUseBracket(this.fNegNumChoice.getSelectionIndex() == 1);
        } else if (category.equals("Percent")) {
            priviewText = new NumberFormatter(DEFAULT_PATTERN, locale).format(1234.56);
            pattern = (FormatPercentNumPattern)this.categoryPatternMaps.get(category);
            places = this.pPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
            pattern.setUseSep(this.pUseSep.getSelection());
            pattern.setSymPos(this.pSymPosChoice.getText());
            pattern.setUseBracket(this.pNegNumChoice.getSelectionIndex() == 1);
        } else if (category.equals("Scientific")) {
            priviewText = new NumberFormatter(null, locale).format(1234.56);
            pattern = (FormatScientificNumPattern)this.categoryPatternMaps.get(category);
            places = this.sPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
        } else if (category.equals("Custom")) {
            priviewText = new NumberFormatter(null, locale).format(1234.56);
            pattern = (FormatCustomNumPattern)this.categoryPatternMaps.get(category);
            pattern.setPattern(this.formatCodeBox.getText().length() == 0 ? null : this.formatCodeBox.getText());
        }
        this.setPreviewText(priviewText);
        if (this.fNegNumChoice != null && this.fNegNumChoice.getItemCount() > 0) {
            int index = this.fNegNumChoice.getSelectionIndex();
            this.fNegNumChoice.removeAll();
            this.fNegNumChoice.add("-" + priviewText);
            this.fNegNumChoice.add("(" + priviewText + ")");
            if (index > -1 && index < 2) {
                this.fNegNumChoice.select(index);
            } else {
                this.fNegNumChoice.select(0);
            }
            gd = (GridData)this.fNegNumChoice.getLayoutData();
            gd.heightHint = this.fNegNumChoice.computeSize((int)-1, (int)-1).y + 2;
            this.fNegNumChoice.setLayoutData((Object)gd);
        }
        if (this.cNegNumChoice != null && this.cNegNumChoice.getItemCount() > 0) {
            int index = this.cNegNumChoice.getSelectionIndex();
            this.cNegNumChoice.removeAll();
            this.cNegNumChoice.add("-" + priviewText);
            this.cNegNumChoice.add("(" + priviewText + ")");
            if (index > -1 && index < 2) {
                this.cNegNumChoice.select(index);
            } else {
                this.cNegNumChoice.select(0);
            }
            gd = (GridData)this.fNegNumChoice.getLayoutData();
            gd.heightHint = this.fNegNumChoice.computeSize((int)-1, (int)-1).y + 2;
            this.cNegNumChoice.setLayoutData((Object)gd);
        }
        if (this.pNegNumChoice != null && this.pNegNumChoice.getItemCount() > 0) {
            int index = this.pNegNumChoice.getSelectionIndex();
            this.pNegNumChoice.removeAll();
            this.pNegNumChoice.add("-" + priviewText);
            this.pNegNumChoice.add("(" + priviewText + ")");
            if (index > -1 && index < 2) {
                this.pNegNumChoice.select(index);
            } else {
                this.pNegNumChoice.select(0);
            }
            gd = (GridData)this.fNegNumChoice.getLayoutData();
            gd.heightHint = this.fNegNumChoice.computeSize((int)-1, (int)-1).y + 2;
            this.pNegNumChoice.setLayoutData((Object)gd);
        }
        if (this.tableItems[0] != null) {
            this.tableItems[0].setText(new String[]{this.getDisplayName4Category("Currency"), new NumberFormatter(this.getPatternForCategory("Currency"), locale).format(1234.56)});
        }
        if (this.tableItems[1] != null) {
            this.tableItems[1].setText(new String[]{this.getDisplayName4Category("Fixed"), new NumberFormatter(this.getPatternForCategory("Fixed"), locale).format(1234.56)});
        }
        if (this.tableItems[2] != null) {
            this.tableItems[2].setText(new String[]{this.getDisplayName4Category("Percent"), new NumberFormatter(this.getPatternForCategory("Percent"), locale).format(1234.56)});
        }
        if (this.tableItems[3] != null) {
            this.tableItems[3].setText(new String[]{this.getDisplayName4Category("Scientific"), new NumberFormatter(this.getPatternForCategory("Scientific"), locale).format(1234.56)});
        }
    }

    private void createCategoryPages(Composite parent) {
        this.categoryPageMaps = new HashMap();
        this.categoryPageMaps.put("Unformatted", this.getGeneralPage(parent));
        this.categoryPageMaps.put("General Number", this.getGeneralPage(parent));
        this.categoryPageMaps.put("Currency", this.getCurrencyPage(parent));
        this.categoryPageMaps.put("Fixed", this.getFixedPage(parent));
        this.categoryPageMaps.put("Percent", this.getPercentPage(parent));
        this.categoryPageMaps.put("Scientific", this.getScientificPage(parent));
        this.categoryPageMaps.put("Custom", this.getCustomPage(parent));
    }

    private void createFormatCodePages(Composite parent) {
        this.getHorizonGeneralFormatCodePage(parent);
        this.getHorizonCustomFormatCodePage(parent);
    }

    private void createCategoryPatterns() {
        this.categoryPatternMaps = new HashMap();
        this.categoryPatternMaps.put("General Number", new FormatNumberPattern());
        this.categoryPatternMaps.put("Currency", new FormatCurrencyNumPattern("Currency"));
        this.categoryPatternMaps.put("Fixed", new FormatFixedNumPattern("Fixed"));
        this.categoryPatternMaps.put("Percent", new FormatPercentNumPattern("Percent"));
        this.categoryPatternMaps.put("Scientific", new FormatScientificNumPattern("Scientific"));
        this.categoryPatternMaps.put("Custom", new FormatCustomNumPattern("Custom"));
    }

    private String[][] initChoiceArray() {
        if (choiceArray == null) {
            IChoiceSet set = ChoiceSetFactory.getStructChoiceSet("NumberFormatValue", "category");
            IChoice[] choices = set.getChoices();
            if (choices.length > 0) {
                choiceArray = new String[choices.length - 1][2];
                int i = 0;
                int j = 0;
                while (i < choices.length) {
                    if (!choices[i].getName().equals("Standard")) {
                        FormatNumberPage.choiceArray[j][0] = choices[i].getDisplayName();
                        FormatNumberPage.choiceArray[j][1] = choices[i].getName();
                        ++j;
                    }
                    ++i;
                }
            } else {
                choiceArray = new String[0][0];
            }
        }
        return choiceArray;
    }

    private String[] getFormatTypes() {
        if (this.initChoiceArray() != null) {
            formatTypes = new String[choiceArray.length];
            int i = 0;
            while (i < choiceArray.length) {
                FormatNumberPage.formatTypes[i] = choiceArray[i][0];
                ++i;
            }
        } else {
            formatTypes = new String[0];
        }
        return formatTypes;
    }

    private int getIndexOfCategory(String name) {
        if (this.initChoiceArray() != null) {
            int i = 0;
            while (i < choiceArray.length) {
                if (choiceArray[i][1].equals(name)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    private String getCategory4DisplayName(String displayName) {
        if (this.initChoiceArray() != null) {
            int i = 0;
            while (i < choiceArray.length) {
                if (choiceArray[i][0].equals(displayName)) {
                    return choiceArray[i][1];
                }
                ++i;
            }
        }
        return displayName;
    }

    private String getDisplayName4Category(String category) {
        return ChoiceSetFactory.getStructDisplayName("NumberFormatValue", "category", category);
    }

    private String getPatternForCategory(String category) {
        String pattern = null;
        if ("Currency".equals(category)) {
            pattern = "\u00a4###,##0.00";
            Currency currency = Currency.getInstance((ULocale)ULocale.getDefault());
            if (currency != null) {
                String symbol = currency.getSymbol();
                NumberFormat formater = NumberFormat.getCurrencyInstance();
                String result = formater.format(1L);
                if (result.endsWith(symbol)) {
                    pattern = "###,##0.00\u00a4";
                }
            }
        } else {
            pattern = "Fixed".equals(category) ? "#0.00" : ("Percent".equals(category) ? "0.00%" : ("Scientific".equals(category) ? "0.00E00" : ""));
        }
        return pattern;
    }

    private FormatNumberPattern getFmtPattern4Category(String category) {
        FormatNumberPattern fmtPattern = null;
        if (this.categoryPatternMaps != null) {
            fmtPattern = (FormatNumberPattern)this.categoryPatternMaps.get(category);
        }
        if (fmtPattern == null) {
            fmtPattern = new FormatNumberPattern();
        }
        return fmtPattern;
    }

    private Control getFmtPage4Category(String category) {
        Control page = null;
        if (this.categoryPageMaps != null) {
            page = (Control)this.categoryPageMaps.get(category);
        }
        if (page == null) {
            page = this.getGeneralPage(this.infoComp);
        }
        return page;
    }

    private void fireFormatChanged(String newCategory, String newPattern, String newLocale) {
        if (this.listeners.isEmpty()) {
            return;
        }
        FormatChangeEvent event = new FormatChangeEvent(this, "numberFormat", newCategory, newPattern, newLocale);
        for (Object listener : this.listeners) {
            if (!(listener instanceof IFormatChangeListener)) continue;
            ((IFormatChangeListener)listener).formatChange(event);
        }
    }

    private void notifyFormatChange() {
        if (this.hasLoaded) {
            this.fireFormatChanged(this.getCategory(), this.getPattern(), this.locale);
        }
    }

    public void addFormatChangeListener(IFormatChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void setInput(String formatString) {
        if (formatString == null) {
            this.setInput(null, null);
            return;
        }
        String fmtStr = formatString;
        int pos = fmtStr.indexOf(":");
        if (StringUtil.isBlank((String)fmtStr)) {
            this.setInput(null, null);
            return;
        }
        if (pos == -1) {
            this.setInput(fmtStr, fmtStr);
            return;
        }
        String category = fmtStr.substring(0, pos);
        String patternStr = fmtStr.substring(pos + 1);
        this.setInput(category, patternStr);
    }

    public void setInput(String categoryStr, String patternStr) {
        this.setInput(categoryStr, patternStr, null);
    }

    public void setInput(String categoryStr, String patternStr, ULocale locale) {
        this.hasLoaded = false;
        String localeStr = this.formatAdapter.getLocaleDisplayName(locale);
        this.initiatePageLayout(categoryStr, patternStr, localeStr);
        this.reLayoutSubPages();
        this.updateTextByLocale();
        this.updatePreview();
        this.oldCategory = categoryStr;
        this.oldPattern = patternStr;
        this.oldLocale = localeStr;
        this.hasLoaded = true;
    }

    public void setPreviewText(String preText) {
        if (preText == null) {
            this.previewTextBox.setText(DEFAULT_PREVIEW_TEXT);
        } else {
            this.previewTextBox.setText(preText);
        }
    }

    public String getCategory() {
        return this.category;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getFormatString() {
        if (this.category == null && this.pattern == null) {
            return "Unformatted";
        }
        if (this.category == null) {
            this.category = "";
        }
        if (this.pattern == null) {
            this.pattern = "";
        }
        if (this.category.equals(this.pattern)) {
            return this.category;
        }
        return String.valueOf(this.category) + ":" + this.pattern;
    }

    public boolean isFormatModified() {
        String c = this.getCategory();
        String p = this.getPattern();
        String l = this.locale;
        if (this.oldCategory == null ? c != null : !this.oldCategory.equals(c)) {
            return true;
        }
        if (this.oldPattern == null ? p != null : !this.oldPattern.equals(p)) {
            return true;
        }
        return this.oldLocale == null ? l != null : !this.oldLocale.equals(l);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setControlsEnabled(enabled);
    }

    private String getPreviewText() {
        return this.previewText;
    }

    private void setPattern(String pattern) {
        this.pattern = pattern;
    }

    private void setCategory(String category) {
        this.category = category;
    }

    private void setLocale(String locale) {
        this.locale = locale;
    }

    private void setDefaultPreviewText(String defText) {
        this.previewText = defText == null || StringUtil.isBlank((String)defText) || !this.isValidNumber(defText) ? null : defText;
    }

    private boolean isValidNumber(String text) {
        ULocale locale = this.getLocaleByDisplayName(this.localeChoicer.getText());
        if (locale == null) {
            locale = ULocale.forLocale((Locale)Locale.getDefault());
        }
        try {
            NumberFormat.getNumberInstance((ULocale)locale).parse(text);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    private ULocale getLocaleByDisplayName(String name) {
        if (this.formatAdapter != null) {
            return this.formatAdapter.getLocaleByDisplayName(name);
        }
        return null;
    }

    private void markDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    private String validatedFmtStr(String fmtStr) {
        String text = fmtStr;
        if (text == null) {
            text = PREVIEW_TEXT_INVALID_FORMAT_CODE;
        }
        return text;
    }

    private void updatePreview() {
        String category;
        this.markDirty(this.hasLoaded);
        if (this.hasLoaded) {
            this.setFmtPatternFromControls();
        }
        if ("Unformatted".equals(category = this.getCategory4DisplayName(this.typeChoicer.getText()))) {
            this.setCategory("Unformatted");
            this.setPattern(null);
        } else {
            FormatNumberPattern fmtPattern = this.getFmtPattern4Category(category);
            this.setCategory(fmtPattern.getCategory());
            this.setPattern(fmtPattern.getPattern());
        }
        this.doPreview(this.getCategory(), this.getPattern(), this.locale);
    }

    private void doPreview(String category, String patternStr, String localeName) {
        ULocale locale = this.getLocaleByDisplayName(localeName);
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        double num = 1234.56;
        if (this.getPreviewText() != null) {
            try {
                if (category.equals("Currency")) {
                    num = new NumberFormatter(DEFAULT_PATTERN, locale).parse(this.getPreviewText()).doubleValue();
                } else if (category.equals("Fixed")) {
                    num = new NumberFormatter(DEFAULT_PATTERN, locale).parse(this.getPreviewText()).doubleValue();
                } else if (category.equals("Percent")) {
                    num = new NumberFormatter(DEFAULT_PATTERN, locale).parse(this.getPreviewText()).doubleValue();
                } else if (category.equals("Scientific")) {
                    num = new NumberFormatter(null, locale).parse(this.getPreviewText()).doubleValue();
                } else if (category.equals("Custom")) {
                    num = new NumberFormatter(null, locale).parse(this.getPreviewText()).doubleValue();
                }
            }
            catch (ParseException e) {
                ExceptionHandler.handle(e);
                num = 1234.56;
            }
        }
        if (category == null) {
            String fmtStr = this.getPreviewText();
            fmtStr = new NumberFormatter(patternStr, locale).format(num);
            this.gPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("Unformatted")) {
            String fmtStr = new NumberFormatter(patternStr, locale).format(num);
            this.gPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("General Number")) {
            String fmtStr = new NumberFormatter(patternStr, locale).format(num);
            this.gPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("Currency")) {
            String fmtStr = new NumberFormatter(patternStr, locale).format(num);
            this.cPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("Fixed")) {
            String fmtStr = new NumberFormatter(patternStr, locale).format(num);
            this.fPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("Percent")) {
            String fmtStr = new NumberFormatter(patternStr, locale).format(num);
            this.pPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("Scientific")) {
            String fmtStr = new NumberFormatter(patternStr, locale).format(num);
            this.sPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
        if (category.equals("Custom")) {
            String fmtStr = StringUtil.isBlank((String)this.previewTextBox.getText()) || this.isValidNumber(this.previewTextBox.getText()) ? new NumberFormatter(patternStr, locale).format(num) : PREVIEW_TEXT_INVALID_NUMBER_TO_PREVIEW;
            this.cusPreviewLabel.setText(this.validatedFmtStr(fmtStr));
            return;
        }
    }

    private void initiatePageLayout(String categoryStr, String patternStr, String localeStr) {
        if (localeStr != null) {
            this.localeChoicer.setText(localeStr);
        } else {
            this.localeChoicer.select(0);
        }
        if (categoryStr == null) {
            this.typeChoicer.select(0);
            return;
        }
        FormatNumberPattern fmtPattern = this.getFmtPattern4Category(categoryStr);
        fmtPattern.setPattern(patternStr);
        if ("General Number".equals(categoryStr)) {
            this.typeChoicer.select(this.getIndexOfCategory(categoryStr));
        } else if ("Currency".equals(categoryStr)) {
            this.refreshCurrencySetting((FormatCurrencyNumPattern)fmtPattern);
            this.typeChoicer.select(this.getIndexOfCategory(categoryStr));
        } else if ("Fixed".equals(categoryStr)) {
            this.refreshFixedSetting((FormatFixedNumPattern)fmtPattern);
            this.typeChoicer.select(this.getIndexOfCategory(categoryStr));
        } else if ("Percent".equals(categoryStr)) {
            this.refreshPercentSetting((FormatPercentNumPattern)fmtPattern);
            this.typeChoicer.select(this.getIndexOfCategory(categoryStr));
        } else if ("Scientific".equals(categoryStr)) {
            this.refreshScientificSetting((FormatScientificNumPattern)fmtPattern);
            this.typeChoicer.select(this.getIndexOfCategory(categoryStr));
        } else if ("Custom".equals(categoryStr)) {
            this.refreshCustomSetting((FormatCustomNumPattern)fmtPattern);
            this.typeChoicer.select(this.getIndexOfCategory(categoryStr));
        } else {
            this.typeChoicer.select(0);
        }
    }

    private void reLayoutSubPages() {
        Control control;
        String category = this.getCategory4DisplayName(this.typeChoicer.getText());
        ((StackLayout)this.infoComp.getLayout()).topControl = control = this.getFmtPage4Category(category);
        this.infoComp.layout();
        if (this.formatCodeComp != null) {
            ((StackLayout)this.formatCodeComp.getLayout()).topControl = category.equals("Custom") ? this.getHorizonCustomFormatCodePage(this.formatCodeComp) : this.getHorizonGeneralFormatCodePage(this.formatCodeComp);
            this.formatCodeComp.layout();
        }
    }

    private void refreshCurrencySetting(FormatCurrencyNumPattern fmtPattern) {
        this.cPlacesChoice.setText(String.valueOf(fmtPattern.getDecPlaces()));
        this.cUseSep.setSelection(fmtPattern.getUseSep());
        this.cUseSpace.setSelection(fmtPattern.getUseSpace());
        if (!StringUtil.isBlank((String)fmtPattern.getSymbol())) {
            this.cSymbolChoice.setText(fmtPattern.getSymbol());
        }
        if (!StringUtil.isBlank((String)fmtPattern.getSymPos())) {
            this.cSymPosChoice.setText(fmtPattern.getSymPos());
            this.cSymPosChoice.setEnabled(true);
        }
        if (fmtPattern.getUseBracket()) {
            this.cNegNumChoice.select(1);
        } else {
            this.cNegNumChoice.select(0);
        }
    }

    private void refreshFixedSetting(FormatFixedNumPattern fmtPattern) {
        this.fPlacesChoice.setText(String.valueOf(fmtPattern.getDecPlaces()));
        this.fUseSep.setSelection(fmtPattern.getUseSep());
        if (fmtPattern.getUseBracket()) {
            this.fNegNumChoice.select(1);
        } else {
            this.fNegNumChoice.select(0);
        }
    }

    private void refreshPercentSetting(FormatPercentNumPattern fmtPattern) {
        this.pPlacesChoice.setText(String.valueOf(fmtPattern.getDecPlaces()));
        this.pUseSep.setSelection(fmtPattern.getUseSep());
        this.pSymPosChoice.setText(fmtPattern.getSymPos());
        if (fmtPattern.getUseBracket()) {
            this.pNegNumChoice.select(1);
        } else {
            this.pNegNumChoice.select(0);
        }
    }

    private void refreshScientificSetting(FormatScientificNumPattern fmtPattern) {
        this.sPlacesChoice.setText(String.valueOf(fmtPattern.getDecPlaces()));
    }

    private void refreshCustomSetting(FormatCustomNumPattern fmtPattern) {
        this.formatCodeBox.setText(fmtPattern.getPattern() == null ? "" : fmtPattern.getPattern());
    }

    private void setFmtPatternFromControls() {
        if (this.categoryPatternMaps == null) {
            return;
        }
        String category = this.getCategory4DisplayName(this.typeChoicer.getText());
        if (category.equals("Currency")) {
            FormatCurrencyNumPattern pattern = (FormatCurrencyNumPattern)this.categoryPatternMaps.get(category);
            String places = this.cPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
            pattern.setUseSep(this.cUseSep.getSelection());
            pattern.setUseSpace(this.cUseSpace.getSelection());
            pattern.setSymbol(this.cSymbolChoice.getText());
            pattern.setSymPos(this.cSymPosChoice.getText());
            pattern.setUseBracket(this.cNegNumChoice.getSelectionIndex() == 1);
        } else if (category.equals("Fixed")) {
            FormatFixedNumPattern pattern = (FormatFixedNumPattern)this.categoryPatternMaps.get(category);
            String places = this.fPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
            pattern.setUseSep(this.fUseSep.getSelection());
            pattern.setUseBracket(this.fNegNumChoice.getSelectionIndex() == 1);
        } else if (category.equals("Percent")) {
            FormatPercentNumPattern pattern = (FormatPercentNumPattern)this.categoryPatternMaps.get(category);
            String places = this.pPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
            pattern.setUseSep(this.pUseSep.getSelection());
            pattern.setSymPos(this.pSymPosChoice.getText());
            pattern.setUseBracket(this.pNegNumChoice.getSelectionIndex() == 1);
        } else if (category.equals("Scientific")) {
            FormatScientificNumPattern pattern = (FormatScientificNumPattern)this.categoryPatternMaps.get(category);
            String places = this.sPlacesChoice.getText();
            pattern.setDecPlaces(DEUtil.isValidInteger((String)places) ? Integer.parseInt(places) : 0);
        } else if (category.equals("Custom")) {
            FormatCustomNumPattern pattern = (FormatCustomNumPattern)this.categoryPatternMaps.get(category);
            pattern.setPattern(this.formatCodeBox.getText().length() == 0 ? null : this.formatCodeBox.getText());
        }
    }

    private Composite getGeneralPage(Composite parent) {
        if (this.generalPage == null) {
            this.generalPage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            this.generalPage.setLayout((Layout)layout);
            this.gPreviewLabel = this.createGeneralPreviewPart4Page(this.generalPage);
        }
        return this.generalPage;
    }

    private Composite getCurrencyPage(Composite parent) {
        if (this.currencyPage == null) {
            this.currencyPage = new Composite(parent, 0);
            this.currencyPage.setLayout((Layout)this.createGridLayout4Page());
            this.createCurrencySettingPart(this.currencyPage);
            this.cPreviewLabel = this.createGeneralPreviewPart4Page(this.currencyPage);
        }
        return this.currencyPage;
    }

    private Composite getFixedPage(Composite parent) {
        if (this.fixedPage == null) {
            this.fixedPage = new Composite(parent, 0);
            this.fixedPage.setLayout((Layout)this.createGridLayout4Page());
            this.createFixedSettingPart(this.fixedPage);
            this.fPreviewLabel = this.createGeneralPreviewPart4Page(this.fixedPage);
        }
        return this.fixedPage;
    }

    private Composite getPercentPage(Composite parent) {
        if (this.percentPage == null) {
            this.percentPage = new Composite(parent, 0);
            this.percentPage.setLayout((Layout)this.createGridLayout4Page());
            this.createPercentSettingPart(this.percentPage);
            this.pPreviewLabel = this.createGeneralPreviewPart4Page(this.percentPage);
        }
        return this.percentPage;
    }

    private Composite getScientificPage(Composite parent) {
        if (this.scientificPage == null) {
            this.scientificPage = new Composite(parent, 0);
            this.scientificPage.setLayout((Layout)this.createGridLayout4Page());
            this.createScientificSettingPart(this.scientificPage);
            this.sPreviewLabel = this.createGeneralPreviewPart4Page(this.scientificPage);
        }
        return this.scientificPage;
    }

    private Composite getCustomPage(Composite parent) {
        if (this.customPage == null) {
            this.customPage = new Composite(parent, 0);
            this.customPage.setLayout((Layout)this.createGridLayout4Page());
            this.createCustomSettingsPart(this.customPage);
            if (this.pageAlignment == 0) {
                Composite container = new Composite(this.customPage, 0);
                container.setLayoutData((Object)new GridData(768));
                container.setLayout((Layout)new GridLayout(2, false));
                new Label(container, 0).setText(LABEL_FORMAT_CODE);
                this.formatCodeBox = new Text(container, 2052);
                this.formatCodeBox.setLayoutData((Object)new GridData(768));
                this.formatCodeBox.addModifyListener(this.myModifyListener);
                this.formatCodeBox.addFocusListener(this.myFocusListener);
            }
            this.createCustomPreviewPart4Page(this.customPage);
        }
        return this.customPage;
    }

    private Composite getHorizonGeneralFormatCodePage(Composite parent) {
        if (this.generalFormatCodePage == null) {
            this.generalFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.generalFormatCodePage.setLayout((Layout)layout);
            Label l = new Label(this.generalFormatCodePage, 258);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            l.setLayoutData((Object)data);
        }
        return this.generalFormatCodePage;
    }

    private Composite getHorizonCustomFormatCodePage(Composite parent) {
        if (this.customFormatCodePage == null) {
            this.customFormatCodePage = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 1;
            this.customFormatCodePage.setLayout((Layout)layout);
            Label l = new Label(this.customFormatCodePage, 258);
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            l.setLayoutData((Object)data);
            Composite container = new Composite(this.customFormatCodePage, 0);
            container.setLayoutData((Object)new GridData(768));
            container.setLayout((Layout)new GridLayout(2, false));
            new Label(container, 0).setText(LABEL_FORMAT_CODE);
            this.formatCodeBox = new Text(container, 2052);
            this.formatCodeBox.setLayoutData((Object)new GridData(768));
            this.formatCodeBox.addModifyListener(this.myModifyListener);
            this.formatCodeBox.addFocusListener(this.myFocusListener);
        }
        return this.customFormatCodePage;
    }

    private void createCurrencySettingPart(Composite parent) {
        Group setting = new Group(parent, 0);
        setting.setText(LABEL_CURRENCY_SETTINGS_GROUP);
        setting.setLayoutData((Object)this.createGridData4Part());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.verticalSpacing = 1;
        setting.setLayout((Layout)layout);
        new Label((Composite)setting, 0).setText(LABEL_DECIMAL_PLACES);
        this.cPlacesChoice = new Combo((Composite)setting, 2564);
        this.cPlacesChoice.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        GridData data = new GridData(768);
        data.heightHint = 20;
        this.cPlacesChoice.setLayoutData((Object)data);
        this.cPlacesChoice.addSelectionListener(this.mySelectionListener);
        this.cPlacesChoice.addModifyListener(this.myModifyListener);
        this.cPlacesChoice.addFocusListener(this.myFocusListener);
        this.cPlacesChoice.select(2);
        this.cUseSep = new Button((Composite)setting, 32);
        this.cUseSep.setText(LABEL_USE_1000S_SEPARATOR);
        data = new GridData();
        data.horizontalSpan = 2;
        this.cUseSep.setLayoutData((Object)data);
        this.cUseSep.addSelectionListener(this.mySelectionListener);
        this.cUseSpace = new Button((Composite)setting, 32);
        this.cUseSpace.setText(LABEL_USE_SYMBOL_SPACE);
        data = new GridData();
        data.horizontalSpan = 2;
        this.cUseSpace.setLayoutData((Object)data);
        this.cUseSpace.addSelectionListener(this.mySelectionListener);
        new Label((Composite)setting, 0).setText(LABEL_CURRENCY_SYMBOL);
        this.cSymbolChoice = new Combo((Composite)setting, 12);
        this.cSymbolChoice.setLayoutData((Object)new GridData(256));
        this.cSymbolChoice.setItems(symbols);
        this.cSymbolChoice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FormatNumberPage.this.cSymbolChoice.getSelectionIndex() == 0) {
                    FormatNumberPage.this.cSymPosChoice.deselectAll();
                    FormatNumberPage.this.cSymPosChoice.setEnabled(false);
                } else if (!FormatNumberPage.this.cSymPosChoice.isEnabled()) {
                    FormatNumberPage.this.cSymPosChoice.setEnabled(true);
                    FormatNumberPage.this.cSymPosChoice.select(1);
                }
                FormatNumberPage.this.updatePreview();
                FormatNumberPage.this.notifyFormatChange();
            }
        });
        this.cSymbolChoice.select(0);
        new Label((Composite)setting, 0).setText(LABEL_SYMBOL_POSITION);
        this.cSymPosChoice = new Combo((Composite)setting, 12);
        this.cSymPosChoice.setItems(new String[]{FormatNumberPattern.SYMBOL_POSITION_AFTER, FormatNumberPattern.SYMBOL_POSITION_BEFORE});
        this.cSymPosChoice.setLayoutData((Object)new GridData(768));
        this.cSymPosChoice.addSelectionListener(this.mySelectionListener);
        this.cSymPosChoice.setEnabled(false);
        Label label = new Label((Composite)setting, 0);
        label.setLayoutData((Object)new GridData(2));
        label.setText(LABEL_NEGATIVE_NUMBERS);
        this.cNegNumChoice = new org.eclipse.swt.widgets.List((Composite)setting, 2052);
        this.cNegNumChoice.add("-" + DEFAULT_LOCALE_TEXT);
        this.cNegNumChoice.add("(" + DEFAULT_LOCALE_TEXT + ")");
        data = new GridData(1808);
        this.cNegNumChoice.setLayoutData((Object)data);
        this.cNegNumChoice.addSelectionListener(this.mySelectionListener);
        this.cNegNumChoice.select(0);
    }

    private void createFixedSettingPart(Composite parent) {
        Group setting = new Group(parent, 0);
        setting.setText(LABEL_FIXED_SETTINGS_GROUP);
        setting.setLayoutData((Object)this.createGridData4Part());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.verticalSpacing = 1;
        setting.setLayout((Layout)layout);
        Label label = new Label((Composite)setting, 0);
        label.setText(LABEL_DECIMAL_PLACES);
        this.fPlacesChoice = new Combo((Composite)setting, 2564);
        this.fPlacesChoice.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        GridData data = new GridData(768);
        data.heightHint = 20;
        this.fPlacesChoice.setLayoutData((Object)data);
        this.fPlacesChoice.addSelectionListener(this.mySelectionListener);
        this.fPlacesChoice.addModifyListener(this.myModifyListener);
        this.fPlacesChoice.addFocusListener(this.myFocusListener);
        this.fPlacesChoice.select(2);
        this.fUseSep = new Button((Composite)setting, 32);
        this.fUseSep.setText(LABEL_USE_1000S_SEPARATOR);
        GridData gData = new GridData();
        gData.horizontalSpan = 2;
        this.fUseSep.setLayoutData((Object)gData);
        this.fUseSep.addSelectionListener(this.mySelectionListener);
        label = new Label((Composite)setting, 0);
        label.setText(LABEL_NEGATIVE_NUMBERS);
        label.setLayoutData((Object)new GridData(2));
        this.fNegNumChoice = new org.eclipse.swt.widgets.List((Composite)setting, 2052);
        this.fNegNumChoice.add("-" + DEFAULT_LOCALE_TEXT);
        this.fNegNumChoice.add("(" + DEFAULT_LOCALE_TEXT + ")");
        gData = new GridData(1808);
        this.fNegNumChoice.setLayoutData((Object)gData);
        this.fNegNumChoice.addSelectionListener(this.mySelectionListener);
        this.fNegNumChoice.select(0);
    }

    private void createPercentSettingPart(Composite percent) {
        Group setting = new Group(percent, 0);
        setting.setText(LABEL_PERCENT_SETTINGS_GROUP);
        setting.setLayoutData((Object)this.createGridData4Part());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.verticalSpacing = 1;
        setting.setLayout((Layout)layout);
        new Label((Composite)setting, 0).setText(LABEL_DECIMAL_PLACES);
        this.pPlacesChoice = new Combo((Composite)setting, 2564);
        this.pPlacesChoice.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        GridData data = new GridData(768);
        this.pPlacesChoice.setLayoutData((Object)data);
        this.pPlacesChoice.addSelectionListener(this.mySelectionListener);
        this.pPlacesChoice.addModifyListener(this.myModifyListener);
        this.pPlacesChoice.addFocusListener(this.myFocusListener);
        this.pPlacesChoice.select(2);
        this.pUseSep = new Button((Composite)setting, 32);
        this.pUseSep.setText(LABEL_USE_1000S_SEPARATOR);
        GridData gData = new GridData();
        gData.horizontalSpan = 2;
        this.pUseSep.setLayoutData((Object)gData);
        this.pUseSep.addSelectionListener(this.mySelectionListener);
        new Label((Composite)setting, 0).setText(LABEL_SYMBOL_POSITION);
        this.pSymPosChoice = new Combo((Composite)setting, 12);
        this.pSymPosChoice.setItems(new String[]{FormatNumberPattern.SYMBOL_POSITION_AFTER, FormatNumberPattern.SYMBOL_POSITION_BEFORE});
        this.pSymPosChoice.setLayoutData((Object)new GridData(768));
        this.pSymPosChoice.addSelectionListener(this.mySelectionListener);
        this.pSymPosChoice.select(0);
        Label label = new Label((Composite)setting, 0);
        label.setText(LABEL_NEGATIVE_NUMBERS);
        label.setLayoutData((Object)new GridData(2));
        this.pNegNumChoice = new org.eclipse.swt.widgets.List((Composite)setting, 2052);
        this.pNegNumChoice.add("-" + DEFAULT_LOCALE_TEXT);
        this.pNegNumChoice.add("(" + DEFAULT_LOCALE_TEXT + ")");
        this.pNegNumChoice.setLayoutData((Object)new GridData(1808));
        this.pNegNumChoice.addSelectionListener(this.mySelectionListener);
        this.pNegNumChoice.select(0);
    }

    private void createScientificSettingPart(Composite percent) {
        Group group = new Group(percent, 0);
        group.setText(LABEL_SCIENTIFIC_SETTINGS_GROUP);
        group.setLayoutData((Object)this.createGridData4Part());
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(LABEL_DECIMAL_PLACES);
        this.sPlacesChoice = new Combo((Composite)group, 2564);
        this.sPlacesChoice.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        GridData data = new GridData(768);
        data.widthHint = 60;
        this.sPlacesChoice.setLayoutData((Object)data);
        this.sPlacesChoice.addSelectionListener(this.mySelectionListener);
        this.sPlacesChoice.addModifyListener(this.myModifyListener);
        this.pPlacesChoice.addFocusListener(this.myFocusListener);
        this.sPlacesChoice.select(2);
    }

    private void createCustomSettingsPart(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(LABEL_CUSTOM_SETTINGS_GROUP);
        group.setLayoutData((Object)this.createGridData4Part());
        group.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label((Composite)group, 0);
        label.setText(LABEL_CUSTOM_SETTINGS_LABEL);
        label.setLayoutData((Object)new GridData());
        this.createTable((Composite)group);
    }

    private void createCustomPreviewPart4Page(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(LABEL_CUSTOM_PREVIEW_GROUP);
        if (this.pageAlignment == 1) {
            group.setLayoutData((Object)new GridData(1808));
            group.setLayout((Layout)new GridLayout(1, false));
        } else {
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)new GridLayout(2, false));
        }
        new Label((Composite)group, 0).setText(LABEL_PREVIEW_NUMBER);
        this.previewTextBox = new Text((Composite)group, 2052);
        this.previewTextBox.setText(DEFAULT_PREVIEW_TEXT);
        GridData data = new GridData(768);
        if (this.pageAlignment == 1) {
            data.horizontalIndent = 10;
        }
        this.previewTextBox.setLayoutData((Object)data);
        this.previewTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormatNumberPage.this.setDefaultPreviewText(FormatNumberPage.this.previewTextBox.getText());
                if (FormatNumberPage.this.hasLoaded) {
                    FormatNumberPage.this.updatePreview();
                }
            }
        });
        Label label = new Label((Composite)group, 0);
        label.setText(LABEL_COSTOM_PREVIEW_LABEL);
        label.setLayoutData((Object)new GridData());
        this.cusPreviewLabel = new CLabel((Composite)group, 0x11000100);
        this.cusPreviewLabel.setLayoutData((Object)new GridData(1808));
    }

    private CLabel createGeneralPreviewPart4Page(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(LABEL_GENERAL_PREVIEW_GROUP);
        GridData data = this.pageAlignment == 1 ? new GridData(1808) : new GridData(768);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        group.setLayout((Layout)layout);
        CLabel previewText = new CLabel((Composite)group, 0x1000300);
        previewText.setLayoutData((Object)new GridData(1808));
        return previewText;
    }

    private void createTable(Composite group) {
        this.table = new Table(group, 100352);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumValue = new TableColumn(this.table, 0);
        tableColumValue.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_CODE);
        tableColumValue.setWidth(120);
        tableColumValue.setResizable(true);
        TableColumn tableColumnDisplay = new TableColumn(this.table, 0);
        tableColumnDisplay.setText(LABEL_TABLE_COLUMN_EXAMPLE_FORMAT_RESULT);
        tableColumnDisplay.setWidth(120);
        tableColumnDisplay.setResizable(true);
        this.tableItems[0] = new TableItem(this.table, 0);
        this.tableItems[0].setText(new String[]{this.getDisplayName4Category("Currency"), new NumberFormatter(this.getPatternForCategory("Currency")).format(1234.56)});
        this.tableItems[1] = new TableItem(this.table, 0);
        this.tableItems[1].setText(new String[]{this.getDisplayName4Category("Fixed"), new NumberFormatter(this.getPatternForCategory("Fixed")).format(1234.56)});
        this.tableItems[2] = new TableItem(this.table, 0);
        this.tableItems[2].setText(new String[]{this.getDisplayName4Category("Percent"), new NumberFormatter(this.getPatternForCategory("Percent")).format(1234.56)});
        this.tableItems[3] = new TableItem(this.table, 0);
        this.tableItems[3].setText(new String[]{this.getDisplayName4Category("Scientific"), new NumberFormatter(this.getPatternForCategory("Scientific")).format(1234.56)});
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String displayName = ((TableItem)e.item).getText(0);
                String category = ChoiceSetFactory.getStructPropValue("NumberFormatValue", "category", displayName);
                String pattern = FormatNumberPage.this.getPatternForCategory(category);
                FormatNumberPage.this.formatCodeBox.setText(pattern);
                FormatNumberPage.this.updatePreview();
                FormatNumberPage.this.notifyFormatChange();
            }
        });
    }

    private GridLayout createGridLayout4Page() {
        GridLayout layout;
        if (this.pageAlignment == 1) {
            layout = new GridLayout(2, false);
            layout.marginHeight = 0;
        } else {
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
        }
        return layout;
    }

    private GridData createGridData4Part() {
        GridData data = this.pageAlignment == 1 ? new GridData(1040) : new GridData(768);
        return data;
    }

    private void setControlsEnabled(boolean b) {
        this.typeChoicer.setEnabled(b);
        this.localeChoicer.setEnabled(b);
        this.cPlacesChoice.setEnabled(b);
        this.cUseSep.setEnabled(b);
        this.cUseSpace.setEnabled(b);
        this.cSymbolChoice.setEnabled(b);
        this.cSymPosChoice.setEnabled(b);
        if (b && this.cSymbolChoice.getSelectionIndex() == 0) {
            this.cSymPosChoice.setEnabled(false);
        }
        this.cNegNumChoice.setEnabled(b);
        this.fPlacesChoice.setEnabled(b);
        this.fUseSep.setEnabled(b);
        this.fNegNumChoice.setEnabled(b);
        this.pPlacesChoice.setEnabled(b);
        this.pUseSep.setEnabled(b);
        this.pSymPosChoice.setEnabled(b);
        this.pNegNumChoice.setEnabled(b);
        this.sPlacesChoice.setEnabled(b);
        this.formatCodeBox.setEnabled(b);
        this.previewTextBox.setEnabled(b);
        this.table.setEnabled(b);
    }

    public ULocale getLocale() {
        return this.getLocaleByDisplayName(this.locale);
    }
}

