/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ResourceEditDialog;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectionChoiceDialog
extends BaseDialog {
    private Text labelEditor;
    private Text valueEditor;
    private SelectionChoice selectionChoice;
    private CLabel messageLine;
    private ISelectionChoiceValidator validator;
    private Text resourceText;

    public SelectionChoiceDialog(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    public SelectionChoiceDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    protected boolean initDialog() {
        Assert.isNotNull((Object)this.selectionChoice);
        this.labelEditor.setText(UIUtil.convertToGUIString(this.selectionChoice.getLabel()));
        this.valueEditor.setText(UIUtil.convertToGUIString(this.selectionChoice.getValue()));
        this.resourceText.setText(UIUtil.convertToGUIString(this.selectionChoice.getLabelResourceKey()));
        if (this.validator != null) {
            this.updateStatus();
        }
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        String[] labels = new String[]{Messages.getString((String)"ParameterDialog.SelectionDialog.Label.DisplayTextKey"), Messages.getString((String)"ParameterDialog.SelectionDialog.Label.DisplayText"), Messages.getString((String)"ParameterDialog.SelectionDialog.Label.Value")};
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        composite.setLayout((Layout)layout);
        new Label(composite, 0).setText(labels[0]);
        this.resourceText = new Text(composite, 2048);
        GridData gd = new GridData(768);
        gd.minimumWidth = 200;
        this.resourceText.setLayoutData((Object)gd);
        this.resourceText.setEditable(false);
        Button resourceBtn = new Button(composite, 8);
        resourceBtn.setText(Messages.getString((String)"ParameterDialog.SelectionDialog.Button.Resource"));
        resourceBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionChoiceDialog.this.handleBrowserSelectedEvent();
            }
        });
        resourceBtn.setEnabled(this.enableResourceKey());
        new Label(composite, 0).setText(labels[1]);
        this.labelEditor = new Text(composite, 2048);
        gd = new GridData(768);
        gd.minimumWidth = 200;
        this.labelEditor.setLayoutData((Object)gd);
        new Label(composite, 0);
        new Label(composite, 0).setText(labels[2]);
        this.valueEditor = new Text(composite, 2048);
        this.valueEditor.setLayoutData((Object)gd);
        this.valueEditor.setFocus();
        new Label(composite, 0);
        Composite noteContainer = new Composite(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.widthHint = UIUtil.getMaxStringWidth(labels, (Control)composite) + 200 + layout.horizontalSpacing * 2 + resourceBtn.computeSize((int)-1, (int)-1).x;
        noteContainer.setLayoutData((Object)gd);
        layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        noteContainer.setLayout((Layout)layout);
        Label note = new Label(noteContainer, 64);
        note.setText(Messages.getString((String)"ParameterDialog.SelectionDialog.Label.Note"));
        gd = new GridData(768);
        gd.minimumWidth = UIUtil.getMaxStringWidth(labels, (Control)composite) + 200 + layout.horizontalSpacing * 2 + resourceBtn.computeSize((int)-1, (int)-1).x;
        note.setLayoutData((Object)gd);
        this.messageLine = new CLabel(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.messageLine.setLayoutData((Object)gd);
        if (this.validator != null) {
            ModifyListener listener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SelectionChoiceDialog.this.updateStatus();
                }
            };
            this.labelEditor.addModifyListener(listener);
            this.valueEditor.addModifyListener(listener);
        }
        UIUtil.bindHelp((Control)composite, "org.eclipse.birt.cshelp.SelectionChoiceDialog_ID");
        return composite;
    }

    protected void okPressed() {
        this.selectionChoice.setLabel(UIUtil.convertToModelString(this.labelEditor.getText(), false));
        this.selectionChoice.setValue(UIUtil.convertToModelString(this.valueEditor.getText(), false));
        this.selectionChoice.setLabelResourceKey(UIUtil.convertToModelString(this.resourceText.getText(), false));
        this.setResult(this.selectionChoice);
        super.okPressed();
    }

    private void updateStatus() {
        String erroeMessage = this.validator.validate(UIUtil.convertToModelString(this.resourceText.getText(), false), UIUtil.convertToModelString(this.labelEditor.getText(), false), UIUtil.convertToModelString(this.valueEditor.getText(), false));
        if (erroeMessage != null) {
            this.messageLine.setText(erroeMessage);
            this.messageLine.setImage(ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK"));
            this.getOkButton().setEnabled(false);
        } else {
            this.messageLine.setText("");
            this.messageLine.setImage(null);
            this.getOkButton().setEnabled(true);
        }
    }

    public void setInput(SelectionChoice selectionChoice) {
        this.selectionChoice = selectionChoice;
    }

    public void setValidator(ISelectionChoiceValidator validator) {
        this.validator = validator;
    }

    private String getBaseName() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResource();
    }

    private URL getResourceURL() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(this.getBaseName(), 5);
    }

    private boolean enableResourceKey() {
        URL resource = this.getResourceURL();
        String path = null;
        try {
            if (resource != null) {
                path = DEUtil.getFilePathFormURL((URL)resource);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return resource != null && path != null && new File(path).exists();
    }

    protected void handleBrowserSelectedEvent() {
        ResourceEditDialog dlg = new ResourceEditDialog(this.getShell(), Messages.getString((String)"ResourceKeyDescriptor.title.SelectKey"));
        dlg.setResourceURL(this.getResourceURL());
        if (dlg.open() == 0) {
            this.handleSelectedEvent((String[])dlg.getDetailResult());
        }
    }

    private void handleSelectedEvent(String[] values) {
        if (values.length == 2) {
            if (values[0] != null) {
                this.resourceText.setText(values[0]);
            }
            if (values[1] != null) {
                this.labelEditor.setText(values[1]);
            }
        }
    }

    public static interface ISelectionChoiceValidator {
        public String validate(String var1, String var2, String var3);
    }
}

