/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class TableOptionDialog
extends BaseDialog {
    private static final String MSG_DATA_SET = Messages.getString((String)"TableOptionDialog.text.DataSet");
    private static final String MSG_REMEMBER_DIMENSIONS_FOR_NEW_GRIDS = Messages.getString((String)"TableOptionDialog.message.RememberGrid");
    private static final String MSG_REMEMBER_DIMENSIONS_FOR_NEW_TABLES = Messages.getString((String)"TableOptionDialog.message.RememberTable");
    private static final String MSG_NUMBER_OF_GRID_ROWS = Messages.getString((String)"TableOptionDialog.text.GridRow");
    private static final String MSG_NUMBER_OF_TABLE_ROWS = Messages.getString((String)"TableOptionDialog.text.TableDetail");
    private static final String MSG_NUMBER_OF_COLUMNS = Messages.getString((String)"TableOptionDialog.text.Column");
    private static final String MSG_GRID_SIZE = Messages.getString((String)"TableOptionDialog.text.GridSize");
    private static final String MSG_TABLE_SIZE = Messages.getString((String)"TableOptionDialog.text.TableSize");
    private static final String MSG_INSERT_GRID = Messages.getString((String)"TableOptionDialog.title.InsertGrid");
    private static final String MSG_INSERT_TABLE = Messages.getString((String)"TableOptionDialog.title.InsertTable");
    private static final String NONE = Messages.getString((String)"BindingPage.None");
    private static final int DEFAULT_TABLE_ROW_COUNT = 1;
    private static final int DEFAULT_ROW_COUNT = 3;
    private static final int DEFAULT_COLUMN_COUNT = 3;
    public static final String DEFAULT_TABLE_ROW_COUNT_KEY = "Default table row count";
    public static final String DEFAULT_TABLE_COLUMN_COUNT_KEY = "Default table column count";
    public static final String DEFAULT_GRID_ROW_COUNT_KEY = "Default grid row count";
    public static final String DEFAULT_GRID_COLUMN_COUNT_KEY = "Default grid column count";
    private Spinner rowEditor;
    private Spinner columnEditor;
    private Button chkbox;
    private int rowCount;
    private int columnCount;
    private boolean insertTable = true;
    private Combo dataSetCombo;

    public TableOptionDialog(Shell parentShell, boolean insertTable) {
        super(parentShell, insertTable ? MSG_INSERT_TABLE : MSG_INSERT_GRID);
        this.insertTable = insertTable;
    }

    private void loadPreference() {
        if (this.insertTable) {
            this.columnCount = ReportPlugin.getDefault().getPreferenceStore().getInt(DEFAULT_TABLE_COLUMN_COUNT_KEY);
            this.rowCount = ReportPlugin.getDefault().getPreferenceStore().getInt(DEFAULT_TABLE_ROW_COUNT_KEY);
        } else {
            this.columnCount = ReportPlugin.getDefault().getPreferenceStore().getInt(DEFAULT_GRID_COLUMN_COUNT_KEY);
            this.rowCount = ReportPlugin.getDefault().getPreferenceStore().getInt(DEFAULT_GRID_ROW_COUNT_KEY);
        }
        if (this.columnCount <= 0) {
            this.columnCount = 3;
        }
        if (this.rowCount <= 0) {
            this.rowCount = this.insertTable ? 1 : 3;
        }
    }

    private void savePreference() {
        if (this.insertTable) {
            ReportPlugin.getDefault().getPreferenceStore().setValue(DEFAULT_TABLE_COLUMN_COUNT_KEY, this.columnCount);
            ReportPlugin.getDefault().getPreferenceStore().setValue(DEFAULT_TABLE_ROW_COUNT_KEY, this.rowCount);
        } else {
            ReportPlugin.getDefault().getPreferenceStore().setValue(DEFAULT_GRID_COLUMN_COUNT_KEY, this.columnCount);
            ReportPlugin.getDefault().getPreferenceStore().setValue(DEFAULT_GRID_ROW_COUNT_KEY, this.rowCount);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.loadPreference();
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        new Label(composite, 0).setText(this.insertTable ? MSG_TABLE_SIZE : MSG_GRID_SIZE);
        Label sp = new Label(composite, 258);
        sp.setLayoutData((Object)new GridData(768));
        Composite innerPane = new Composite(composite, 0);
        GridData gdata = new GridData(1808);
        gdata.horizontalSpan = 2;
        innerPane.setLayoutData((Object)gdata);
        GridLayout glayout = new GridLayout(2, false);
        glayout.marginWidth = 10;
        innerPane.setLayout((Layout)glayout);
        new Label(innerPane, 0).setText(MSG_NUMBER_OF_COLUMNS);
        this.columnEditor = new Spinner(innerPane, 2048);
        this.columnEditor.setMinimum(1);
        this.columnEditor.setMaximum(Integer.MAX_VALUE);
        this.columnEditor.setIncrement(1);
        this.columnEditor.setSelection(this.columnCount);
        this.columnEditor.setLayoutData((Object)new GridData(768));
        new Label(innerPane, 0).setText(this.insertTable ? MSG_NUMBER_OF_TABLE_ROWS : MSG_NUMBER_OF_GRID_ROWS);
        this.rowEditor = new Spinner(innerPane, 2048);
        this.rowEditor.setMinimum(1);
        this.rowEditor.setMaximum(Integer.MAX_VALUE);
        this.rowEditor.setIncrement(1);
        this.rowEditor.setSelection(this.rowCount);
        this.rowEditor.setLayoutData((Object)new GridData(768));
        if (this.insertTable) {
            new Label(innerPane, 0).setText(MSG_DATA_SET);
            this.dataSetCombo = new Combo(innerPane, 2060);
            this.dataSetCombo.setLayoutData((Object)new GridData(768));
            String[] dataSets = ChoiceSetFactory.getDataSets();
            String[] newList = new String[dataSets.length + 1];
            System.arraycopy(dataSets, 0, newList, 1, dataSets.length);
            newList[0] = NONE;
            this.dataSetCombo.setItems(newList);
            this.dataSetCombo.select(0);
        } else {
            Label lb = new Label(composite, 0);
            gdata = new GridData(768);
            gdata.horizontalSpan = 2;
            lb.setLayoutData((Object)gdata);
        }
        this.chkbox = new Button(composite, 32);
        this.chkbox.setText(this.insertTable ? MSG_REMEMBER_DIMENSIONS_FOR_NEW_TABLES : MSG_REMEMBER_DIMENSIONS_FOR_NEW_GRIDS);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.chkbox.setLayoutData((Object)gdata);
        if (this.insertTable) {
            UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.TableOptionDialog_ID");
        } else {
            UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.GridOptionDialog_ID");
        }
        return composite;
    }

    protected void okPressed() {
        this.rowCount = this.rowEditor.getSelection();
        this.columnCount = this.columnEditor.getSelection();
        if (this.columnCount <= 0) {
            this.columnCount = 3;
        }
        if (this.rowCount <= 0) {
            int n = this.rowCount = this.insertTable ? 1 : 3;
        }
        if (this.insertTable) {
            this.setResult(new Object[]{this.rowCount, this.columnCount, this.dataSetCombo.getItem(this.dataSetCombo.getSelectionIndex())});
        } else {
            this.setResult(new Object[]{this.rowCount, this.columnCount});
        }
        if (this.chkbox.getSelection()) {
            this.savePreference();
        }
        super.okPressed();
    }
}

