/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.helper;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.AbstractDialogHelper;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterDialog;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DefaultParameterDialogControlTypeHelper
extends AbstractDialogHelper {
    protected static final IChoiceSet CONTROL_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getChoiceSet("paramControl");
    protected Combo dataTypeChooser;

    public void createContent(Composite parent) {
        this.dataTypeChooser = new Combo(parent, 12);
        this.dataTypeChooser.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                List listeners = (List)DefaultParameterDialogControlTypeHelper.this.listeners.get(13);
                if (listeners == null) {
                    return;
                }
                int i = 0;
                while (i < listeners.size()) {
                    ((Listener)listeners.get(i)).handleEvent(e);
                    ++i;
                }
            }
        });
    }

    public Control getControl() {
        return this.dataTypeChooser;
    }

    protected boolean isStatic() {
        return (Boolean)this.getProperty("static");
    }

    protected String getDataType() {
        return (String)this.getProperty("datatype");
    }

    protected String getInputControlType() {
        return (String)this.getProperty("controltypeinput");
    }

    public void update(boolean inward) {
        if (inward) {
            this.inwardUpdate();
        } else {
            this.outwardUpdate();
        }
    }

    protected void outwardUpdate() {
        String displayText = this.dataTypeChooser.getText();
        if (StringUtil.isBlank((String)displayText)) {
            return;
        }
        if (ParameterDialog.DISPLAY_NAME_CONTROL_COMBO.equals(displayText)) {
            this.setProperty("controltype", "list-box/Combo");
            return;
        }
        if (ParameterDialog.DISPLAY_NAME_CONTROL_LIST.equals(displayText)) {
            this.setProperty("controltype", "list-box/List");
            return;
        }
        this.setProperty("controltype", CONTROL_TYPE_CHOICE_SET.findChoiceByDisplayName(displayText).getName());
    }

    protected void inwardUpdate() {
        String[] choices = this.isStatic() ? ("boolean".equals(this.getDataType()) ? new String[3] : new String[4]) : new String[2];
        if (this.dataTypeChooser.getItemCount() != choices.length) {
            String originalSelection = this.dataTypeChooser.getText();
            if (this.isStatic()) {
                if ("boolean".equals(this.getDataType())) {
                    choices[0] = CONTROL_TYPE_CHOICE_SET.findChoice("check-box").getDisplayName();
                    choices[1] = ParameterDialog.DISPLAY_NAME_CONTROL_COMBO;
                } else {
                    choices[0] = CONTROL_TYPE_CHOICE_SET.findChoice("text-box").getDisplayName();
                    choices[1] = ParameterDialog.DISPLAY_NAME_CONTROL_COMBO;
                    choices[2] = ParameterDialog.DISPLAY_NAME_CONTROL_LIST;
                }
                choices[choices.length - 1] = CONTROL_TYPE_CHOICE_SET.findChoice("radio-button").getDisplayName();
            } else {
                choices[0] = ParameterDialog.DISPLAY_NAME_CONTROL_COMBO;
                choices[1] = ParameterDialog.DISPLAY_NAME_CONTROL_LIST;
            }
            this.dataTypeChooser.setItems(choices);
            if (originalSelection.length() == 0) {
                this.dataTypeChooser.setText(this.getInputControlDisplayName());
            } else {
                int index = this.dataTypeChooser.indexOf(originalSelection);
                if (index == -1) {
                    this.dataTypeChooser.select(0);
                    this.dataTypeChooser.notifyListeners(13, new Event());
                }
                this.dataTypeChooser.setText(originalSelection);
            }
        }
    }

    protected String getInputControlDisplayName() {
        String type = this.getInputControlType();
        String displayName = null;
        if (CONTROL_TYPE_CHOICE_SET.findChoice(type) != null) {
            displayName = CONTROL_TYPE_CHOICE_SET.findChoice(type).getDisplayName();
        } else if ("list-box/Combo".equals(type)) {
            displayName = ParameterDialog.DISPLAY_NAME_CONTROL_COMBO;
        } else if ("list-box/List".equals(type)) {
            displayName = ParameterDialog.DISPLAY_NAME_CONTROL_LIST;
        }
        return displayName;
    }
}

