/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.rulers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRuler;

public class EditorGuide {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final String PROPERTY_CHILDREN = "subparts changed";
    public static final String PROPERTY_POSITION = "position changed";
    static final long serialVersionUID = 1L;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Map map;
    private int position;
    private boolean horizontal;
    private int direction;

    public EditorGuide(boolean isHorizontal, int direction) {
        this.setHorizontal(isHorizontal);
        this.setDirection(direction);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public int getAlignment(EditorRuler part) {
        if (this.getMap().get(part) != null) {
            return (Integer)this.getMap().get(part);
        }
        return -2;
    }

    public Map getMap() {
        if (this.map == null) {
            this.map = new Hashtable();
        }
        return this.map;
    }

    public Set getParts() {
        return this.getMap().keySet();
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void setHorizontal(boolean isHorizontal) {
        this.horizontal = isHorizontal;
    }

    public void setPosition(int offset) {
        if (this.position != offset) {
            int oldValue = this.position;
            this.position = offset;
            this.listeners.firePropertyChange(PROPERTY_POSITION, (Object)oldValue, (Object)this.position);
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public String getPropertyName() {
        if (this.getDirection() == 0 && !this.isHorizontal()) {
            return "leftMargin";
        }
        if (this.getDirection() == 1 && !this.isHorizontal()) {
            return "rightMargin";
        }
        if (this.getDirection() == 0 && this.isHorizontal()) {
            return "topMargin";
        }
        if (this.getDirection() == 1 && this.isHorizontal()) {
            return "bottomMargin";
        }
        return null;
    }
}

