/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.LineBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.ReportDesignMarginBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractReportEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.MasterPageEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.AbstractPageFlowLayout;
import org.eclipse.birt.report.designer.internal.ui.layout.MasterPageLayout;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.swt.widgets.Display;

public class MasterPageEditPart
extends AbstractReportEditPart {
    private static final Point PRIVATE_POINT = new Point();
    private static final Insets DEFAULT_CROP = new Insets(-3, -3, -2, -2);
    private List children = new ArrayList();

    public MasterPageEditPart(Object model) {
        super(model);
    }

    public void elementChanged(DesignElementHandle element, NotificationEvent ev) {
        switch (ev.getEventType()) {
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 15: 
            case 17: {
                this.markDirty(true);
                this.refresh();
                Iterator it = this.getChildren().iterator();
                while (it.hasNext()) {
                    ((AbstractEditPart)it.next()).refresh();
                }
                break;
            }
        }
    }

    public void activate() {
        super.activate();
        this.getFigure().setFocusTraversable(false);
        if (this.getModel() instanceof ReportDesignHandle) {
            this.getViewer().setProperty("bidiLayoutOrientation", (Object)((ReportDesignHandle)this.getModel()).getBidiOrientation());
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new MasterPageEditPolicy());
    }

    protected IFigure createFigure() {
        ReportElementFigure figure = new ReportElementFigure(){

            protected void paintFigure(Graphics graphics) {
                graphics.fillRectangle(this.getBounds());
                super.paintFigure(graphics);
                graphics.setForegroundColor(ReportColorConstants.ReportForeground);
                graphics.drawRectangle(this.getBounds().getCopy().crop(new Insets(0, 0, 1, 1)));
            }

            protected void paintChildren(Graphics graphics) {
                int i = 0;
                while (i < this.getChildren().size()) {
                    IFigure child = (IFigure)this.getChildren().get(i);
                    if (child.isVisible()) {
                        graphics.setClip(this.getBounds().getCopy().intersect(child.getBounds()));
                        child.paint(graphics);
                        graphics.restoreState();
                    }
                    ++i;
                }
            }

            protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
                PRIVATE_POINT.setLocation(x, y);
                this.translateFromParent((Translatable)PRIVATE_POINT);
                if (!this.getBounds().contains(PRIVATE_POINT)) {
                    return null;
                }
                int i = this.getChildren().size();
                while (i > 0) {
                    IFigure fig = (IFigure)this.getChildren().get(--i);
                    if (!fig.isVisible() || (fig = fig.findFigureAt(PRIVATE_POINT.x, PRIVATE_POINT.y, search)) == null) continue;
                    return fig;
                }
                return null;
            }
        };
        figure.setOpaque(true);
        MasterPageLayout layout = new MasterPageLayout((GraphicalEditPart)this);
        MasterPageHandle masterPageHandle = (MasterPageHandle)this.getModel();
        Dimension size = this.getMasterPageSize((DesignElementHandle)masterPageHandle);
        Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
        layout.setInitSize(bounds);
        figure.setLayoutManager((LayoutManager)layout);
        figure.setBorder((Border)new ReportDesignMarginBorder(this.getMasterPageInsets((DesignElementHandle)((MasterPageHandle)this.getModel()))));
        figure.setBounds(bounds.getCopy());
        return figure;
    }

    public void refreshChildren() {
        super.refreshChildren();
        List list = this.getChildren();
        int size = list.size();
        int i = 0;
        while (i < size) {
            ((ReportElementEditPart)((Object)list.get(i))).refreshChildren();
            ++i;
        }
    }

    public void refreshFigure() {
        int color = this.getBackgroundColor((DesignElementHandle)((MasterPageHandle)this.getModel()));
        this.getFigure().setBackgroundColor(this.getBackGroundColor(color));
        Dimension size = this.getMasterPageSize((DesignElementHandle)((MasterPageHandle)this.getModel()));
        Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
        ((AbstractPageFlowLayout)this.getFigure().getLayoutManager()).setInitSize(bounds);
        ReportDesignMarginBorder reportDesignMarginBorder = new ReportDesignMarginBorder(this.getMasterPageInsets((DesignElementHandle)((MasterPageHandle)this.getModel())));
        reportDesignMarginBorder.setBackgroundColor(((MasterPageHandle)this.getModel()).getPropertyHandle("backgroundColor").getIntValue());
        this.refreshMarginBorder(reportDesignMarginBorder);
        this.refreshBackground((DesignElementHandle)((MasterPageHandle)this.getModel()));
    }

    public void refreshMarginBorder(ReportDesignMarginBorder border) {
        this.refreshBorder((DesignElementHandle)((MasterPageHandle)this.getModel()), border);
        Insets pist = this.getPadding(null);
        ((LineBorder)this.getFigure().getBorder()).setPaddingInsets(pist);
    }

    private Insets getPadding(Insets retValue) {
        return DEUtil.getPadding((DesignElementHandle)((MasterPageHandle)this.getModel()), (Insets)retValue);
    }

    protected List getModelChildren() {
        SlotHandle model = ((SimpleMasterPageHandle)this.getModel()).getPageHeader();
        if (!this.children.contains(model)) {
            this.children.add(model);
        }
        if (!this.children.contains(model = ((SimpleMasterPageHandle)this.getModel()).getPageFooter())) {
            this.children.add(model);
        }
        return this.children;
    }

    public boolean isinterest(Object model) {
        return super.isinterest(model) || model instanceof ModuleHandle;
    }

    protected void propertyChange(Map info) {
        boolean invalidate = false;
        if (info.get("bidiLayoutOrientation") instanceof ReportDesignHandle) {
            String newOrientation = ((ReportDesignHandle)info.get("bidiLayoutOrientation")).getBidiOrientation();
            UIUtil.processOrientationChange(newOrientation, this.getViewer());
            invalidate = true;
        }
        super.propertyChange(info);
        if (info.get("width") instanceof MasterPageHandle || info.get("height") instanceof MasterPageHandle) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    List list = MasterPageEditPart.this.getChildren();
                    int size = list.size();
                    int i = 0;
                    while (i < size) {
                        ((ReportElementEditPart)((Object)list.get(i))).refreshVisuals();
                        ++i;
                    }
                }
            });
        }
        if (invalidate) {
            this.getFigure().invalidateTree();
            this.getFigure().revalidate();
        }
    }
}

