/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.LineBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.ReportDesignMarginBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractReportEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportContainerEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportFlowLayoutEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportRootFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.RootDragTracker;
import org.eclipse.birt.report.designer.internal.ui.layout.AbstractPageFlowLayout;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportDesignLayout;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DeselectAllTracker;

public class ReportDesignEditPart
extends AbstractReportEditPart {
    protected boolean showMargin = true;

    public ReportDesignEditPart(Object obj) {
        super(obj);
    }

    protected IFigure createFigure() {
        ReportRootFigure figure = new ReportRootFigure();
        figure.setOpaque(true);
        figure.setShowMargin(this.showMargin);
        ReportDesignLayout layout = new ReportDesignLayout((GraphicalEditPart)this);
        SimpleMasterPageHandle masterPageHandle = this.getSimpleMasterPageHandle();
        Dimension size = this.getMasterPageSize((DesignElementHandle)masterPageHandle);
        Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
        layout.setInitSize(bounds);
        figure.setLayoutManager((LayoutManager)layout);
        figure.setBorder((Border)new ReportDesignMarginBorder(this.getMasterPageInsets((DesignElementHandle)masterPageHandle)));
        figure.setBounds(bounds.getCopy());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ReportFlowLayoutEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ReportContainerEditPolicy());
    }

    protected List getModelChildren() {
        return HandleAdapterFactory.getInstance().getReportDesignHandleAdapter(this.getModel()).getChildren();
    }

    public DragTracker getDragTracker(Request req) {
        if (req instanceof SelectionRequest && ((SelectionRequest)req).getLastButtonPressed() == 3) {
            return new DeselectAllTracker((EditPart)this);
        }
        return new RootDragTracker();
    }

    public void refreshFigure() {
        SimpleMasterPageHandle masterPageHandle = this.getSimpleMasterPageHandle();
        Dimension size = this.getMasterPageSize((DesignElementHandle)masterPageHandle);
        Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
        ReportRootFigure figure = (ReportRootFigure)this.getFigure();
        figure.setShowMargin(this.showMargin);
        ((ReportDesignLayout)figure.getLayoutManager()).setAuto("auto layout".equals(((ReportDesignHandle)this.getModel()).getLayoutPreference()));
        ((ReportDesignLayout)figure.getLayoutManager()).setAuto("ltr".equals(((ReportDesignHandle)this.getModel()).getBidiOrientation()));
        if (!this.showMargin) {
            Insets mg = this.getMasterPageInsets((DesignElementHandle)masterPageHandle);
            bounds.width -= mg.getWidth();
            bounds.height -= mg.getHeight();
        }
        Insets initInsets = this.getMasterPageInsets((DesignElementHandle)masterPageHandle);
        ((AbstractPageFlowLayout)this.getFigure().getLayoutManager()).setInitSize(bounds);
        ((AbstractPageFlowLayout)this.getFigure().getLayoutManager()).setInitInsets(initInsets);
        this.refreshMarginBorder((ReportDesignMarginBorder)this.getFigure().getBorder());
        int color = this.getBackgroundColor((DesignElementHandle)masterPageHandle);
        this.getFigure().setBackgroundColor(this.getBackGroundColor(color));
        this.refreshBackground((DesignElementHandle)masterPageHandle);
    }

    public void refreshMarginBorder(ReportDesignMarginBorder border) {
        this.refreshBorder((DesignElementHandle)this.getSimpleMasterPageHandle(), border);
        Insets pist = this.getPadding((MasterPageHandle)this.getSimpleMasterPageHandle(), null);
        ((LineBorder)this.getFigure().getBorder()).setPaddingInsets(pist);
    }

    private SimpleMasterPageHandle getSimpleMasterPageHandle() {
        SlotHandle slotHandle = ((ModuleHandle)this.getModel()).getMasterPages();
        Iterator iter = slotHandle.iterator();
        SimpleMasterPageHandle masterPageHandle = (SimpleMasterPageHandle)iter.next();
        return masterPageHandle;
    }

    public void activate() {
        super.activate();
        this.getViewer().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("Property Margin Visibility".equals(evt.getPropertyName())) {
                    ReportDesignEditPart.this.showMargin = (Boolean)evt.getNewValue();
                    ReportDesignEditPart.this.refresh();
                    ReportDesignEditPart.this.markDirty(true);
                }
            }
        });
        if (this.getModel() instanceof ReportDesignHandle) {
            this.getViewer().setProperty("layout", (Object)((ReportDesignHandle)this.getModel()).getLayoutPreference());
            this.getViewer().setProperty("bidiLayoutOrientation", (Object)((ReportDesignHandle)this.getModel()).getBidiOrientation());
        }
    }

    public boolean isinterest(Object model) {
        return super.isinterest(model) || model instanceof MasterPageHandle;
    }

    protected void propertyChange(Map info) {
        boolean invalidate = false;
        if (info.get("bidiLayoutOrientation") instanceof ReportDesignHandle) {
            String newOrientation = ((ReportDesignHandle)info.get("bidiLayoutOrientation")).getBidiOrientation();
            UIUtil.processOrientationChange(newOrientation, this.getViewer());
            invalidate = true;
        }
        super.propertyChange(info);
        if (info.get("layoutPreference") != null && info.get("layoutPreference") instanceof ReportDesignHandle) {
            this.getViewer().setProperty("layout", (Object)((ReportDesignHandle)info.get("layoutPreference")).getLayoutPreference());
        }
        if (invalidate) {
            this.getFigure().invalidateTree();
            this.getFigure().revalidate();
        }
        if (this.getModel() instanceof ReportDesignHandle && (info.get("topMargin") != null || info.get("bottomMargin") != null || info.get("leftMargin") != null || info.get("rightMargin") != null || info.get("type") != null || info.get("width") != null || info.get("height") != null || info.get("orientation") != null)) {
            SlotHandle slotHandle = ((ModuleHandle)this.getModel()).getMasterPages();
            Iterator iter = slotHandle.iterator();
            SimpleMasterPageHandle masterPageHandle = (SimpleMasterPageHandle)iter.next();
            Dimension size = this.getMasterPageSize((DesignElementHandle)masterPageHandle);
            Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
            ((AbstractPageFlowLayout)this.getFigure().getLayoutManager()).setInitSize(bounds);
            this.refreshMarginBorder(new ReportDesignMarginBorder(this.getMasterPageInsets((DesignElementHandle)masterPageHandle)));
            this.figure.setBounds(bounds.getCopy());
        }
    }

    private Insets getPadding(MasterPageHandle handle, Insets retValue) {
        return DEUtil.getPadding((DesignElementHandle)handle, (Insets)retValue);
    }
}

