/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.data.ui.util.SelectValueFetcher;
import org.eclipse.birt.report.designer.internal.ui.dialogs.PreviewLabel;
import org.eclipse.birt.report.designer.internal.ui.extension.IUseCubeQueryList;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.MultiValueCombo;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ValueCombo;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionValue;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.HighlightHandleProvider;
import org.eclipse.birt.report.designer.ui.widget.ColorBuilder;
import org.eclipse.birt.report.designer.ui.widget.FontSizeBuilder;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class HighlightRuleBuilder
extends TitleAreaDialog {
    private final String NULL_STRING;
    protected IExpressionProvider expressionProvider;
    protected transient String bindingName = null;
    protected ReportElementHandle currentItem = null;
    protected String[] popupItems = null;
    protected static final String[] EMPTY_ARRAY = new String[0];
    private static final String NONE_DISPLAY_TEXT = Messages.getString((String)"HighlightRuleBuilderDialog.displayText.None");
    protected static String[] actions = new String[]{Messages.getString((String)"ExpressionValueCellEditor.selectValueAction"), Messages.getString((String)"ExpressionValueCellEditor.buildExpressionAction")};
    protected ParamBindingHandle[] bindingParams = null;
    public static final int EXPRESSION_CONTROL_COMBO = 0;
    public static final int EXPRESSION_CONTROL_TEXT = 1;
    private int exprControlType;
    protected String dlgDescription = "";
    protected String dlgTitle = "";
    protected Logger logger = Logger.getLogger(HighlightRuleBuilder.class.getName());
    public static final String[][] OPERATOR;
    protected List columnList;
    private static final String[] EMPTY;
    protected List valueList = new ArrayList();
    private HighlightRuleHandle handle;
    private HighlightHandleProvider provider;
    private int handleCount;
    protected Combo expressionCombo;
    protected Combo stylesChooser;
    protected Text expressionText;
    private Combo operator;
    protected Composite valueListComposite;
    protected MultiValueCombo addExpressionValue;
    protected Button addBtn;
    protected Button editBtn;
    protected Button delBtn;
    protected Button delAllBtn;
    protected Table table;
    protected TableViewer tableViewer;
    protected int valueVisible;
    protected List compositeList = new ArrayList();
    private ValueCombo expressionValue1;
    private ValueCombo expressionValue2;
    private Label andLable;
    private Combo font;
    private FontSizeBuilder size;
    private ColorBuilder color;
    private ColorBuilder backColor;
    private Button bold;
    private Button italic;
    private Button underline;
    private Button linethrough;
    private PreviewLabel previewLabel;
    protected DesignElementHandle designHandle;
    private boolean isBoldChanged;
    private boolean isItalicChanged;
    private boolean isUnderlineChanged;
    private boolean isLinethroughChanged;
    private static final String DEFAULT_CHOICE;
    private static final String[] SYSTEM_FONT_LIST;
    protected static final String VALUE_OF_THIS_DATA_ITEM;
    private Map styles = new HashMap();
    protected SelectionListener expSelListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (HighlightRuleBuilder.this.getExpression().equals(VALUE_OF_THIS_DATA_ITEM) && HighlightRuleBuilder.this.designHandle instanceof DataItemHandle) {
                if (HighlightRuleBuilder.this.designHandle.getContainer() instanceof ExtendedItemHandle) {
                    HighlightRuleBuilder.this.setExpression(DEUtil.getDataExpression((String)((DataItemHandle)HighlightRuleBuilder.this.designHandle).getResultSetColumn()));
                } else {
                    HighlightRuleBuilder.this.setExpression(DEUtil.getColumnExpression((String)((DataItemHandle)HighlightRuleBuilder.this.designHandle).getResultSetColumn()));
                }
            } else {
                String newValue = HighlightRuleBuilder.this.getExpression();
                String value = DEUtil.getExpression((Object)HighlightRuleBuilder.this.getResultSetColumn(newValue));
                if (value != null) {
                    newValue = value;
                }
                HighlightRuleBuilder.this.setExpression(newValue);
            }
            HighlightRuleBuilder.this.updateButtons();
        }
    };
    private Listener textModifyListener = new Listener(){

        public void handleEvent(Event event) {
            HighlightRuleBuilder.this.updateButtons();
        }
    };
    protected ITableLabelProvider tableLableProvier = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof Expression) {
                    return ((Expression)element).getStringExpression();
                }
                return element.toString();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    protected IStructuredContentProvider tableContentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }
    };
    protected ValueCombo.ISelection expValueAction = new ValueCombo.ISelection(){

        public String doSelection(String input) {
            String retValue = null;
            ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), input);
            if (HighlightRuleBuilder.this.expressionProvider == null) {
                dialog.setExpressionProvier(new ExpressionProvider(HighlightRuleBuilder.this.designHandle));
            } else {
                dialog.setExpressionProvier(HighlightRuleBuilder.this.expressionProvider);
            }
            if (dialog.open() == 0) {
                retValue = dialog.getResult();
            }
            return retValue;
        }
    };
    protected ValueCombo.ISelection selectValueAction = new ValueCombo.ISelection(){

        public String doSelection(String input) {
            String retValue = null;
            Iterator iter = HighlightRuleBuilder.this.columnList.iterator();
            while (iter.hasNext()) {
                String columnName = ((ComputedColumnHandle)iter.next()).getName();
                if (HighlightRuleBuilder.this.getExpression().equals(VALUE_OF_THIS_DATA_ITEM) && HighlightRuleBuilder.this.designHandle instanceof DataItemHandle) {
                    if (HighlightRuleBuilder.this.designHandle.getContainer() instanceof ExtendedItemHandle) {
                        if (!DEUtil.getDataExpression((String)columnName).equals(HighlightRuleBuilder.this.getExpression())) continue;
                        HighlightRuleBuilder.this.bindingName = columnName;
                        break;
                    }
                    if (!DEUtil.getColumnExpression((String)columnName).equals(HighlightRuleBuilder.this.getExpression())) continue;
                    HighlightRuleBuilder.this.bindingName = columnName;
                    break;
                }
                String value = DEUtil.getExpression((Object)HighlightRuleBuilder.this.getResultSetColumn(columnName));
                if (value == null || !value.equals(HighlightRuleBuilder.this.getExpression())) continue;
                HighlightRuleBuilder.this.bindingName = columnName;
                break;
            }
            if (HighlightRuleBuilder.this.bindingName != null) {
                List selectValueList;
                block15: {
                    selectValueList = HighlightRuleBuilder.this.getSelectValueList();
                    if (selectValueList != null && selectValueList.size() != 0) break block15;
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
                    return null;
                }
                try {
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList(selectValueList);
                    if (HighlightRuleBuilder.this.bindingParams != null) {
                        dialog.setBindingParams(HighlightRuleBuilder.this.bindingParams);
                    }
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValue();
                    }
                }
                catch (Exception ex) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
                }
            } else if (HighlightRuleBuilder.this.designHandle instanceof TabularCubeHandle) {
                DataSetHandle dataSet = ((TabularCubeHandle)HighlightRuleBuilder.this.designHandle).getDataSet();
                String expressionString = HighlightRuleBuilder.this.getExpression();
                try {
                    List selectValueList = SelectValueFetcher.getSelectValueList(expressionString, dataSet);
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList(selectValueList);
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValue();
                    }
                }
                catch (BirtException e1) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + e1.getMessage()));
                }
            } else {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
            }
            return retValue;
        }
    };
    protected MultiValueCombo.ISelection mAddExpValueAction = new MultiValueCombo.ISelection(){

        public String[] doSelection(String input) {
            String[] retValue = null;
            Iterator iter = HighlightRuleBuilder.this.columnList.iterator();
            while (iter.hasNext()) {
                String columnName = ((ComputedColumnHandle)iter.next()).getName();
                if (!DEUtil.getColumnExpression((String)columnName).equals(HighlightRuleBuilder.this.getExpression())) continue;
                HighlightRuleBuilder.this.bindingName = columnName;
                break;
            }
            ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), input);
            if (HighlightRuleBuilder.this.expressionProvider == null) {
                dialog.setExpressionProvier(new ExpressionProvider(HighlightRuleBuilder.this.designHandle));
            } else {
                dialog.setExpressionProvier(HighlightRuleBuilder.this.expressionProvider);
            }
            if (dialog.open() == 0 && dialog.getResult().length() != 0) {
                retValue = new String[]{dialog.getResult()};
            }
            return retValue;
        }

        public void doAfterSelection(MultiValueCombo combo) {
            HighlightRuleBuilder.this.mAddSelValueAction.doAfterSelection(combo);
        }
    };
    protected MultiValueCombo.ISelection mAddSelValueAction = new MultiValueCombo.ISelection(){

        public String[] doSelection(String input) {
            String[] retValue = null;
            Iterator iter = HighlightRuleBuilder.this.columnList.iterator();
            while (iter.hasNext()) {
                String columnName = ((ComputedColumnHandle)iter.next()).getName();
                if (HighlightRuleBuilder.this.getExpression().equals(VALUE_OF_THIS_DATA_ITEM) && HighlightRuleBuilder.this.designHandle instanceof DataItemHandle) {
                    if (HighlightRuleBuilder.this.designHandle.getContainer() instanceof ExtendedItemHandle) {
                        if (!DEUtil.getDataExpression((String)columnName).equals(HighlightRuleBuilder.this.getExpression())) continue;
                        HighlightRuleBuilder.this.bindingName = columnName;
                        break;
                    }
                    if (!DEUtil.getColumnExpression((String)columnName).equals(HighlightRuleBuilder.this.getExpression())) continue;
                    HighlightRuleBuilder.this.bindingName = columnName;
                    break;
                }
                String value = DEUtil.getExpression((Object)HighlightRuleBuilder.this.getResultSetColumn(columnName));
                if (value == null || !value.equals(HighlightRuleBuilder.this.getExpression())) continue;
                HighlightRuleBuilder.this.bindingName = columnName;
                break;
            }
            if (HighlightRuleBuilder.this.bindingName != null) {
                try {
                    List selectValueList = HighlightRuleBuilder.this.getSelectValueList();
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList(selectValueList);
                    if (HighlightRuleBuilder.this.bindingParams != null) {
                        dialog.setBindingParams(HighlightRuleBuilder.this.bindingParams);
                    }
                    dialog.setMultipleSelection(true);
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValues();
                    }
                }
                catch (Exception ex) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
                }
            } else if (HighlightRuleBuilder.this.designHandle instanceof TabularCubeHandle) {
                DataSetHandle dataSet = ((TabularCubeHandle)HighlightRuleBuilder.this.designHandle).getDataSet();
                String expressionString = HighlightRuleBuilder.this.getExpression();
                try {
                    List selectValueList = SelectValueFetcher.getSelectValueList(expressionString, dataSet);
                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                    dialog.setSelectedValueList(selectValueList);
                    dialog.setMultipleSelection(true);
                    if (dialog.open() == 0) {
                        retValue = dialog.getSelectedExprValues();
                    }
                }
                catch (BirtException e1) {
                    MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + e1.getMessage()));
                }
            } else {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
            }
            return retValue;
        }

        public void doAfterSelection(MultiValueCombo combo) {
            HighlightRuleBuilder.this.addBtn.setEnabled(false);
            if (HighlightRuleBuilder.this.addExpressionValue.getSelStrings().length == 1) {
                HighlightRuleBuilder.this.addExpressionValue.setText(DEUtil.resolveNull((String)HighlightRuleBuilder.this.addExpressionValue.getSelStrings()[0]));
            } else if (HighlightRuleBuilder.this.addExpressionValue.getSelStrings().length > 1) {
                HighlightRuleBuilder.this.addExpressionValue.setText("");
            }
            boolean change = false;
            int i = 0;
            while (i < HighlightRuleBuilder.this.addExpressionValue.getSelStrings().length) {
                if (HighlightRuleBuilder.this.valueList.indexOf(DEUtil.resolveNull((String)HighlightRuleBuilder.this.addExpressionValue.getSelStrings()[i])) < 0) {
                    HighlightRuleBuilder.this.valueList.add(DEUtil.resolveNull((String)HighlightRuleBuilder.this.addExpressionValue.getSelStrings()[i]));
                    change = true;
                }
                ++i;
            }
            if (change) {
                HighlightRuleBuilder.this.tableViewer.refresh();
                HighlightRuleBuilder.this.updateButtons();
                HighlightRuleBuilder.this.addExpressionValue.setFocus();
            }
        }
    };

    static {
        EMPTY = new String[0];
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet("HighlightRule", "operator");
        IChoice[] chs = chset.getChoices((Comparator)new AlphabeticallyComparator());
        OPERATOR = new String[chs.length][2];
        int i = 0;
        while (i < chs.length) {
            HighlightRuleBuilder.OPERATOR[i][0] = chs[i].getDisplayName();
            HighlightRuleBuilder.OPERATOR[i][1] = chs[i].getName();
            ++i;
        }
        DEFAULT_CHOICE = Messages.getString((String)"HighlightRuleBuilderDialog.text.Default");
        SYSTEM_FONT_LIST = DEUtil.getSystemFontNames();
        VALUE_OF_THIS_DATA_ITEM = Messages.getString((String)"HighlightRuleBuilderDialog.choice.ValueOfThisDataItem");
    }

    public static String getValueForOperator(String name) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][0].equals(name)) {
                return OPERATOR[i][1];
            }
            ++i;
        }
        return null;
    }

    public static int determineValueVisible(String operatorValue) {
        if ("any".equals(operatorValue) || "is-false".equals(operatorValue) || "is-true".equals(operatorValue) || "is-null".equals(operatorValue) || "is-not-null".equals(operatorValue)) {
            return 0;
        }
        if ("lt".equals(operatorValue) || "le".equals(operatorValue) || "eq".equals(operatorValue) || "ne".equals(operatorValue) || "ge".equals(operatorValue) || "gt".equals(operatorValue) || "like".equals(operatorValue)) {
            return 1;
        }
        if ("between".equals(operatorValue) || "not-between".equals(operatorValue)) {
            return 2;
        }
        if ("in".equals(operatorValue) || "not-in".equals(operatorValue)) {
            return 3;
        }
        return 1;
    }

    public static String getNameForOperator(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return OPERATOR[i][0];
            }
            ++i;
        }
        return "";
    }

    public static int getIndexForOperatorValue(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public HighlightRuleBuilder(Shell parentShell, String title, HighlightHandleProvider provider) {
        super(parentShell);
        this.NULL_STRING = null;
        this.dlgTitle = title;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.provider = provider;
    }

    private String[] getDataSetColumns() {
        if (this.columnList.isEmpty()) {
            return EMPTY;
        }
        String[] values = new String[this.columnList.size()];
        int i = 0;
        while (i < this.columnList.size()) {
            values[i] = ((ComputedColumnHandle)this.columnList.get(i)).getName();
            ++i;
        }
        return values;
    }

    public void setReportElement(ReportElementHandle reportItem) {
        this.currentItem = reportItem;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.refreshList();
        Composite contents = new Composite(composite, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        Group condition = new Group(contents, 0);
        GridData gdata = new GridData(768);
        condition.setLayoutData((Object)gdata);
        GridLayout glayout = GridLayoutFactory.createFrom((GridLayout)new GridLayout()).spacing(5, 0).numColumns(4).equalWidth(false).create();
        condition.setLayout((Layout)glayout);
        condition.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Group.Condition"));
        gdata = new GridData();
        gdata.widthHint = 150;
        if (this.exprControlType == 0) {
            this.expressionCombo = new Combo((Composite)condition, 0);
            this.expressionCombo.setLayoutData((Object)gdata);
            this.expressionCombo.setItems(this.getDataSetColumns());
            this.fillExpression(this.expressionCombo);
            this.expressionCombo.addSelectionListener(this.expSelListener);
            this.expressionCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    HighlightRuleBuilder.this.updateButtons();
                }
            });
        } else {
            this.expressionText = new Text((Composite)condition, 2048);
            this.expressionText.setLayoutData((Object)gdata);
            if (this.handle != null) {
                this.expressionText.setText(this.handle.getTestExpression());
            }
            this.expressionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    HighlightRuleBuilder.this.updateButtons();
                }
            });
        }
        Button expBuilder = new Button((Composite)condition, 8);
        expBuilder.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.ExpBuilder"));
        expBuilder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.editValue(HighlightRuleBuilder.this.getExpressionControl());
            }
        });
        UIUtil.setExpressionButtonImage(expBuilder);
        this.operator = new Combo((Composite)condition, 8);
        int i = 0;
        while (i < OPERATOR.length) {
            this.operator.add(OPERATOR[i][0]);
            ++i;
        }
        this.operator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.update2ValueStatus();
                HighlightRuleBuilder.this.operator.getParent().layout(true, true);
                HighlightRuleBuilder.this.operator.getParent().setSize(HighlightRuleBuilder.this.operator.getParent().computeSize(-1, -1));
                if (HighlightRuleBuilder.this.operator.getShell() != null) {
                    HighlightRuleBuilder.this.operator.getShell().pack();
                }
            }
        });
        this.refreshList();
        this.create2ValueComposite((Composite)condition);
        this.createApplyStyleArea(contents);
        Label lb = new Label(contents, 258);
        lb.setLayoutData((Object)new GridData(768));
        if (this.handle != null) {
            this.syncViewProperties();
        } else {
            this.update2ValueStatus();
        }
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        parent.getShell().setText(this.dlgTitle);
        this.setTitle(Messages.getString((String)"HighlightRuleBuilderDialog.text.Title"));
        this.setMessage(this.dlgDescription);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.HighlightRuleBuilder_ID");
        this.updatePreview();
        this.updateButtons();
        return composite;
    }

    private void update2ValueStatus() {
        String value = HighlightRuleBuilder.getValueForOperator(this.operator.getText());
        this.valueVisible = HighlightRuleBuilder.determineValueVisible(value);
        if (this.valueVisible == 3) {
            int ret = this.createValueListComposite(this.operator.getParent());
            if (ret != 0) {
                if (this.handle != null) {
                    this.valueList = new ArrayList(this.handle.getValue1List());
                }
                this.tableViewer.setInput((Object)this.valueList);
            }
        } else {
            int ret = this.create2ValueComposite(this.operator.getParent());
            if (ret != 0 && this.handle != null) {
                this.expressionValue1.setText(DEUtil.resolveNull((String)this.handle.getValue1()));
                this.expressionValue2.setText(DEUtil.resolveNull((String)this.handle.getValue2()));
            }
        }
        if (this.valueVisible == 0) {
            this.expressionValue1.setVisible(false);
            this.expressionValue2.setVisible(false);
            this.andLable.setVisible(false);
            ((GridData)this.expressionValue1.getLayoutData()).exclude = true;
            ((GridData)this.expressionValue2.getLayoutData()).exclude = true;
            ((GridData)this.andLable.getLayoutData()).exclude = true;
        } else if (this.valueVisible == 1) {
            this.expressionValue1.setVisible(true);
            this.expressionValue2.setVisible(false);
            this.andLable.setVisible(false);
            ((GridData)this.expressionValue1.getLayoutData()).exclude = false;
            ((GridData)this.expressionValue2.getLayoutData()).exclude = true;
            ((GridData)this.andLable.getLayoutData()).exclude = true;
        } else if (this.valueVisible == 2) {
            this.expressionValue1.setVisible(true);
            this.expressionValue2.setVisible(true);
            this.andLable.setVisible(true);
            ((GridData)this.expressionValue1.getLayoutData()).exclude = false;
            ((GridData)this.expressionValue2.getLayoutData()).exclude = false;
            ((GridData)this.andLable.getLayoutData()).exclude = false;
        }
        this.updateButtons();
    }

    protected Object getResultSetColumn(String name) {
        if (this.columnList.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.columnList.size()) {
            ComputedColumnHandle column = (ComputedColumnHandle)this.columnList.get(i);
            if (column.getName().equals(name)) {
                return column;
            }
            ++i;
        }
        return null;
    }

    private Composite createApplyStyleArea(Composite parent) {
        Group styleGroup = new Group(parent, 0);
        styleGroup.setLayoutData((Object)new GridData(768));
        styleGroup.setLayout((Layout)new GridLayout(5, false));
        styleGroup.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Group.Format"));
        Label lb = new Label((Composite)styleGroup, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.applyStyle"));
        lb.setLayoutData((Object)new GridData(128));
        this.stylesChooser = new Combo((Composite)styleGroup, 12);
        GridData gdata = new GridData();
        gdata.widthHint = 100;
        gdata.horizontalSpan = 2;
        this.stylesChooser.setLayoutData((Object)gdata);
        this.fillStyles(this.stylesChooser);
        this.stylesChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.updateButtons();
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        this.createDummy((Composite)styleGroup, 3);
        lb = new Label((Composite)styleGroup, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 5;
        lb.setLayoutData((Object)gd);
        lb = new Label((Composite)styleGroup, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Font"));
        lb.setLayoutData((Object)new GridData(128));
        this.font = new Combo((Composite)styleGroup, 8);
        gdata = new GridData();
        gdata.widthHint = 100;
        this.font.setLayoutData((Object)gdata);
        IChoiceSet fontSet = ChoiceSetFactory.getElementChoiceSet("Style", "fontFamily");
        this.font.setData((Object)fontSet);
        this.font.setItems(ChoiceSetFactory.getDisplayNamefromChoiceSet(fontSet, (Comparator)new AlphabeticallyComparator()));
        if (SYSTEM_FONT_LIST != null && SYSTEM_FONT_LIST.length > 0) {
            int i = 0;
            while (i < SYSTEM_FONT_LIST.length) {
                this.font.add(SYSTEM_FONT_LIST[i]);
                ++i;
            }
        }
        this.font.add(DEFAULT_CHOICE, 0);
        this.font.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        if (this.font.getItemCount() > 0) {
            this.font.select(0);
        }
        this.createDummy((Composite)styleGroup, 1);
        lb = new Label((Composite)styleGroup, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Size"));
        lb.setLayoutData((Object)new GridData(128));
        this.size = new FontSizeBuilder((Composite)styleGroup, 0);
        if (this.designHandle != null) {
            this.size.setDefaultUnit(this.designHandle.getPropertyHandle("fontSize").getDefaultUnit());
        }
        gdata = new GridData();
        gdata.widthHint = 200;
        this.size.setLayoutData(gdata);
        this.size.setFontSizeValue(null);
        this.size.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        lb = new Label((Composite)styleGroup, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Color"));
        lb.setLayoutData((Object)new GridData(128));
        this.color = new ColorBuilder((Composite)styleGroup, 0);
        gdata = new GridData();
        gdata.widthHint = 100;
        this.color.setLayoutData(gdata);
        this.color.setChoiceSet(ChoiceSetFactory.getElementChoiceSet("Style", "color"));
        this.color.setRGB(null);
        this.color.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                HighlightRuleBuilder.this.previewLabel.setForeground(ColorManager.getColor((RGB)HighlightRuleBuilder.this.color.getRGB()));
                HighlightRuleBuilder.this.previewLabel.redraw();
            }
        });
        this.createDummy((Composite)styleGroup, 2);
        Composite fstyle = new Composite((Composite)styleGroup, 0);
        gdata = new GridData(768);
        fstyle.setLayoutData((Object)gdata);
        fstyle.setLayout((Layout)new GridLayout(4, false));
        this.bold = this.createToggleButton(fstyle);
        this.bold.setImage(ReportPlatformUIImages.getImage("fontWeight"));
        this.bold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.isBoldChanged = true;
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        this.bold.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.Bold"));
        this.italic = this.createToggleButton(fstyle);
        this.italic.setImage(ReportPlatformUIImages.getImage("fontStyle"));
        this.italic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.isItalicChanged = true;
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        this.italic.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.Italic"));
        this.underline = this.createToggleButton(fstyle);
        this.underline.setImage(ReportPlatformUIImages.getImage("textUnderline"));
        this.underline.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.isUnderlineChanged = true;
                HighlightRuleBuilder.this.previewLabel.setUnderline(HighlightRuleBuilder.this.underline.getSelection());
                HighlightRuleBuilder.this.previewLabel.redraw();
            }
        });
        this.underline.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.Underline"));
        this.linethrough = this.createToggleButton(fstyle);
        this.linethrough.setImage(ReportPlatformUIImages.getImage("textLineThrough"));
        this.linethrough.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.isLinethroughChanged = true;
                HighlightRuleBuilder.this.previewLabel.setLinethrough(HighlightRuleBuilder.this.linethrough.getSelection());
                HighlightRuleBuilder.this.previewLabel.redraw();
            }
        });
        this.linethrough.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.Text_Line_Through"));
        lb = new Label((Composite)styleGroup, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.BackgroundColor"));
        lb.setLayoutData((Object)new GridData(128));
        this.backColor = new ColorBuilder((Composite)styleGroup, 0);
        gdata = new GridData();
        gdata.widthHint = 100;
        this.backColor.setLayoutData(gdata);
        this.backColor.setChoiceSet(ChoiceSetFactory.getElementChoiceSet("Style", "backgroundColor"));
        this.backColor.setRGB(null);
        this.backColor.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                HighlightRuleBuilder.this.previewLabel.setBackground(ColorManager.getColor((RGB)HighlightRuleBuilder.this.backColor.getRGB()));
                HighlightRuleBuilder.this.previewLabel.redraw();
            }
        });
        this.createDummy((Composite)styleGroup, 3);
        Composite preview = new Composite((Composite)styleGroup, 0);
        GridLayout glayout = new GridLayout();
        preview.setLayout((Layout)glayout);
        gdata = new GridData(1808);
        gdata.horizontalSpan = 5;
        preview.setLayoutData((Object)gdata);
        lb = new Label(preview, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Preview"));
        Composite previewPane = new Composite(preview, 2048);
        glayout = new GridLayout();
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        previewPane.setLayout((Layout)glayout);
        gdata = new GridData(1808);
        gdata.heightHint = 60;
        previewPane.setLayoutData((Object)gdata);
        this.previewLabel = new PreviewLabel(previewPane, 0);
        this.previewLabel.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.PreviewContent"));
        gdata = new GridData(1808);
        this.previewLabel.setLayoutData(gdata);
        this.updatePreview();
        return styleGroup;
    }

    private void refreshList() {
        ArrayList<String> finalItems = new ArrayList<String>(10);
        int n = 0;
        while (n < actions.length) {
            finalItems.add(actions[n]);
            ++n;
        }
        this.popupItems = finalItems.toArray(EMPTY_ARRAY);
    }

    private List getSelectValueList() throws BirtException {
        List selectValueList = new ArrayList();
        ReportItemHandle reportItem = DEUtil.getBindingHolder((DesignElementHandle)this.currentItem);
        if (this.bindingName != null && reportItem != null) {
            Object[] arrays;
            Object[] obj;
            if (reportItem instanceof ExtendedItemHandle && (obj = ElementAdapterManager.getAdapters(reportItem, IUseCubeQueryList.class)) instanceof Object[] && (arrays = obj).length == 1 && arrays[0] != null) {
                List valueList = ((IUseCubeQueryList)arrays[0]).getQueryList(this.getExpression(), (ExtendedItemHandle)reportItem);
                selectValueList.addAll(valueList);
            }
            if (selectValueList.size() == 0) {
                selectValueList = SelectValueFetcher.getSelectValueList(this.getExpression(), reportItem.getDataSet(), false);
            }
        } else {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"SelectValueDialog.errorRetrievinglist"), Messages.getString((String)"SelectValueDialog.noExpressionSet"));
        }
        return selectValueList;
    }

    private Composite createDummy(Composite parent, int colSpan) {
        Composite dummy = new Composite(parent, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 22;
        gdata.horizontalSpan = colSpan;
        gdata.heightHint = 10;
        dummy.setLayoutData((Object)gdata);
        return dummy;
    }

    private Button createToggleButton(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        wrapper.setLayout((Layout)layout);
        Button btn = new Button(wrapper, 2);
        GridData gdata = new GridData();
        gdata.widthHint = 22;
        gdata.heightHint = 22;
        btn.setLayoutData((Object)gdata);
        return btn;
    }

    private void updatePreview() {
        if (this.stylesChooser.getText().equals(NONE_DISPLAY_TEXT)) {
            String familyValue = this.getFontFamily();
            int sizeValue = this.getFontSize();
            this.previewLabel.setFontFamily(familyValue);
            this.previewLabel.setFontSize(sizeValue);
            this.previewLabel.setBold(this.bold.getSelection());
            this.previewLabel.setItalic(this.italic.getSelection());
            this.previewLabel.setForeground(ColorManager.getColor((RGB)this.color.getRGB()));
            this.previewLabel.setBackground(ColorManager.getColor((RGB)this.backColor.getRGB()));
            this.previewLabel.setUnderline(this.underline.getSelection());
            this.previewLabel.setLinethrough(this.linethrough.getSelection());
            this.previewLabel.setOverline(false);
            this.previewLabel.updateView();
        } else {
            StyleHandle style = (StyleHandle)this.styles.get(this.stylesChooser.getText());
            String familyValue = DEUtil.removeQuote((String)style.getFontFamilyHandle().getStringValue());
            int sizeValue = DEUtil.getFontSize((String)style.getFontSize().getDisplayValue());
            this.previewLabel.setFontFamily(familyValue);
            this.previewLabel.setFontSize(sizeValue);
            this.previewLabel.setForeground(ColorManager.getColor((int)style.getColor().getRGB()));
            this.previewLabel.setBackground(ColorManager.getColor((int)style.getBackgroundColor().getRGB()));
            if (style.getFontWeight().equals("bold")) {
                this.previewLabel.setBold(true);
            } else {
                this.previewLabel.setBold(false);
            }
            if (style.getFontStyle().equals("italic")) {
                this.previewLabel.setItalic(true);
            } else {
                this.previewLabel.setItalic(false);
            }
            if (style.getTextUnderline().equals("underline")) {
                this.previewLabel.setUnderline(true);
            } else {
                this.previewLabel.setUnderline(false);
            }
            if (style.getTextLineThrough().equals("line-through")) {
                this.previewLabel.setLinethrough(true);
            } else {
                this.previewLabel.setLinethrough(false);
            }
            if (style.getTextOverline().equals("overline")) {
                this.previewLabel.setOverline(true);
            } else {
                this.previewLabel.setOverline(false);
            }
            this.previewLabel.updateView();
        }
    }

    public void updateHandle(HighlightRuleHandle handle, int handleCount) {
        this.handle = handle;
        this.handleCount = handleCount;
    }

    public void setDesignHandle(DesignElementHandle handle) {
        this.designHandle = handle;
        this.initializeProviderType();
        this.inilializeColumnList(handle);
        this.initializeParamterBinding(handle);
        this.initilizeDlgDescription(handle);
        this.exprControlType = this.getHighlightExpCtrType(this.designHandle);
    }

    protected void inilializeColumnList(DesignElementHandle handle) {
        this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)handle);
    }

    private void initializeParamterBinding(DesignElementHandle handle) {
        if (handle instanceof ReportItemHandle) {
            ReportItemHandle inputHandle = (ReportItemHandle)handle;
            ArrayList<ParamBindingHandle> list = new ArrayList<ParamBindingHandle>();
            Iterator iterator = inputHandle.paramBindingsIterator();
            while (iterator.hasNext()) {
                ParamBindingHandle paramBindingHandle = (ParamBindingHandle)iterator.next();
                list.add(paramBindingHandle);
            }
            this.bindingParams = new ParamBindingHandle[list.size()];
            list.toArray(this.bindingParams);
        }
    }

    public HighlightRuleHandle getHandle() {
        return this.handle;
    }

    private Text createText(Composite parent) {
        Text txt = new Text(parent, 2048);
        GridData gdata = new GridData(768);
        gdata.widthHint = 100;
        txt.setLayoutData((Object)gdata);
        return txt;
    }

    private void fillStyles(Combo stylesChooser) {
        stylesChooser.removeAll();
        this.styles.clear();
        stylesChooser.add(NONE_DISPLAY_TEXT);
        Iterator iter = DEUtil.getStyles();
        while (iter.hasNext()) {
            StyleHandle styleHandle = (StyleHandle)iter.next();
            if (styleHandle.isPredefined()) continue;
            String styleName = styleHandle.getName();
            stylesChooser.add(styleName);
            this.styles.put(styleName, styleHandle);
        }
        if (this.handle != null && this.handle.getStyle() != null) {
            stylesChooser.setText(this.handle.getStyle().getName());
        } else {
            stylesChooser.setText(NONE_DISPLAY_TEXT);
        }
    }

    private void fillExpression(Combo control) {
        if (this.handle != null) {
            this.handle.getTestExpression();
        }
        if (this.designHandle instanceof DataItemHandle && ((DataItemHandle)this.designHandle).getResultSetColumn() != null) {
            control.add(VALUE_OF_THIS_DATA_ITEM);
        }
        if (control.getItemCount() == 0) {
            control.add(DEUtil.resolveNull(null));
            control.select(control.getItemCount() - 1);
        }
    }

    protected void updateButtons() {
        this.enableInput(this.isExpressionOK());
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.isConditionOK());
        }
    }

    private void enableInput(boolean val) {
        boolean val2 = val;
        this.stylesChooser.setEnabled(val);
        if (!this.stylesChooser.getText().equals(NONE_DISPLAY_TEXT) || !this.stylesChooser.isEnabled()) {
            val2 = false;
        }
        this.font.setEnabled(val2);
        this.size.setEnabled(val2);
        this.color.setEnabled(val2);
        this.bold.setEnabled(val2);
        this.italic.setEnabled(val2);
        this.underline.setEnabled(val2);
        this.linethrough.setEnabled(val2);
        this.backColor.setEnabled(val2);
        this.operator.setEnabled(val);
        if (this.valueVisible != 3) {
            if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
                this.expressionValue1.setEnabled(val);
            }
            if (this.expressionValue2 != null && !this.expressionValue2.isDisposed()) {
                this.expressionValue2.setEnabled(val);
            }
            if (this.andLable != null && !this.andLable.isDisposed()) {
                this.andLable.setEnabled(val);
            }
        } else {
            this.setControlEnable((Control)this.valueListComposite, val);
            if (val) {
                this.checkAddButtonStatus();
                this.checkEditDelButtonStatus();
            }
        }
    }

    private boolean isExpressionOK() {
        if (this.getExpressionControl() == null) {
            return false;
        }
        return this.getExpression() != null && this.getExpression().length() != 0;
    }

    private boolean isConditionOK() {
        if (this.getExpressionControl() == null) {
            return false;
        }
        if (!this.isExpressionOK()) {
            return false;
        }
        return this.checkValues();
    }

    private boolean checkValues() {
        if (this.valueVisible == 3) {
            return this.valueList.size() > 0;
        }
        if (this.expressionValue1.getVisible() && (this.expressionValue1.getText() == null || this.expressionValue1.getText().length() == 0)) {
            return false;
        }
        return !this.expressionValue2.getVisible() || this.expressionValue2.getText() != null && this.expressionValue2.getText().length() != 0;
    }

    private void removeLocalStyleProperties() {
        try {
            this.handle.getFontFamilyHandle().setStringValue(null);
            this.handle.getFontSize().setStringValue(null);
            this.handle.getColor().setValue(null);
            this.handle.getBackgroundColor().setValue(null);
            this.handle.setFontStyle(null);
            this.handle.setFontWeight(null);
            this.handle.setTextUnderline(null);
            this.handle.setTextLineThrough(null);
        }
        catch (Exception e) {
            WidgetUtil.processError(this.getShell(), e);
        }
    }

    private void syncViewProperties() {
        if (this.handle != null) {
            this.setExpression(DEUtil.resolveNull((String)this.handle.getTestExpression()));
            this.operator.select(HighlightRuleBuilder.getIndexForOperatorValue(this.handle.getOperator()));
            String value = HighlightRuleBuilder.getValueForOperator(this.operator.getText());
            this.valueVisible = HighlightRuleBuilder.determineValueVisible(value);
            if (this.valueVisible == 3) {
                this.createValueListComposite(this.operator.getParent());
                if (this.handle != null) {
                    this.valueList = new ArrayList(this.handle.getValue1List());
                }
                this.tableViewer.setInput((Object)this.valueList);
            } else {
                this.create2ValueComposite(this.operator.getParent());
                if (this.handle != null) {
                    this.expressionValue1.setText(DEUtil.resolveNull((String)this.handle.getValue1()));
                    this.expressionValue2.setText(DEUtil.resolveNull((String)this.handle.getValue2()));
                }
            }
            if (this.valueVisible == 0) {
                this.expressionValue1.setVisible(false);
                this.expressionValue2.setVisible(false);
                this.andLable.setVisible(false);
            } else if (this.valueVisible == 1) {
                this.expressionValue1.setVisible(true);
                this.expressionValue2.setVisible(false);
                this.andLable.setVisible(false);
            } else if (this.valueVisible == 2) {
                this.expressionValue1.setVisible(true);
                this.expressionValue2.setVisible(true);
                this.andLable.setVisible(true);
            }
        }
        this.syncFamily();
        this.syncSize();
        if (this.handle != null && this.handle.getStyle() == null) {
            if (this.handle.getColor().isSet()) {
                this.color.setRGB(DEUtil.getRGBValue((int)this.handle.getColor().getRGB()));
            }
            if (this.handle.getBackgroundColor().isSet()) {
                this.backColor.setRGB(DEUtil.getRGBValue((int)this.handle.getBackgroundColor().getRGB()));
            }
            this.bold.setSelection("bold".equals(this.handle.getFontWeight()));
            this.italic.setSelection("italic".equals(this.handle.getFontStyle()));
            this.underline.setSelection("underline".equals(this.handle.getTextUnderline()));
            this.linethrough.setSelection("line-through".equals(this.handle.getTextLineThrough()));
        }
    }

    private void syncFamily() {
        String fm;
        if (this.handle != null && this.handle.getStyle() == null && this.innerSyncFamily(fm = DEUtil.removeQuote((String)this.handle.getFontFamilyHandle().getDisplayValue()))) {
            return;
        }
    }

    private boolean innerSyncFamily(String fm) {
        String[] items = this.font.getItems();
        int idx = this.getSelectionIndex(fm, items);
        if (idx >= 0) {
            this.font.select(idx);
            return true;
        }
        if (SYSTEM_FONT_LIST != null && SYSTEM_FONT_LIST.length > 0) {
            int i = 0;
            while (i < SYSTEM_FONT_LIST.length) {
                if (SYSTEM_FONT_LIST[i].equals(fm)) {
                    this.font.select(items.length + i);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private int getSelectionIndex(String fm, String[] items) {
        int i = 0;
        while (i < items.length) {
            if (items[i].equalsIgnoreCase(fm)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void syncSize() {
        if (this.handle != null && this.handle.getStyle() == null) {
            this.size.setFontSizeValue(this.handle.getFontSize().getStringValue());
        }
    }

    private String getFontFamily() {
        String rfm = this.getRawFontFamily();
        if (rfm == null) {
            rfm = this.designHandle != null ? (this.designHandle instanceof StyleHandle ? ((StyleHandle)this.designHandle).getFontFamilyHandle().getStringValue() : this.designHandle.getPrivateStyle().getFontFamilyHandle().getStringValue()) : "serif";
        }
        return HighlightHandleProvider.getFontFamily(rfm);
    }

    private String getRawFontFamily() {
        String ftName = this.font.getText();
        IChoiceSet cs = (IChoiceSet)this.font.getData();
        IChoice ci = cs.findChoiceByDisplayName(ftName);
        if (ci != null) {
            return ci.getName();
        }
        if (SYSTEM_FONT_LIST != null && SYSTEM_FONT_LIST.length > 0) {
            int i = 0;
            while (i < SYSTEM_FONT_LIST.length) {
                if (SYSTEM_FONT_LIST[i].equals(ftName)) {
                    return ftName;
                }
                ++i;
            }
        }
        return null;
    }

    private int getFontSize() {
        String rfs = this.getRawFontSize();
        if (rfs == null && this.designHandle != null) {
            rfs = this.designHandle instanceof StyleHandle ? ((StyleHandle)this.designHandle).getFontSize().getStringValue() : this.designHandle.getPrivateStyle().getFontSize().getStringValue();
        }
        return DEUtil.getFontSize((String)rfs);
    }

    private String getRawFontSize() {
        return this.size.getFontSizeValue();
    }

    protected void okPressed() {
        try {
            String lingthroughValue;
            String familyValue = this.getRawFontFamily();
            String sizeValue = this.getRawFontSize();
            int colorValue = DEUtil.getRGBInt((RGB)this.color.getRGB());
            int backColorValue = DEUtil.getRGBInt((RGB)this.backColor.getRGB());
            String italicValue = this.italic.getSelection() ? "italic" : "normal";
            String weightValue = this.bold.getSelection() ? "bold" : "normal";
            String underlineValue = this.underline.getSelection() ? "underline" : "none";
            String string = lingthroughValue = this.linethrough.getSelection() ? "line-through" : "none";
            if (this.handle == null) {
                HighlightRule rule = StructureFactory.createHighlightRule();
                rule.setProperty("operator", (Object)DEUtil.resolveNull((String)HighlightRuleBuilder.getValueForOperator(this.operator.getText())));
                if (this.valueVisible == 3) {
                    rule.setValue1(this.valueList);
                    rule.setValue2("");
                } else {
                    if (this.expressionValue1.isVisible()) {
                        rule.setProperty("value1", (Object)DEUtil.resolveNull((String)this.expressionValue1.getText()));
                    }
                    if (this.expressionValue2.isVisible()) {
                        rule.setProperty("value2", (Object)DEUtil.resolveNull((String)this.expressionValue2.getText()));
                    }
                }
                rule.setTestExpression(DEUtil.resolveNull((String)this.getExpression()));
                if (!this.stylesChooser.getText().equals(NONE_DISPLAY_TEXT)) {
                    rule.setStyle((StyleHandle)this.styles.get(this.stylesChooser.getText()));
                } else {
                    if (this.color.getRGB() != null) {
                        rule.setProperty("color", (Object)colorValue);
                    }
                    if (this.backColor.getRGB() != null) {
                        rule.setProperty("backgroundColor", (Object)backColorValue);
                    }
                    if (familyValue != null) {
                        rule.setProperty("fontFamily", (Object)familyValue);
                    }
                    if (sizeValue != null) {
                        rule.setProperty("fontSize", (Object)sizeValue);
                    }
                    if (this.isItalicChanged) {
                        rule.setProperty("fontStyle", (Object)italicValue);
                    }
                    if (this.isBoldChanged) {
                        rule.setProperty("fontWeight", (Object)weightValue);
                    }
                    if (this.isLinethroughChanged) {
                        rule.setProperty("textLineThrough", (Object)lingthroughValue);
                    }
                    if (this.isUnderlineChanged) {
                        rule.setProperty("textUnderline", (Object)underlineValue);
                    }
                }
                this.handle = this.provider.doAddItem(rule, this.handleCount);
            } else {
                this.handle.setTestExpression(DEUtil.resolveNull((String)this.getExpression()));
                this.handle.setOperator(DEUtil.resolveNull((String)HighlightRuleBuilder.getValueForOperator(this.operator.getText())));
                if (this.valueVisible != 3) {
                    if (this.expressionValue1.isVisible()) {
                        this.handle.setValue1(DEUtil.resolveNull((String)this.expressionValue1.getText()));
                    } else {
                        this.handle.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.isVisible()) {
                        this.handle.setValue2(DEUtil.resolveNull((String)this.expressionValue2.getText()));
                    } else {
                        this.handle.setValue2(this.NULL_STRING);
                    }
                } else {
                    this.handle.setValue1(this.valueList);
                    this.handle.setValue2("");
                }
                if (!this.stylesChooser.getText().equals(NONE_DISPLAY_TEXT)) {
                    if (this.handle.getStyle() == null) {
                        this.handle.setStyle((StyleHandle)this.styles.get(this.stylesChooser.getText()));
                    } else if (!this.stylesChooser.getText().equals(this.handle.getStyle().getName())) {
                        this.handle.setStyle((StyleHandle)this.styles.get(this.stylesChooser.getText()));
                    }
                    this.removeLocalStyleProperties();
                } else {
                    this.handle.setStyle(null);
                    this.handle.getFontFamilyHandle().setStringValue(DEUtil.resolveNull((String)familyValue));
                    this.handle.getFontSize().setStringValue(DEUtil.resolveNull((String)sizeValue));
                    if (this.color.getRGB() != null) {
                        this.handle.getColor().setRGB(colorValue);
                    } else {
                        this.handle.getColor().setValue(null);
                    }
                    if (this.backColor.getRGB() != null) {
                        this.handle.getBackgroundColor().setRGB(backColorValue);
                    } else {
                        this.handle.getBackgroundColor().setValue(null);
                    }
                    if (this.isItalicChanged) {
                        this.handle.setFontStyle(italicValue);
                    }
                    if (this.isBoldChanged) {
                        this.handle.setFontWeight(weightValue);
                    }
                    if (this.isUnderlineChanged) {
                        this.handle.setTextUnderline(underlineValue);
                    }
                    if (this.isLinethroughChanged) {
                        this.handle.setTextLineThrough(lingthroughValue);
                    }
                }
            }
        }
        catch (Exception e) {
            WidgetUtil.processError(this.getShell(), e);
        }
        super.okPressed();
    }

    private void editValue(Object control) {
        String initValue = null;
        if (control instanceof Text) {
            initValue = ((Text)control).getText();
        } else if (control instanceof Combo) {
            initValue = ((Combo)control).getText();
        } else if (control instanceof ExpressionValue) {
            initValue = ((ExpressionValue)control).getText();
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getShell(), initValue);
        if (this.designHandle != null) {
            ExpressionProvider expressionProvider = new ExpressionProvider(this.designHandle);
            expressionProvider.addFilter(new ExpressionFilter(){

                public boolean select(Object parentElement, Object element) {
                    return !"Category".equals(parentElement) || !ExpressionProvider.CURRENT_CUBE.equals(element);
                }
            });
            expressionBuilder.setExpressionProvier(expressionProvider);
        }
        if (expressionBuilder.open() == 0) {
            String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
            if (control instanceof Text) {
                ((Text)control).setText(result);
            } else if (control instanceof Combo) {
                ((Combo)control).setText(result);
            }
        }
        this.updateButtons();
    }

    protected String getExpression(String resultSet) {
        if (this.provider.getExpressionType() == 0) {
            return DEUtil.getColumnExpression((String)resultSet);
        }
        if (this.provider.getExpressionType() == 1) {
            return DEUtil.getDataExpression((String)resultSet);
        }
        return null;
    }

    private void initializeProviderType() {
        if (this.designHandle instanceof DataItemHandle) {
            DataItemHandle dataItem = (DataItemHandle)this.designHandle;
            if (dataItem.getContainer() instanceof ExtendedItemHandle) {
                this.provider.setExpressionType(1);
            } else {
                this.provider.setExpressionType(0);
            }
        }
    }

    protected int create2ValueComposite(Composite condition) {
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            return 0;
        }
        this.disposeComposites();
        GridData gd = new GridData(768);
        this.expressionValue1 = new ValueCombo(condition, 0);
        this.compositeList.add(this.expressionValue1);
        this.expressionValue1.setLayoutData(gd);
        this.expressionValue1.setItems(this.popupItems);
        this.expressionValue1.addListener(24, this.textModifyListener);
        this.expressionValue1.addSelectionListener(0, this.selectValueAction);
        this.expressionValue1.addSelectionListener(1, this.expValueAction);
        Composite dummy = this.createDummy(condition, 3);
        this.compositeList.add(dummy);
        this.andLable = new Label(condition, 0);
        this.andLable.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.AND"));
        this.andLable.setVisible(false);
        gd = new GridData(768);
        this.andLable.setLayoutData((Object)gd);
        this.compositeList.add(this.andLable);
        dummy = this.createDummy(condition, 3);
        this.compositeList.add(dummy);
        this.expressionValue2 = new ValueCombo(condition, 0);
        gd = new GridData(768);
        this.expressionValue2.setLayoutData(gd);
        this.compositeList.add(this.expressionValue2);
        this.expressionValue2.setItems(this.popupItems);
        this.expressionValue2.addListener(24, this.textModifyListener);
        this.expressionValue2.addSelectionListener(0, this.selectValueAction);
        this.expressionValue2.addSelectionListener(1, this.expValueAction);
        this.expressionValue2.setVisible(false);
        if (this.operator.getItemCount() > 0 && this.operator.getSelectionIndex() == -1) {
            this.operator.select(0);
        }
        condition.getParent().layout(true, true);
        return 1;
    }

    private void disposeComposites() {
        if (this.compositeList.size() > 0) {
            int count = this.compositeList.size();
            int i = 0;
            while (i < count) {
                Object obj = this.compositeList.get(i);
                if (obj != null && obj instanceof Widget && !((Widget)obj).isDisposed()) {
                    ((Widget)obj).dispose();
                }
                ++i;
            }
        }
        this.compositeList.clear();
    }

    private int createValueListComposite(Composite parent) {
        if (this.valueListComposite != null && !this.valueListComposite.isDisposed()) {
            return 0;
        }
        this.disposeComposites();
        this.valueListComposite = new Composite(parent, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 4;
        this.valueListComposite.setLayoutData((Object)gdata);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.valueListComposite.setLayout((Layout)layout);
        this.compositeList.add(this.valueListComposite);
        Group group = new Group(this.valueListComposite, 0);
        GridData data = new GridData(768);
        data.heightHint = 118;
        data.horizontalSpan = 3;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        new Label((Composite)group, 0).setText(Messages.getString((String)"FilterConditionBuilder.label.value"));
        GridData expgd = new GridData();
        expgd.widthHint = 100;
        this.addExpressionValue = new MultiValueCombo((Composite)group, 0);
        this.addExpressionValue.setLayoutData(expgd);
        this.addBtn = new Button((Composite)group, 8);
        this.addBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.add"));
        this.addBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.add.tooltip"));
        this.setButtonLayoutData(this.addBtn);
        this.addBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String value = HighlightRuleBuilder.this.addExpressionValue.getText().trim();
                if (HighlightRuleBuilder.this.valueList.indexOf(value) < 0) {
                    HighlightRuleBuilder.this.valueList.add(value);
                    HighlightRuleBuilder.this.tableViewer.refresh();
                    HighlightRuleBuilder.this.updateButtons();
                    HighlightRuleBuilder.this.addExpressionValue.setFocus();
                    HighlightRuleBuilder.this.addExpressionValue.setText("");
                } else {
                    HighlightRuleBuilder.this.addBtn.setEnabled(false);
                }
            }
        });
        new Label((Composite)group, 0);
        int tableStyle = 68356;
        this.table = new Table((Composite)group, tableStyle);
        data = new GridData(1808);
        data.horizontalSpan = 4;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(true);
        String[] columNames = new String[]{Messages.getString((String)"FilterConditionBuilder.list.item1")};
        int[] columLength = new int[]{484};
        int i = 0;
        while (i < columNames.length) {
            TableColumn column = new TableColumn(this.table, 0, i);
            column.setText(columNames[i]);
            column.setWidth(columLength[i]);
            ++i;
        }
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.checkEditDelButtonStatus();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    int index = HighlightRuleBuilder.this.table.getSelectionIndex();
                    if (index > -1) {
                        HighlightRuleBuilder.this.valueList.remove(index);
                        HighlightRuleBuilder.this.tableViewer.refresh();
                        if (HighlightRuleBuilder.this.valueList.size() > 0) {
                            if (HighlightRuleBuilder.this.valueList.size() <= index) {
                                --index;
                            }
                            HighlightRuleBuilder.this.table.select(index);
                        }
                        HighlightRuleBuilder.this.updateButtons();
                    } else {
                        HighlightRuleBuilder.this.delBtn.setEnabled(false);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                HighlightRuleBuilder.this.editTableValue();
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columNames);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableLableProvier);
        this.tableViewer.setContentProvider((IContentProvider)this.tableContentProvider);
        Composite rightPart = new Composite(this.valueListComposite, 0);
        data = new GridData(40);
        rightPart.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        rightPart.setLayout((Layout)layout);
        this.editBtn = new Button(rightPart, 8);
        this.editBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.edit"));
        this.editBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.edit.tooltip"));
        this.setButtonLayoutData(this.editBtn);
        this.editBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.editTableValue();
            }
        });
        this.delBtn = new Button(rightPart, 8);
        this.delBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.delete"));
        this.delBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.delete.tooltip"));
        this.setButtonLayoutData(this.delBtn);
        this.delBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = HighlightRuleBuilder.this.table.getSelectionIndex();
                if (index > -1) {
                    HighlightRuleBuilder.this.valueList.remove(index);
                    HighlightRuleBuilder.this.tableViewer.refresh();
                    if (HighlightRuleBuilder.this.valueList.size() > 0) {
                        if (HighlightRuleBuilder.this.valueList.size() <= index) {
                            --index;
                        }
                        HighlightRuleBuilder.this.table.select(index);
                    }
                    HighlightRuleBuilder.this.updateButtons();
                } else {
                    HighlightRuleBuilder.this.delBtn.setEnabled(false);
                }
            }
        });
        this.delAllBtn = new Button(rightPart, 8);
        this.delAllBtn.setText(Messages.getString((String)"FilterConditionBuilder.button.deleteall"));
        this.delAllBtn.setToolTipText(Messages.getString((String)"FilterConditionBuilder.button.deleteall.tooltip"));
        this.setButtonLayoutData(this.delAllBtn);
        this.delAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int count = HighlightRuleBuilder.this.valueList.size();
                if (count > 0) {
                    HighlightRuleBuilder.this.valueList.clear();
                    HighlightRuleBuilder.this.tableViewer.refresh();
                    HighlightRuleBuilder.this.updateButtons();
                } else {
                    HighlightRuleBuilder.this.delAllBtn.setEnabled(false);
                }
            }
        });
        this.addExpressionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HighlightRuleBuilder.this.checkAddButtonStatus();
                HighlightRuleBuilder.this.updateButtons();
            }
        });
        this.addExpressionValue.addSelectionListener(0, this.mAddSelValueAction);
        this.addExpressionValue.addSelectionListener(1, this.mAddExpValueAction);
        this.addExpressionValue.setItems(this.popupItems);
        return 1;
    }

    protected void checkEditDelButtonStatus() {
        StructuredSelection selection;
        boolean enabled;
        if (this.tableViewer == null) {
            return;
        }
        boolean bl = enabled = this.tableViewer.getSelection() != null;
        if (enabled && this.tableViewer.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)this.tableViewer.getSelection()).toList().size() <= 0) {
            enabled = false;
        }
        this.editBtn.setEnabled(enabled);
        this.delBtn.setEnabled(enabled);
        enabled = this.table.getItemCount() > 0;
        this.delAllBtn.setEnabled(enabled);
    }

    protected void checkAddButtonStatus() {
        if (this.addExpressionValue != null && !this.addExpressionValue.isDisposed()) {
            String value = this.addExpressionValue.getText();
            if (value == null || value.length() == 0 || value.trim().length() == 0) {
                this.addBtn.setEnabled(false);
                return;
            }
            if (value != null) {
                value = value.trim();
            }
            if (this.valueList.indexOf(value) < 0) {
                this.addBtn.setEnabled(true);
            } else {
                this.addBtn.setEnabled(false);
            }
        }
    }

    protected void setControlEnable(Control control, boolean bool) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setEnabled(bool);
        Composite tmp = null;
        if (control instanceof Composite) {
            tmp = (Composite)control;
        }
        if (tmp != null && tmp.getChildren() != null) {
            int i = 0;
            while (i < tmp.getChildren().length) {
                this.setControlEnable(tmp.getChildren()[i], bool);
                ++i;
            }
        }
    }

    private void editTableValue() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.getFirstElement() != null && selection.getFirstElement() instanceof String) {
            String initValue = (String)selection.getFirstElement();
            ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getShell(), initValue);
            if (this.designHandle != null) {
                if (this.expressionProvider == null) {
                    expressionBuilder.setExpressionProvier(new ExpressionProvider(this.designHandle));
                } else {
                    expressionBuilder.setExpressionProvier(this.expressionProvider);
                }
            }
            if (expressionBuilder.open() == 0) {
                String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
                if (result.length() == 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"MapRuleBuilderDialog.MsgDlg.Title"), (String)Messages.getString((String)"MapRuleBuilderDialog.MsgDlg.Msg"));
                    return;
                }
                int index = this.table.getSelectionIndex();
                this.valueList.remove(index);
                this.valueList.add(index, result);
                this.tableViewer.refresh();
                this.table.select(index);
            }
            this.updateButtons();
        } else {
            this.editBtn.setEnabled(false);
        }
    }

    protected int getHighlightExpCtrType(DesignElementHandle handle) {
        int type = 0;
        HashSet<Class> comboClassSet = new HashSet<Class>(){};
        comboClassSet.add(TableHandle.class);
        comboClassSet.add(ListHandle.class);
        comboClassSet.add(GridHandle.class);
        Class<?> handleClass = handle.getClass();
        if (comboClassSet.contains(handleClass)) {
            type = 1;
        }
        return type;
    }

    protected void initilizeDlgDescription(DesignElementHandle handle) {
        Class[] classList = new Class[]{TableHandle.class, ListHandle.class, GridHandle.class, RowHandle.class, ColumnHandle.class, DataItemHandle.class, CellHandle.class};
        String[] desList = new String[]{Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.Table"), Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.List"), Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.Grid"), Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.Row"), Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.Column"), Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.DataItem"), Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.Cell")};
        Class<?> handleClass = handle.getClass();
        int i = 0;
        while (i < classList.length) {
            if (classList[i] == handleClass) {
                this.dlgDescription = desList[i];
                break;
            }
            ++i;
        }
        if (this.dlgDescription == null || this.dlgDescription.length() == 0) {
            this.dlgDescription = Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.ReportElement");
        }
        this.dlgDescription = Messages.getFormattedString((String)"HighlightRuleBuilderDialog.text.Description", (Object[])new Object[]{this.dlgDescription});
    }

    protected void setExpression(String exp) {
        if (this.exprControlType == 1 && this.expressionText != null) {
            this.expressionText.setText(exp);
        } else if (this.exprControlType == 0 && this.expressionCombo != null) {
            this.expressionCombo.setText(exp);
        }
    }

    protected String getExpression() {
        if (this.exprControlType == 1 && this.expressionText != null) {
            return this.expressionText.getText();
        }
        if (this.exprControlType == 0 && this.expressionCombo != null) {
            return this.expressionCombo.getText();
        }
        return "";
    }

    protected Control getExpressionControl() {
        if (this.exprControlType == 1 && this.expressionText != null) {
            return this.expressionText;
        }
        if (this.exprControlType == 0 && this.expressionCombo != null) {
            return this.expressionCombo;
        }
        return null;
    }
}

