/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.parameters.AbstractParameterGroup;
import org.eclipse.birt.report.designer.ui.parameters.CascadingParameterGroup;
import org.eclipse.birt.report.designer.ui.parameters.ComboBoxParameter;
import org.eclipse.birt.report.designer.ui.parameters.ListingParameter;
import org.eclipse.birt.report.designer.ui.parameters.ParameterUtil;
import org.eclipse.birt.report.designer.ui.parameters.RadioParameter;
import org.eclipse.birt.report.designer.ui.parameters.ScalarParameter;
import org.eclipse.birt.report.designer.ui.parameters.StaticTextParameter;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputParameterDialog
extends Dialog {
    private static final String NULL_VALUE_STR = ParameterUtil.LABEL_NULL;
    private Composite contentPane;
    private ScrolledComposite scrollPane;
    private List params;
    private Map paramValues = new HashMap();
    private List isRequiredParameters = new ArrayList();
    private List dataTypeCheckList = new ArrayList();
    private boolean performed = false;
    private static IParameterSelectionChoice nullValueChoice = new IParameterSelectionChoice(){

        public String getLabel() {
            return NULL_VALUE_STR;
        }

        public Object getValue() {
            return null;
        }
    };
    private static IParameterSelectionChoice blankValueChoice = new IParameterSelectionChoice(){

        public String getLabel() {
            return "";
        }

        public Object getValue() {
            return "";
        }
    };

    public InputParameterDialog(Shell parentShell, List params, Map paramValues) {
        super(parentShell);
        this.params = params;
        if (paramValues != null) {
            this.paramValues.putAll(paramValues);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Object paramValue;
            for (String paramName : this.isRequiredParameters) {
                paramValue = this.paramValues.get(paramName);
                if (paramValue != null && (!(paramValue instanceof String) || ((String)paramValue).trim().length() != 0) && (!(paramValue instanceof Object[]) || ((Object[])paramValue).length != 0)) continue;
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)(String.valueOf(paramName) + " cannot be NULL or blank"));
                return;
            }
            for (ScalarParameter scalarParameter : this.dataTypeCheckList) {
                paramValue = (String)this.paramValues.get(scalarParameter.getHandle().getName());
                try {
                    this.paramValues.put(scalarParameter.getHandle().getName(), scalarParameter.converToDataType(paramValue));
                }
                catch (BirtException birtException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Invalid value type", (String)("The value \"" + paramValue + "\" is invalid with type " + scalarParameter.getHandle().getDataType()));
                    return;
                }
            }
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        InputParameterDialog.applyDialogFont((Control)composite);
        this.scrollPane = new ScrolledComposite(composite, 768);
        this.scrollPane.setExpandHorizontal(true);
        this.scrollPane.setExpandVertical(true);
        this.scrollPane.setLayoutData((Object)new GridData(1808));
        this.createParameters();
        this.performed = true;
        return composite;
    }

    private void createParameters() {
        if (this.contentPane != null && !this.contentPane.isDisposed()) {
            this.contentPane.dispose();
        }
        this.contentPane = new Composite((Composite)this.scrollPane, 0);
        this.scrollPane.setContent((Control)this.contentPane);
        this.contentPane.setLayoutData((Object)new GridData(1808));
        this.contentPane.setLayout((Layout)new GridLayout());
        this.createParametersSection(this.params, this.contentPane);
        this.contentPane.setSize(this.contentPane.computeSize(-1, -1));
        this.scrollPane.setMinSize(this.contentPane.computeSize(-1, -1));
    }

    private void createParametersSection(List children, Composite parent) {
        for (Object obj : children) {
            if (obj instanceof ScalarParameter && !((ScalarParameter)obj).getHandle().isHidden()) {
                ScalarParameter param = (ScalarParameter)obj;
                this.createParamSection(param, parent);
                continue;
            }
            if (!(obj instanceof AbstractParameterGroup)) continue;
            AbstractParameterGroup group = (AbstractParameterGroup)obj;
            this.createParametersSection(group.getChildren(), this.createParamGroupSection(group, parent));
        }
    }

    private Composite createParamGroupSection(AbstractParameterGroup paramGroup, Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(paramGroup.getHandle().getDisplayLabel());
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout());
        return group;
    }

    private Composite createParamSection(ScalarParameter param, Composite parent) {
        boolean isRequired = param.getHandle().isRequired();
        param.getHandle().getDataType().equals("string");
        if (isRequired) {
            this.isRequiredParameters.add(param.getHandle().getName());
        }
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(String.valueOf(param.getHandle().getDisplayLabel()) + ":");
        if (param instanceof StaticTextParameter) {
            final StaticTextParameter textParam = (StaticTextParameter)param;
            String value = textParam.getDefaultValue();
            this.dataTypeCheckList.add(textParam);
            Text input = new Text(container, 2048);
            input.setLayoutData((Object)new GridData(768));
            input.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text input = (Text)e.getSource();
                    InputParameterDialog.this.paramValues.put(textParam.getHandle().getName(), input.getText());
                }
            });
            if (this.paramValues.containsKey(textParam.getHandle().getName())) {
                value = this.paramValues.get(textParam.getHandle().getName()).toString();
            }
            if (value != null) {
                input.setText(value);
            }
        } else if (param instanceof RadioParameter) {
            final RadioParameter radioParameter = (RadioParameter)param;
            Object value = null;
            try {
                value = radioParameter.converToDataType(radioParameter.getDefaultValue());
            }
            catch (BirtException birtException) {}
            if (this.paramValues.containsKey(radioParameter.getHandle().getName())) {
                value = this.paramValues.get(radioParameter.getHandle().getName());
            }
            List list = radioParameter.getValueList();
            if (!isRequired) {
                list.add(nullValueChoice);
            }
            int i = 0;
            while (i < list.size()) {
                if (i > 0) {
                    new Label(container, 0);
                }
                IParameterSelectionChoice choice = (IParameterSelectionChoice)list.get(i);
                Button button = new Button(container, 16);
                button.setText(choice.getLabel());
                button.setData(choice.getValue());
                if (choice.getValue() != null && choice.getValue().equals(value)) {
                    button.setSelection(true);
                } else if (value == null && choice.getLabel().equals(NULL_VALUE_STR)) {
                    button.setSelection(true);
                }
                button.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        Button button = (Button)e.getSource();
                        InputParameterDialog.this.paramValues.put(radioParameter.getHandle().getName(), button.getData());
                    }
                });
                ++i;
            }
        } else if (param instanceof ListingParameter) {
            ListingParameter listParam = (ListingParameter)param;
            if ("multi-value".equals(listParam.getHandle().getParamType())) {
                this.createList(container, listParam);
                GridData labelLayout = new GridData(2);
                label.setLayoutData((Object)labelLayout);
            } else {
                this.createCombo(container, listParam);
            }
        }
        return container;
    }

    private void checkParam(final String defaultValue, List list) {
        if (!this.performed) {
            boolean contains = false;
            int i = 0;
            while (i < list.size()) {
                try {
                    if (((IParameterSelectionChoice)list.get(i)).getValue().toString().equals(defaultValue)) {
                        contains = true;
                        break;
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
            if (!contains) {
                IParameterSelectionChoice choice = new IParameterSelectionChoice(){

                    public String getLabel() {
                        return defaultValue;
                    }

                    public Object getValue() {
                        return defaultValue;
                    }
                };
                list.add(choice);
            }
        }
    }

    private void createCombo(Composite container, final ListingParameter listParam) {
        boolean isRequired = listParam.getHandle().isRequired();
        boolean isStringType = listParam.getHandle().getDataType().equals("string");
        Object value = null;
        try {
            value = listParam.converToDataType(listParam.getDefaultValue());
        }
        catch (BirtException birtException) {}
        if (this.paramValues.containsKey(listParam.getHandle().getName()) && (value = this.paramValues.get(listParam.getHandle().getName())) != null) {
            listParam.setSelectionValue(value.toString());
        }
        int style = 2048;
        if (!(listParam instanceof ComboBoxParameter)) {
            style |= 8;
        }
        Combo combo = new Combo(container, style);
        combo.setLayoutData((Object)new GridData(768));
        ArrayList<IParameterSelectionChoice> list = new ArrayList<IParameterSelectionChoice>();
        if (isStringType && !isRequired) {
            list.add(blankValueChoice);
        }
        list.addAll(listParam.getValueList());
        this.checkParam(listParam.getDefaultValue(), list);
        if (!isRequired) {
            boolean hasNull = false;
            int i = 0;
            while (i < list.size()) {
                IParameterSelectionChoice choice = (IParameterSelectionChoice)list.get(i);
                if (choice.getValue() == null) {
                    hasNull = true;
                }
                ++i;
            }
            if (!hasNull) {
                list.add(nullValueChoice);
            }
        }
        boolean nullAdded = false;
        for (IParameterSelectionChoice choice : list) {
            String label;
            String string = label = choice.getLabel() == null ? String.valueOf(choice.getValue()) : choice.getLabel();
            if (choice.getValue() == null && choice.getLabel() == null) {
                if (isRequired || nullAdded) continue;
                combo.add(NULL_VALUE_STR);
                combo.setData(NULL_VALUE_STR, null);
                nullAdded = true;
                continue;
            }
            combo.add(label);
            combo.setData(label, choice.getValue());
        }
        if (value == null) {
            if (!isRequired) {
                combo.select(combo.getItemCount() - 1);
            }
            listParam.setSelectionValue(null);
            this.paramValues.put(listParam.getHandle().getName(), null);
        } else {
            boolean found = false;
            int i = 0;
            while (i < combo.getItemCount()) {
                if (value.equals(combo.getData(combo.getItem(i)))) {
                    combo.select(i);
                    this.paramValues.put(listParam.getHandle().getName(), combo.getData(combo.getItem(i)));
                    listParam.setSelectionValue(value.toString());
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                if (listParam instanceof ComboBoxParameter) {
                    combo.setText(value.toString());
                    listParam.setSelectionValue(combo.getText());
                    this.paramValues.put(listParam.getHandle().getName(), combo.getText());
                } else {
                    listParam.setSelectionValue(null);
                    this.paramValues.put(listParam.getHandle().getName(), null);
                }
            }
        }
        combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                CascadingParameterGroup group;
                if (!(listParam instanceof ComboBoxParameter)) {
                    return;
                }
                Combo combo = (Combo)e.getSource();
                if (combo.indexOf(combo.getText()) < 0) {
                    InputParameterDialog.this.paramValues.put(listParam.getHandle().getName(), combo.getText());
                } else {
                    InputParameterDialog.this.paramValues.put(listParam.getHandle().getName(), combo.getData(combo.getItem(combo.indexOf(combo.getText()))));
                }
                if (listParam.getParentGroup() instanceof CascadingParameterGroup && (group = (CascadingParameterGroup)listParam.getParentGroup()).getPostParameter(listParam) != null) {
                    try {
                        InputParameterDialog.this.createParameters();
                    }
                    catch (RuntimeException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CascadingParameterGroup group;
                Combo combo = (Combo)e.getSource();
                InputParameterDialog.this.paramValues.put(listParam.getHandle().getName(), combo.getData(combo.getItem(combo.getSelectionIndex())));
                if (listParam.getParentGroup() instanceof CascadingParameterGroup && (group = (CascadingParameterGroup)listParam.getParentGroup()).getPostParameter(listParam) != null) {
                    try {
                        InputParameterDialog.this.createParameters();
                    }
                    catch (RuntimeException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
    }

    private void createList(Composite container, final ListingParameter listParam) {
        boolean isRequired = listParam.getHandle().isRequired();
        boolean isStringType = listParam.getHandle().getDataType().equals("string");
        Object value = null;
        try {
            value = listParam.converToDataType(listParam.getDefaultValue());
        }
        catch (BirtException birtException) {}
        if (this.paramValues.containsKey(listParam.getHandle().getName()) && (value = this.paramValues.get(listParam.getHandle().getName())) != null) {
            listParam.setSelectionValue(value.toString());
        }
        ListViewer listViewer = new ListViewer(container);
        GridData gd = new GridData(768);
        gd.heightHint = 70;
        listViewer.getList().setLayoutData((Object)gd);
        ArrayList<IParameterSelectionChoice> list = new ArrayList<IParameterSelectionChoice>();
        if (isStringType && !isRequired) {
            list.add(blankValueChoice);
        }
        list.addAll(listParam.getValueList());
        this.checkParam(listParam.getDefaultValue(), list);
        if (!isRequired) {
            list.add(nullValueChoice);
        }
        for (IParameterSelectionChoice choice : list) {
            String label;
            String string = label = choice.getLabel() == null ? String.valueOf(choice.getValue()) : choice.getLabel();
            if (label == null) continue;
            listViewer.getList().add(label);
            listViewer.getList().setData(label, choice.getValue());
        }
        if (value == null && !isRequired) {
            listViewer.getList().select(listViewer.getList().getItemCount() - 1);
        } else {
            ArrayList<Object> newValueList = new ArrayList<Object>();
            List<Object> oldvalueList = new ArrayList<Object>();
            if (value instanceof Object[]) {
                oldvalueList = Arrays.asList((Object[])value);
            } else {
                oldvalueList.add(value);
            }
            int i = 0;
            while (i < listViewer.getList().getItemCount()) {
                Object item = listViewer.getList().getData(listViewer.getList().getItem(i));
                if (oldvalueList.indexOf(item) >= 0) {
                    listViewer.getList().select(i);
                    newValueList.add(listViewer.getList().getData(listViewer.getList().getItem(i)));
                }
                ++i;
            }
            this.paramValues.put(listParam.getHandle().getName(), newValueList.toArray(new Object[newValueList.size()]));
        }
        listViewer.getList().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CascadingParameterGroup group;
                org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)e.getSource();
                String[] strs = list.getSelection();
                if (strs != null && strs.length > 0) {
                    ArrayList<Object> array = new ArrayList<Object>();
                    int i = 0;
                    while (i < strs.length) {
                        Object obj = list.getData(strs[i]);
                        array.add(obj);
                        ++i;
                    }
                    Object[] objs = new Object[array.size()];
                    array.toArray(objs);
                    InputParameterDialog.this.paramValues.put(listParam.getHandle().getName(), objs);
                }
                if (listParam.getParentGroup() instanceof CascadingParameterGroup && (group = (CascadingParameterGroup)listParam.getParentGroup()).getPostParameter(listParam) != null) {
                    try {
                        InputParameterDialog.this.createParameters();
                    }
                    catch (RuntimeException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString((String)"InputParameterDialog.msg.title"));
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    public Map getParameters() {
        return this.paramValues;
    }
}

