/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SelectValueDialog
extends BaseDialog {
    private boolean multipleSelection = false;
    private org.eclipse.swt.widgets.List selectValueList = null;
    private int[] selectedIndices = null;
    private List modelValueList = new ArrayList();
    private List viewerValueList = new ArrayList();
    private ParamBindingHandle[] bindingParams = null;
    private final String nullValueDispaly = Messages.getString((String)"SelectValueDialog.SelectValue.NullValue");

    public SelectValueDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public ParamBindingHandle[] getBindingParams() {
        return this.bindingParams;
    }

    public void setBindingParams(ParamBindingHandle[] handles) {
        this.bindingParams = handles;
    }

    public void setSelectedValueList(Collection valueList) {
        this.modelValueList.clear();
        this.modelValueList.addAll(valueList);
    }

    public boolean isMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString((String)"SelectValueDialog.selectValue"));
        this.selectValueList = new org.eclipse.swt.widgets.List(composite, (this.isMultipleSelection() ? 2 : 4) | 0x200 | 0x100);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.selectValueList.setLayoutData((Object)data);
        this.selectValueList.add(Messages.getString((String)"SelectValueDialog.retrieving"));
        this.selectValueList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (SelectValueDialog.this.selectValueList.getSelectionCount() > 0) {
                    SelectValueDialog.this.okPressed();
                }
            }
        });
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SelectValueDialog.this.populateList();
            }
        });
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.SelectValueDialog_ID");
        return composite;
    }

    protected void okPressed() {
        this.selectedIndices = this.selectValueList.getSelectionIndices();
        this.setResult(this.selectValueList.getSelection());
        super.okPressed();
    }

    public String getSelectedValue() {
        String[] result = (String[])this.getResult();
        return result != null && result.length > 0 ? result[0] : null;
    }

    public String[] getSelectedValues() {
        String[] result = (String[])this.getResult();
        return result != null && result.length > 0 ? result : null;
    }

    public String getSelectedExprValue() {
        String exprValue = null;
        if (this.selectedIndices != null && this.selectedIndices.length > 0) {
            int firstIndex = this.selectedIndices[0];
            Object modelValue = this.modelValueList.get(firstIndex);
            if (modelValue == null) {
                return "null";
            }
            String viewerValue = (String)this.viewerValueList.get(firstIndex);
            exprValue = modelValue instanceof Boolean || modelValue instanceof Integer || modelValue instanceof Double ? viewerValue : (modelValue instanceof BigDecimal ? "new java.math.BigDecimal(\"" + viewerValue + "\")" : "\"" + JavascriptEvalUtil.transformToJsConstants((String)viewerValue) + "\"");
        }
        return exprValue;
    }

    public String[] getSelectedExprValues() {
        String[] exprValues = null;
        if (this.selectedIndices != null && this.selectedIndices.length > 0) {
            exprValues = new String[this.selectedIndices.length];
            int i = 0;
            while (i < this.selectedIndices.length) {
                int firstIndex = this.selectedIndices[i];
                Object modelValue = this.modelValueList.get(firstIndex);
                if (modelValue == null) {
                    exprValues[i] = "null";
                } else {
                    String viewerValue = (String)this.viewerValueList.get(firstIndex);
                    exprValues[i] = modelValue instanceof Boolean || modelValue instanceof Integer || modelValue instanceof Double ? viewerValue : (modelValue instanceof BigDecimal ? "new java.math.BigDecimal(\"" + viewerValue + "\")" : "\"" + JavascriptEvalUtil.transformToJsConstants((String)viewerValue) + "\"");
                }
                ++i;
            }
        }
        return exprValues;
    }

    private void populateList() {
        try {
            this.getOkButton().setEnabled(false);
            this.selectValueList.removeAll();
            this.viewerValueList.clear();
            if (this.modelValueList != null) {
                Iterator iter = this.modelValueList.iterator();
                DateFormatter formatter = new DateFormatter(ULocale.US);
                while (iter.hasNext()) {
                    Object candiateValue = iter.next();
                    if (candiateValue != null) {
                        String displayCandiateValue;
                        if (candiateValue instanceof Date) {
                            formatter.applyPattern("yyyy-MM-dd");
                            displayCandiateValue = formatter.format((java.util.Date)candiateValue);
                        } else if (candiateValue instanceof Time) {
                            formatter.applyPattern("HH:mm:ss.SSS");
                            displayCandiateValue = formatter.format((java.util.Date)candiateValue);
                        } else if (candiateValue instanceof java.util.Date) {
                            formatter.applyPattern("yyyy-MM-dd HH:mm:ss.SSS");
                            displayCandiateValue = formatter.format((java.util.Date)candiateValue);
                        } else {
                            displayCandiateValue = candiateValue;
                        }
                        this.viewerValueList.add(displayCandiateValue.toString());
                        this.selectValueList.add(displayCandiateValue.toString());
                        continue;
                    }
                    this.viewerValueList.add(null);
                    this.selectValueList.add(this.nullValueDispaly);
                }
            } else {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"SelectValueDialog.errorRetrievinglist"), Messages.getString((String)"SelectValueDialog.noExpressionSet"));
            }
            if (this.selectValueList.getItemCount() > 0) {
                this.selectValueList.select(0);
                this.getOkButton().setEnabled(true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }
}

