/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseTitleAreaDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionHelper;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VariableDialog
extends BaseTitleAreaDialog {
    private ReportDesignHandle designHandle;
    private VariableElementHandle variable;
    private Text nameTxt;
    private Text expressionTxt;
    private Button reportRadio;
    private Button pageRadio;
    private static final String EXPR_TYPE = "exprType";
    private IExpressionHelper helper;
    private Combo dataTypeCombo;
    private ExpressionButton expressionButton;

    public VariableDialog(String title, ReportDesignHandle designHandle, VariableElementHandle variable) {
        super(UIUtil.getDefaultShell());
        this.title = title;
        this.designHandle = designHandle;
        this.variable = variable;
        this.helper = new IExpressionHelper(){

            public String getExpression() {
                if (VariableDialog.this.expressionTxt != null) {
                    return VariableDialog.this.expressionTxt.getText();
                }
                return "";
            }

            public void setExpression(String expression) {
                if (VariableDialog.this.expressionTxt != null) {
                    VariableDialog.this.expressionTxt.setText(expression);
                }
            }

            public void notifyExpressionChangeEvent(String oldExpression, String newExpression) {
            }

            public IExpressionProvider getExpressionProvider() {
                ExpressionProvider provider = new ExpressionProvider((DesignElementHandle)VariableDialog.this.variable);
                provider.addFilter(new ExpressionFilter(){

                    public boolean select(Object parentElement, Object element) {
                        return !element.equals(VariableDialog.this.variable);
                    }
                });
                return provider;
            }

            public String getExpressionType() {
                return (String)VariableDialog.this.expressionTxt.getData(VariableDialog.EXPR_TYPE);
            }

            public void setExpressionType(String exprType) {
                VariableDialog.this.expressionTxt.setData(VariableDialog.EXPR_TYPE, (Object)exprType);
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(1808));
        content.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        new Label(content, 0).setText(Messages.getString((String)"VariableDialog.VariableType"));
        Composite typeChoices = new Composite(content, 0);
        typeChoices.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        this.reportRadio = new Button(typeChoices, 16);
        this.reportRadio.setText(Messages.getString((String)"VariableDialog.ReportVariable"));
        this.pageRadio = new Button(typeChoices, 16);
        this.pageRadio.setText(Messages.getString((String)"VariableDialog.PageVariable"));
        new Label(content, 0);
        new Label(content, 0).setText(Messages.getString((String)"VariableDialog.Name"));
        this.nameTxt = new Text(content, 2048);
        this.nameTxt.setLayoutData((Object)new GridData(768));
        this.nameTxt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VariableDialog.this.validate();
            }
        });
        new Label(content, 0);
        new Label(content, 0).setText(Messages.getString((String)"VariableDialog.DefaultValue"));
        this.expressionTxt = new Text(content, 2048);
        this.expressionTxt.setLayoutData((Object)new GridData(768));
        this.expressionButton = UIUtil.createExpressionButton(content, 8);
        this.expressionButton.setExpressionHelper(this.helper);
        return content;
    }

    protected boolean initDialog() {
        if (this.variable != null) {
            this.nameTxt.setText(this.variable.getName());
            if (this.variable.getType() == null || this.variable.getType().equals("report")) {
                this.reportRadio.setSelection(true);
            } else {
                this.pageRadio.setSelection(true);
            }
            ExpressionHandle expression = this.variable.getExpressionProperty("value");
            if (expression.getValue() != null) {
                this.expressionTxt.setText(expression.getValue().toString());
            }
            if (expression.getType() != null) {
                this.expressionTxt.setData(EXPR_TYPE, (Object)expression.getType());
            }
            this.expressionButton.refresh();
        } else {
            this.reportRadio.setSelection(true);
        }
        this.validate();
        return true;
    }

    protected void okPressed() {
        if (this.variable == null) {
            this.variable = DesignElementFactory.getInstance((ModuleHandle)this.designHandle).newVariableElement(this.nameTxt.getText());
            try {
                this.designHandle.add("pageVariables", (DesignElementHandle)this.variable);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
        try {
            this.variable.setVariableName(this.nameTxt.getText());
            if (this.reportRadio.getSelection()) {
                this.variable.setType("report");
            } else {
                this.variable.setType("page");
            }
            Expression expression = new Expression((Object)this.expressionTxt.getText(), (String)this.expressionTxt.getData(EXPR_TYPE));
            this.variable.setValue(this.expressionTxt.getText());
            this.variable.setExpressionProperty("value", expression);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        super.okPressed();
    }

    private String getDataTypeByDisplayName(String text, IChoiceSet datatypes) {
        IChoice[] iChoiceArray = datatypes.getChoices();
        int n = iChoiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IChoice choice = iChoiceArray[n2];
            if (choice.getDisplayName().equals(text)) {
                return choice.getName();
            }
            ++n2;
        }
        return null;
    }

    private String getDisplayNameByDataType(String text, IChoiceSet datatypes) {
        IChoice[] iChoiceArray = datatypes.getChoices();
        int n = iChoiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IChoice choice = iChoiceArray[n2];
            if (choice.getValue().equals(text)) {
                return choice.getDisplayName();
            }
            ++n2;
        }
        return null;
    }

    private void validate() {
        if (this.nameTxt.getText() == null || this.nameTxt.getText().equals("")) {
            this.getOkButton().setEnabled(false);
        } else if (this.isNameDuplicated(this.nameTxt.getText())) {
            this.setErrorMessage(Messages.getFormattedString((String)"VariableDialog.Error.NameDuplicate", (Object[])new String[]{this.nameTxt.getText()}));
            this.getOkButton().setEnabled(false);
        } else {
            this.setErrorMessage(null);
            this.getOkButton().setEnabled(true);
        }
    }

    private boolean isNameDuplicated(String text) {
        if (this.variable != null && this.variable.getName().equals(text)) {
            return false;
        }
        for (VariableElementHandle veh : this.designHandle.getPageVariables()) {
            if (!veh.getName().equals(text)) continue;
            return true;
        }
        return false;
    }
}

