/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.CubeQueryUtil;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.AbstractBindingDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.CrosstabAggregationExpressionProvider;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.CrosstabBindingExpressionProvider;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.AggregationArgument;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrosstabBindingDialogHelper
extends AbstractBindingDialogHelper {
    protected static final String NAME = Messages.getString((String)"BindingDialogHelper.text.Name");
    protected static final String DATA_TYPE = Messages.getString((String)"BindingDialogHelper.text.DataType");
    protected static final String FUNCTION = Messages.getString((String)"BindingDialogHelper.text.Function");
    protected static final String DATA_FIELD = Messages.getString((String)"BindingDialogHelper.text.DataField");
    protected static final String FILTER_CONDITION = Messages.getString((String)"BindingDialogHelper.text.Filter");
    protected static final String AGGREGATE_ON = Messages.getString((String)"BindingDialogHelper.text.AggOn");
    protected static final String EXPRESSION = Messages.getString((String)"BindingDialogHelper.text.Expression");
    protected static final String ALL = Messages.getString((String)"CrosstabBindingDialogHelper.AggOn.All");
    protected static final String DISPLAY_NAME = Messages.getString((String)"BindingDialogHelper.text.displayName");
    protected static final String DEFAULT_ITEM_NAME = Messages.getString((String)"BindingDialogHelper.bindingName.dataitem");
    protected static final String DEFAULT_AGGREGATION_NAME = Messages.getString((String)"BindingDialogHelper.bindingName.aggregation");
    protected static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices();
    protected static final IChoice[] DATA_TYPE_CHOICES = DATA_TYPE_CHOICE_SET.getChoices(null);
    protected String[] dataTypes = ChoiceSetFactory.getDisplayNamefromChoiceSet((IChoiceSet)DATA_TYPE_CHOICE_SET);
    private Text txtName;
    private Text txtFilter;
    private Text txtExpression;
    private Combo cmbType;
    private Combo cmbFunction;
    private Combo cmbAggOn;
    private Composite paramsComposite;
    private Map<String, Control> paramsMap = new HashMap<String, Control>();
    private Map<String, String> paramsValueMap = new HashMap<String, String>();
    private Composite composite;
    private Text txtDisplayName;
    private ComputedColumn newBinding;
    private CLabel messageLine;
    private Label lbName;
    private Object container;

    public void createContent(Composite parent) {
        this.composite = parent;
        ((GridLayout)this.composite.getLayout()).numColumns = 3;
        this.lbName = new Label(this.composite, 0);
        this.lbName.setText(NAME);
        this.txtName = new Text(this.composite, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 250;
        this.txtName.setLayoutData((Object)gd);
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabBindingDialogHelper.this.validate();
            }
        });
        new Label(this.composite, 0).setText(DISPLAY_NAME);
        this.txtDisplayName = new Text(this.composite, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.txtDisplayName.setLayoutData((Object)gd);
        new Label(this.composite, 0).setText(DATA_TYPE);
        this.cmbType = new Combo(this.composite, 2056);
        this.cmbType.setLayoutData((Object)gd);
        if (this.isAggregate()) {
            this.createAggregateSection(this.composite);
        } else {
            this.createCommonSection(this.composite);
        }
        this.createMessageSection(this.composite);
        gd = new GridData(1808);
        this.composite.setLayoutData((Object)gd);
        this.setContentSize(this.composite);
    }

    public void initDialog() {
        this.cmbType.setItems(this.dataTypes);
        if (this.isAggregate()) {
            this.initFunction();
            this.initFilter();
            this.initAggOn();
        }
        if (this.getBinding() == null) {
            this.setTypeSelect(this.dataTypes[0]);
            this.newBinding = StructureFactory.newComputedColumn((DesignElementHandle)this.getBindingHolder(), (String)(this.isAggregate() ? DEFAULT_AGGREGATION_NAME : DEFAULT_ITEM_NAME));
            this.setName(this.newBinding.getName());
        } else {
            this.setName(this.getBinding().getName());
            this.setDisplayName(this.getBinding().getDisplayName());
            if (this.getBinding().getDataType() != null) {
                if (DATA_TYPE_CHOICE_SET.findChoice(this.getBinding().getDataType()) != null) {
                    this.setTypeSelect(DATA_TYPE_CHOICE_SET.findChoice(this.getBinding().getDataType()).getDisplayName());
                } else {
                    this.cmbType.setText("");
                }
            }
            if (this.getBinding().getExpression() != null) {
                this.setDataFieldExpression(this.getBinding().getExpression());
            }
        }
        if (this.getBinding() != null) {
            this.txtName.setEnabled(false);
        }
        this.validate();
    }

    private void initAggOn() {
        try {
            AggregationCellHandle cellHandle;
            CrosstabReportItemHandle xtabHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)this.getBindingHolder()).getReportItem();
            String[] aggOns = this.getAggOns(xtabHandle);
            this.cmbAggOn.setItems(aggOns);
            String aggstr = "";
            if (this.getBinding() != null) {
                List aggOnList = this.getBinding().getAggregateOnList();
                int i = 0;
                Iterator iterator = aggOnList.iterator();
                while (iterator.hasNext()) {
                    if (i > 0) {
                        aggstr = String.valueOf(aggstr) + ",";
                    }
                    String name = (String)iterator.next();
                    aggstr = String.valueOf(aggstr) + name;
                    ++i;
                }
            } else if (this.getDataItemContainer() instanceof AggregationCellHandle) {
                cellHandle = (AggregationCellHandle)this.getDataItemContainer();
                if (cellHandle.getAggregationOnRow() != null) {
                    aggstr = String.valueOf(aggstr) + cellHandle.getAggregationOnRow().getFullName();
                    if (cellHandle.getAggregationOnColumn() != null) {
                        aggstr = String.valueOf(aggstr) + ",";
                    }
                }
                if (cellHandle.getAggregationOnColumn() != null) {
                    aggstr = String.valueOf(aggstr) + cellHandle.getAggregationOnColumn().getFullName();
                }
            } else if (this.container instanceof AggregationCellHandle) {
                cellHandle = (AggregationCellHandle)this.container;
                if (cellHandle.getAggregationOnRow() != null) {
                    aggstr = String.valueOf(aggstr) + cellHandle.getAggregationOnRow().getFullName();
                    if (cellHandle.getAggregationOnColumn() != null) {
                        aggstr = String.valueOf(aggstr) + ",";
                    }
                }
                if (cellHandle.getAggregationOnColumn() != null) {
                    aggstr = String.valueOf(aggstr) + cellHandle.getAggregationOnColumn().getFullName();
                }
            }
            int j = 0;
            while (j < aggOns.length) {
                if (aggOns[j].equals(aggstr)) {
                    this.cmbAggOn.select(j);
                    return;
                }
                ++j;
            }
            this.cmbAggOn.select(0);
        }
        catch (ExtendedElementException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private String[] getAggOns(CrosstabReportItemHandle xtabHandle) {
        List rowLevelList = this.getCrosstabViewHandleLevels(xtabHandle, 0);
        List columnLevelList = this.getCrosstabViewHandleLevels(xtabHandle, 1);
        ArrayList<String> aggOnList = new ArrayList<String>();
        aggOnList.add(ALL);
        for (String name : rowLevelList) {
            aggOnList.add(name);
        }
        for (String name : columnLevelList) {
            aggOnList.add(name);
        }
        for (String name : rowLevelList) {
            for (String name2 : columnLevelList) {
                aggOnList.add(String.valueOf(name) + "," + name2);
            }
        }
        return aggOnList.toArray(new String[aggOnList.size()]);
    }

    private List getCrosstabViewHandleLevels(CrosstabReportItemHandle xtab, int type) {
        ArrayList<String> levelList = new ArrayList<String>();
        CrosstabViewHandle viewHandle = xtab.getCrosstabView(type);
        if (viewHandle != null) {
            int dimensions = viewHandle.getDimensionCount();
            int i = 0;
            while (i < dimensions) {
                DimensionViewHandle dimension = viewHandle.getDimension(i);
                int levels = dimension.getLevelCount();
                int j = 0;
                while (j < levels) {
                    LevelViewHandle level = dimension.getLevel(j);
                    levelList.add(level.getCubeLevel().getFullName());
                    ++j;
                }
                ++i;
            }
        }
        return levelList;
    }

    private void initFilter() {
        if (this.binding != null && this.binding.getFilterExpression() != null) {
            this.txtFilter.setText(this.binding.getFilterExpression());
        }
    }

    private void initFunction() {
        this.cmbFunction.setItems(this.getFunctionDisplayNames());
        if (this.binding == null) {
            this.cmbFunction.select(0);
            this.handleFunctionSelectEvent();
            return;
        }
        try {
            String functionString = this.getFunctionDisplayName(DataAdapterUtil.adaptModelAggregationType((String)this.binding.getAggregateFunction()));
            int itemIndex = this.getItemIndex(this.getFunctionDisplayNames(), functionString);
            this.cmbFunction.select(itemIndex);
            this.handleFunctionSelectEvent();
        }
        catch (AdapterException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        Iterator iterator = this.binding.argumentsIterator();
        while (iterator.hasNext()) {
            AggregationArgumentHandle arg = (AggregationArgumentHandle)iterator.next();
            String argName = DataAdapterUtil.adaptArgumentName((String)arg.getName());
            if (!this.paramsMap.containsKey(argName) || arg.getValue() == null) continue;
            Control control = this.paramsMap.get(argName);
            if (control instanceof Text) {
                ((Text)control).setText(arg.getValue());
                continue;
            }
            if (!(control instanceof Combo)) continue;
            ((Combo)control).setText(arg.getValue());
        }
    }

    private String[] getFunctionDisplayNames() {
        IAggrFunction[] choices = this.getFunctions();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        return displayNames;
    }

    private IAggrFunction getFunctionByDisplayName(String displayName) {
        IAggrFunction[] choices = this.getFunctions();
        if (choices == null) {
            return null;
        }
        int i = 0;
        while (i < choices.length) {
            if (choices[i].getDisplayName().equals(displayName)) {
                return choices[i];
            }
            ++i;
        }
        return null;
    }

    private String getFunctionDisplayName(String function) {
        try {
            return DataUtil.getAggregationManager().getAggregation(function).getDisplayName();
        }
        catch (BirtException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    private IAggrFunction[] getFunctions() {
        try {
            List aggrInfoList = DataUtil.getAggregationManager().getAggregations(1);
            return aggrInfoList.toArray(new IAggrFunction[0]);
        }
        catch (BirtException e) {
            ExceptionHandler.handle((Throwable)e);
            return new IAggrFunction[0];
        }
    }

    private String getDataTypeDisplayName(String dataType) {
        int i = 0;
        while (i < DATA_TYPE_CHOICES.length) {
            if (dataType.equals(DATA_TYPE_CHOICES[i].getName())) {
                return DATA_TYPE_CHOICES[i].getDisplayName();
            }
            ++i;
        }
        return "";
    }

    private void initTextField(Text txtParam, IParameterDefn param) {
        if (this.paramsValueMap.containsKey(param.getName())) {
            txtParam.setText(this.paramsValueMap.get(param.getName()));
            return;
        }
        if (this.binding != null) {
            Iterator iterator = this.binding.argumentsIterator();
            while (iterator.hasNext()) {
                AggregationArgumentHandle arg = (AggregationArgumentHandle)iterator.next();
                if (!arg.getName().equals(param.getName())) continue;
                if (arg.getValue() != null) {
                    txtParam.setText(arg.getValue());
                }
                return;
            }
        }
    }

    private void initDataFields(Combo cmbDataField, IParameterDefn param) {
        List<String> datas = this.getMesures();
        datas.addAll(this.getDatas());
        String[] items = datas.toArray(new String[datas.size()]);
        cmbDataField.setItems(items);
        if (this.paramsValueMap.containsKey(param.getName())) {
            cmbDataField.setText(this.paramsValueMap.get(param.getName()));
            return;
        }
        if (this.binding != null) {
            Iterator iterator = this.binding.argumentsIterator();
            while (iterator.hasNext()) {
                AggregationArgumentHandle arg = (AggregationArgumentHandle)iterator.next();
                if (!arg.getName().equals(param.getName()) || arg.getValue() == null) continue;
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(arg.getValue())) {
                        cmbDataField.select(i);
                        break;
                    }
                    ++i;
                }
                return;
            }
            if (this.binding.getExpression() != null) {
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(this.binding.getExpression())) {
                        cmbDataField.select(i);
                    }
                    ++i;
                }
            }
        }
    }

    private List<String> getMesures() {
        ArrayList<String> measures = new ArrayList<String>();
        try {
            CrosstabReportItemHandle xtabHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)this.getBindingHolder()).getReportItem();
            measures.add("");
            int i = 0;
            while (i < xtabHandle.getMeasureCount()) {
                MeasureViewHandle mv = xtabHandle.getMeasure(i);
                if (!(mv instanceof ComputedMeasureViewHandle)) {
                    measures.add(DEUtil.getExpression((Object)mv.getCubeMeasure()));
                }
                ++i;
            }
        }
        catch (ExtendedElementException extendedElementException) {}
        return measures;
    }

    private List<String> getDatas() {
        ArrayList<String> datas = new ArrayList<String>();
        try {
            CrosstabReportItemHandle xtabHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)this.getBindingHolder()).getReportItem();
            try {
                IBinding[] aggregateBindings;
                IBinding[] iBindingArray = aggregateBindings = CubeQueryUtil.getAggregationBindings((IBinding[])this.getCrosstabBindings(xtabHandle));
                int n = aggregateBindings.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinding binding = iBindingArray[n2];
                    if (this.getBinding() == null || !this.getBinding().getName().equals(binding.getBindingName())) {
                        datas.add(ExpressionUtil.createJSDataExpression((String)binding.getBindingName()));
                    }
                    ++n2;
                }
            }
            catch (AdapterException adapterException) {
            }
            catch (BirtException birtException) {}
        }
        catch (ExtendedElementException extendedElementException) {}
        return datas;
    }

    private IBinding[] getCrosstabBindings(CrosstabReportItemHandle xtabHandle) throws BirtException {
        Iterator bindingItr = ((ExtendedItemHandle)xtabHandle.getModelHandle()).columnBindingsIterator();
        ModuleHandle module = ((ExtendedItemHandle)xtabHandle.getModelHandle()).getModuleHandle();
        ArrayList<Binding> bindingList = new ArrayList<Binding>();
        if (bindingItr != null) {
            HashMap cache = new HashMap();
            ArrayList rowLevelNameList = new ArrayList();
            ArrayList columnLevelNameList = new ArrayList();
            while (bindingItr.hasNext()) {
                ComputedColumnHandle column = (ComputedColumnHandle)bindingItr.next();
                Binding binding = new Binding(column.getName());
                binding.setAggrFunction(column.getAggregateFunction() == null ? null : DataAdapterUtil.adaptModelAggregationType((String)column.getAggregateFunction()));
                binding.setExpression((IBaseExpression)(column.getExpression() == null ? null : new ScriptExpression(column.getExpression())));
                binding.setDataType(DataAdapterUtil.adaptModelDataType((String)column.getDataType()));
                if (column.getFilterExpression() != null) {
                    binding.setFilter((IBaseExpression)new ScriptExpression(column.getFilterExpression()));
                }
                Iterator argItr = column.argumentsIterator();
                while (argItr.hasNext()) {
                    AggregationArgumentHandle aah = (AggregationArgumentHandle)argItr.next();
                    if (aah.getValue() == null) continue;
                    binding.addArgument((IBaseExpression)new ScriptExpression(aah.getValue()));
                }
                List aggrList = column.getAggregateOnList();
                if (aggrList != null) {
                    for (String baseLevel : aggrList) {
                        CrosstabUtil.addHierachyAggregateOn((ModuleHandle)module, (Binding)binding, (String)baseLevel, rowLevelNameList, columnLevelNameList, cache);
                    }
                }
                bindingList.add(binding);
            }
        }
        return bindingList.toArray(new IBinding[bindingList.size()]);
    }

    private void setDataFieldExpression(String expression) {
        if (expression != null && this.txtExpression != null && !this.txtExpression.isDisposed()) {
            this.txtExpression.setText(expression);
        }
    }

    private void setName(String name) {
        if (name != null && this.txtName != null) {
            this.txtName.setText(name);
        }
    }

    private void setDisplayName(String displayName) {
        if (displayName != null && this.txtDisplayName != null) {
            this.txtDisplayName.setText(displayName);
        }
    }

    private void setTypeSelect(String typeSelect) {
        if (this.cmbType != null) {
            if (typeSelect != null) {
                this.cmbType.select(this.getItemIndex(this.cmbType.getItems(), typeSelect));
            } else {
                this.cmbType.select(0);
            }
        }
    }

    private int getItemIndex(String[] items, String item) {
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createAggregateSection(Composite composite) {
        new Label(composite, 0).setText(FUNCTION);
        this.cmbFunction = new Combo(composite, 2056);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.cmbFunction.setLayoutData((Object)gd);
        this.cmbFunction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CrosstabBindingDialogHelper.this.handleFunctionSelectEvent();
                CrosstabBindingDialogHelper.this.validate();
            }
        });
        this.paramsComposite = new Composite(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.exclude = true;
        this.paramsComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        this.paramsComposite.setLayout((Layout)layout);
        new Label(composite, 0).setText(FILTER_CONDITION);
        this.txtFilter = new Text(composite, 2048);
        gridData = new GridData(768);
        this.txtFilter.setLayoutData((Object)gridData);
        this.createExpressionButton(composite, this.txtFilter);
        Label lblAggOn = new Label(composite, 0);
        lblAggOn.setText(AGGREGATE_ON);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        lblAggOn.setLayoutData((Object)gridData);
        this.cmbAggOn = new Combo(composite, 2056);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.cmbAggOn.setLayoutData((Object)gridData);
    }

    private void createCommonSection(Composite composite) {
        new Label(composite, 0).setText(EXPRESSION);
        this.txtExpression = new Text(composite, 2048);
        this.txtExpression.setLayoutData((Object)new GridData(768));
        this.createExpressionButton(composite, this.txtExpression);
        this.txtExpression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabBindingDialogHelper.this.validate();
            }
        });
    }

    private void createMessageSection(Composite composite) {
        this.messageLine = new CLabel(composite, 16384);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        this.messageLine.setLayoutData((Object)layoutData);
    }

    protected void handleFunctionSelectEvent() {
        Control[] children = this.paramsComposite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        IAggrFunction function = this.getFunctionByDisplayName(this.cmbFunction.getText());
        if (function != null) {
            this.paramsMap.clear();
            IParameterDefn[] params = function.getParameterDefn();
            if (params.length > 0) {
                ((GridData)this.paramsComposite.getLayoutData()).exclude = false;
                ((GridData)this.paramsComposite.getLayoutData()).heightHint = -1;
                IParameterDefn[] iParameterDefnArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    final IParameterDefn param = iParameterDefnArray[n2];
                    Label lblParam = new Label(this.paramsComposite, 0);
                    lblParam.setText(String.valueOf(param.getDisplayName()) + ":");
                    GridData gd = new GridData();
                    gd.widthHint = this.lbName.getBounds().width - this.lbName.getBorderWidth();
                    lblParam.setLayoutData((Object)gd);
                    if (param.isDataField()) {
                        final Combo cmbDataField = new Combo(this.paramsComposite, 2048);
                        cmbDataField.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
                        this.initDataFields(cmbDataField, param);
                        cmbDataField.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                CrosstabBindingDialogHelper.this.validate();
                                CrosstabBindingDialogHelper.this.paramsValueMap.put(param.getName(), cmbDataField.getText());
                            }
                        });
                        this.paramsMap.put(param.getName(), (Control)cmbDataField);
                    } else {
                        final Text txtParam = new Text(this.paramsComposite, 2048);
                        this.initTextField(txtParam, param);
                        txtParam.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                CrosstabBindingDialogHelper.this.validate();
                                CrosstabBindingDialogHelper.this.paramsValueMap.put(param.getName(), txtParam.getText());
                            }
                        });
                        GridData gridData = new GridData(768);
                        gridData.horizontalIndent = 0;
                        txtParam.setLayoutData((Object)gridData);
                        this.createExpressionButton(this.paramsComposite, txtParam);
                        this.paramsMap.put(param.getName(), (Control)txtParam);
                    }
                    ++n2;
                }
            } else {
                ((GridData)this.paramsComposite.getLayoutData()).heightHint = 0;
            }
            try {
                this.cmbType.setText(this.getDataTypeDisplayName(DataAdapterUtil.adapterToModelDataType((int)DataUtil.getAggregationManager().getAggregation(function.getName()).getDataType())));
            }
            catch (BirtException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            ((GridData)this.paramsComposite.getLayoutData()).heightHint = 0;
            ((GridData)this.paramsComposite.getLayoutData()).exclude = true;
        }
        this.composite.layout(true, true);
        this.setContentSize(this.composite);
    }

    private void createExpressionButton(Composite parent, final Text text) {
        Button expressionButton = new Button(parent, 8);
        if (this.expressionProvider == null) {
            this.expressionProvider = this.isAggregate() ? new CrosstabAggregationExpressionProvider((DesignElementHandle)this.bindingHolder, this.binding) : new CrosstabBindingExpressionProvider((DesignElementHandle)this.bindingHolder, this.binding);
        }
        UIUtil.setExpressionButtonImage((Button)expressionButton);
        expressionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder expression = new ExpressionBuilder(text.getText());
                expression.setExpressionProvier((IExpressionProvider)CrosstabBindingDialogHelper.this.expressionProvider);
                if (expression.open() == 0 && expression.getResult() != null) {
                    text.setText(expression.getResult());
                }
            }
        });
    }

    private String getArgumentDisplayNameByName(String functionName, String argument) {
        try {
            IAggrFunction function = DataUtil.getAggregationManager().getAggregation(functionName);
            IParameterDefn[] iParameterDefnArray = function.getParameterDefn();
            int n = iParameterDefnArray.length;
            int n2 = 0;
            while (n2 < n) {
                IParameterDefn param = iParameterDefnArray[n2];
                if (param.getName().equals(argument)) {
                    return param.getDisplayName();
                }
                ++n2;
            }
        }
        catch (BirtException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public void validate() {
        if (this.txtName != null && (this.txtName.getText() == null || this.txtName.getText().trim().equals(""))) {
            this.dialog.setCanFinish(false);
        } else if (this.txtExpression != null && (this.txtExpression.getText() == null || this.txtExpression.getText().trim().equals(""))) {
            this.dialog.setCanFinish(false);
        } else {
            IParameterDefn param;
            int n;
            int n2;
            IParameterDefn[] iParameterDefnArray;
            IAggrFunction function;
            IParameterDefn[] params;
            if (this.binding == null) {
                for (ComputedColumnHandle computedColumn : this.bindingHolder.getColumnBindings()) {
                    if (!computedColumn.getName().equals(this.txtName.getText())) continue;
                    this.dialog.setCanFinish(false);
                    this.messageLine.setText(Messages.getFormattedString((String)"BindingDialogHelper.error.nameduplicate", (Object[])new Object[]{this.txtName.getText()}));
                    this.messageLine.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
                    return;
                }
            }
            if (this.isAggregate() && (params = (function = this.getFunctionByDisplayName(this.cmbFunction.getText())).getParameterDefn()).length > 0) {
                iParameterDefnArray = params;
                n2 = params.length;
                n = 0;
                while (n < n2) {
                    param = iParameterDefnArray[n];
                    if (param.isDataField()) {
                        Combo cmbDataField = (Combo)this.paramsMap.get(param.getName());
                        String expression = cmbDataField.getText();
                        DataRequestSession session = null;
                        try {
                            session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
                            if (session.getCubeQueryUtil().getReferencedMeasureName(expression) != null && function.getType() == 1) {
                                this.dialog.setCanFinish(false);
                                this.messageLine.setText(Messages.getFormattedString((String)"BindingDialogHelper.error.improperexpression", (Object[])new Object[]{function.getName()}));
                                this.messageLine.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
                                return;
                            }
                        }
                        catch (BirtException birtException) {
                        }
                        finally {
                            if (session != null) {
                                session.shutdown();
                            }
                        }
                    }
                    ++n;
                }
            }
            this.dialog.setCanFinish(true);
            this.messageLine.setText("");
            this.messageLine.setImage(null);
            if (this.txtExpression != null && (this.txtExpression.getText() == null || this.txtExpression.getText().trim().equals(""))) {
                this.dialog.setCanFinish(false);
                return;
            }
            if (this.isAggregate()) {
                try {
                    IAggrFunction aggregation = DataUtil.getAggregationManager().getAggregation(this.getFunctionByDisplayName(this.cmbFunction.getText()).getName());
                    if (aggregation.getParameterDefn().length > 0) {
                        IParameterDefn[] parameters;
                        iParameterDefnArray = parameters = aggregation.getParameterDefn();
                        n2 = parameters.length;
                        n = 0;
                        while (n < n2) {
                            String paramValue;
                            param = iParameterDefnArray[n];
                            if (!param.isOptional() && ((paramValue = this.getControlValue(this.paramsMap.get(param.getName()))) == null || paramValue.trim().equals(""))) {
                                this.dialog.setCanFinish(false);
                                return;
                            }
                            ++n;
                        }
                    }
                }
                catch (BirtException birtException) {}
            }
            this.dialog.setCanFinish(true);
        }
    }

    public boolean differs(ComputedColumnHandle binding) {
        if (this.isAggregate()) {
            if (!this.strEquals(binding.getName(), this.txtName.getText())) {
                return true;
            }
            if (!this.strEquals(binding.getDisplayName(), this.txtDisplayName.getText())) {
                return true;
            }
            if (!this.strEquals(binding.getDataType(), this.getDataType())) {
                return true;
            }
            try {
                if (!this.strEquals(DataAdapterUtil.adaptModelAggregationType((String)binding.getAggregateFunction()), this.getFunctionByDisplayName(this.cmbFunction.getText()).getName())) {
                    return true;
                }
            }
            catch (AdapterException adapterException) {}
            if (!this.strEquals(binding.getFilterExpression(), this.txtFilter.getText())) {
                return true;
            }
            if (!this.strEquals(this.cmbAggOn.getText(), DEUtil.getAggregateOn((ComputedColumnHandle)binding))) {
                return true;
            }
            IAggrFunction function = this.getFunctionByDisplayName(this.cmbFunction.getText());
            if (function != null) {
                IParameterDefn[] params;
                IParameterDefn[] iParameterDefnArray = params = function.getParameterDefn();
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    IParameterDefn param = iParameterDefnArray[n2];
                    if (this.paramsMap.containsKey(param.getName())) {
                        String paramValue = this.getControlValue(this.paramsMap.get(param.getName()));
                        Iterator iterator = binding.argumentsIterator();
                        while (iterator.hasNext()) {
                            AggregationArgumentHandle handle = (AggregationArgumentHandle)iterator.next();
                            if (!param.getName().equals(handle.getName()) || this.strEquals(handle.getValue(), paramValue)) continue;
                            return true;
                        }
                        if (param.isDataField() && binding.getExpression() != null && !this.strEquals(binding.getExpression(), paramValue)) {
                            return true;
                        }
                    }
                    ++n2;
                }
            }
        } else {
            if (!this.strEquals(this.txtName.getText(), binding.getName())) {
                return true;
            }
            if (!this.strEquals(this.txtDisplayName.getText(), binding.getDisplayName())) {
                return true;
            }
            if (!this.strEquals(this.getDataType(), binding.getDataType())) {
                return true;
            }
            if (!this.strEquals(this.txtExpression.getText(), binding.getExpression())) {
                return true;
            }
        }
        return false;
    }

    private String getControlValue(Control control) {
        if (control instanceof Text) {
            return ((Text)control).getText();
        }
        if (control instanceof Combo) {
            return ((Combo)control).getText();
        }
        return null;
    }

    private boolean strEquals(String left, String right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return "".equals(right);
        }
        if (right == null) {
            return "".equals(left);
        }
        return left.equals(right);
    }

    private String getDataType() {
        int i = 0;
        while (i < DATA_TYPE_CHOICES.length) {
            if (DATA_TYPE_CHOICES[i].getDisplayName().equals(this.cmbType.getText())) {
                return DATA_TYPE_CHOICES[i].getName();
            }
            ++i;
        }
        return "";
    }

    public ComputedColumnHandle editBinding(ComputedColumnHandle binding) throws SemanticException {
        if (this.isAggregate()) {
            binding.setDisplayName(this.txtDisplayName.getText());
            int i = 0;
            while (i < DATA_TYPE_CHOICES.length) {
                if (DATA_TYPE_CHOICES[i].getDisplayName().equals(this.cmbType.getText())) {
                    binding.setDataType(DATA_TYPE_CHOICES[i].getName());
                    break;
                }
                ++i;
            }
            binding.setAggregateFunction(this.getFunctionByDisplayName(this.cmbFunction.getText()).getName());
            binding.setFilterExpression(this.txtFilter.getText());
            binding.clearAggregateOnList();
            String aggStr = this.cmbAggOn.getText();
            StringTokenizer token = new StringTokenizer(aggStr, ",");
            while (token.hasMoreTokens()) {
                String agg = token.nextToken();
                if (agg.equals(ALL)) continue;
                binding.addAggregateOn(agg);
            }
            binding.setExpression(null);
            binding.clearArgumentList();
            for (String arg : this.paramsMap.keySet()) {
                String value = this.getControlValue(this.paramsMap.get(arg));
                if (value == null) continue;
                AggregationArgument argHandle = StructureFactory.createAggregationArgument();
                argHandle.setName(arg);
                argHandle.setValue(value);
                binding.addArgument(argHandle);
            }
        } else {
            int i = 0;
            while (i < DATA_TYPE_CHOICES.length) {
                if (DATA_TYPE_CHOICES[i].getDisplayName().equals(this.cmbType.getText())) {
                    binding.setDataType(DATA_TYPE_CHOICES[i].getName());
                    break;
                }
                ++i;
            }
            binding.setDisplayName(this.txtDisplayName.getText());
            binding.setExpression(this.txtExpression.getText());
        }
        return binding;
    }

    public ComputedColumnHandle newBinding(ReportItemHandle bindingHolder, String name) throws SemanticException {
        ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)bindingHolder, (String)(name == null ? this.txtName.getText() : name));
        ComputedColumnHandle binding = DEUtil.addColumn((DesignElementHandle)bindingHolder, (ComputedColumn)column, (boolean)true);
        return this.editBinding(binding);
    }

    public void setContainer(Object container) {
        this.container = container;
    }

    public boolean canProcessAggregation() {
        return true;
    }
}

