/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SelectValueDialog
extends BaseDialog {
    private boolean multipleSelection = false;
    private org.eclipse.swt.widgets.List selectValueList = null;
    private int[] selectedIndices = null;
    private List modelValueList = new ArrayList();
    private List viewerValueList = new ArrayList();

    public SelectValueDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public void setSelectedValueList(Collection valueList) {
        this.modelValueList.clear();
        this.modelValueList.addAll(valueList);
    }

    public boolean isMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("SelectValueDialog.selectValue"));
        this.selectValueList = new org.eclipse.swt.widgets.List(composite, this.isMultipleSelection() ? 2 : 772);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.selectValueList.setLayoutData((Object)data);
        this.selectValueList.add(Messages.getString("SelectValueDialog.retrieving"));
        this.selectValueList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (SelectValueDialog.this.selectValueList.getSelectionCount() > 0) {
                    SelectValueDialog.this.okPressed();
                }
            }
        });
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SelectValueDialog.this.populateList();
            }
        });
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.CrossTabFilterSelectValueDialog_ID");
        return composite;
    }

    protected void okPressed() {
        this.selectedIndices = this.selectValueList.getSelectionIndices();
        this.setResult(this.selectValueList.getSelection());
        super.okPressed();
    }

    public String getSelectedValue() {
        String[] result = (String[])this.getResult();
        return result != null && result.length > 0 ? result[0] : null;
    }

    public String[] getSelectedValues() {
        String[] result = (String[])this.getResult();
        return result != null && result.length > 0 ? result : null;
    }

    public String getSelectedExprValue() {
        String exprValue = null;
        if (this.selectedIndices != null && this.selectedIndices.length > 0) {
            String viewerValue;
            int firstIndex = this.selectedIndices[0];
            exprValue = viewerValue = (String)this.viewerValueList.get(firstIndex);
        }
        return exprValue;
    }

    private void populateList() {
        try {
            this.getOkButton().setEnabled(false);
            this.selectValueList.removeAll();
            this.viewerValueList.clear();
            if (this.modelValueList != null) {
                for (Object candiateValue : this.modelValueList) {
                    if (candiateValue == null) continue;
                    this.viewerValueList.add(candiateValue.toString());
                    this.selectValueList.add(candiateValue.toString());
                }
            } else {
                ExceptionHandler.openErrorMessageBox((String)Messages.getString("SelectValueDialog.errorRetrievinglist"), (String)Messages.getString("SelectValueDialog.noExpressionSet"));
            }
            if (this.selectValueList.getItemCount() > 0) {
                this.selectValueList.select(0);
                this.getOkButton().setEnabled(true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }
}

