/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dnd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.designer.core.commands.CreateCommand;
import org.eclipse.birt.report.designer.core.model.LibRootModel;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDropAdapter;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ReportCreationTool;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class CubeDropAdapter
implements IDropAdapter {
    public int canDrop(Object transfer, Object target, int operation, DNDLocation location) {
        DesignElementHandle targetHandle;
        Object model;
        IStructuredSelection models;
        SlotHandle targetSlot;
        if (target != null && transfer instanceof TabularCubeHandle && ((targetSlot = this.getTargetSlotHandle(target, "Crosstab")) != null ? DNDUtil.handleValidateTargetCanContainType((Object)targetSlot, (String)"Crosstab") && DNDUtil.handleValidateTargetCanContainMore((Object)targetSlot, (int)0) : !(models = InsertInLayoutUtil.editPart2Model((ISelection)new StructuredSelection(target))).isEmpty() && (model = DNDUtil.unwrapToModel((Object)models.getFirstElement())) instanceof DesignElementHandle && (targetHandle = (DesignElementHandle)model).canContain(DEUtil.getDefaultContentName((Object)targetHandle), "Crosstab"))) {
            return 1;
        }
        return 0;
    }

    private SlotHandle getTargetSlotHandle(Object target, String insertType) {
        IStructuredSelection models = InsertInLayoutUtil.editPart2Model((ISelection)new StructuredSelection(target));
        if (models.isEmpty()) {
            return null;
        }
        Object model = DNDUtil.unwrapToModel((Object)models.getFirstElement());
        if (model instanceof LibRootModel) {
            model = ((LibRootModel)model).getModel();
        }
        if (model instanceof SlotHandle) {
            return (SlotHandle)model;
        }
        if (model instanceof DesignElementHandle) {
            int slotId;
            DesignElementHandle handle = (DesignElementHandle)model;
            if (handle.getDefn().isContainer() && handle.canContain(slotId = DEUtil.getDefaultSlotID((Object)handle), insertType)) {
                return handle.getSlot(slotId);
            }
            return handle.getContainerSlotHandle();
        }
        return null;
    }

    public boolean performDrop(Object transfer, Object target, int operation, DNDLocation location) {
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans("Create crosstab from Cube");
        TabularCubeHandle cube = (TabularCubeHandle)transfer;
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (cube.getModuleHandle() != moduleHandle && cube.getRoot() instanceof LibraryHandle) {
            try {
                UIUtil.includeLibrary((ModuleHandle)moduleHandle, (LibraryHandle)((LibraryHandle)cube.getRoot()));
                cube = (TabularCubeHandle)moduleHandle.getElementFactory().newElementFrom((DesignElementHandle)cube, cube.getName());
                moduleHandle.getCubes().add((DesignElementHandle)cube);
            }
            catch (Exception exception) {
                stack.rollback();
                return false;
            }
        }
        ExtendedItemHandle handle = null;
        String name = ReportPlugin.getDefault().getCustomName("Crosstab");
        try {
            handle = CrosstabExtendedItemFactory.createCrosstabReportItem((ModuleHandle)SessionHandleAdapter.getInstance().getReportDesignHandle(), null, (String)name);
        }
        catch (Exception exception) {
            stack.rollback();
            return false;
        }
        if (target instanceof EditPart) {
            EditPartViewer viewer = ((EditPart)target).getViewer();
            EditPart editPart = (EditPart)target;
            if (editPart != null) {
                try {
                    CreateRequest request = new CreateRequest();
                    request.getExtendedData().put("newObject", handle);
                    request.setLocation(location.getPoint());
                    Command command = editPart.getCommand((Request)request);
                    if (command != null && command.canExecute()) {
                        viewer.getEditDomain().getCommandStack().execute(command);
                        handle.setProperty("cube", (Object)cube);
                        List dimensions = cube.getContents("dimensions");
                        for (TabularDimensionHandle dimension : dimensions) {
                            if (dimension.isTimeType()) {
                                this.createDimensionViewHandle(handle, (DimensionHandle)dimension, 1);
                                continue;
                            }
                            this.createDimensionViewHandle(handle, (DimensionHandle)dimension, 0);
                        }
                        List measureGroups = cube.getContents("measureGroups");
                        int index = 0;
                        for (MeasureGroupHandle measureGroup : measureGroups) {
                            List measures = measureGroup.getContents("measures");
                            int j = 0;
                            while (j < measures.size()) {
                                Object temp = measures.get(j);
                                if (temp instanceof MeasureHandle) {
                                    this.addMeasureHandle(handle, (MeasureHandle)temp, index++);
                                }
                                ++j;
                            }
                        }
                        stack.commit();
                        viewer.flush();
                        viewer.getControl().setFocus();
                        ReportCreationTool.selectAddedObject((Object)handle, (EditPartViewer)viewer);
                        return true;
                    }
                }
                catch (Exception exception) {
                    stack.rollback();
                    return false;
                }
            }
        }
        HashMap<String, ExtendedItemHandle> map = new HashMap<String, ExtendedItemHandle>();
        map.put("newObject", handle);
        CreateCommand command = new CreateCommand(map);
        try {
            SlotHandle parentModel = this.getTargetSlotHandle(target, "Crosstab");
            if (parentModel != null) {
                command.setParent((Object)parentModel);
            } else {
                command.setParent((Object)SessionHandleAdapter.getInstance().getReportDesignHandle());
            }
            command.execute();
            handle.setProperty("cube", (Object)cube);
            List dimensions = cube.getContents("dimensions");
            for (TabularDimensionHandle dimension : dimensions) {
                if (dimension.isTimeType()) {
                    this.createDimensionViewHandle(handle, (DimensionHandle)dimension, 1);
                    continue;
                }
                this.createDimensionViewHandle(handle, (DimensionHandle)dimension, 0);
            }
            List measureGroups = cube.getContents("measureGroups");
            int index = 0;
            for (MeasureGroupHandle measureGroup : measureGroups) {
                List measures = measureGroup.getContents("measures");
                int j = 0;
                while (j < measures.size()) {
                    Object temp = measures.get(j);
                    if (temp instanceof MeasureHandle) {
                        this.addMeasureHandle(handle, (MeasureHandle)temp, index++);
                    }
                    ++j;
                }
            }
            stack.commit();
            if (target instanceof EditPart) {
                ((EditPart)target).getViewer().flush();
            }
            ReportRequest request = new ReportRequest();
            ArrayList<ExtendedItemHandle> selectionObjects = new ArrayList<ExtendedItemHandle>();
            selectionObjects.add(handle);
            request.setSelectionObject(selectionObjects);
            request.setType((Object)"selection");
            SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
            if (SessionHandleAdapter.getInstance().getReportDesignHandle() instanceof LibraryHandle) {
                HandleAdapterFactory.getInstance().getLibraryHandleAdapter().setCurrentEditorModel((Object)handle, "create element");
            }
        }
        catch (Exception exception) {
            stack.rollback();
            return false;
        }
        return true;
    }

    private void addMeasureHandle(ExtendedItemHandle handle, MeasureHandle measureHandle, int index) throws SemanticException {
        IReportItem reportItem = handle.getReportItem();
        CrosstabReportItemHandle xtabHandle = (CrosstabReportItemHandle)reportItem;
        CrosstabAdaptUtil.addMeasureHandle(xtabHandle, measureHandle, index);
    }

    private void createDimensionViewHandle(ExtendedItemHandle handle, DimensionHandle dimensionHandle, int type) throws SemanticException {
        if (dimensionHandle.getDefaultHierarchy().getLevelCount() > 0) {
            IReportItem reportItem = handle.getReportItem();
            CrosstabReportItemHandle xtabHandle = (CrosstabReportItemHandle)reportItem;
            DimensionViewHandle viewHandle = xtabHandle.insertDimension(dimensionHandle, type, xtabHandle.getDimensionCount(type));
            LevelHandle[] levels = this.getLevelHandles(dimensionHandle);
            int j = 0;
            while (j < levels.length) {
                LevelHandle levelHandle = levels[j];
                DataItemHandle dataHandle = CrosstabAdaptUtil.createColumnBindingAndDataItem((ReportItemHandle)((ExtendedItemHandle)xtabHandle.getModelHandle()), levelHandle);
                LevelViewHandle levelViewHandle = viewHandle.insertLevel(levelHandle, j);
                CrosstabCellHandle cellHandle = levelViewHandle.getCell();
                cellHandle.addContent((DesignElementHandle)dataHandle);
                ++j;
            }
        }
    }

    private LevelHandle[] getLevelHandles(DimensionHandle dimensionHandle) {
        LevelHandle[] dimensionLevelHandles = new LevelHandle[dimensionHandle.getDefaultHierarchy().getLevelCount()];
        int i = 0;
        while (i < dimensionLevelHandles.length) {
            dimensionLevelHandles[i] = dimensionHandle.getDefaultHierarchy().getLevel(i);
            ++i;
        }
        return dimensionLevelHandles;
    }
}

