/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.action;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AbstractCrosstabAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DeleteDimensionViewHandleAction
extends AbstractCrosstabAction {
    DimensionViewHandle dimensionHandle;
    private static final String NAME = Messages.getString("DeleteDimensionViewHandleAction.TransName");
    private static final String ID = "delete_test_dimensionviewhandle";
    private static final String TEXT = Messages.getString("DeleteDimensionViewHandleAction.DisplayName");

    public DeleteDimensionViewHandleAction(DesignElementHandle handle) {
        super(handle);
        this.setId(ID);
        this.setText(TEXT);
        ExtendedItemHandle extendedHandle = CrosstabAdaptUtil.getExtendedItemHandle(handle);
        this.setHandle((DesignElementHandle)extendedHandle);
        this.dimensionHandle = CrosstabAdaptUtil.getDimensionViewHandle(extendedHandle);
        ISharedImages shareImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public boolean isEnabled() {
        return !DEUtil.isReferenceElement((DesignElementHandle)this.dimensionHandle.getCrosstabHandle());
    }

    public void run() {
        if (this.dimensionHandle == null) {
            return;
        }
        this.transStar(NAME);
        try {
            CrosstabReportItemHandle handle = this.dimensionHandle.getCrosstab();
            boolean bool = CrosstabAdaptUtil.needRemoveInvaildBindings(handle);
            this.dimensionHandle.getCrosstab().removeDimension(this.dimensionHandle.getAxisType(), this.dimensionHandle.getIndex());
            if (bool) {
                CrosstabAdaptUtil.removeInvalidBindings(handle);
            }
            AggregationCellProviderWrapper providerWrapper = new AggregationCellProviderWrapper((ExtendedItemHandle)handle.getModelHandle());
            providerWrapper.updateAllAggregationCells(0);
        }
        catch (SemanticException e) {
            this.rollBack();
            ExceptionHandler.handle((Throwable)e);
            return;
        }
        this.transEnd();
    }
}

