/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.AbstractCrosstabCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class AddMeasureViewHandleCommand
extends AbstractCrosstabCommand {
    private CrosstabCellAdapter handleAdpter;
    private MeasureHandle measureHandle;
    private Object after = null;
    private static final String NAME = Messages.getString("AddMeasureViewHandleCommand.TransName");

    public AddMeasureViewHandleCommand(CrosstabCellAdapter handleAdpter, MeasureHandle measureHandle, Object after) {
        super((DesignElementHandle)measureHandle);
        this.handleAdpter = handleAdpter;
        this.measureHandle = measureHandle;
        this.after = after;
        this.setLabel(NAME);
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        this.transStart(NAME);
        CrosstabReportItemHandle reportHandle = this.handleAdpter.getCrosstabCellHandle().getCrosstab();
        try {
            int position = this.findPosition();
            CrosstabAdaptUtil.addMeasureHandle(reportHandle, this.measureHandle, position);
            this.transEnd();
        }
        catch (SemanticException e) {
            this.rollBack();
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private int findPosition() {
        int index;
        int base = CrosstabAdaptUtil.getMeasureViewHandle((ExtendedItemHandle)this.handleAdpter.getCrosstabCellHandle().getModelHandle()).getModelHandle().getIndex();
        if (this.after instanceof DesignElementHandle && (index = ((DesignElementHandle)this.after).getIndex()) == 0) {
            return base;
        }
        return base + 1;
    }
}

