/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.commands.AbstractCrosstabCommand;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabHandleAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class CreateMultipleMeasureCommand
extends AbstractCrosstabCommand {
    private CrosstabHandleAdapter handleAdpter;
    private List list;
    private static final String NAME = Messages.getString("CreateMeasureViewCommand.TransName");

    public CreateMultipleMeasureCommand(CrosstabHandleAdapter handleAdpter, List list) {
        super(handleAdpter.getDesignElementHandle());
        this.handleAdpter = handleAdpter;
        this.list = list;
        this.setLabel(NAME);
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        this.transStart(NAME);
        try {
            int i = 0;
            while (i < this.list.size()) {
                Object obj = this.list.get(i);
                if (obj instanceof MeasureHandle) {
                    this.addMeasureHandle((MeasureHandle)obj);
                }
                if (obj instanceof MeasureGroupHandle) {
                    List children = ((MeasureGroupHandle)obj).getContents("measures");
                    int j = 0;
                    while (j < children.size()) {
                        Object temp = children.get(j);
                        if (temp instanceof MeasureHandle) {
                            this.addMeasureHandle((MeasureHandle)temp);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (SemanticException e) {
            this.rollBack();
            ExceptionHandler.handle((Throwable)e);
            return;
        }
        this.transEnd();
    }

    private void addMeasureHandle(MeasureHandle measureHandle) throws SemanticException {
        CrosstabReportItemHandle reportHandle = (CrosstabReportItemHandle)this.handleAdpter.getCrosstabItemHandle();
        if (reportHandle.getCube() == null) {
            reportHandle.setCube(CrosstabAdaptUtil.getCubeHandle((DesignElementHandle)measureHandle));
        }
        CrosstabAdaptUtil.addMeasureHandle(reportHandle, measureHandle, reportHandle.getMeasureCount());
    }
}

