/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.model;

import org.eclipse.birt.report.designer.util.IVirtualValidator;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class NormalCrosstabCellAdapter
extends CrosstabCellAdapter
implements IVirtualValidator {
    public NormalCrosstabCellAdapter(CrosstabCellHandle handle) {
        super(handle);
    }

    public int hashCode() {
        return this.getCrosstabItemHandle().hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleValidate(Object obj) {
        CrosstabReportItemHandle crosstab = this.getCrosstabCellHandle().getCrosstab();
        if (obj instanceof Object[]) {
            Object[] objects = (Object[])obj;
            int len = objects.length;
            if (len == 0) {
                return false;
            }
            if (len == 1) {
                return this.handleValidate(objects[0]);
            }
            boolean isValidate = false;
            int i = 0;
            while (i < len) {
                Object temp = objects[i];
                if (temp instanceof LevelAttributeHandle) {
                    temp = ((LevelAttributeHandle)temp).getElementHandle();
                }
                if (temp instanceof MeasureHandle || temp instanceof MeasureGroupHandle) {
                    if (!this.getPositionType().equals("cell_measure") || crosstab.getCube() != CrosstabAdaptUtil.getCubeHandle((DesignElementHandle)temp)) return false;
                    isValidate = this.handleValidate(temp);
                } else {
                    if (!(temp instanceof LevelHandle)) return false;
                    if (i > 0) {
                        DesignElementHandle preContainer;
                        Object preObj = objects[i - 1];
                        if (preObj instanceof LevelAttributeHandle) {
                            preObj = ((LevelAttributeHandle)preObj).getElementHandle();
                        }
                        if (!(preObj instanceof LevelHandle)) {
                            return false;
                        }
                        DesignElementHandle container = ((LevelHandle)temp).getContainer();
                        if (container != (preContainer = ((LevelHandle)preObj).getContainer())) {
                            return false;
                        }
                    }
                    isValidate = this.handleValidate(temp);
                }
                ++i;
            }
            return isValidate;
        }
        if (obj instanceof DimensionHandle && (this.getPositionType().equals("level_handle") || this.getPositionType().equals("first_level_handle")) && CrosstabUtil.canContain((CrosstabReportItemHandle)crosstab, (DimensionHandle)((DimensionHandle)obj))) {
            return true;
        }
        if (obj instanceof LevelHandle) {
            return this.handleValidate(CrosstabAdaptUtil.getDimensionHandle((LevelHandle)obj));
        }
        if (obj instanceof LevelAttributeHandle) {
            LevelViewHandle lvh;
            LevelAttributeHandle lah = (LevelAttributeHandle)obj;
            LevelHandle lh = (LevelHandle)lah.getElementHandle();
            if (this.handleValidate(CrosstabAdaptUtil.getDimensionHandle(lh))) {
                return true;
            }
            if (this.getCrosstabCellHandle() != null && this.getCrosstabCellHandle().getContainer() instanceof LevelViewHandle && (lvh = (LevelViewHandle)this.getCrosstabCellHandle().getContainer()).getCubeLevel() == lh) {
                return true;
            }
        }
        if (!(obj instanceof MeasureHandle) || !this.getPositionType().equals("cell_measure") || !CrosstabUtil.canContain((CrosstabReportItemHandle)crosstab, (MeasureHandle)((MeasureHandle)obj))) return obj instanceof MeasureGroupHandle && this.getPositionType().equals("cell_measure") && crosstab.getCube() == CrosstabAdaptUtil.getCubeHandle((DesignElementHandle)obj);
        return true;
    }
}

