/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.dialogs.SortkeyBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.SortingModelProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.ui.views.dialogs.CrosstabSortKeyBuilder;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.SortElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public class CrosstabSortingModelProvider
extends SortingModelProvider {
    private static final String EMPTY_STRING = "";

    public boolean doEditItem(Object item, int pos) {
        if (item instanceof ExtendedItemHandle && ((ExtendedItemHandle)item).getExtensionName().equals("Crosstab")) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(item);
            Object[] levelArray = this.getElements(list);
            if (levelArray == null || levelArray.length <= 0) {
                return true;
            }
            LevelSortKeyHandle levelSortKeyHandle = (LevelSortKeyHandle)Arrays.asList(levelArray).get(pos);
            if (levelSortKeyHandle == null) {
                return false;
            }
            LevelViewHandle level = levelSortKeyHandle.getLevelHandle();
            SortElementHandle sortKey = levelSortKeyHandle.getSortKeyHandle();
            CrosstabSortKeyBuilder dialog = new CrosstabSortKeyBuilder(UIUtil.getDefaultShell(), SortkeyBuilder.DLG_TITLE_EDIT, SortkeyBuilder.DLG_MESSAGE_EDIT);
            dialog.setHandle((DesignElementHandle)item);
            dialog.setInput(sortKey, level);
            return dialog.open() != 1;
        }
        return super.doEditItem(item, pos);
    }

    public boolean deleteItem(Object item, int pos) throws PropertyValueException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(item);
        Object[] levelArray = this.getElements(list);
        if (levelArray == null || levelArray.length <= 0) {
            return true;
        }
        LevelSortKeyHandle levelSortKeyHandle = (LevelSortKeyHandle)Arrays.asList(levelArray).get(pos);
        LevelViewHandle level = levelSortKeyHandle.getLevelHandle();
        SortElementHandle sortKey = levelSortKeyHandle.getSortKeyHandle();
        try {
            level.getModelHandle().drop("sort", (DesignElementHandle)sortKey);
        }
        catch (SemanticException semanticException) {
            return false;
        }
        return true;
    }

    public boolean doAddItem(Object item, int pos) throws SemanticException {
        if (item instanceof ExtendedItemHandle && ((ExtendedItemHandle)item).getExtensionName().equals("Crosstab")) {
            CrosstabSortKeyBuilder dialog = new CrosstabSortKeyBuilder(UIUtil.getDefaultShell(), SortkeyBuilder.DLG_TITLE_NEW, SortkeyBuilder.DLG_MESSAGE_NEW);
            dialog.setHandle((DesignElementHandle)item);
            dialog.setInput(null);
            return dialog.open() != 1;
        }
        return super.doAddItem(item, pos);
    }

    public boolean setStringValue(Object item, Object element, String key, String newValue) throws SemanticException {
        return true;
    }

    public String getText(Object element, String key) {
        IChoice choice;
        if (!(element instanceof LevelSortKeyHandle)) {
            return EMPTY_STRING;
        }
        if (key.equals("level")) {
            LevelHandle cubeLevel = ((LevelSortKeyHandle)element).getLevelHandle().getCubeLevel();
            if (cubeLevel == null) {
                return EMPTY_STRING;
            }
            return cubeLevel.getFullName();
        }
        element = ((LevelSortKeyHandle)element).getSortKeyHandle();
        String value = null;
        value = ((SortElementHandle)element).getStringProperty(key);
        if (value == null) {
            value = EMPTY_STRING;
        }
        if (key.equals("direction") && (choice = this.choiceSetDirection.findChoice(value)) != null) {
            return choice.getDisplayName();
        }
        return value;
    }

    public String[] getColumnNames(String[] keys) {
        assert (keys != null);
        String[] columnNames = new String[keys.length];
        columnNames[0] = Messages.getString("CrosstabSortingModelProvider.ColumnName.GroupLevel");
        int i = 1;
        while (i < keys.length) {
            IElementDefn ElementDefn = DEUtil.getMetaDataDictionary().getElement("SortElement");
            columnNames[i] = ElementDefn.getProperty(keys[i]).getDisplayName();
            ++i;
        }
        return columnNames;
    }

    public Object[] getElements(List input) {
        DesignElementHandle elementHandle;
        ArrayList list = new ArrayList();
        Object obj = input.get(0);
        if (!(obj instanceof ExtendedItemHandle)) {
            return EMPTY;
        }
        ExtendedItemHandle element = (ExtendedItemHandle)obj;
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)element.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (crossTab == null) {
            return list.toArray();
        }
        if (crossTab.getCrosstabView(1) != null) {
            elementHandle = crossTab.getCrosstabView(1).getModelHandle();
            list.addAll(this.getLevel((ExtendedItemHandle)elementHandle));
        }
        if (crossTab.getCrosstabView(0) != null) {
            elementHandle = crossTab.getCrosstabView(0).getModelHandle();
            list.addAll(this.getLevel((ExtendedItemHandle)elementHandle));
        }
        return list.toArray();
    }

    private List getLevel(ExtendedItemHandle handle) {
        CrosstabViewHandle crossTabViewHandle = null;
        try {
            crossTabViewHandle = (CrosstabViewHandle)handle.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        ArrayList<LevelSortKeyHandle> list = new ArrayList<LevelSortKeyHandle>();
        if (crossTabViewHandle == null) {
            return list;
        }
        int dimensionCount = crossTabViewHandle.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crossTabViewHandle.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                LevelViewHandle levelHandle = dimension.getLevel(j);
                Iterator iter = levelHandle.sortsIterator();
                while (iter.hasNext()) {
                    LevelSortKeyHandle levelSortKeyHandle = new LevelSortKeyHandle(levelHandle, (SortElementHandle)iter.next());
                    list.add(levelSortKeyHandle);
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public boolean moveItem(Object item, int oldPos, int newPos) throws PropertyValueException {
        return false;
    }

    static class LevelSortKeyHandle {
        protected LevelViewHandle levelHandle;
        protected SortElementHandle sortKeyHandle;

        public LevelSortKeyHandle(LevelViewHandle level, SortElementHandle sortKey) {
            this.levelHandle = level;
            this.sortKeyHandle = sortKey;
        }

        public LevelViewHandle getLevelHandle() {
            return this.levelHandle;
        }

        public void setLevelHandle(LevelViewHandle level) {
            this.levelHandle = level;
        }

        public SortElementHandle getSortKeyHandle() {
            return this.sortKeyHandle;
        }

        public void setSortKeyHandle(SortElementHandle sortKey) {
            this.sortKeyHandle = sortKey;
        }
    }
}

