/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFormHandleProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.ui.views.dialogs.CrosstabPageBreakDialog;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Table;

public class RowPageBreakProvider
extends AbstractFormHandleProvider {
    private CellEditor[] editors;
    private String[] columnNames = new String[]{Messages.getString("CrosstabPageBreakProvider.Column.GroupLevel"), Messages.getString("CrosstabPageBreakProvider.Column.Before"), Messages.getString("CrosstabPageBreakProvider.Column.After"), Messages.getString("CrosstabPageBreakProvider.Column.Inside"), Messages.getString("CrosstabPageBreakProvider.Column.Interval")};
    private static final IChoice[] pagebreakBeforeChoicesAll = DEUtil.getMetaDataDictionary().getChoiceSet("pageBreakBefore").getChoices();
    private static final IChoice[] pagebreakAfterChoicesAll = DEUtil.getMetaDataDictionary().getChoiceSet("pageBreakAfter").getChoices();
    private static final IChoice[] pagebreakInsideChoicesAll = DEUtil.getMetaDataDictionary().getChoiceSet("pageBreakInside").getChoices();
    private static final int PAGE_BREAK_BEFORE = 0;
    private static final int PAGE_BREAK_AFTER = 1;
    private static final int PAGE_BREAK_INSIDE = 2;
    private int[] columnWidths = new int[]{160, 140, 140, 140, 80};
    private static final String[] EMPTY = new String[0];

    public boolean canModify(Object element, String property) {
        return false;
    }

    public boolean doAddItem(int pos) throws Exception {
        CrosstabReportItemHandle reportHandle = null;
        try {
            reportHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)((List)this.input).get(0)).getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        CrosstabPageBreakDialog pageBreakDialog = new CrosstabPageBreakDialog(reportHandle);
        pageBreakDialog.setAxis(0);
        return pageBreakDialog.open() != 1;
    }

    public boolean doDeleteItem(int pos) throws Exception {
        CrosstabReportItemHandle reportHandle = null;
        try {
            reportHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)((List)this.input).get(0)).getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (reportHandle.getCrosstabView(0) != null) {
            LevelViewHandle levelViewHandle = null;
            CrosstabViewHandle crosstabView = reportHandle.getCrosstabView(0);
            levelViewHandle = (LevelViewHandle)this.getLevel(crosstabView).get(pos);
            if (levelViewHandle != null) {
                CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                stack.startTrans("Remove PageBreak");
                try {
                    levelViewHandle.setPageBreakAfter(null);
                    levelViewHandle.setPageBreakBefore(null);
                    levelViewHandle.getModelHandle().setProperty("pageBreakInterval", null);
                }
                catch (SemanticException semanticException) {
                    stack.rollback();
                    return false;
                }
                stack.commit();
            }
        }
        return true;
    }

    public boolean doEditItem(int pos) {
        CrosstabReportItemHandle reportHandle = null;
        try {
            reportHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)((List)this.input).get(0)).getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        List list = new ArrayList();
        if (reportHandle.getCrosstabView(0) != null) {
            CrosstabViewHandle crosstabView = reportHandle.getCrosstabView(0);
            list = this.getLevel(crosstabView);
        }
        CrosstabPageBreakDialog pageBreakDialog = new CrosstabPageBreakDialog(reportHandle);
        pageBreakDialog.setLevelViewHandle((LevelViewHandle)list.get(pos));
        pageBreakDialog.setAxis(0);
        return pageBreakDialog.open() != 1;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws Exception {
        return false;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof LevelViewHandle)) {
            return "";
        }
        LevelViewHandle levelViewHandle = (LevelViewHandle)element;
        switch (columnIndex) {
            case 0: {
                return levelViewHandle.getCubeLevelName();
            }
            case 1: {
                return this.getPageBreakDisplayName(levelViewHandle.getPageBreakBefore(), 0);
            }
            case 2: {
                return this.getPageBreakDisplayName(levelViewHandle.getPageBreakAfter(), 1);
            }
            case 3: {
                return this.getPageBreakDisplayName(levelViewHandle.getPageBreakInside(), 2);
            }
            case 4: {
                if (levelViewHandle.getModelHandle().getProperty("pageBreakInterval") == null) {
                    return "";
                }
                return "" + levelViewHandle.getPageBreakInterval();
            }
        }
        return "";
    }

    private String getPageBreakDisplayName(String value, int type) {
        IChoice[][] pageBreakChoices = new IChoice[][]{pagebreakBeforeChoicesAll, pagebreakAfterChoicesAll, pagebreakInsideChoicesAll};
        if (type > 3 || type < 0) {
            type = 0;
        }
        int i = 0;
        while (i < pageBreakChoices[type].length) {
            if (pageBreakChoices[type][i].getName().equals(value)) {
                return pageBreakChoices[type][i].getDisplayName();
            }
            ++i;
        }
        return "";
    }

    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    public CellEditor[] getEditors(Table table) {
        if (this.editors == null) {
            this.editors = new CellEditor[this.columnNames.length];
            int i = 0;
            while (i < this.columnNames.length) {
                this.editors[i] = new TextCellEditor();
                ++i;
            }
        }
        return this.editors;
    }

    public Object[] getElements(Object inputElement) {
        this.input = inputElement;
        Object obj = null;
        obj = inputElement instanceof List ? ((List)inputElement).get(0) : inputElement;
        ArrayList list = new ArrayList();
        if (!(obj instanceof ExtendedItemHandle)) {
            return EMPTY;
        }
        ExtendedItemHandle element = (ExtendedItemHandle)obj;
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)element.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (crossTab == null) {
            return list.toArray();
        }
        if (crossTab.getCrosstabView(0) != null) {
            CrosstabViewHandle crosstabView = crossTab.getCrosstabView(0);
            list.addAll(this.getLevel(crosstabView));
        }
        return list.toArray();
    }

    public String getImagePath(Object element, int columnIndex) {
        return null;
    }

    public Object getValue(Object element, String property) {
        return null;
    }

    public boolean modify(Object data, String property, Object value) throws Exception {
        return false;
    }

    public boolean needRefreshed(NotificationEvent event) {
        return false;
    }

    public String getDisplayName() {
        return Messages.getString("CrosstabPageGenerator.List.PageBreak");
    }

    private List getLevel(CrosstabViewHandle crosstabViewHandle) {
        ArrayList<LevelViewHandle> list = new ArrayList<LevelViewHandle>();
        if (crosstabViewHandle == null) {
            return list;
        }
        int dimensionCount = crosstabViewHandle.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crosstabViewHandle.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                LevelViewHandle levelHandle = dimension.getLevel(j);
                ExtendedItemHandle ext = (ExtendedItemHandle)levelHandle.getModelHandle();
                PropertyHandle before = ext.getPropertyHandle("pageBreakBefore");
                PropertyHandle after = ext.getPropertyHandle("pageBreakAfter");
                if (before != null && before.isLocal() || after != null && after.isLocal()) {
                    list.add(levelHandle);
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public boolean isAddEnable() {
        ExtendedItemHandle extend = (ExtendedItemHandle)DEUtil.getInputFirstElement((Object)this.input);
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)extend.getReportItem();
        }
        catch (ExtendedElementException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        if (crossTab == null) {
            return false;
        }
        return this.getLevelNames(crossTab).length != 0;
    }

    private String[] getLevelNames(CrosstabReportItemHandle crosstabHandle) {
        ArrayList<String> list = new ArrayList<String>();
        if (crosstabHandle.getCrosstabView(0) == null) {
            return new String[0];
        }
        CrosstabViewHandle crosstabView = crosstabHandle.getCrosstabView(0);
        if (crosstabView == null) {
            return new String[0];
        }
        int dimensionCount = crosstabView.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crosstabView.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                if (!this.isInLevelList(crosstabHandle, dimension.getLevel(j))) {
                    list.add(dimension.getLevel(j).getCubeLevelName());
                }
                ++j;
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private boolean isInLevelList(CrosstabReportItemHandle crosstabHandle, LevelViewHandle level) {
        List list = new ArrayList();
        if (crosstabHandle.getCrosstabView(0) != null) {
            CrosstabViewHandle crosstabView = crosstabHandle.getCrosstabView(0);
            list = this.getLevel(crosstabView);
        }
        return list.indexOf(level) != -1;
    }
}

