/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFormHandleProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.ui.views.dialogs.CrosstabSubTotalDialog;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Table;

public class SubTotalProvider
extends AbstractFormHandleProvider {
    protected static final Logger logger = Logger.getLogger(SubTotalProvider.class.getName());
    private CellEditor[] editors;
    private String[] columnNames = new String[]{Messages.getString("CrosstabSubToatalProvider.Column.AggregateOn"), Messages.getString("CrosstabSubToatalProvider.Column.DataField"), Messages.getString("CrosstabSubToatalProvider.Column.Function")};
    private int[] columnWidths = new int[]{160, 160, 200};
    private int axis;

    public void setAxis(int axis) {
        this.axis = axis;
    }

    public boolean canModify(Object element, String property) {
        return false;
    }

    public boolean doAddItem(int pos) throws Exception {
        CrosstabReportItemHandle reportHandle = null;
        try {
            reportHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)((List)this.input).get(0)).getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        CrosstabSubTotalDialog subTotalDialog = new CrosstabSubTotalDialog(reportHandle, this.axis);
        return subTotalDialog.open() != 1;
    }

    public boolean doDeleteItem(int pos) throws Exception {
        SubTotalInfo subTotalInfo = (SubTotalInfo)this.getElements(this.input)[pos];
        LevelViewHandle levelViewHandle = subTotalInfo.level;
        String measureName = subTotalInfo.measureName;
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)((List)this.input).get(0);
        List tmpMeasures = extendedItem.getPropertyHandle("measures").getContents();
        int measureIndex = -1;
        int i = 0;
        while (i < tmpMeasures.size()) {
            ExtendedItemHandle extHandle = (ExtendedItemHandle)tmpMeasures.get(i);
            try {
                if (((MeasureViewHandle)extHandle.getReportItem()).getCubeMeasureName().equals(measureName)) {
                    measureIndex = i;
                    break;
                }
            }
            catch (ExtendedElementException e1) {
                logger.log(Level.SEVERE, e1.getMessage(), e1);
            }
            ++i;
        }
        ExtendedItemHandle extend = (ExtendedItemHandle)DEUtil.getInputFirstElement((Object)this.input);
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)extend.getReportItem();
        }
        catch (ExtendedElementException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        if (crossTab == null) {
            return false;
        }
        if (CrosstabUtil.isAggregationAffectAllMeasures((CrosstabReportItemHandle)crossTab, (int)this.axis)) {
            levelViewHandle.removeSubTotal();
        } else {
            levelViewHandle.removeSubTotal(measureIndex);
        }
        return true;
    }

    public boolean doEditItem(int pos) {
        CrosstabReportItemHandle reportHandle = null;
        try {
            reportHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)((List)this.input).get(0)).getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        CrosstabSubTotalDialog subTotalDialog = new CrosstabSubTotalDialog(reportHandle, this.axis);
        subTotalDialog.setInput((SubTotalInfo)this.getElements(this.input)[pos]);
        return subTotalDialog.open() != 1;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws Exception {
        return false;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getColumnText(Object element, int columnIndex) {
        SubTotalInfo info = (SubTotalInfo)element;
        switch (columnIndex) {
            case 0: {
                return info.level.getCubeLevelName();
            }
            case 1: {
                return info.measureName == null ? "" : info.measureName;
            }
            case 2: {
                if (info.function == null || info.function.trim().equals("")) {
                    info.function = this.getFunctionNames()[0];
                }
                return this.getFunctionDisplayName(info.function);
            }
        }
        return "";
    }

    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    public CellEditor[] getEditors(Table table) {
        if (this.editors == null) {
            this.editors = new CellEditor[this.columnNames.length];
            int i = 0;
            while (i < this.columnNames.length) {
                this.editors[i] = new TextCellEditor();
                ++i;
            }
        }
        return this.editors;
    }

    public Object[] getElements(Object inputElement) {
        this.input = inputElement;
        Object obj = null;
        obj = inputElement instanceof List ? ((List)inputElement).get(0) : inputElement;
        ArrayList list = new ArrayList();
        if (!(obj instanceof ExtendedItemHandle)) {
            return new Object[0];
        }
        ExtendedItemHandle element = (ExtendedItemHandle)obj;
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)element.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (crossTab == null) {
            return new Object[0];
        }
        if (crossTab.getCrosstabView(this.axis) != null) {
            CrosstabViewHandle crosstabView = crossTab.getCrosstabView(this.axis);
            list.addAll(this.getLevel(crosstabView));
        }
        return list.toArray();
    }

    private List getLevel(CrosstabViewHandle crosstabViewHandle) {
        ArrayList<SubTotalInfo> list = new ArrayList<SubTotalInfo>();
        if (crosstabViewHandle == null) {
            return list;
        }
        int dimensionCount = crosstabViewHandle.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crosstabViewHandle.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                LevelViewHandle levelHandle = dimension.getLevel(j);
                List aggMeasures = levelHandle.getAggregationMeasures();
                int k = 0;
                while (k < aggMeasures.size()) {
                    MeasureViewHandle measure = (MeasureViewHandle)aggMeasures.get(k);
                    if (!(measure instanceof ComputedMeasureViewHandle)) {
                        SubTotalInfo info = new SubTotalInfo();
                        info.measureName = measure.getCubeMeasureName();
                        info.function = levelHandle.getAggregationFunction(measure);
                        info.level = levelHandle;
                        list.add(info);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public String getImagePath(Object element, int columnIndex) {
        return null;
    }

    public Object getValue(Object element, String property) {
        return null;
    }

    public boolean modify(Object data, String property, Object value) throws Exception {
        return false;
    }

    public boolean needRefreshed(NotificationEvent event) {
        return event instanceof ContentEvent || event instanceof PropertyEvent;
    }

    public String getDisplayName() {
        return Messages.getString("CrosstabPageGenerator.List.SubTotals");
    }

    public String[] getFunctionNames() {
        IChoice[] choices = this.getFunctions();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getName();
            ++i;
        }
        return displayNames;
    }

    public String getFunctionDisplayName(String name) {
        return ChoiceSetFactory.getDisplayNameFromChoiceSet((String)name, (IChoiceSet)DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("function").getAllowedChoices());
    }

    private IChoice[] getFunctions() {
        return DEUtil.getMetaDataDictionary().getElement("Measure").getProperty("function").getAllowedChoices().getChoices();
    }

    public boolean isAddEnable() {
        ExtendedItemHandle extend = (ExtendedItemHandle)DEUtil.getInputFirstElement((Object)this.input);
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)extend.getReportItem();
        }
        catch (ExtendedElementException e) {
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        if (crossTab == null) {
            return false;
        }
        CrosstabViewHandle crosstabView = crossTab.getCrosstabView(this.axis);
        return (this.getAllLevelCount(crossTab) - 1) * this.getMeasureCount(crossTab) - this.getLevel(crosstabView).size() > 0;
    }

    private int getAllLevelCount(CrosstabReportItemHandle crosstab) {
        CrosstabViewHandle crosstabView = crosstab.getCrosstabView(this.axis);
        if (crosstabView == null) {
            return 0;
        }
        int dimCount = crosstabView.getDimensionCount();
        int result = 0;
        int i = 0;
        while (i < dimCount) {
            DimensionViewHandle dimensionView = crosstabView.getDimension(i);
            int levelCount = dimensionView.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                ++result;
                ++j;
            }
            ++i;
        }
        return result;
    }

    private int getMeasureCount(CrosstabReportItemHandle crosstab) {
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)crosstab.getModelHandle();
        int allCount = extendedItem.getPropertyHandle("measures").getContentCount();
        int comoputecCount = crosstab.getComputedMeasures().size();
        return allCount - comoputecCount;
    }

    public static class SubTotalInfo {
        private LevelViewHandle level = null;
        private String measureName = "";
        private String function = "";

        public LevelViewHandle getLevel() {
            return this.level;
        }

        public void setLevel(LevelViewHandle level) {
            this.level = level;
        }

        public String getMeasureName() {
            return this.measureName;
        }

        public void setMeasureName(String name) {
            this.measureName = name;
        }

        public String getFunction() {
            return this.function;
        }

        public void setFunction(String function) {
            this.function = function;
        }
    }
}

