/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result.filter;

import org.eclipse.core.runtime.Assert;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;

public class NotExpression
extends FilterExpression {
    private FilterExpression m_expression;

    public static String getName() {
        return NotExpression.class.getSimpleName();
    }

    public NotExpression(FilterExpression expression) {
        Assert.isNotNull((Object)expression);
        this.m_expression = expression;
    }

    public FilterExpression getNegatingExpression() {
        return this.m_expression;
    }

    public void validate(ValidationContext context) throws OdaException {
        if (context != null && context.getValidator() != null) {
            context.getValidator().validate(this, context);
        }
        if (this.m_expression == null) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_NOT_EXPR_MISSING_CHILD, (Object)this));
        }
        if (!this.m_expression.isNegatable()) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_NOT_EXPR_INCOMPATIBLE, (Object)this.m_expression.getQualifiedId(), (Object)this.getQualifiedId()));
        }
        this.m_expression.validate(context);
    }

    public boolean equals(Object object) {
        if (!(object instanceof NotExpression)) {
            return false;
        }
        NotExpression that = (NotExpression)object;
        return this.m_expression.equals(that.m_expression);
    }

    public boolean isNegatable() {
        return true;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " (" + this.m_expression + ")";
    }
}

