/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.FolderArchive;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.impl.AbstractRunTask;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.data.dte.DocumentDataSource;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.dup.SuppressDuplciateReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.emitter.ReportEmitterExecutor;
import org.eclipse.birt.report.engine.internal.presentation.ReportDocumentInfo;
import org.eclipse.birt.report.engine.presentation.ReportDocumentBuilder;

public class RunTask
extends AbstractRunTask
implements IRunTask {
    private String documentName;
    private IDocArchiveWriter archive;
    private ReportDocumentWriter writer;
    private ReportDocumentBuilder documentBuilder;

    public RunTask(ReportEngine engine, IReportRunnable runnable) {
        super(engine, runnable, 1);
        this.executionContext.setFactoryMode(true);
        this.executionContext.setPresentationMode(false);
    }

    public void run(String reportDocName) throws EngineException {
        try {
            this.switchToOsgiClassLoader();
            this.changeStatusToRunning();
            if (reportDocName == null || reportDocName.length() == 0) {
                throw new EngineException("Error.ReportDocNameNotSpecifiedError");
            }
            this.documentName = reportDocName;
            this.doRun();
        }
        finally {
            this.changeStatusToStopped();
            this.switchClassLoaderBack();
        }
    }

    public void run(IDocArchiveWriter archive) throws EngineException {
        try {
            this.switchToOsgiClassLoader();
            this.changeStatusToRunning();
            if (archive == null) {
                throw new EngineException("Error.ReportArchiveError");
            }
            this.archive = archive;
            this.doRun();
        }
        finally {
            this.changeStatusToStopped();
            this.switchClassLoaderBack();
        }
    }

    private void openArchive() throws IOException {
        File file = new File(this.documentName);
        this.archive = file.exists() ? (file.isDirectory() ? new FolderArchiveWriter(this.documentName) : new FileArchiveWriter(this.documentName)) : (this.documentName.endsWith("\\") || this.documentName.endsWith("/") ? new FolderArchiveWriter(this.documentName) : new FileArchiveWriter(this.documentName));
    }

    private void openReportDocument() throws EngineException {
        try {
            if (this.archive == null) {
                this.openArchive();
            }
            String[] exts = this.executionContext.getEngineExtensions();
            this.writer = new ReportDocumentWriter(this.engine, this.archive, exts);
            this.executionContext.setReportDocWriter(this.writer);
            DocumentDataSource ds = this.executionContext.getDataSource();
            if (ds != null) {
                this.writer.saveReportletDocument(ds.getBookmark(), ds.getInstanceID());
            }
        }
        catch (IOException ex) {
            throw new EngineException("Error.ReportArchiveOpenError", ex);
        }
    }

    private void closeReportDocument() {
        this.writer.close();
        this.writer = null;
        this.archive = null;
        this.documentName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun() throws EngineException {
        if (this.progressMonitor != null) {
            this.progressMonitor.onProgress(1, 1);
        }
        this.loadDataSource();
        this.doValidateParameters();
        this.loadDesign();
        this.prepareDesign();
        this.startFactory();
        this.openReportDocument();
        try {
            try {
                ReportRunnable newRunnable = this.writer.saveDesign(this.executionContext.getRunnable(), this.executionContext.getOriginalRunnable());
                this.executionContext.updateRunnable(newRunnable);
                this.writer.saveReportIR(this.executionContext.getReport());
                this.writer.saveParamters(this.inputValues);
                this.executionContext.openDataEngine();
                RunTask runTask = this;
                synchronized (runTask) {
                    if (!this.executionContext.isCanceled()) {
                        this.documentBuilder = new ReportDocumentBuilder(this.executionContext, this.writer);
                    }
                }
                if (this.documentBuilder != null) {
                    if (this.pageHandler != null) {
                        this.documentBuilder.setPageHandler(this.pageHandler);
                    }
                    IContentEmitter emitter = this.documentBuilder.getContentEmitter();
                    IReportExecutor executor = new ReportExecutor(this.executionContext);
                    executor = this.createReportExtensionExecutor(executor);
                    executor = new ReportEmitterExecutor(executor, emitter);
                    executor = new SuppressDuplciateReportExecutor(executor);
                    this.executionContext.setExecutor(executor);
                    this.initializeContentEmitter(emitter, executor);
                    this.documentBuilder.build();
                }
                this.executionContext.closeDataEngine();
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "An error happened while running the report. Cause:", ex);
                throw new EngineException("Error.ReportRunError", ex);
            }
            catch (OutOfMemoryError err) {
                this.log.log(Level.SEVERE, "An OutOfMemory error happened while running the report.");
                throw err;
            }
            catch (Throwable t) {
                this.log.log(Level.SEVERE, "Error happened while running the report.", t);
                throw new EngineException("Error.ReportRunError", t);
            }
        }
        finally {
            this.documentBuilder = null;
            this.closeFactory();
            this.writer.savePersistentObjects(this.executionContext.getGlobalBeans());
            this.closeReportDocument();
            if (this.pageHandler != null && !this.executionContext.isCanceled()) {
                int totalPage = (int)this.executionContext.getTotalPage();
                ReportDocumentInfo docInfo = new ReportDocumentInfo(this.executionContext, totalPage, true);
                this.pageHandler.onPage(totalPage, true, docInfo);
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.onProgress(2, 1);
            }
        }
    }

    public void close() {
        super.close();
    }

    public void run(FolderArchive fArchive) throws EngineException {
        try {
            this.changeStatusToRunning();
            this.setDataSource((IDocArchiveReader)fArchive);
            this.run((IDocArchiveWriter)fArchive);
        }
        finally {
            this.changeStatusToStopped();
        }
    }

    public void cancel() {
        super.cancel();
        if (this.documentBuilder != null) {
            this.documentBuilder.cancel();
        }
    }

    public void setMaxRowsPerQuery(int maxRows) {
        this.executionContext.setMaxRowsPerQuery(maxRows);
    }

    public void enableProgressiveViewing(boolean enabled) {
        this.executionContext.enableProgressiveViewing(enabled);
    }
}

