/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ListBandExecutor;
import org.eclipse.birt.report.engine.executor.ListingElementExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ListItemDesign;

public class ListItemExecutor
extends ListingElementExecutor {
    protected ListItemExecutor(ExecutorManager manager) {
        super(manager, 3);
    }

    public IContent execute() {
        ListItemDesign listDesign = (ListItemDesign)this.getDesign();
        IListContent listContent = this.report.createListContent();
        this.setContent(listContent);
        this.executeQuery();
        this.initializeContent(listDesign, listContent);
        this.processAction(listDesign, listContent);
        this.processBookmark(listDesign, listContent);
        this.processStyle(listDesign, listContent);
        this.processVisibility(listDesign, listContent);
        if (this.context.isInFactory()) {
            this.handleOnCreate(listContent);
        }
        this.startTOCEntry(listContent);
        boolean showIfBlank = "true".equalsIgnoreCase(this.content.getStyle().getShowIfBlank());
        if (showIfBlank && this.rsetEmpty) {
            this.createQueryForShowIfBlank();
        }
        this.prepareToExecuteChildren();
        return listContent;
    }

    public void close() throws BirtException {
        this.finishTOCEntry();
        this.closeQuery();
        super.close();
    }

    public IReportItemExecutor getNextChild() {
        IReportItemExecutor executor = super.getNextChild();
        if (executor instanceof ListBandExecutor) {
            ListBandExecutor bandExecutor = (ListBandExecutor)executor;
            bandExecutor.setListingExecutor(this);
        }
        return executor;
    }
}

