/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractArea
implements IArea {
    protected static Logger logger = Logger.getLogger(AbstractArea.class.getName());
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int baseLine = 0;
    protected float scale = 1.0f;
    protected transient CSSValue vAlign;
    protected String bookmark = null;
    protected transient ContainerArea parent;
    protected IHyperlinkAction action = null;

    AbstractArea(AbstractArea area) {
        this.x = area.getX();
        this.y = area.getY();
        this.baseLine = area.getBaseLine();
        this.bookmark = area.getBookmark();
        this.action = area.getAction();
        this.scale = area.getScale();
        this.width = area.getWidth();
        this.height = area.getHeight();
    }

    public ContainerArea getParent() {
        return this.parent;
    }

    public void setParent(ContainerArea parent) {
        this.parent = parent;
    }

    public CSSValue getVerticalAlign() {
        return this.vAlign;
    }

    public void setVerticalAlign(CSSValue vAlign) {
        this.vAlign = vAlign;
    }

    AbstractArea() {
    }

    public String getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(String bookmark) {
        this.bookmark = bookmark;
    }

    public IHyperlinkAction getAction() {
        return this.action;
    }

    public void setAction(IHyperlinkAction action) {
        this.action = action;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setAllocatedPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setAllocatedY(int ay) {
        this.y = ay;
    }

    public void setAllocatedX(int ax) {
        this.x = ax;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getAllocatedWidth() {
        return this.width;
    }

    public int getAllocatedHeight() {
        return this.height;
    }

    public void setBaseLine(int baseLine) {
        this.baseLine = baseLine;
    }

    public int getBaseLine() {
        if (this.baseLine == 0) {
            return this.height;
        }
        return this.baseLine;
    }

    public abstract AbstractArea cloneArea();

    public AbstractArea deepClone() {
        return this.cloneArea();
    }

    public int getAllocatedX() {
        return this.x;
    }

    public int getAllocatedY() {
        return this.y;
    }
}

