/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEmitterAdapter;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.PageArea;

public class RootArea
extends BlockContainerArea {
    protected transient LayoutEmitterAdapter emitter;
    protected PageArea page;

    public RootArea(LayoutContext context, IContent content, LayoutEmitterAdapter emitter) {
        super(null, context, content);
        this.emitter = emitter;
    }

    public RootArea(RootArea area) {
        super(area);
    }

    public int getMaxAvaHeight() {
        return this.context.getMaxBP();
    }

    public void autoPageBreak() throws BirtException {
        int height = this.context.getMaxBP();
        ContainerArea.SplitResult result = this.split(height, false);
        if (result == ContainerArea.SplitResult.BEFORE_AVOID_WITH_NULL || result == ContainerArea.SplitResult.SUCCEED_WITH_NULL) {
            result = this.split(height, true);
        }
        if (result.getResult() != null) {
            this.page.setBody(result.getResult());
            this.context.setFinished(false);
            this.page.close();
        }
        this.updateChildrenPosition();
        this.initialize();
    }

    public RootArea cloneArea() {
        return new RootArea(this);
    }

    public void initialize() throws BirtException {
        IPageContent pageContent = (IPageContent)this.content;
        if (this.context.isAutoPageBreak()) {
            this.context.setPageNumber(this.context.getPageNumber() + 1L);
            pageContent = this.createPageContent(pageContent);
        }
        this.createNewPage(pageContent);
        this.width = this.maxAvaWidth = this.page.getBody().getWidth();
    }

    protected void createNewPage(IPageContent pageContent) throws BirtException {
        this.page = new PageArea(this.context, pageContent, this.emitter);
        this.page.initialize();
    }

    protected IPageContent createPageContent(IPageContent htmlPageContent) {
        if (this.context.getPageNumber() == htmlPageContent.getPageNumber()) {
            return htmlPageContent;
        }
        IPageContent pageContent = this.createPageContent(htmlPageContent, this.context.getPageNumber(), this.context.getTotalPage());
        return pageContent;
    }

    protected IPageContent createPageContent(IPageContent pageContent, long pageNumber, long totalPageNumber) {
        return (IPageContent)this.cloneContent((IContent)pageContent.getParent(), pageContent, pageNumber, totalPageNumber);
    }

    protected IContent cloneContent(IContent parent, IContent content, long pageNumber, long totalPageNumber) {
        IAutoTextContent autoText;
        int type;
        IContent newContent = content.cloneContent(false);
        newContent.setParent(parent);
        if (newContent.getContentType() == 12 && ((type = (autoText = (IAutoTextContent)newContent).getType()) == 1 || type == 3)) {
            DataFormatValue format = autoText.getComputedStyle().getDataFormat();
            NumberFormatter nf = null;
            if (format == null) {
                nf = new NumberFormatter();
            } else {
                String pattern = format.getNumberPattern();
                String locale = format.getNumberLocale();
                nf = locale == null ? new NumberFormatter(pattern) : new NumberFormatter(pattern, new ULocale(locale));
            }
            autoText.setText(nf.format(pageNumber));
        }
        for (IContent child : content.getChildren()) {
            IContent newChild = this.cloneContent(newContent, child, pageNumber, totalPageNumber);
            newChild.setParent(newContent);
            newContent.getChildren().add(newChild);
        }
        return newContent;
    }

    public void close() throws BirtException {
        this.page.setBody(this);
        this.context.setFinished(true);
        this.page.close();
        this.finished = true;
    }
}

