/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.core.template.TemplateParser;
import org.eclipse.birt.core.template.TextTemplate;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.api.CachedImage;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.ImageSize;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.engine.content.ContentVisitorAdapter;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.data.dte.SingleCubeResultSet;
import org.eclipse.birt.report.engine.data.dte.SingleQueryResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.template.TemplateExecutor;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemPresentation;
import org.eclipse.birt.report.engine.extension.Size;
import org.eclipse.birt.report.engine.extension.internal.ReportItemPresentationInfo;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.script.internal.OnRenderScriptVisitor;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.w3c.dom.css.CSSValue;

public class LocalizedContentVisitor
extends ContentVisitorAdapter {
    protected static Logger logger = Logger.getLogger(LocalizedContentVisitor.class.getName());
    private ExecutionContext context;
    private Locale locale;
    private String outputFormat;
    protected HashMap templates = new HashMap();
    private OnRenderScriptVisitor onRenderVisitor;
    static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public LocalizedContentVisitor(ExecutionContext context) {
        this.context = context;
        this.locale = context.getLocale();
        this.outputFormat = context.getOutputFormat();
        this.onRenderVisitor = new OnRenderScriptVisitor(context);
    }

    IReportContent getReportContent() {
        return this.context.getReportContent();
    }

    ReportDesignHandle getReportDesign() {
        return this.context.getDesign();
    }

    protected void processBackgroundImage(IStyle style) {
        URL url;
        if (style == null) {
            return;
        }
        String image = style.getBackgroundImage();
        if (image == null) {
            return;
        }
        ReportDesignHandle reportDesign = this.context.getDesign();
        if (reportDesign != null && (url = reportDesign.findResource(image, 1, this.context.getAppContext())) != null) {
            style.setBackgroundImage(url.toExternalForm());
        }
    }

    public IContent localize(IContent content) throws BirtException {
        IStyle style = content.getInlineStyle();
        this.processBackgroundImage(style);
        Object value = content.accept(this, content);
        return (IContent)value;
    }

    protected IContent localizeAllChildren(IContent content) throws BirtException {
        ArrayList children = (ArrayList)content.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.size()) {
                IContent child = (IContent)children.get(i);
                this.localize(child);
                this.localizeAllChildren(child);
                ++i;
            }
        }
        return content;
    }

    public Object visitPage(IPageContent page, Object value) throws BirtException {
        boolean isExecutingMasterPage = this.context.isExecutingMasterPage();
        this.context.setExecutingMasterPage(true);
        value = this.localizeAllChildren(page);
        this.context.setExecutingMasterPage(isExecutingMasterPage);
        return value;
    }

    protected TextTemplate parseTemplate(String text) throws BirtException {
        SoftReference<TextTemplate> templateRef = (SoftReference<TextTemplate>)this.templates.get(text);
        TextTemplate template = null;
        if (templateRef != null && (template = (TextTemplate)templateRef.get()) != null) {
            return template;
        }
        try {
            template = new TemplateParser().parse(text);
            templateRef = new SoftReference<TextTemplate>(template);
            this.templates.put(text, templateRef);
        }
        catch (Throwable ex) {
            throw new EngineException(ex.getLocalizedMessage(), ex);
        }
        return template;
    }

    String executeTemplate(TextTemplate template, HashMap values) {
        return new TemplateExecutor(this.context).execute(template, values);
    }

    public Object visitList(IListContent list, Object value) {
        if (list.getGenerateBy() instanceof ListItemDesign) {
            this.handleOnRender(list);
        }
        return list;
    }

    public Object visitTable(ITableContent table, Object value) {
        this.handleOnRender(table);
        String captionText = table.getCaption();
        String captionKey = table.getCaptionKey();
        captionText = this.localize(table, captionKey, captionText);
        table.setCaption(captionText);
        return table;
    }

    public Object visitRow(IRowContent row, Object value) {
        this.handleOnRender(row);
        return row;
    }

    public Object visitCell(ICellContent cell, Object value) {
        this.handleOnRender(cell);
        return cell;
    }

    public Object visitData(IDataContent data, Object value) {
        this.handleOnRender(data);
        this.processData(data);
        return data;
    }

    protected void processData(IDataContent data) {
        String helpText = this.localize(data, data.getHelpKey(), data.getHelpText());
        data.setHelpText(helpText);
        String text = "";
        if (data.getLabelKey() != null || data.getLabelText() != null) {
            text = this.localize(data, data.getLabelKey(), data.getLabelText());
        } else {
            CSSValue align;
            Object value = data.getValue();
            IStyle style = data.getComputedStyle();
            text = this.format(value, style);
            if (value instanceof Number && (align = style.getProperty(12)) != null && align != CSSValueConstants.NONE_VALUE) {
                data.getStyle().setProperty(25, align);
            }
        }
        data.setText(text == null ? "" : text);
    }

    protected String format(Object value, IStyle style) {
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            value = values.length > 0 ? values[0] : null;
        }
        if (value == null) {
            return null;
        }
        DataFormatValue dataFormat = style.getDataFormat();
        if (value instanceof Number) {
            NumberFormatter fmt = null;
            if (dataFormat == null) {
                fmt = this.context.getNumberFormatter(null, null);
            } else {
                String pattern = dataFormat.getNumberPattern();
                String locale = dataFormat.getNumberLocale();
                fmt = locale == null ? this.context.getNumberFormatter(pattern, null) : this.context.getNumberFormatter(pattern, new ULocale(locale));
            }
            return fmt.format((Number)value);
        }
        if (value instanceof String) {
            StringFormatter fmt = null;
            if (dataFormat == null) {
                fmt = this.context.getStringFormatter(null, null);
            } else {
                String pattern = dataFormat.getStringPattern();
                String locale = dataFormat.getStringLocale();
                fmt = locale == null ? this.context.getStringFormatter(pattern, null) : this.context.getStringFormatter(pattern, new ULocale(locale));
            }
            return fmt.format((String)value);
        }
        if (value instanceof java.util.Date) {
            DateFormatter fmt = null;
            String pattern = null;
            String locale = null;
            if (dataFormat != null) {
                if (value instanceof Date) {
                    pattern = dataFormat.getDatePattern();
                    locale = dataFormat.getDateLocale();
                } else if (value instanceof Time) {
                    pattern = dataFormat.getTimePattern();
                    locale = dataFormat.getTimeLocale();
                }
                if (pattern == null && locale == null) {
                    pattern = dataFormat.getDateTimePattern();
                    locale = dataFormat.getDateTimeLocale();
                }
                fmt = locale == null ? this.context.getDateFormatter(pattern, null) : this.context.getDateFormatter(pattern, new ULocale(locale));
            } else {
                fmt = this.context.getDateFormatter(null, null);
            }
            return fmt.format((java.util.Date)value);
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            int length = bytes.length <= 8 ? bytes.length : 8;
            StringBuffer buffer = new StringBuffer();
            int index = 0;
            while (index < length) {
                byte byteValue = bytes[index];
                int lowValue = byteValue & 0xF;
                int highValue = byteValue >> 4 & 0xF;
                buffer.append(HEX[highValue]).append(HEX[lowValue]).append(' ');
                ++index;
            }
            if (length > 0) {
                if (length != bytes.length) {
                    buffer.append("...");
                } else {
                    buffer.setLength(buffer.length() - 1);
                }
            }
            return buffer.toString();
        }
        return value.toString();
    }

    public Object visitLabel(ILabelContent label, Object value) {
        this.handleOnRender(label);
        this.processLabel(label);
        return label;
    }

    protected void processLabel(ILabelContent label) {
        String helpText = this.localize(label, label.getHelpKey(), label.getHelpText());
        label.setHelpText(helpText);
        if (label.getText() == null) {
            String text = this.localize(label, label.getLabelKey(), label.getLabelText());
            label.setText(text);
        }
    }

    public Object visitText(ITextContent text, Object value) {
        this.handleOnRender(text);
        return value;
    }

    public Object visitAutoText(IAutoTextContent autoText, Object value) {
        int type = autoText.getType();
        IStyle style = autoText.getComputedStyle();
        if (type == 1) {
            long number = this.context.getFilteredPageNumber();
            String text = this.format(number, style);
            autoText.setText(text == null ? "" : text);
        } else if (type == 0) {
            long totalPage = this.context.getFilteredTotalPage();
            if (totalPage <= 0L) {
                autoText.setText("---");
            } else {
                String text = this.format(totalPage, style);
                autoText.setText(text == null ? "" : text);
            }
        } else if (type == 3) {
            long number = this.context.getPageNumber();
            String text = this.format(number, style);
            autoText.setText(text == null ? "" : text);
        } else if (type == 2) {
            long totalPage = this.context.getTotalPage();
            if (totalPage <= 0L) {
                autoText.setText("---");
            } else {
                String text = this.format(totalPage, style);
                autoText.setText(text == null ? "" : text);
            }
        } else if (type == 4) {
            AutoTextItemDesign design = (AutoTextItemDesign)autoText.getGenerateBy();
            AutoTextHandle designHandle = (AutoTextHandle)design.getHandle();
            String varName = designHandle.getPageVariable();
            Object result = this.context.getPageVariable(varName);
            String text = this.format(result, style);
            autoText.setText(text == null ? "" : text);
        }
        this.handleOnRender(autoText);
        return value;
    }

    public Object visitForeign(IForeignContent foreignContent, Object value) {
        IReportContent reportContent = this.getReportContent();
        String rawFormat = foreignContent.getRawType();
        Object rawValue = foreignContent.getRawValue();
        this.handleOnRender(foreignContent);
        if ("text/template".equals(rawFormat)) {
            this.processTemplateContent(foreignContent);
            return foreignContent;
        }
        if ("object/external".equals(rawFormat)) {
            return this.processExtendedContent(foreignContent);
        }
        if ("binary/image".equals(rawFormat)) {
            if (rawValue instanceof IImageContent) {
                IImageContent image = (IImageContent)rawValue;
                this.processImage(image);
                return image;
            }
            if (rawValue instanceof byte[]) {
                IImageContent imageContent = reportContent.createImageContent(foreignContent);
                imageContent.setImageSource(2);
                imageContent.setData((byte[])rawValue);
                this.processImage(imageContent);
                return imageContent;
            }
        }
        if ("text/plaintext".equals(rawFormat)) {
            IDataContent textContent = reportContent.createDataContent(foreignContent);
            textContent.setText(rawValue == null ? "" : rawValue.toString());
            return textContent;
        }
        if ("text/html".equals(rawFormat)) {
            String text;
            String key = foreignContent.getRawKey();
            if (key != null && (text = this.localize(foreignContent, key, null)) != null) {
                foreignContent.setRawValue(text);
            }
            return foreignContent;
        }
        if ("binary/value".equals(rawFormat)) {
            IDataContent dataContent = reportContent.createDataContent(foreignContent);
            dataContent.setValue(rawValue);
            this.processData(dataContent);
            return dataContent;
        }
        return foreignContent;
    }

    private String localize(IContent content, String key, String text) {
        assert (content != null);
        if (content.getGenerateBy() != null) {
            String t;
            DesignElementHandle element = ((ReportItemDesign)content.getGenerateBy()).getHandle();
            if (key != null && element != null && (t = ModuleUtil.getExternalizedValue((DesignElementHandle)element, (String)key, (String)text, (ULocale)ULocale.forLocale((Locale)this.locale))) != null) {
                return t;
            }
        }
        return text;
    }

    public Object visitImage(IImageContent image, Object value) {
        String appBaseUrl;
        IRenderOption option;
        String uri;
        this.handleOnRender(image);
        if (image.getImageSource() == 0) {
            String strUri = image.getURI();
            ReportDesignHandle reportDesign = this.context.getDesign();
            URL uri2 = reportDesign.findResource(strUri, 1, this.context.getAppContext());
            if (uri2 != null) {
                image.setURI(uri2.toExternalForm());
            }
        } else if (image.getImageSource() == 3 && !(uri = image.getURI()).contains(":/") && (option = this.context.getRenderOption()) != null && (appBaseUrl = option.getAppBaseURL()) != null) {
            if (appBaseUrl.endsWith("/")) {
                image.setURI(String.valueOf(appBaseUrl) + uri);
            } else {
                image.setURI(String.valueOf(appBaseUrl) + "/" + uri);
            }
        }
        this.processImage(image);
        return image;
    }

    protected void processImage(IImageContent image) {
        String altText = this.localize(image, image.getAltTextKey(), image.getAltText());
        image.setAltText(altText);
        String helpText = this.localize(image, image.getHelpKey(), image.getHelpText());
        image.setHelpText(helpText);
    }

    protected void processTemplateContent(IForeignContent foreignContent) {
        assert ("text/template".equals(foreignContent.getRawType()));
        if (foreignContent.getGenerateBy() instanceof TextItemDesign) {
            TextItemDesign design = (TextItemDesign)foreignContent.getGenerateBy();
            String text = null;
            HashMap rawValues = null;
            if (foreignContent.getRawValue() instanceof Object[]) {
                Object[] rawValue = (Object[])foreignContent.getRawValue();
                assert (rawValue.length == 2);
                assert (rawValue[0] == null || rawValue[0] instanceof String);
                if (rawValue[0] != null) {
                    text = (String)rawValue[0];
                }
                if (rawValue[1] instanceof HashMap) {
                    rawValues = (HashMap)rawValue[1];
                }
            }
            if (text == null) {
                String textKey = design.getTextKey();
                String textContent = design.getText();
                text = this.localize(foreignContent, textKey, textContent);
            }
            try {
                TextTemplate template = this.parseTemplate(text);
                String result = this.executeTemplate(template, rawValues);
                foreignContent.setRawType("text/html");
                foreignContent.setRawValue(result);
            }
            catch (BirtException ex) {
                this.context.addException(design, ex);
            }
        }
    }

    public Object visitGroup(IGroupContent group, Object value) {
        this.handleOnRender(group);
        return group;
    }

    protected String getOutputFormat() {
        return this.outputFormat;
    }

    protected boolean isForPrinting() {
        String outputFormat = this.getOutputFormat();
        return "FO".equalsIgnoreCase(outputFormat) || "PDF".equalsIgnoreCase(outputFormat) || "POSTSCRIPT".equalsIgnoreCase(outputFormat);
    }

    private int getChartResolution() {
        Object tmp;
        Map appContext = this.context.getAppContext();
        int resolution = 0;
        if (appContext != null && (tmp = appContext.get("CHART_RESOLUTION")) != null && tmp instanceof Number && (resolution = ((Number)tmp).intValue()) < 96) {
            resolution = 96;
        }
        if (resolution == 0) {
            resolution = this.isForPrinting() ? 192 : 96;
        }
        return resolution;
    }

    private String getChartFormats() {
        IRenderOption renderOption = this.context.getRenderOption();
        String formats = renderOption.getSupportedImageFormats();
        if (formats != null) {
            return formats;
        }
        return "PNG;GIF;JPG;BMP;";
    }

    private String getImageCacheID(IContent content) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(content.getInstanceID().toUniqueString());
        buffer.append(this.getChartResolution());
        buffer.append(this.getChartFormats());
        buffer.append(this.locale);
        return buffer.toString();
    }

    private ImageSize processImageSize(Size size) {
        if (size == null) {
            return null;
        }
        return new ImageSize(size.getUnit(), size.getWidth(), size.getHeight());
    }

    private IContent processCachedImage(IForeignContent content, CachedImage cachedImage) {
        IImageContent imageObj = this.getReportContent().createImageContent(content);
        imageObj.setParent(content.getParent());
        imageObj.setImageSource(0);
        imageObj.setURI(cachedImage.getURL());
        imageObj.setMIMEType(cachedImage.getMIMEType());
        imageObj.setImageMap(cachedImage.getImageMap());
        imageObj.setAltText(content.getAltText());
        imageObj.setAltTextKey(content.getAltTextKey());
        ImageSize size = cachedImage.getImageSize();
        if (size != null) {
            DimensionType height = new DimensionType(size.getHeight(), size.getUnit());
            DimensionType width = new DimensionType(size.getWidth(), size.getUnit());
            imageObj.setHeight(height);
            imageObj.setWidth(width);
        }
        this.processImage(imageObj);
        return imageObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IContent processExtendedContent(IForeignContent content) {
        String imageId;
        CachedImage cachedImage;
        IHTMLImageHandler imageHandler;
        assert ("object/external".equals(content.getRawType()));
        assert (content.getGenerateBy() instanceof ExtendedItemDesign);
        IContent generatedContent = content;
        ExtendedItemDesign design = (ExtendedItemDesign)content.getGenerateBy();
        ExtendedItemHandle handle = (ExtendedItemHandle)design.getHandle();
        String tagName = handle.getExtensionName();
        if ("Chart".equals(tagName) && (imageHandler = this.context.getImageHandler()) != null && (cachedImage = imageHandler.getCachedImage(imageId = this.getImageCacheID(content), 4, this.context.getReportContext())) != null) {
            return this.processCachedImage(content, cachedImage);
        }
        IReportItemPresentation itemPresentation = this.context.getExtendedItemManager().createPresentation(handle);
        int resolution = 0;
        if (itemPresentation != null) {
            DesignElementHandle elementHandle;
            IDataQueryDefinition[] queries = design.getQueries();
            ReportItemPresentationInfo info = new ReportItemPresentationInfo();
            info.setModelObject(handle);
            info.setApplicationClassLoader(this.context.getApplicationClassLoader());
            info.setReportContext(this.context.getReportContext());
            info.setReportQueries(queries);
            resolution = this.getChartResolution();
            info.setResolution(resolution);
            info.setExtendedItemContent(content);
            info.setSupportedImageFormats(this.getChartFormats());
            info.setActionHandler(this.context.getActionHandler());
            info.setOutputFormat(this.getOutputFormat());
            itemPresentation.init(info);
            Object rawValue = content.getRawValue();
            if (rawValue instanceof byte[]) {
                byte[] values = (byte[])rawValue;
                itemPresentation.deserialize(new ByteArrayInputStream(values));
            }
            if (queries == null && (elementHandle = design.getHandle()) instanceof ReportElementHandle) {
                queries = (IBaseQueryDefinition[])this.context.getReport().getQueryByReportHandle((ReportElementHandle)elementHandle);
            }
            IBaseResultSet[] rsets = this.context.getResultSets();
            IBaseResultSet[] resultSets = null;
            if (queries == null) {
                if (rsets != null) {
                    resultSets = new IBaseResultSet[1];
                    int type = rsets[0].getType();
                    if (type == 0) {
                        resultSets[0] = new SingleQueryResultSet((IQueryResultSet)rsets[0]);
                    } else {
                        if (1 != type) throw new UnsupportedOperationException("Unknown type of result set is found: " + rsets[0].getClass().getName());
                        resultSets[0] = new SingleCubeResultSet((ICubeResultSet)rsets[0]);
                    }
                }
            } else {
                resultSets = rsets;
            }
            try {
                Object output = itemPresentation.onRowSets(resultSets);
                if (output != null) {
                    int type = itemPresentation.getOutputType();
                    String imageMIMEType = itemPresentation.getImageMIMEType();
                    Size size = itemPresentation.getSize();
                    generatedContent = this.processExtendedContent(content, type, output, imageMIMEType, size);
                    if (size != null) {
                        DimensionType height = new DimensionType(size.getHeight(), size.getUnit());
                        DimensionType width = new DimensionType(size.getWidth(), size.getUnit());
                        generatedContent.setHeight(height);
                        generatedContent.setWidth(width);
                    }
                } else {
                    generatedContent = null;
                }
                itemPresentation.finish();
            }
            catch (BirtException ex) {
                this.context.addException(design.getHandle(), ex);
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (!(generatedContent instanceof IImageContent)) return generatedContent;
        IImageContent imageContent = (IImageContent)generatedContent;
        imageContent.setResolution(resolution);
        return generatedContent;
    }

    protected IContent processExtendedContent(IForeignContent content, int type, Object output, String imageMIMEType, Size size) {
        assert ("object/external".equals(content.getRawType()));
        assert (output != null);
        IReportContent reportContent = this.getReportContent();
        switch (type) {
            case 0: {
                break;
            }
            case 1: 
            case 6: {
                Object imageMap = null;
                byte[] imageContent = new byte[]{};
                Object image = output;
                if (type == 6) {
                    Object[] imageWithMap = (Object[])output;
                    if (imageWithMap.length > 0) {
                        image = imageWithMap[0];
                    }
                    if (imageWithMap.length > 1) {
                        imageMap = imageWithMap[1];
                    }
                }
                if (image instanceof InputStream) {
                    imageContent = LocalizedContentVisitor.readContent((InputStream)image);
                } else if (output instanceof byte[]) {
                    imageContent = (byte[])image;
                } else {
                    assert (false);
                    logger.log(Level.WARNING, "unsupported image type:{0}", output);
                }
                IImageContent imageObj = reportContent.createImageContent(content);
                imageObj.setParent(content.getParent());
                imageObj.setImageSource(2);
                imageObj.setData(imageContent);
                imageObj.setImageMap(imageMap);
                imageObj.setMIMEType(imageMIMEType);
                imageObj.setAltText(content.getAltText());
                imageObj.setAltTextKey(content.getAltTextKey());
                IHTMLImageHandler imageHandler = this.context.getImageHandler();
                if (imageHandler != null) {
                    Image img = new Image(imageObj);
                    img.setRenderOption(this.context.getRenderOption());
                    img.setReportRunnable(this.context.getRunnable());
                    img.setImageSize(this.processImageSize(size));
                    String imageId = this.getImageCacheID(content);
                    CachedImage cachedImage = imageHandler.addCachedImage(imageId, 4, img, this.context.getReportContext());
                    if (cachedImage != null) {
                        return this.processCachedImage(content, cachedImage);
                    }
                }
                this.processImage(imageObj);
                return imageObj;
            }
            case 5: {
                IDataContent dataObj = reportContent.createDataContent(content);
                dataObj.setValue(output);
                this.processData(dataObj);
                return dataObj;
            }
            case 3: {
                content.setRawType("text/html");
                content.setRawValue(output.toString());
                return content;
            }
            case 2: {
                ITextContent textObj = reportContent.createTextContent();
                textObj.setText(output.toString());
                return textObj;
            }
            case 7: {
                return content;
            }
            default: {
                assert (false);
                logger.log(Level.WARNING, "unsupported output format:{0}", new Integer(type));
            }
        }
        return content;
    }

    protected static byte[] readContent(InputStream in) {
        BufferedInputStream bin = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int readSize = 0;
        try {
            readSize = bin.read(buffer);
            while (readSize != -1) {
                out.write(buffer, 0, readSize);
                readSize = bin.read(buffer);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return out.toByteArray();
    }

    protected void handleOnRender(IContent content) {
        if (content.getGenerateBy() != null) {
            this.onRenderVisitor.onRender(content);
        }
    }
}

