/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IListGroupEventHandler;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.ListGroup;
import org.eclipse.birt.report.engine.script.internal.instance.ReportElementInstance;
import org.eclipse.birt.report.engine.script.internal.instance.RunningState;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;

public class ListGroupScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(ListGroupHandle groupHandle, ExecutionContext context) {
        try {
            ListGroup group = new ListGroup(groupHandle);
            IListGroupEventHandler eh = ListGroupScriptExecutor.getEventHandler(groupHandle, context);
            if (eh != null) {
                eh.onPrepare(group, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListGroupScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(IListGroupContent content, ExecutionContext context) {
        ReportItemDesign listGroupDesign = (ReportItemDesign)content.getGenerateBy();
        if (!ListGroupScriptExecutor.needOnCreate(listGroupDesign)) {
            return;
        }
        try {
            ReportElementInstance list = new ReportElementInstance(content, context, RunningState.CREATE);
            if (ListGroupScriptExecutor.handleJS(list, listGroupDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IListGroupEventHandler eh = ListGroupScriptExecutor.getEventHandler(listGroupDesign, context);
            if (eh != null) {
                eh.onCreate(list, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListGroupScriptExecutor.addException(context, e, listGroupDesign.getHandle());
        }
    }

    public static void handleOnRender(IListGroupContent content, ExecutionContext context) {
        ReportItemDesign listGroupDesign = (ReportItemDesign)content.getGenerateBy();
        if (!ListGroupScriptExecutor.needOnRender(listGroupDesign)) {
            return;
        }
        try {
            ReportElementInstance list = new ReportElementInstance(content, context, RunningState.RENDER);
            if (ListGroupScriptExecutor.handleJS(list, listGroupDesign.getOnRender(), context).didRun()) {
                return;
            }
            IListGroupEventHandler eh = ListGroupScriptExecutor.getEventHandler(listGroupDesign, context);
            if (eh != null) {
                eh.onRender(list, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListGroupScriptExecutor.addException(context, e, listGroupDesign.getHandle());
        }
    }

    public static void handleOnPageBreak(IListGroupContent content, ExecutionContext context) {
        ReportItemDesign listGroupDesign = (ReportItemDesign)content.getGenerateBy();
        if (!ListGroupScriptExecutor.needOnPageBreak(listGroupDesign)) {
            return;
        }
        try {
            ReportElementInstance list = new ReportElementInstance(content, context, RunningState.PAGEBREAK);
            if (ListGroupScriptExecutor.handleJS(list, listGroupDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IListGroupEventHandler eh = ListGroupScriptExecutor.getEventHandler(listGroupDesign, context);
            if (eh != null) {
                eh.onPageBreak(list, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListGroupScriptExecutor.addException(context, e, listGroupDesign.getHandle());
        }
    }

    private static IListGroupEventHandler getEventHandler(ListGroupHandle handle, ExecutionContext context) {
        try {
            return (IListGroupEventHandler)ListGroupScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            ListGroupScriptExecutor.addClassCastException(context, e, (DesignElementHandle)handle, IListGroupEventHandler.class);
        }
        catch (EngineException e) {
            ListGroupScriptExecutor.addException(context, (Exception)((Object)e), (DesignElementHandle)handle);
        }
        return null;
    }

    private static IListGroupEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (IListGroupEventHandler)ListGroupScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            ListGroupScriptExecutor.addClassCastException(context, e, design.getHandle(), IListGroupEventHandler.class);
        }
        catch (EngineException e) {
            ListGroupScriptExecutor.addException(context, (Exception)((Object)e), design.getHandle());
        }
        return null;
    }
}

