/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.TimeZone;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ReportContextImpl
implements IReportContext {
    protected ExecutionContext context;

    public ReportContextImpl(ExecutionContext context) {
        this.context = context;
    }

    public IReportRunnable getReportRunnable() {
        return this.context.getRunnable();
    }

    public Map getAppContext() {
        return this.context.getAppContext();
    }

    public void setAppContext(Map appContext) {
        this.context.setAppContext(appContext);
    }

    public void setGlobalVariable(String name, Object obj) {
        this.context.registerBean(name, obj);
    }

    public void deleteGlobalVariable(String name) {
        this.context.registerBean(name, null);
    }

    public Object getGlobalVariable(String name) {
        return this.context.getBeans().get(name);
    }

    public void setPersistentGlobalVariable(String name, Serializable obj) {
        this.context.registerGlobalBean(name, obj);
    }

    public void deletePersistentGlobalVariable(String name) {
        this.context.unregisterGlobalBean(name);
    }

    public Object getPersistentGlobalVariable(String name) {
        return this.context.getGlobalBeans().get(name);
    }

    public void setRegisteredPersistantObjects(Map persistantMap) {
        this.context.registerBeans(persistantMap);
    }

    public Object getParameterValue(String name) {
        return this.context.getParameterValue(name);
    }

    public void setParameterValue(String name, Object value) {
        this.context.setParameterValue(name, value);
    }

    public Object getPageVariable(String name) {
        return this.context.getPageVariable(name);
    }

    public void setPageVariable(String name, Object value) {
        this.context.setPageVariable(name, value);
    }

    public Locale getLocale() {
        return this.context.getLocale();
    }

    public TimeZone getTimeZone() {
        return this.context.getTimeZone();
    }

    public String getOutputFormat() {
        return this.context.getOutputFormat();
    }

    public IRenderOption getRenderOption() {
        return this.context.getRenderOption();
    }

    public Object getHttpServletRequest() {
        return this.getAppContext().get("BIRT_VIEWER_HTTPSERVET_REQUEST");
    }

    public String getMessage(String key) {
        return this.context.getDesign().getMessage(key);
    }

    public String getMessage(String key, Locale locale) {
        return this.context.getDesign().getMessage(key, locale);
    }

    public String getMessage(String key, Object[] params) {
        String msg = this.context.getDesign().getMessage(key);
        if (msg == null) {
            return "";
        }
        return MessageFormat.format((String)msg, (Object[])params);
    }

    public String getMessage(String key, Locale locale, Object[] params) {
        String msg = this.context.getDesign().getMessage(key, locale);
        if (msg == null) {
            return "";
        }
        MessageFormat formatter = new MessageFormat(msg, locale);
        return formatter.format(params, new StringBuffer(), null).toString();
    }

    public String getParameterDisplayText(String name) {
        return this.context.getParameterDisplayText(name);
    }

    public void setParameterDisplayText(String name, String displayText) {
        this.context.setParameterDisplayText(name, displayText);
    }

    public int getTaskType() {
        IEngineTask task = this.context.getEngineTask();
        if (task != null) {
            return task.getTaskType();
        }
        return -1;
    }

    public ReportDesignHandle getDesignHandle() {
        return (ReportDesignHandle)this.getReportRunnable().getDesignHandle();
    }

    public URL getResource(String resourceName) {
        return this.context.getResource(resourceName);
    }

    public String getResourceRenderURL(String resourceName) {
        URL resourceUrl;
        IHTMLImageHandler imageHandler;
        IRenderOption option = this.context.getRenderOption();
        if (option != null && (imageHandler = option.getImageHandler()) != null && (resourceUrl = this.context.getResource(resourceName)) != null) {
            Image image = new Image(resourceUrl.toExternalForm());
            if (image.getSource() == 3) {
                return imageHandler.onFileImage((IImage)image, this);
            }
            return imageHandler.onURLImage((IImage)image, this);
        }
        return resourceName;
    }

    public Object evaluate(String script) throws BirtException {
        if (script != null && script.length() > 0) {
            return this.context.evaluate(script);
        }
        return null;
    }
}

