/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewNode
extends TOCNode {
    static final List<ViewNode> EMPTY_CHILDREN = Collections.unmodifiableList(new ArrayList(0));
    TOCView view;
    ITreeNode node;
    int level;

    ViewNode(TOCView view, ViewNode parent, ITreeNode node) {
        this.view = view;
        this.node = node;
        this.nodeId = node.getNodeId();
        this.bookmark = node.getBookmark();
        this.parent = parent;
        if (parent != null) {
            this.level = parent.level + 1;
            this.tocStyle = view.getTOCStyle(this.level - 1, node.getElementId());
            Object value = node.getTOCValue();
            if (value != null) {
                this.displayString = view.localizeValue(value, this.tocStyle);
            }
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public List getChildren() {
        if (this.children == null) {
            this.children = this.createViewChildren();
        }
        return this.children;
    }

    public Object getTOCValue() {
        return this.node.getTOCValue();
    }

    private ArrayList<ViewNode> createViewChildren() {
        ArrayList<ViewNode> children = new ArrayList<ViewNode>();
        for (ITreeNode treeNode : this.node.getChildren()) {
            this.addViewNode(this, children, treeNode);
        }
        return children;
    }

    private void addViewChildren(ViewNode node, ArrayList<ViewNode> children, ITreeNode tree) {
        for (ITreeNode treeNode : tree.getChildren()) {
            this.addViewNode(node, children, treeNode);
        }
    }

    private void addViewNode(ViewNode node, ArrayList<ViewNode> children, ITreeNode treeNode) {
        if (this.isHidden(treeNode)) {
            return;
        }
        if (!this.isVisible(treeNode)) {
            this.addViewChildren(node, children, treeNode);
            return;
        }
        if (treeNode.isGroup()) {
            ViewNode group = this.createGroupNode(node, treeNode);
            if (group != null) {
                children.add(group);
            }
            return;
        }
        if (treeNode.getTOCValue() != null) {
            ViewNode child = new ViewNode(this.view, node, treeNode);
            children.add(child);
            return;
        }
        this.addViewChildren(node, children, treeNode);
    }

    protected ViewNode createGroupNode(ViewNode parent, ITreeNode treeNode) {
        ITreeNode labelNode = this.getFirstNoneNode(treeNode);
        if (labelNode != null) {
            String groupLabel;
            ViewNode groupNode = new ViewNode(this.view, parent, treeNode);
            Object groupValue = labelNode.getTOCValue();
            IScriptStyle groupStyle = groupNode.getTOCStyle();
            groupNode.displayString = groupLabel = this.view.localizeValue(groupValue, groupStyle);
            return groupNode;
        }
        return null;
    }

    private ITreeNode getFirstNoneNode(ITreeNode treeNode) {
        if (this.isHidden(treeNode)) {
            return null;
        }
        if (this.isVisible(treeNode) && treeNode.getTOCValue() != null) {
            return treeNode;
        }
        for (ITreeNode childNode : treeNode.getChildren()) {
            ITreeNode firstNode = this.getFirstNoneNode(childNode);
            if (firstNode == null) continue;
            return firstNode;
        }
        return null;
    }

    protected boolean isHidden(ITreeNode node) {
        return this.view.isHidden(node);
    }

    protected boolean isVisible(ITreeNode node) {
        return this.view.isVisible(node);
    }
}

