/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.page;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeGroupContent;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SimpleCubeBuilder
extends TitleAreaDialog {
    private TabularCubeHandle cube;
    private DataSetHandle dataset;
    private Text nameText;
    private CubeGroupContent group;

    public SimpleCubeBuilder(Shell parentShell) {
        super(parentShell);
    }

    public void setInput(TabularCubeHandle cube, DataSetHandle dataset) {
        this.cube = cube;
        this.dataset = dataset;
        try {
            cube.setDataSet(dataset);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout());
        this.setTitle(Messages.getString("SimpleCubeBuilder.Title.Title"));
        this.setMessage(Messages.getString("SimpleCubeBuilder.Title.Message"));
        this.createNameArea(container);
        this.group = new CubeGroupContent(container, 0);
        this.group.setLayoutData(new GridData(1808));
        this.initDialog();
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.SimpleCubeBuilder_ID");
        return area;
    }

    private void initDialog() {
        if (this.cube != null) {
            this.nameText.setText(this.cube.getName() == null ? "" : this.cube.getName());
            this.group.setInput(this.cube, this.dataset);
            this.group.load();
        }
    }

    protected void createNameArea(Composite parent) {
        Composite nameArea = new Composite(parent, 0);
        nameArea.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 10;
        nameArea.setLayout((Layout)layout);
        Label nameLabel = new Label(nameArea, 0);
        nameLabel.setText(Messages.getString("SimpleCubeBuilder.Label.Name"));
        this.nameText = new Text(nameArea, 2048);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Button finishButton = SimpleCubeBuilder.this.getButton(0);
                if (!SimpleCubeBuilder.this.nameText.getText().trim().equals("")) {
                    block6: {
                        String name = SimpleCubeBuilder.this.nameText.getText().trim();
                        try {
                            SimpleCubeBuilder.this.cube.setName(name);
                            if (finishButton != null) {
                                finishButton.setEnabled(true);
                            }
                            SimpleCubeBuilder.this.setErrorMessage(null);
                            SimpleCubeBuilder.this.setMessage(Messages.getString("SimpleCubeBuilder.Title.Message"));
                        }
                        catch (NameException e1) {
                            SimpleCubeBuilder.this.setErrorMessage(e1.getMessage());
                            if (finishButton == null) break block6;
                            finishButton.setEnabled(false);
                        }
                    }
                    SimpleCubeBuilder.this.group.refresh();
                } else if (finishButton != null) {
                    finishButton.setEnabled(false);
                }
            }
        });
        Label space = new Label(nameArea, 0);
        gd = new GridData();
        gd.widthHint = 70;
        space.setLayoutData((Object)gd);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(IDialogConstants.FINISH_LABEL);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("SimpleCubeBuilder.Title"));
    }
}

