/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.actions;

import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.actions.NewSQLStatementComposite;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewSQLStatementDialog
extends Dialog
implements ModifyListener {
    private NewSQLStatementComposite fDialogArea;
    private IInputValidator stmtNameValidator;

    public NewSQLStatementDialog(Shell parent, IInputValidator validator) {
        super(parent);
        this.stmtNameValidator = validator;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.datatools_sqlbuilder_newStatementDialog_title);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.fDialogArea = new NewSQLStatementComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 25;
        layout.marginWidth = 5;
        this.fDialogArea.setLayout((Layout)layout);
        this.fDialogArea.getStatementNameText().addModifyListener((ModifyListener)this);
        WorkbenchHelp.setHelp((Control)this.fDialogArea, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqld0100");
        return this.fDialogArea;
    }

    public NewSQLStatementComposite getDialogAreaComposite() {
        return this.fDialogArea;
    }

    public void modifyText(ModifyEvent evt) {
        Object source = evt.getSource();
        if (source == this.fDialogArea.getStatementNameText()) {
            String statementName = this.fDialogArea.getStatementNameText().getText().trim();
            if (this.stmtNameValidator != null) {
                String error = this.stmtNameValidator.isValid(statementName);
                if (error != null) {
                    this.getButton(0).setEnabled(false);
                    this.fDialogArea.setErrorLabelText(error);
                } else {
                    this.getButton(0).setEnabled(true);
                    this.fDialogArea.setErrorLabelText("");
                }
            } else {
                this.getButton(0).setEnabled(true);
            }
        }
    }
}

