/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.actions.AddToFavoritesAction;
import org.eclipse.debug.internal.ui.actions.EditLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.commands.actions.DebugCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.DisconnectCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.DropToFrameCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.ResumeCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepIntoCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepOverCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepReturnCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.SuspendCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateAllAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateAndRelaunchAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateAndRemoveAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.ToggleStepFiltersAction;
import org.eclipse.debug.internal.ui.sourcelookup.EditSourceLookupPathAction;
import org.eclipse.debug.internal.ui.sourcelookup.LookupSourceAction;
import org.eclipse.debug.internal.ui.viewers.model.InternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.VirtualFindAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.DebugModelPresentationContext;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.launch.BreadcrumbDropDownAutoExpandAction;
import org.eclipse.debug.internal.ui.views.launch.BreadcrumbWorkbenchPart;
import org.eclipse.debug.internal.ui.views.launch.DebugViewModeAction;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewBreadcrumb;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewMessages;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.contexts.AbstractDebugContextProvider;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;

public class LaunchView
extends AbstractDebugView
implements ISelectionChangedListener,
IPerspectiveListener2,
IPageListener,
IShowInTarget,
IShowInSource,
IShowInTargetList,
IPartListener2,
IViewerUpdateListener {
    public static final String ID_CONTEXT_ACTIVITY_BINDINGS = "contextActivityBindings";
    private static final String TERMINATE = "terminate";
    private static final String DISCONNECT = "disconnect";
    private static final String SUSPEND = "suspend";
    private static final String RESUME = "resume";
    private static final String STEP_RETURN = "step_return";
    private static final String STEP_OVER = "step_over";
    private static final String DROP_TO_FRAME = "drop_to_frame";
    private static final String STEP_INTO = "step_into";
    private static final String TERMINATE_AND_REMOVE = "terminate_and_remove";
    private static final String TERMINATE_ALL = "terminate_all";
    private static final String TERMINATE_AND_RELAUNCH = "terminate_relaunch";
    private static final String TOGGLE_STEP_FILTERS = "toggle_step_filters";
    private static final int BREADCRUMB_TRIGGER_RANGE = 5;
    private static final int BREADCRUMB_STICKY_RANGE = 20;
    private boolean fIsActive = true;
    private IDebugModelPresentation fPresentation = null;
    private EditLaunchConfigurationAction fEditConfigAction = null;
    private AddToFavoritesAction fAddToFavoritesAction = null;
    private EditSourceLookupPathAction fEditSourceAction = null;
    private LookupSourceAction fLookupAction = null;
    private String fCurrentViewMode = "Debug_view.mode.auto";
    private DebugViewModeAction[] fDebugViewModeActions;
    private BreadcrumbDropDownAutoExpandAction fBreadcrumbDropDownAutoExpandAction;
    private String PREF_STATE_MEMENTO = "pref_state_memento.";
    private static final String BREADCRUMB_DROPDOWN_AUTO_EXPAND = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".BREADCRUMB_DROPDOWN_AUTO_EXPAND";
    private boolean fBreadcrumbDropDownAutoExpand = false;
    private BreadcrumbPage fBreadcrumbPage;
    private TreeViewerContextProvider fTreeViewerDebugContextProvider;
    private PageBookView.PageRec fDefaultPageRec = null;
    private ISelectionChangedListener fTreeViewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            LaunchView.this.fTreeViewerDebugContextProvider.activate(event.getSelection());
        }
    };
    private ContextProviderProxy fContextProviderProxy;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.debug_view_context";
    }

    protected void createActions() {
        this.setAction("Properties", (IAction)new PropertyDialogAction((IShellProvider)this.getSite(), this.getSite().getSelectionProvider()));
        this.fEditConfigAction = new EditLaunchConfigurationAction();
        this.fAddToFavoritesAction = new AddToFavoritesAction();
        this.fEditSourceAction = new EditSourceLookupPathAction(this);
        this.fLookupAction = new LookupSourceAction(this);
        this.setAction(FIND_ACTION, (IAction)new VirtualFindAction((InternalTreeModelViewer)this.getViewer()));
        this.addCapabilityAction(new TerminateCommandAction(), TERMINATE);
        this.addCapabilityAction(new DisconnectCommandAction(), DISCONNECT);
        this.addCapabilityAction(new SuspendCommandAction(), SUSPEND);
        this.addCapabilityAction(new ResumeCommandAction(), RESUME);
        this.addCapabilityAction(new StepReturnCommandAction(), STEP_RETURN);
        this.addCapabilityAction(new StepOverCommandAction(), STEP_OVER);
        this.addCapabilityAction(new StepIntoCommandAction(), STEP_INTO);
        this.addCapabilityAction(new DropToFrameCommandAction(), DROP_TO_FRAME);
        this.addCapabilityAction(new TerminateAndRemoveAction(), TERMINATE_AND_REMOVE);
        this.addCapabilityAction(new TerminateAndRelaunchAction(), TERMINATE_AND_RELAUNCH);
        this.addCapabilityAction(new TerminateAllAction(), TERMINATE_ALL);
        this.addCapabilityAction(new ToggleStepFiltersAction(), TOGGLE_STEP_FILTERS);
    }

    private void addCapabilityAction(DebugCommandAction capability, String actionID) {
        capability.init((IWorkbenchPart)this);
        this.setAction(actionID, (IAction)capability);
    }

    private void disposeCommandAction(String actionID) {
        DebugCommandAction action = (DebugCommandAction)this.getAction(actionID);
        action.dispose();
    }

    public void createPartControl(final Composite parent) {
        super.createPartControl(parent);
        this.setGlobalActionBarsToPage((IPageBookViewPage)this.getDefaultPage());
        this.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        ((IPageBookViewPage)this.getDefaultPage()).getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.partActivated(new BreadcrumbWorkbenchPart(this.getSite()));
        this.fContextProviderProxy = new ContextProviderProxy(new IDebugContextProvider[]{this.fTreeViewerDebugContextProvider, this.fBreadcrumbPage.getContextProvider()});
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).addDebugContextProvider(this.fContextProviderProxy);
        this.createViewModeActions(parent);
        IPreferenceStore prefStore = DebugUIPlugin.getDefault().getPreferenceStore();
        String mode = prefStore.getString("org.eclispe.debug.ui.Debug_view.mode");
        this.setViewMode(mode, parent);
        int i = 0;
        while (i < this.fDebugViewModeActions.length) {
            this.fDebugViewModeActions[i].setChecked(this.fDebugViewModeActions[i].getMode().equals(mode));
            ++i;
        }
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (parent.isDisposed()) {
                    return;
                }
                if ("Debug_view.mode.auto".equals(LaunchView.this.fCurrentViewMode)) {
                    LaunchView.this.autoSelectViewPage(parent);
                }
            }
        });
    }

    private void setGlobalActionBarsToPage(IPageBookViewPage page) {
        IActionBars pageActionBars = page.getSite().getActionBars();
        IActionBars bars = this.getViewSite().getActionBars();
        pageActionBars.setGlobalActionHandler(FIND_ACTION, bars.getGlobalActionHandler(FIND_ACTION));
        pageActionBars.setGlobalActionHandler(COPY_ACTION, bars.getGlobalActionHandler(COPY_ACTION));
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (part instanceof BreadcrumbWorkbenchPart) {
            this.fBreadcrumbPage = new BreadcrumbPage();
            this.fBreadcrumbPage.createControl((Composite)this.getPageBook());
            this.initPage((IPageBookViewPage)this.fBreadcrumbPage);
            this.setGlobalActionBarsToPage((IPageBookViewPage)this.fBreadcrumbPage);
            return new PageBookView.PageRec(part, (IPage)this.fBreadcrumbPage);
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof BreadcrumbWorkbenchPart;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        if (pageRec.page == this.getDefaultPage()) {
            this.fDefaultPageRec = pageRec;
        }
        super.showPageRec(pageRec);
    }

    private void createViewModeActions(Composite parent) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fDebugViewModeActions = new DebugViewModeAction[3];
        this.fDebugViewModeActions[0] = new DebugViewModeAction(this, "Debug_view.mode.auto", parent);
        this.fDebugViewModeActions[1] = new DebugViewModeAction(this, "Debug_view.mode.full", parent);
        this.fDebugViewModeActions[2] = new DebugViewModeAction(this, "Debug_view.mode.compact", parent);
        this.fBreadcrumbDropDownAutoExpandAction = new BreadcrumbDropDownAutoExpandAction(this);
        viewMenu.add((IContributionItem)new Separator());
        final MenuManager modeSubmenu = new MenuManager(LaunchViewMessages.LaunchView_ViewModeMenu_label);
        modeSubmenu.setRemoveAllWhenShown(true);
        modeSubmenu.add((IAction)this.fDebugViewModeActions[0]);
        modeSubmenu.add((IAction)this.fDebugViewModeActions[1]);
        modeSubmenu.add((IAction)this.fDebugViewModeActions[2]);
        modeSubmenu.add((IContributionItem)new Separator());
        modeSubmenu.add((IAction)this.fBreadcrumbDropDownAutoExpandAction);
        viewMenu.add((IContributionItem)modeSubmenu);
        viewMenu.add((IContributionItem)new Separator());
        modeSubmenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                modeSubmenu.add((IAction)LaunchView.this.fDebugViewModeActions[0]);
                modeSubmenu.add((IAction)LaunchView.this.fDebugViewModeActions[1]);
                modeSubmenu.add((IAction)LaunchView.this.fDebugViewModeActions[2]);
                modeSubmenu.add((IContributionItem)new Separator());
                modeSubmenu.add((IAction)LaunchView.this.fBreadcrumbDropDownAutoExpandAction);
            }
        });
    }

    void setViewMode(String mode, Composite parent) {
        if (this.fCurrentViewMode.equals(mode)) {
            return;
        }
        this.fCurrentViewMode = mode;
        if ("Debug_view.mode.compact".equals(mode)) {
            this.showBreadcrumbPage();
        } else if ("Debug_view.mode.full".equals(mode)) {
            this.showTreeViewerPage();
        } else {
            this.autoSelectViewPage(parent);
        }
        DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclispe.debug.ui.Debug_view.mode", mode);
    }

    private void autoSelectViewPage(Composite parent) {
        int breadcrumbHeight = this.fBreadcrumbPage.getHeight();
        if (parent.getClientArea().height < breadcrumbHeight + 5) {
            this.showBreadcrumbPage();
        } else if (parent.getClientArea().height > breadcrumbHeight + 20) {
            this.showTreeViewerPage();
        }
    }

    void showTreeViewerPage() {
        if (this.fDefaultPageRec != null && !this.getDefaultPage().equals(this.getCurrentPage())) {
            this.showPageRec(this.fDefaultPageRec);
            this.fContextProviderProxy.setActiveProvider(this.fTreeViewerDebugContextProvider);
            this.fBreadcrumbPage.fCrumb.clearSelection();
        }
    }

    void showBreadcrumbPage() {
        PageBookView.PageRec rec = this.getPageRec((IPage)this.fBreadcrumbPage);
        if (rec != null && !((Object)((Object)this.fBreadcrumbPage)).equals(this.getCurrentPage())) {
            this.showPageRec(rec);
            if (this.getSite().getPage().getActivePart() == this) {
                this.setFocus();
            }
            this.fBreadcrumbPage.fCrumb.debugContextChanged(new DebugContextEvent(this.fTreeViewerDebugContextProvider, this.fTreeViewerDebugContextProvider.getActiveContext(), 1));
            this.fContextProviderProxy.setActiveProvider(this.fBreadcrumbPage.getContextProvider());
        }
    }

    protected Viewer createViewer(Composite parent) {
        this.fPresentation = new DelegatingModelPresentation();
        TreeModelViewer viewer = new TreeModelViewer(parent, 268436226, new DebugModelPresentationContext("org.eclipse.debug.ui.DebugView", this.fPresentation));
        viewer.addSelectionChangedListener(this.fTreeViewerSelectionChangedListener);
        viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    LaunchView.this.handleDeleteKeyPressed();
                }
            }
        });
        viewer.addViewerUpdateListener(this);
        viewer.setInput(DebugPlugin.getDefault().getLaunchManager());
        this.fTreeViewerDebugContextProvider = new TreeViewerContextProvider(viewer);
        return viewer;
    }

    private void handleDeleteKeyPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        Iterator iter = selection.iterator();
        boolean itemsToTerminate = false;
        while (iter.hasNext()) {
            ITerminate terminable;
            Object item = iter.next();
            if (!(item instanceof ITerminate) || !(terminable = (ITerminate)item).canTerminate() || terminable.isTerminated()) continue;
            itemsToTerminate = true;
            break;
        }
        if (itemsToTerminate && !MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)DebugUIViewsMessages.LaunchView_Terminate_and_Remove_1, (String)DebugUIViewsMessages.LaunchView_Terminate_and_remove_selected__2)) {
            return;
        }
        MultiStatus status = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, DebugUIViewsMessages.LaunchView_Exceptions_occurred_attempting_to_terminate_and_remove_3, null);
        iter = selection.iterator();
        while (iter.hasNext()) {
            try {
                LaunchView.terminateAndRemove(iter.next());
            }
            catch (DebugException exception) {
                status.merge(exception.getStatus());
            }
        }
        if (!status.isOK()) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), DebugUIViewsMessages.LaunchView_Terminate_and_Remove_4, DebugUIViewsMessages.LaunchView_Terminate_and_remove_failed_5, (IStatus)status);
            } else {
                DebugUIPlugin.log((IStatus)status);
            }
        }
    }

    public static void terminateAndRemove(Object element) throws DebugException {
        ILaunch launch = null;
        ILaunch terminable = null;
        if (element instanceof ILaunch) {
            launch = (ILaunch)element;
        } else if (element instanceof IDebugElement) {
            launch = ((IDebugElement)element).getLaunch();
        } else if (element instanceof IProcess) {
            launch = ((IProcess)element).getLaunch();
        }
        terminable = launch;
        if (terminable == null && element instanceof ITerminate) {
            terminable = (ITerminate)element;
        }
        if (terminable == null) {
            return;
        }
        if (!terminable.canTerminate() && !terminable.isTerminated()) {
            return;
        }
        try {
            if (!terminable.isTerminated()) {
                terminable.terminate();
            }
        }
        finally {
            if (launch != null) {
                ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
                lManager.removeLaunch(launch);
            }
        }
    }

    private void commonInit(IViewSite site) {
        site.getPage().addPartListener((IPartListener2)this);
        site.getWorkbenchWindow().addPageListener((IPageListener)this);
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    private void preferenceInit(IViewSite site) {
        Boolean auto;
        IMemento mem;
        block13: {
            this.PREF_STATE_MEMENTO = String.valueOf(this.PREF_STATE_MEMENTO) + site.getId();
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            String string = store.getString(this.PREF_STATE_MEMENTO);
            if (string.length() > 0) {
                ByteArrayInputStream bin = new ByteArrayInputStream(string.getBytes());
                InputStreamReader reader = new InputStreamReader(bin);
                try {
                    try {
                        XMLMemento stateMemento = XMLMemento.createReadRoot((Reader)reader);
                        this.setMemento((IMemento)stateMemento);
                    }
                    catch (WorkbenchException workbenchException) {
                        try {
                            reader.close();
                            bin.close();
                        }
                        catch (IOException iOException) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                        bin.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    reader.close();
                    bin.close();
                }
                catch (IOException iOException) {}
            }
        }
        if ((mem = this.getMemento()) != null && (auto = mem.getBoolean(BREADCRUMB_DROPDOWN_AUTO_EXPAND)) != null) {
            this.setBreadcrumbDropDownAutoExpand(auto);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.commonInit(site);
        this.preferenceInit(site);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.commonInit(site);
        this.preferenceInit(site);
    }

    public void partDeactivated(IWorkbenchPart part) {
        block12: {
            String id = part.getSite().getId();
            if (id.equals(this.getSite().getId())) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(bout);
                try {
                    try {
                        XMLMemento memento = XMLMemento.createWriteRoot((String)"DebugViewMemento");
                        this.saveViewerState((IMemento)memento);
                        memento.save((Writer)writer);
                        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
                        String xmlString = bout.toString();
                        store.putValue(this.PREF_STATE_MEMENTO, xmlString);
                    }
                    catch (IOException iOException) {
                        try {
                            writer.close();
                            bout.close();
                        }
                        catch (IOException iOException2) {}
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                        bout.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    writer.close();
                    bout.close();
                }
                catch (IOException iOException) {}
            }
        }
        super.partDeactivated(part);
    }

    public void saveViewerState(IMemento memento) {
        memento.putBoolean(BREADCRUMB_DROPDOWN_AUTO_EXPAND, this.getBreadcrumbDropDownAutoExpand());
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("threadGroup"));
        tbm.add((IContributionItem)new Separator("stepGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepOverGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        tbm.add((IContributionItem)new GroupMarker("emptyStepGroup"));
        tbm.add((IContributionItem)new Separator("renderGroup"));
        tbm.appendToGroup("threadGroup", this.getAction(RESUME));
        tbm.appendToGroup("threadGroup", this.getAction(SUSPEND));
        tbm.appendToGroup("threadGroup", this.getAction(TERMINATE));
        tbm.appendToGroup("threadGroup", this.getAction(DISCONNECT));
        tbm.appendToGroup("stepIntoGroup", this.getAction(STEP_INTO));
        tbm.appendToGroup("stepOverGroup", this.getAction(STEP_OVER));
        tbm.appendToGroup("stepReturnGroup", this.getAction(STEP_RETURN));
        tbm.appendToGroup("emptyStepGroup", this.getAction(DROP_TO_FRAME));
        tbm.appendToGroup("renderGroup", this.getAction(TOGGLE_STEP_FILTERS));
    }

    public void dispose() {
        this.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).removeDebugContextProvider(this.fContextProviderProxy);
        this.fContextProviderProxy.dispose();
        this.fTreeViewerDebugContextProvider.dispose();
        this.disposeActions();
        Viewer viewer = this.getViewer();
        if (viewer != null) {
            viewer.removeSelectionChangedListener(this.fTreeViewerSelectionChangedListener);
            ((TreeModelViewer)viewer).removeViewerUpdateListener(this);
        }
        IWorkbenchPage page = this.getSite().getPage();
        page.removePartListener((IPartListener2)this);
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.removePerspectiveListener((IPerspectiveListener)this);
        window.removePageListener((IPageListener)this);
        super.dispose();
    }

    private void disposeActions() {
        PropertyDialogAction properties = (PropertyDialogAction)this.getAction("Properties");
        properties.dispose();
        this.disposeCommandAction(TERMINATE);
        this.disposeCommandAction(DISCONNECT);
        this.disposeCommandAction(SUSPEND);
        this.disposeCommandAction(RESUME);
        this.disposeCommandAction(STEP_RETURN);
        this.disposeCommandAction(STEP_OVER);
        this.disposeCommandAction(STEP_INTO);
        this.disposeCommandAction(DROP_TO_FRAME);
        this.disposeCommandAction(TERMINATE_AND_REMOVE);
        this.disposeCommandAction(TERMINATE_AND_RELAUNCH);
        this.disposeCommandAction(TERMINATE_ALL);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateObjects();
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object o = ss.getFirstElement();
        if (o == null || o instanceof IStackFrame) {
            return;
        }
        StructuredViewer viewer = (StructuredViewer)this.getViewer();
        viewer.refresh(o);
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.setActive(page.findView(this.getSite().getId()) != null);
        this.updateObjects();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        this.setActive(page.findView(this.getSite().getId()) != null);
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public void pageActivated(IWorkbenchPage page) {
        if (this.getSite().getPage().equals(page)) {
            this.setActive(true);
            this.updateObjects();
        }
    }

    public void pageClosed(IWorkbenchPage page) {
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public IDebugModelPresentation getPresentation(String id) {
        return ((DelegatingModelPresentation)this.fPresentation).getPresentation(id);
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyEditGroup"));
        menu.add((IContributionItem)new Separator("editGroup"));
        menu.add(this.getAction(FIND_ACTION));
        menu.add((IContributionItem)new Separator("emptyStepGroup"));
        menu.add((IContributionItem)new Separator("stepGroup"));
        menu.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        menu.add((IContributionItem)new GroupMarker("stepOverGroup"));
        menu.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("emptyThreadGroup"));
        menu.add((IContributionItem)new Separator("threadGroup"));
        menu.add((IContributionItem)new Separator("emptyLaunchGroup"));
        menu.add((IContributionItem)new Separator("launchGroup"));
        IStructuredSelection selection = (IStructuredSelection)this.getSite().getSelectionProvider().getSelection();
        this.updateAndAdd(menu, this.fEditConfigAction, selection);
        this.updateAndAdd(menu, this.fAddToFavoritesAction, selection);
        this.updateAndAdd(menu, this.fEditSourceAction, selection);
        this.updateAndAdd(menu, this.fLookupAction, selection);
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("propertyGroup"));
        PropertyDialogAction action = (PropertyDialogAction)this.getAction("Properties");
        TreeSelection sel = (TreeSelection)this.fTreeViewerDebugContextProvider.getActiveContext();
        boolean enabled = true;
        if (sel != null && sel.size() > 0) {
            enabled = !(sel.getFirstElement() instanceof ILaunch);
        }
        action.setEnabled(action.isApplicableForSelection() && enabled);
        menu.add((IAction)action);
        menu.add((IContributionItem)new Separator("additions"));
        menu.appendToGroup("launchGroup", this.getAction(TERMINATE_AND_REMOVE));
        menu.appendToGroup("launchGroup", this.getAction(TERMINATE_ALL));
        menu.appendToGroup("threadGroup", this.getAction(RESUME));
        menu.appendToGroup("threadGroup", this.getAction(SUSPEND));
        menu.appendToGroup("threadGroup", this.getAction(TERMINATE));
        menu.appendToGroup("threadGroup", this.getAction(TERMINATE_AND_RELAUNCH));
        menu.appendToGroup("threadGroup", this.getAction(DISCONNECT));
        menu.appendToGroup("stepIntoGroup", this.getAction(STEP_INTO));
        menu.appendToGroup("stepOverGroup", this.getAction(STEP_OVER));
        menu.appendToGroup("stepReturnGroup", this.getAction(STEP_RETURN));
        menu.appendToGroup("emptyStepGroup", this.getAction(DROP_TO_FRAME));
        menu.appendToGroup("renderGroup", this.getAction(TOGGLE_STEP_FILTERS));
    }

    private void updateAndAdd(IMenuManager menu, SelectionListenerAction action, IStructuredSelection selection) {
        action.selectionChanged(selection);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
    }

    protected void setActive(boolean active) {
        this.fIsActive = active;
    }

    protected boolean isActive() {
        return this.fIsActive && this.getViewer() != null;
    }

    public boolean show(ShowInContext context) {
        Object obj;
        IStructuredSelection ss;
        ISelection selection = context.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && ((obj = ss.getFirstElement()) instanceof IDebugTarget || obj instanceof IProcess)) {
            Viewer viewer = this.getViewer();
            if (viewer instanceof InternalTreeModelViewer) {
                InternalTreeModelViewer tv = (InternalTreeModelViewer)viewer;
                tv.setSelection(selection, true, true);
            } else {
                viewer.setSelection(selection, true);
            }
            return true;
        }
        return false;
    }

    public ShowInContext getShowInContext() {
        Object object;
        IStructuredSelection selection;
        if (this.isActive() && (selection = (IStructuredSelection)this.getViewer().getSelection()).size() == 1 && (object = selection.getFirstElement()) instanceof IAdaptable) {
            IShowInSource show;
            IAdaptable adaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((show = (IShowInSource)adaptable.getAdapter((Class)clazz)) != null) {
                return show.getShowInContext();
            }
        }
        return null;
    }

    public String[] getShowInTargetIds() {
        Object object;
        IStructuredSelection selection;
        if (this.isActive() && (selection = (IStructuredSelection)this.getViewer().getSelection()).size() == 1 && (object = selection.getFirstElement()) instanceof IAdaptable) {
            IShowInTargetList show;
            IAdaptable adaptable = (IAdaptable)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((show = (IShowInTargetList)adaptable.getAdapter((Class)clazz)) != null) {
                return show.getShowInTargetIds();
            }
        }
        return new String[0];
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part == this) {
            this.setActive(true);
            this.getSite().getPage().showActionSet("org.eclipse.debug.ui.debugActionSet");
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    protected void becomesVisible() {
        super.becomesVisible();
        this.getViewer().refresh();
    }

    public void updateComplete(IViewerUpdate update) {
    }

    public void updateStarted(IViewerUpdate update) {
    }

    public synchronized void viewerUpdatesBegin() {
        IWorkbenchSiteProgressService progressService;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((progressService = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            progressService.incrementBusy();
        }
    }

    public synchronized void viewerUpdatesComplete() {
        IWorkbenchSiteProgressService progressService;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((progressService = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            progressService.decrementBusy();
        }
    }

    boolean isBreadcrumbVisible() {
        return ((Object)((Object)this.fBreadcrumbPage)).equals(this.getCurrentPage());
    }

    boolean getBreadcrumbDropDownAutoExpand() {
        return this.fBreadcrumbDropDownAutoExpand;
    }

    void setBreadcrumbDropDownAutoExpand(boolean expand) {
        this.fBreadcrumbDropDownAutoExpand = expand;
    }

    private class BreadcrumbPage
    extends Page {
        LaunchViewBreadcrumb fCrumb;
        Control fControl;

        private BreadcrumbPage() {
        }

        public void createControl(Composite parent) {
            this.fCrumb = new LaunchViewBreadcrumb(LaunchView.this, (TreeModelViewer)LaunchView.this.getViewer(), LaunchView.this.fTreeViewerDebugContextProvider);
            this.fControl = this.fCrumb.createContent(parent);
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            pageSite.setSelectionProvider(this.fCrumb.getSelectionProvider());
        }

        public Control getControl() {
            return this.fControl;
        }

        public void setFocus() {
            this.fCrumb.activate();
        }

        IDebugContextProvider getContextProvider() {
            return this.fCrumb.getContextProvider();
        }

        int getHeight() {
            return this.fCrumb.getHeight();
        }
    }

    private class ContextProviderProxy
    extends AbstractDebugContextProvider
    implements IDebugContextListener {
        private IDebugContextProvider fActiveProvider;
        private IDebugContextProvider[] fProviders;

        ContextProviderProxy(IDebugContextProvider[] providers) {
            super((IWorkbenchPart)LaunchView.this);
            this.fProviders = providers;
            this.fActiveProvider = providers[0];
            int i = 0;
            while (i < this.fProviders.length) {
                this.fProviders[i].addDebugContextListener(this);
                ++i;
            }
        }

        void setActiveProvider(IDebugContextProvider provider) {
            if (!provider.equals(this.fActiveProvider)) {
                ISelection activeContext = this.getActiveContext();
                this.fActiveProvider = provider;
                ISelection newActiveContext = this.getActiveContext();
                if (!activeContext.equals(newActiveContext)) {
                    this.fire(new DebugContextEvent(this, this.getActiveContext(), 1));
                }
            }
        }

        public ISelection getActiveContext() {
            ISelection activeContext = this.fActiveProvider.getActiveContext();
            if (activeContext != null) {
                return activeContext;
            }
            return TreeSelection.EMPTY;
        }

        public void debugContextChanged(DebugContextEvent event) {
            if (event.getSource().equals(this.fActiveProvider)) {
                this.fire(new DebugContextEvent(this, event.getContext(), event.getFlags()));
            }
        }

        void dispose() {
            int i = 0;
            while (i < this.fProviders.length) {
                this.fProviders[i].removeDebugContextListener(this);
                ++i;
            }
            this.fProviders = null;
            this.fActiveProvider = null;
        }
    }

    class TreeViewerContextProvider
    extends AbstractDebugContextProvider
    implements IModelChangedListener {
        private ISelection fContext = null;
        private TreeModelViewer fViewer = null;
        private Visitor fVisitor = new Visitor();

        private TreePath getViewerTreePath(IModelDelta node) {
            ArrayList<Object> list = new ArrayList<Object>();
            IModelDelta parentDelta = node.getParentDelta();
            while (parentDelta != null) {
                list.add(0, node.getElement());
                node = parentDelta;
                parentDelta = node.getParentDelta();
            }
            return new TreePath(list.toArray());
        }

        public TreeViewerContextProvider(TreeModelViewer viewer) {
            super((IWorkbenchPart)LaunchView.this);
            this.fViewer = viewer;
            this.fViewer.addModelChangedListener(this);
        }

        protected void dispose() {
            this.fContext = null;
            this.fViewer.removeModelChangedListener(this);
        }

        public synchronized ISelection getActiveContext() {
            return this.fContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void activate(ISelection selection) {
            TreeViewerContextProvider treeViewerContextProvider = this;
            synchronized (treeViewerContextProvider) {
                this.fContext = selection;
            }
            this.fire(new DebugContextEvent(this, selection, 1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void possibleChange(TreePath element, int type) {
            DebugContextEvent event = null;
            TreeViewerContextProvider treeViewerContextProvider = this;
            synchronized (treeViewerContextProvider) {
                TreePath current;
                ITreeSelection ss;
                if (this.fContext instanceof ITreeSelection && (ss = (ITreeSelection)this.fContext).size() == 1 && (current = ss.getPaths()[0]).startsWith(element, null)) {
                    event = current.getSegmentCount() == element.getSegmentCount() ? new DebugContextEvent(this, this.fContext, type) : new DebugContextEvent(this, this.fContext, 16);
                }
            }
            if (event == null) {
                return;
            }
            if (LaunchView.this.getControl().getDisplay().getThread() == Thread.currentThread()) {
                this.fire(event);
            } else {
                DebugContextEvent finalEvent = event;
                UIJob job = new UIJob(this, "context change", finalEvent){
                    final /* synthetic */ TreeViewerContextProvider this$1;
                    private final /* synthetic */ DebugContextEvent val$finalEvent;
                    {
                        this.this$1 = treeViewerContextProvider;
                        this.val$finalEvent = debugContextEvent;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        TreeViewerContextProvider treeViewerContextProvider = this.this$1;
                        synchronized (treeViewerContextProvider) {
                            if (TreeViewerContextProvider.access$1(this.this$1) instanceof IStructuredSelection) {
                                IStructuredSelection ss = (IStructuredSelection)TreeViewerContextProvider.access$1(this.this$1);
                                Object changed = ((IStructuredSelection)this.val$finalEvent.getContext()).getFirstElement();
                                if (ss.size() != 1 || !ss.getFirstElement().equals(changed)) {
                                    return Status.OK_STATUS;
                                }
                            }
                        }
                        TreeViewerContextProvider.access$2(this.this$1, this.val$finalEvent);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }

        public void modelChanged(IModelDelta delta, IModelProxy proxy) {
            delta.accept(this.fVisitor);
        }

        static /* synthetic */ ISelection access$1(TreeViewerContextProvider treeViewerContextProvider) {
            return treeViewerContextProvider.fContext;
        }

        static /* synthetic */ void access$2(TreeViewerContextProvider treeViewerContextProvider, DebugContextEvent debugContextEvent) {
            treeViewerContextProvider.fire(debugContextEvent);
        }

        class Visitor
        implements IModelDeltaVisitor {
            Visitor() {
            }

            public boolean visit(IModelDelta delta, int depth) {
                if ((delta.getFlags() & 0xC00) > 0 && (delta.getFlags() & 0x200000) == 0) {
                    if ((delta.getFlags() & 0x400) > 0) {
                        TreeViewerContextProvider.this.possibleChange(TreeViewerContextProvider.this.getViewerTreePath(delta), 1);
                    } else if ((delta.getFlags() & 0x800) > 0) {
                        TreeViewerContextProvider.this.possibleChange(TreeViewerContextProvider.this.getViewerTreePath(delta), 16);
                    }
                }
                return true;
            }
        }
    }
}

