/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.ModulePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ComboPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.TextPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.ComboSection;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.TextAndTwoButtonSection;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.TextSection;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ThumbnailBuilder;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;

public class ReportPage
extends ModulePage {
    private TextAndTwoButtonSection prvImageSection;

    public void buildUI(Composite parent) {
        super.buildUI(parent);
        ComboPropertyDescriptorProvider layoutProvider = new ComboPropertyDescriptorProvider("layoutPreference", "ReportDesign");
        ComboSection layoutSection = new ComboSection(layoutProvider.getDisplayName(), this.container, true);
        layoutSection.setProvider(layoutProvider);
        layoutSection.setWidth(500);
        layoutSection.setGridPlaceholder(2, true);
        this.addSection("REPORT_LAYOUT_PREFERENCE", layoutSection);
        ComboPropertyDescriptorProvider biDiOrientatonProvider = new ComboPropertyDescriptorProvider("bidiLayoutOrientation", "ReportDesign");
        ComboSection biDiOrientatonSection = new ComboSection(biDiOrientatonProvider.getDisplayName(), this.container, true);
        biDiOrientatonSection.setProvider(biDiOrientatonProvider);
        biDiOrientatonSection.setWidth(500);
        biDiOrientatonSection.setGridPlaceholder(2, true);
        this.addSection("REPORT_BIDI_ORIENTATION", biDiOrientatonSection);
        TextPropertyDescriptorProvider displayProvider = new TextPropertyDescriptorProvider("displayName", "ReportDesign");
        TextSection displaySection = new TextSection(displayProvider.getDisplayName(), this.container, true);
        displaySection.setProvider(displayProvider);
        displaySection.setWidth(500);
        displaySection.setGridPlaceholder(2, true);
        this.addSection("REPORT_DISPLAY", displaySection);
        TextPropertyDescriptorProvider prvImageProvider = new TextPropertyDescriptorProvider("iconFile", "ReportDesign");
        this.prvImageSection = new TextAndTwoButtonSection(prvImageProvider.getDisplayName(), this.container, true);
        this.prvImageSection.setProvider(prvImageProvider);
        this.prvImageSection.addSecondSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThumbnailBuilder dialog = new ThumbnailBuilder();
                dialog.setImageName(ReportPage.this.prvImageSection.getTextControl().getText());
                ReportDesignHandle handle = (ReportDesignHandle)SessionHandleAdapter.getInstance().getReportDesignHandle();
                dialog.setReportDesignHandle(handle);
                if (dialog.open() != 0) {
                    Image image = dialog.getImage();
                    if (image != null) {
                        image.dispose();
                        image = null;
                    }
                    return;
                }
                if (dialog.shouldSetThumbnail()) {
                    Image image = dialog.getImage();
                    if (image != null) {
                        ImageData imageData = image.getImageData();
                        ImageLoader imageLoader = new ImageLoader();
                        imageLoader.data = new ImageData[1];
                        imageLoader.data[0] = imageData;
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        imageLoader.save((OutputStream)outputStream, 5);
                        try {
                            handle.setThumbnail(outputStream.toByteArray());
                        }
                        catch (SemanticException e1) {
                            ExceptionHandler.handle((Throwable)e1);
                        }
                        image.dispose();
                        image = null;
                    }
                    ReportPage.this.prvImageSection.setStringValue(dialog.getImageName());
                    ReportPage.this.prvImageSection.forceFocus();
                } else {
                    if (handle.getThumbnail() != null && handle.getThumbnail().length != 0) {
                        try {
                            handle.deleteThumbnail();
                        }
                        catch (SemanticException e1) {
                            ExceptionHandler.handle((Throwable)e1);
                        }
                    }
                    ReportPage.this.prvImageSection.setStringValue("");
                    ReportPage.this.prvImageSection.forceFocus();
                }
            }
        });
        this.prvImageSection.setWidth(500);
        this.prvImageSection.setSecondButtonText("...");
        this.prvImageSection.setSecondButtonTooltipText(Messages.getString((String)"ReportPage.PreviewImage.Button.ToolTip"));
        this.addSection("REPORT_PRVIMAGE", this.prvImageSection);
        this.createSections();
        this.layoutSections();
    }
}

