/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FormatDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FormatDateTimePattern;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;

public class FormatDataTimeDescriptorProvider
extends FormatDescriptorProvider {
    private Object input;
    private Date defaultDate;
    private String[][] choiceArray = null;
    private String[] formatTypes = null;
    private List listeners = new ArrayList();
    public String DATETIEM_FORMAT_TYPE_UNFORMATTED = "Unformatted";
    public String DATETIEM_FORMAT_TYPE_CUSTOM = "Custom";
    public String NUMBER_FORMAT_TYPE_CUSTOM = "Custom";
    public String DATETIEM_FORMAT_TYPE_GENERAL_DATE = "General Date";
    public String DATETIEM_FORMAT_TYPE_LONG_DATE = "Long Date";
    public String DATETIEM_FORMAT_TYPE_MUDIUM_DATE = "Medium Date";
    public String DATETIEM_FORMAT_TYPE_SHORT_DATE = "Short Date";
    public String DATETIEM_FORMAT_TYPE_LONG_TIME = "Long Time";
    public String DATETIEM_FORMAT_TYPE_MEDIUM_TIME = "Medium Time";
    public String DATETIEM_FORMAT_TYPE_SHORT_TIME = "Short Time";

    public String getDisplayName() {
        return null;
    }

    public Object load() {
        PropertyHandle propHandle;
        FormatValue formatValueToSet;
        FormatValueHandle formatHandle;
        ULocale uLocale;
        StyleHandle style;
        Object formatValue;
        if (DEUtil.getInputElements((Object)this.input).isEmpty()) {
            return null;
        }
        String baseCategory = ((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input)).getPrivateStyle().getDateTimeFormatCategory();
        String basePattern = ((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input)).getPrivateStyle().getDateTimeFormat();
        String baseLocale = NONE;
        DesignElementHandle element = (DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input);
        if (element.getPrivateStyle() != null && (formatValue = (style = element.getPrivateStyle()).getProperty("dateTimeFormat")) instanceof FormatValue && (uLocale = (formatHandle = (FormatValueHandle)(formatValueToSet = (FormatValue)formatValue).getHandle((SimpleValueHandle)(propHandle = style.getPropertyHandle("dateTimeFormat")))).getLocale()) != null) {
            baseLocale = uLocale.getDisplayName();
        }
        for (DesignElementHandle handle : DEUtil.getInputElements((Object)this.input)) {
            PropertyHandle propHandle2;
            FormatValue formatValueToSet2;
            FormatValueHandle formatHandle2;
            ULocale uLocale2;
            StyleHandle style2;
            Object formatValue2;
            String category = handle.getPrivateStyle().getDateTimeFormatCategory();
            String pattern = handle.getPrivateStyle().getDateTimeFormat();
            String locale = NONE;
            if (handle.getPrivateStyle() != null && (formatValue2 = (style2 = handle.getPrivateStyle()).getProperty("dateTimeFormat")) instanceof FormatValue && (uLocale2 = (formatHandle2 = (FormatValueHandle)(formatValueToSet2 = (FormatValue)formatValue2).getHandle((SimpleValueHandle)(propHandle2 = style2.getPropertyHandle("dateTimeFormat")))).getLocale()) != null) {
                locale = uLocale2.getDisplayName();
            }
            if ((baseCategory == null && category == null || baseCategory != null && baseCategory.equals(category)) && (basePattern == null && pattern == null || basePattern != null && basePattern.equals(pattern)) && (baseLocale == null && locale == null || baseLocale != null && baseLocale.equals(locale))) continue;
            return null;
        }
        return new String[]{baseCategory, basePattern, baseLocale};
    }

    public void save(Object value) throws SemanticException {
        String[] result = (String[])value;
        if (result.length == 3) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(Messages.getString((String)"FormatDateTimeAttributePage.Trans.SetDateTimeFormat"));
            for (DesignElementHandle element : DEUtil.getInputElements((Object)this.input)) {
                try {
                    StyleHandle style;
                    Object formatValue;
                    if (result[0] == null && result[1] == null) {
                        element.setProperty("dateTimeFormat", null);
                    } else {
                        element.getPrivateStyle().setDateTimeFormatCategory(result[0]);
                        element.getPrivateStyle().setDateTimeFormat(result[1]);
                    }
                    if (element.getPrivateStyle() == null || !((formatValue = (style = element.getPrivateStyle()).getProperty("dateTimeFormat")) instanceof FormatValue)) continue;
                    PropertyHandle propHandle = style.getPropertyHandle("dateTimeFormat");
                    FormatValue formatValueToSet = (FormatValue)formatValue;
                    FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                    if (result[2] == null) continue;
                    formatHandle.setLocale(this.getLocaleByDisplayName(result[2]));
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle((Throwable)e);
                    stack.rollbackAll();
                    return;
                }
            }
            stack.commit();
        }
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public FormatDataTimeDescriptorProvider() {
        this.defaultDate = new Date();
    }

    private String getDisplayName4Category(String category) {
        return ChoiceSetFactory.getStructDisplayName((String)"DateTimeFormatValue", (String)"category", (String)category);
    }

    public String[][] getTableItems(ULocale locale) {
        ArrayList<Object> itemList = new ArrayList<Object>();
        String[][] items = new String[][]{{this.getDisplayName4Category("General Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"General Date"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"General Date"), locale).getFormatCode()}, {this.getDisplayName4Category("Long Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Date"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Date"), locale).getFormatCode()}, {this.getDisplayName4Category("Medium Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Date"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Date"), locale).getFormatCode()}, {this.getDisplayName4Category("Short Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Date"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Date"), locale).getFormatCode()}, {this.getDisplayName4Category("Long Time"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Time"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Time"), locale).getFormatCode()}, {this.getDisplayName4Category("Medium Time"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Time"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Time"), locale).getFormatCode()}, {this.getDisplayName4Category("Short Time"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Time"), locale).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Time"), locale).getFormatCode()}};
        itemList.addAll(Arrays.asList(items));
        String[] customPatterns = FormatDateTimePattern.getCustormPatternCategorys();
        int i = 0;
        while (i < customPatterns.length) {
            itemList.add(new String[]{FormatDateTimePattern.getDisplayName4CustomCategory((String)customPatterns[i]), new DateFormatter(FormatDateTimePattern.getCustormFormatPattern((String)customPatterns[i]), locale).format(this.defaultDate), FormatDateTimePattern.getCustormFormatPattern((String)customPatterns[i])});
            ++i;
        }
        return (String[][])itemList.toArray((T[])new String[0][3]);
    }

    public String getCategory4UIDisplayName(String displayName) {
        if (this.initChoiceArray() != null) {
            int i = 0;
            while (i < this.choiceArray.length) {
                if (this.formatTypes[i].equals(displayName)) {
                    return this.choiceArray[i][1];
                }
                ++i;
            }
        }
        return displayName;
    }

    public String[][] initChoiceArray() {
        if (this.choiceArray == null) {
            IChoiceSet set = ChoiceSetFactory.getStructChoiceSet((String)"DateTimeFormatValue", (String)"category");
            IChoice[] choices = set.getChoices();
            if (choices.length > 0) {
                this.choiceArray = new String[choices.length][2];
                int i = 0;
                int j = 0;
                while (i < choices.length) {
                    this.choiceArray[j][0] = choices[i].getDisplayName();
                    this.choiceArray[j][1] = choices[i].getName();
                    ++j;
                    ++i;
                }
            } else {
                this.choiceArray = new String[0][0];
            }
        }
        return this.choiceArray;
    }

    public String[] getFormatTypes(ULocale locale) {
        if (this.initChoiceArray() != null) {
            this.formatTypes = new String[this.choiceArray.length];
            int i = 0;
            while (i < this.choiceArray.length) {
                String fmtStr = "";
                String category = this.choiceArray[i][1];
                if (category.equals("Custom") || category.equals("Unformatted")) {
                    fmtStr = this.choiceArray[i][0];
                } else {
                    String pattern = FormatDateTimePattern.getPatternForCategory((String)category);
                    fmtStr = new DateFormatter(pattern, locale).format(this.defaultDate);
                }
                this.formatTypes[i] = fmtStr;
                ++i;
            }
        } else {
            this.formatTypes = new String[0];
        }
        return this.formatTypes;
    }

    public int getIndexOfCategory(String category) {
        if (this.initChoiceArray() != null) {
            int i = 0;
            while (i < this.choiceArray.length) {
                if (this.choiceArray[i][1].equals(category)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void fireFormatChanged(String newCategory, String newPattern, String locale) {
        if (this.listeners.isEmpty()) {
            return;
        }
        FormatChangeEvent event = new FormatChangeEvent((Object)this, "dateTimeFormat", newCategory, newPattern, locale);
        for (Object listener : this.listeners) {
            if (!(listener instanceof IFormatChangeListener)) continue;
            ((IFormatChangeListener)listener).formatChange(event);
        }
    }

    public void addFormatChangeListener(IFormatChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public String getPattern(String displayName) {
        String category = ChoiceSetFactory.getStructPropValue((String)"DateTimeFormatValue", (String)"category", (String)displayName);
        return FormatDateTimePattern.getPatternForCategory((String)category);
    }
}

