/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FormatDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class FormatNumberDescriptorProvider
extends FormatDescriptorProvider {
    private Object input;
    private List listeners = new ArrayList();
    public String NUMBER_FORMAT_TYPE_UNFORMATTED = "Unformatted";
    public String NUMBER_FORMAT_TYPE_GENERAL_NUMBER = "General Number";
    public String NUMBER_FORMAT_TYPE_CURRENCY = "Currency";
    public String NUMBER_FORMAT_TYPE_FIXED = "Fixed";
    public String NUMBER_FORMAT_TYPE_PERCENT = "Percent";
    public String NUMBER_FORMAT_TYPE_SCIENTIFIC = "Scientific";
    public String NUMBER_FORMAT_TYPE_CUSTOM = "Custom";
    private static String[][] choiceArray = null;
    private static String[] formatTypes = null;

    public String getDisplayName() {
        return null;
    }

    public void save(Object value) throws SemanticException {
        String[] result = (String[])value;
        if (result.length == 3) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(Messages.getString((String)"FormatNumberAttributePage.Trans.SetNumberFormat"));
            for (DesignElementHandle element : DEUtil.getInputElements((Object)this.input)) {
                try {
                    StyleHandle style;
                    Object formatValue;
                    if (result[0] == null && result[1] == null) {
                        element.setProperty("numberFormat", null);
                    } else {
                        element.getPrivateStyle().setNumberFormatCategory(result[0]);
                        element.getPrivateStyle().setNumberFormat(result[1]);
                    }
                    if (element.getPrivateStyle() == null || !((formatValue = (style = element.getPrivateStyle()).getProperty("numberFormat")) instanceof FormatValue)) continue;
                    PropertyHandle propHandle = style.getPropertyHandle("numberFormat");
                    FormatValue formatValueToSet = (FormatValue)formatValue;
                    FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle((SimpleValueHandle)propHandle);
                    if (result[2] == null) continue;
                    formatHandle.setLocale(this.getLocaleByDisplayName(result[2]));
                }
                catch (SemanticException e) {
                    stack.rollbackAll();
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            stack.commit();
        }
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public int getIndexOfCategory(String name) {
        if (this.initChoiceArray() != null) {
            int i = 0;
            while (i < choiceArray.length) {
                if (choiceArray[i][1].equals(name)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public String getCategory4DisplayName(String displayName) {
        if (this.initChoiceArray() != null) {
            int i = 0;
            while (i < choiceArray.length) {
                if (choiceArray[i][0].equals(displayName)) {
                    return choiceArray[i][1];
                }
                ++i;
            }
        }
        return displayName;
    }

    public String getDisplayName4Category(String category) {
        return ChoiceSetFactory.getStructDisplayName((String)"NumberFormatValue", (String)"category", (String)category);
    }

    public String getPatternForCategory(String category) {
        String pattern = null;
        if ("Currency".equals(category)) {
            pattern = "\u00a4###,##0.00";
            Currency currency = Currency.getInstance((ULocale)ULocale.getDefault());
            if (currency != null) {
                String symbol = currency.getSymbol();
                NumberFormat formater = NumberFormat.getCurrencyInstance();
                String result = formater.format(1L);
                if (result.endsWith(symbol)) {
                    pattern = "###,##0.00";
                    result = result.substring(0, result.indexOf(symbol));
                    int i = result.length() - 1;
                    while (i >= 0) {
                        if (result.charAt(i) != ' ') break;
                        pattern = String.valueOf(pattern) + " ";
                        --i;
                    }
                    pattern = String.valueOf(pattern) + "\u00a4";
                } else {
                    pattern = "\u00a4";
                    result = result.substring(result.indexOf(symbol) + symbol.length());
                    int i = 0;
                    while (i < result.length()) {
                        if (result.charAt(i) != ' ') break;
                        pattern = String.valueOf(pattern) + " ";
                        ++i;
                    }
                    pattern = String.valueOf(pattern) + "###,##0.00";
                }
            }
        } else if ("Fixed".equals(category)) {
            pattern = "#0.00";
        } else if ("Percent".equals(category)) {
            pattern = "0.00";
            NumberFormat formater = NumberFormat.getPercentInstance();
            String result = formater.format(1L);
            if (result.indexOf(37) > 0) {
                result = result.substring(0, result.indexOf(37));
                int i = result.length() - 1;
                while (i >= 0) {
                    if (result.charAt(i) != ' ') break;
                    pattern = String.valueOf(pattern) + " ";
                    --i;
                }
            }
            pattern = String.valueOf(pattern) + "%";
        } else {
            pattern = "Scientific".equals(category) ? "0.00E00" : "";
        }
        return pattern;
    }

    public void fireFormatChanged(String newCategory, String newPattern, String locale) {
        if (this.listeners.isEmpty()) {
            return;
        }
        FormatChangeEvent event = new FormatChangeEvent((Object)this, "numberFormat", newCategory, newPattern, locale);
        for (Object listener : this.listeners) {
            if (!(listener instanceof IFormatChangeListener)) continue;
            ((IFormatChangeListener)listener).formatChange(event);
        }
    }

    public void addFormatChangeListener(IFormatChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public String getPattern(String displayName) {
        String category = ChoiceSetFactory.getStructPropValue((String)"NumberFormatValue", (String)"category", (String)displayName);
        return this.getPatternForCategory(category);
    }

    public String[][] initChoiceArray() {
        if (choiceArray == null) {
            IChoiceSet set = ChoiceSetFactory.getStructChoiceSet((String)"NumberFormatValue", (String)"category");
            IChoice[] choices = set.getChoices();
            if (choices.length > 0) {
                choiceArray = new String[choices.length - 1][2];
                int i = 0;
                int j = 0;
                while (i < choices.length) {
                    if (!choices[i].getName().equals("Standard")) {
                        FormatNumberDescriptorProvider.choiceArray[j][0] = choices[i].getDisplayName();
                        FormatNumberDescriptorProvider.choiceArray[j][1] = choices[i].getName();
                        ++j;
                    }
                    ++i;
                }
            } else {
                choiceArray = new String[0][0];
            }
        }
        return choiceArray;
    }

    public String[] getFormatTypes() {
        if (this.initChoiceArray() != null) {
            formatTypes = new String[choiceArray.length];
            int i = 0;
            while (i < choiceArray.length) {
                FormatNumberDescriptorProvider.formatTypes[i] = choiceArray[i][0];
                ++i;
            }
        } else {
            formatTypes = new String[0];
        }
        return formatTypes;
    }

    public boolean isBlank(String fmtStr) {
        return StringUtil.isBlank((String)fmtStr);
    }

    public Object load() {
        PropertyHandle propHandle;
        FormatValue formatValueToSet;
        FormatValueHandle formatHandle;
        ULocale uLocale;
        StyleHandle style;
        Object formatValue;
        if (DEUtil.getInputElements((Object)this.input).isEmpty()) {
            return null;
        }
        String baseCategory = ((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input)).getPrivateStyle().getNumberFormatCategory();
        String basePattern = ((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input)).getPrivateStyle().getNumberFormat();
        String baseLocale = NONE;
        DesignElementHandle element = (DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input);
        if (element.getPrivateStyle() != null && (formatValue = (style = element.getPrivateStyle()).getProperty("numberFormat")) instanceof FormatValue && (uLocale = (formatHandle = (FormatValueHandle)(formatValueToSet = (FormatValue)formatValue).getHandle((SimpleValueHandle)(propHandle = style.getPropertyHandle("numberFormat")))).getLocale()) != null) {
            baseLocale = uLocale.getDisplayName();
        }
        for (DesignElementHandle handle : DEUtil.getInputElements((Object)this.input)) {
            PropertyHandle propHandle2;
            FormatValue formatValueToSet2;
            FormatValueHandle formatHandle2;
            ULocale uLocale2;
            StyleHandle style2;
            Object formatValue2;
            String category = handle.getPrivateStyle().getNumberFormatCategory();
            String pattern = handle.getPrivateStyle().getNumberFormat();
            String locale = NONE;
            if (handle.getPrivateStyle() != null && (formatValue2 = (style2 = handle.getPrivateStyle()).getProperty("numberFormat")) instanceof FormatValue && (uLocale2 = (formatHandle2 = (FormatValueHandle)(formatValueToSet2 = (FormatValue)formatValue2).getHandle((SimpleValueHandle)(propHandle2 = style2.getPropertyHandle("numberFormat")))).getLocale()) != null) {
                locale = uLocale2.getDisplayName();
            }
            if ((baseCategory == null && category == null || baseCategory != null && baseCategory.equals(category)) && (basePattern == null && pattern == null || basePattern != null && basePattern.equals(pattern)) && (baseLocale == null && locale == null || baseLocale != null && baseLocale.equals(locale))) continue;
            return null;
        }
        return new String[]{baseCategory, basePattern, baseLocale};
    }
}

